"use strict";
/*

cataclysm-warship-replica-2.js

Ship script for warship replica during fight.


Oolite
Copyright © 2008 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.

*/


this.name = "cataclysm-warship-replica-2";
this.author = "Commander McLane";
this.copyright = "© 2009 Commander McLane";
this.version = "1.1";


this.shipEnergyIsLow = function () {
	this.ship.energy *= 2;
}

this.shipDied = function () {
	this.ship.spawnOne("cataclysm_warship_replica_2");
	var stns = system.stations;
	var i = stns.length;
	while (i--) {
		stns[i].abortDockingForShip(this.ship);
	}
}

this.shipSpawned = this.shipLaunchedFromStation = function () {
	this.ship.primaryRole = "cataclysm_military";
}

this.shipBeingAttacked = function (whom) {
	if (whom.primaryRole == "cataclysm_military" || whom.primaryRole == "cataclysm_tetier_station" || whom.isPlayer) return;
	this.ship.reactToAIMessage("ATTACKED_BY_HOSTILE");
}

this.shipAttackedWithMissile = function (missile, whom) {
	if (whom.primaryRole == "cataclysm_military" || whom.primaryRole == "cataclysm_tetier_station" || whom.isPlayer) return;
	this.ship.reactToAIMessage("INCOMING_HOSTILE_MISSILE");
}

this.groupAttackTarget = function () {
	var target = this.ship.target;
	this.ship.reactToAIMessage("GROUP_ATTACK_TARGET");
	system.shipsWithRole("cataclysm_military", this.ship, 8000).forEach(function (ship) {
		if (ship.AI == "cataclysm_militaryAI.plist") {
			ship.target = target;
			ship.reactToAIMessage("GROUP_ATTACK_TARGET");
		}
	})
	system.shipsWithPrimaryRole("cataclysm_tetier_station")[0].target = target;
	system.shipsWithPrimaryRole("cataclysm_tetier_station")[0].reactToAIMessage("GROUP_ATTACK_TARGET");
}

this.checkOffender = function () {
	var target = this.ship.target;
	if (target.primaryRole == "cataclysm_military" || target.primaryRole == "cataclysm_tetier_station" || target.isPlayer) return;
	this.groupAttackTarget();
}
