"use strict";
/*

cataclysm-warship-replica-1.js

Ship script for warship replica during flight test.


Oolite
Copyright © 2008 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.

*/


this.name = "cataclysm-warship-replica-1";
this.author = "Commander McLane";
this.copyright = "© 2009 Commander McLane";
this.version = "1.1";

this.newPhase = function () {
	if (missionVariables.cataclysm == "STAGE10") {
		this.ship.commsMessage(expandDescription("[cataclysm_replica_test_1]"));
		missionVariables.cataclysm = "STAGE10a";
		this.ship.AIState = "ACCELERATE";
	}
	else if (missionVariables.cataclysm == "STAGE10c") {
		missionVariables.cataclysm = "STAGE10d";
		this.ship.AIState = "MANOEUVRE_2";
	}
	else if (missionVariables.cataclysm == "STAGE10d") {
		missionVariables.cataclysm = "STAGE10e";
		this.ship.AIState = "MANOEUVRE_3";
	}
	else if (missionVariables.cataclysm == "STAGE10g") {
		this.ship.commsMessage(expandDescription("[cataclysm_replica_test_2]"));
		missionVariables.cataclysm = "STAGE10h";
		this.ship.target = system.shipsWithPrimaryRole("cataclysm_target_asteroid_2")[0];
		this.ship.target.target = this.ship;
		this.ship.AIState = "ATTACK_TARGET";
		this.ship.reactToAIMessage("ATTACKED");
	}
	else if (missionVariables.cataclysm == "STAGE10h") {
		this.ship.commsMessage(expandDescription("[cataclysm_replica_test_3]"));
		missionVariables.cataclysm = "STAGE10i";
		this.ship.target = system.shipsWithPrimaryRole("cataclysm_target_asteroid_3")[0];
		this.ship.target.target = this.ship;
		this.ship.AIState = "ATTACK_TARGET";
		this.ship.reactToAIMessage("ATTACKED");
	}
	else if (missionVariables.cataclysm == "STAGE10i") {
		this.ship.commsMessage(expandDescription("[cataclysm_replica_test_4]"));
		missionVariables.cataclysm = "STAGE10j";
		this.ship.target = system.shipsWithPrimaryRole("cataclysm_target_asteroid_4")[0];
		this.ship.AIState = "ATTACK_WITH_MISSILE";
		this.ship.reactToAIMessage("ATTACKED");
	}
	else if (missionVariables.cataclysm == "STAGE10j") {
		this.ship.commsMessage(expandDescription("[cataclysm_replica_test_5]"));
		missionVariables.cataclysm = "STAGE10k";
		this.ship.target = player.ship;
		this.ship.AIState = "ATTACK_PLAYER";
		if (worldScripts.BountySystem_Core) {
			worldScripts.BountySystem_Core._changing = true;
		}
	}
	else if (missionVariables.cataclysm == "STAGE10k") {
		this.ship.commsMessage(expandDescription("[cataclysm_replica_test_6]"));
		this.ship.bounty = 0;
		player.bounty = 0;
		missionVariables.cataclysm = "STAGE10l";
		this.ship.fuel = 7;
		this.ship.target = system.shipsWithPrimaryRole("cataclysm_tetier_station")[0];
		this.ship.AIState = "RETURN_TO_STATION";
		// turn on the repurchase function again, if it was turned off
		if (worldScripts.ShipRepurchase) {
			var sr = worldScripts.ShipRepurchase;
			sr.shipTakingDamage = sr.$hide_shipTakingDamage;
			delete sr.$hide_shipTakingDamage;
		}
	}
	else if (this.ship.position.distanceTo(player.ship.position) < 2200) {
		if (missionVariables.cataclysm == "STAGE10a") {
			this.ship.commsMessage(expandDescription("[cataclysm_replica_test_7]"));
			missionVariables.cataclysm = "STAGE10b";
			this.ship.AIState = "TUMBLE";
		}
		else if (missionVariables.cataclysm == "STAGE10b") {
			this.ship.commsMessage(expandDescription("[cataclysm_replica_test_8]"));
			missionVariables.cataclysm = "STAGE10c";
			this.ship.AIState = "MANOEUVRE_1";
		}
		else if (missionVariables.cataclysm == "STAGE10e") {
			this.ship.commsMessage(expandDescription("[cataclysm_replica_test_9]"));
			missionVariables.cataclysm = "STAGE10f";
			this.ship.AIState = "INJECTORS";
		}
		else if (missionVariables.cataclysm == "STAGE10f") {
			this.ship.commsMessage(expandDescription("[cataclysm_replica_test_10]"));
			missionVariables.cataclysm = "STAGE10g";
			this.ship.fuel = 0;
			this.ship.target = system.shipsWithPrimaryRole("cataclysm_target_asteroid_1")[0];
			this.ship.target.target = this.ship;
			this.ship.AIState = "ATTACK_TARGET";
			this.ship.reactToAIMessage("ATTACKED");
		}
	}
}

this.checkForDestroyedTarget = function () {
	if (!this.ship.target) this.ship.reactToAIMessage("DESTROYED_TARGET");
}

this.checkForMissileFired = function () {
	if (!this.ship.target) {
		this.ship.reactToAIMessage("DESTROYED_TARGET");
		return;
	}
	function isMyMissile(missile) {
		return missile.owner == this.ship;
	}
	if (system.filteredEntities(this, isMyMissile, this.ship, 25000).length == 0)
		this.ship.reactToAIMessage("TARGET_FOUND");
}

this.startCombatTimer = function () {
	this.combatTimer = new Timer(this, this.stopCombat, 120);
}

this.stopCombat = function () {
	this.combatTimer.stop();
	if (worldScripts.BountySystem_Core) {
		worldScripts.BountySystem_Core._changing = false;
	}
	// make sure there aren't any missiles in transit that could destroy a low energy player/replica
	var s = this.ship.checkScanner(true);
	var sl = s.length;
	while (sl--) {
		if (s[sl].isMissile) s[sl].explode();
	}
	this.ship.reactToAIMessage("COMBAT_ENDED");
}

this.shipBeingAttacked = function (whom) {
	if (whom.isPlayer) player.bounty = 0;
}

this.shipEnergyIsLow = function () {
	if (missionVariables.cataclysm == "STAGE10k") this.ship.energy *= 1.5;
}

this.sendTestCompleteMessage = function () {
	if (this.ship.target.position.distanceTo(player.ship.position) < 25000)
		this.ship.target.commsMessage(expandDescription("[cataclysm_replica_test_complete]"));
	else
		player.commsMessage(expandDescription("[cataclysm_replica_test_complete]"), 6);
}

this.shipDockedWithStation = function (station) {
	if (missionVariables.cataclysm == "STAGE10l") {
		station.commsMessage(expandDescription("[cataclysm_dock_complete]"));
		missionVariables.cataclysm = "STAGE10m";
	}
}

this.shipDied = function (whom, why) {
	if (whom.isPlayer) {
		player.commsMessage(expandDescription("[cataclysm_replica_dead]"), 6);
		if (worldScripts.BountySystem_Core) {
			worldScripts.BountySystem_Core._changing = false;
		}
		player.setBounty(500, "war crimes");
		system.shipsWithPrimaryRole("cataclysm_military").forEach(function (ship) {
			ship.target = player.ship;
			ship.reactToAIMessage("GROUP_ATTACK_TARGET");
		})
		system.shipsWithPrimaryRole("cataclysm_tetier_station")[0].target = player.ship;
		system.shipsWithPrimaryRole("cataclysm_tetier_station")[0].reactToAIMessage("GROUP_ATTACK_TARGET");
	}
	else {
		this.AI_State = this.ship.AIState;
		var newGame = this.ship.spawnOne("cataclysm_warship_replica_1");
		newGame.AIState = this.AI_State;
	}
	var stns = system.stations;
	var i = stns.length;
	while (i--) {
		stns[i].abortDockingForShip(this.ship);
	}
}
