"use strict";
/*

cataclysm-disabled-warship-1.js

Ship script for disabled captured thargoid warship.


Oolite
Copyright © 2008 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.

*/


this.name = "cataclysm-disabled-warship-1";
this.author = "Commander McLane";
this.copyright = "© 2009 Commander McLane";
this.version = "1.1";


this.shipDied = function () {
	player.commsMessage(expandDescription("[cataclysm_warship_destroyed]"), 6);
	missionVariables.cataclysm = "DESTROYED";
}

this.checkThargoids = function () {
	if (system.countShipsWithRole("thargoid") < 3) {
		this.ship.AIState = "PREPARE_TO_LEAVE";
		worldScripts.Cataclysm.wormholeCollapseTimer = new Timer(worldScripts.Cataclysm, worldScripts.Cataclysm.wormholeCollapsed, 245);
	}
}

this.defuseCascadeWeapons = function () {
	function isCascadingWeapon(ship) {
		return ship.primaryRole == "EQ_QC_MINE" || ship.primaryRole == "EQ_CASCADE_MISSILE" || ship.name == expandDescription("[cataclysm_robot_mine]");
	}
	var cascadeWeapons = system.filteredEntities(this, isCascadingWeapon, this.ship, 100000);
	cascadeWeapons.forEach(function (ship) { ship.explode(); })
}

this.weHaveLeft = function () {
	player.commsMessage(expandDescription("[cataclysm_warship_jumped]"), 6);
}

this.spawnSubstitute = function () {
	this.ship.spawnOne("cataclysm_disabled_warship_2");
	missionVariables.cataclysm = "STAGE7a";
} 
