"use strict";
/*

cataclysm-defector.js

Ship script for defector ship.


Oolite
Copyright © 2008 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.

*/


this.name = "cataclysm-defector";
this.author = "Commander McLane";
this.copyright = "© 2009 Commander McLane";
this.version = "1.1";


this.countdownStarted = function () {
	var agent = system.shipsWithPrimaryRole("police", player.ship, 25000)[0];
	if (!agent) agent = player;
	agent.commsMessage(expandDescription("[cataclysm_defector_hurryup]"));
}

this.enteringWitchspace = function () {
	this.ship.fuel = 7;
	var agent = system.shipsWithPrimaryRole("police", player.ship, 25000)[0];
	if (!agent) agent = player;
	agent.commsMessage(expandDescription("[cataclysm_defector_escaped]"));
	missionVariables.cataclysm_missions = "DEFECTOR_ESCAPED";
}

this.shipDied = function (whom, why) {
	if (missionVariables.cataclysm_missions == "DEFECTOR_HUNT") {
		this.ship.commsMessage(expandDescription("%R! %R! %R!"));
		missionVariables.cataclysm_missions = "DEFECTOR_KILLED";
	}
}