"use strict";
/*

cataclysm-ambassador.js

Ship script for ambassador ship.


Oolite
Copyright © 2008 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.

*/


this.name = "cataclysm-ambassador";
this.author = "Commander McLane";
this.copyright = "© 2009 Commander McLane";
this.version = "1.1";

this.shipDockedWithStation = function () {
	if (missionVariables.cataclysm_missions == "ESCORT_AMBASSADOR") {
		system.mainStation.commsMessage(expandDescription("[cataclysm_ambassador_arrived]"));
		missionVariables.cataclysm_missions = "AMBASSADOR_SUCCESS";
	}
}

this.shipDied = function (whom, why) {
	this.ship.commsMessage(expandDescription("[cataclysm_ambassador_died]"));
	missionVariables.cataclysm_missions = "AMBASSADOR_FAILURE";
	if (whom == system.mainStation && why == "scrape damage" && this.ship.alertCondition < 3) {
		// probably docking failure - not the players fault
		missionVariables.cataclysm_missions = "AMBASSADOR_FAILURE2";
	}
}