"use strict";
this.name = "trade_outpost";
this.author = "phkb";
this.copyright = "2025 phkb";
this.description = "Main script for Trade Outpost";
this.licence = "CC BY-NC-SA 3.0";

this._replaceMainStations = false;

this._toConfig = {
	Name: this.name,
	Alias: expandDescription("[trade_outpost_config_alias]"),
	Display: expandDescription("[trade_outpost_config_display]"),
	Alive: "_toConfig",
	Bool: {
		B0: { Name: "_replaceMainStations", Def: false, Desc: expandDescription("[trade_outpost_main_stations]") },
		Info: expandDescription("[trade_outpost_config_bool_info]")
	},
};

this.startUp = function() {
	if (missionVariables.TradeOutpost_MainStations && missionVariables.TradeOutpost_MainStations == "replace") this._replaceMainStations = true;
}

this.startUpComplete = function() {
	if (worldScripts.Lib_Config) {
		var lib = worldScripts.Lib_Config;
		lib._registerSet(this._toConfig);
    }
}

this.playerWillSaveGame = function() {
	if (this._replaceMainStations == true) {
		missionVariables.TradeOutpost_MainStations = "replace";
	} else {
		delete missionVariables.TradeOutpost_MainStations;
	}
}