"use strict";
this.name      = "communist_population"; 
this.author    = "eric walch"; 
this.copyright = "� 2009 Dr Nil."; 
this.description = "Code for a communist_population"; 

this._shipSpawnOverride = false;
this._sourceGov = -1;
this._destGov = -1;
this._debug = false;

this.startUpComplete = function() {
    // remove the original interstellar space populator from commies (which doesn't work anyway)
    delete worldScripts.communist_population.shipWillExitWitchspace;
}

this.shipWillEnterWitchspace = function (cause) {
    this._sourceGov = system.info.government;
    this._destGov = System.infoForSystem(galaxyNumber, player.ship.nextSystem).government;
}

this.interstellarSpaceWillPopulate = function() {
    if (this._sourceGov === 4 || this._destGov === 4) {
        if (Math.random() > 0.80) {
			system.setPopulator("commies_comgrc_1", {
				location: "WITCHPOINT",
				callback: function(pos) {
                    system.addShips("comgrc", 1, pos);
                }}
			);
            //system.legacy_addShips("comgrc", 1);
            //system.addShips("comgrc-defender", 2);
            //system.legacy_addShips("comgrc-defender", 2);
        }
        if (Math.random() > 0.90) {
			system.setPopulator("commies_comgrc_2", {
				location: "WITCHPOINT",
				callback: function(pos) {
                    system.addShips("comgrc", 1, pos);
                }}
			);
            //system.legacy_addShips("comgrc", 1);
            //system.addShips("comgrc-defender", 3);
            //system.legacy_addShips("comgrc-defender", 3);
        }
    }
}

/*this.shipWillExitWitchspace = function () {
    if (system.info.government === 4) {
        if (system.isInterstellarSpace) this.witchspacePopulator()
    }
}*/

this.systemWillPopulate = function () {
    if (system.info.government !== 4) return;

	// get the witchpoint position for later calculations that replace the deprecated function "legacy_addSystemShips"
	// which works on the WP - Main Station lane. However, that lane isn't directly accessible via the "fromCoordinateSystem" functions
	// so we have to create our own lane
	var wpPos = null;
	var wp = system.shipsWithPrimaryRole("buoy-witchpoint")[0];
	if (!wp || wp.length === 0) {
		wpPos = new Vector3D(0, 0, 0);
	} else {
		wpPos = wp.position;
	}
	
    for (var i = 0; i < 4; i++) {
		if (Math.random() > 0.50) {
			var posCom = Vector3D.interpolate(wpPos, system.mainStation.position, 0.55 + i * 0.12);
			system.setPopulator("commies_workcom_" + i, {
				location: "COORDINATES",
				coordinates: posCom,
				callback: function(pos) {
					var wc = system.addShips("workcom", 1, pos, 0);
					if ((!wc || wc.length === 0) && worldScripts.communist_population._debug === true) log("commies.populator", "OOPS! No worker's commuters spawned (1)");
				}}
			);
			//system.legacy_addSystemShips("workcom", 1, 0.55+i*0.12)
		}
	};
    if (system.techLevel > 6 && Math.random() > 0.75) {
		var pos1 = Vector3D(0, 0.45, 2.6).fromCoordinateSystem("sps");
		system.setPopulator("commies_workcom_a", {
			location: "COORDINATES",
			coordinates: pos1,
			callback: function(pos) {
				var wc = system.addShips("workcom", 1, pos, 0);
				if ((!wc || wc.length === 0) && worldScripts.communist_population._debug === true) log("commies.populator", "OOPS! No worker's commuters spawned (a)");
			}}
		);
		//system.legacy_addShipsAt("workcom", 1, "sps", [0, 0.45, 2.6]);
	}
    for (var i = 0; i < 2; i++) {
		if (Math.random() > 0.75) {
			var posLiner = Vector3D.interpolate(wpPos, system.mainStation.position, 0.3 + i * 0.05);
			system.setPopulator("commies_comliner_" + i, {
				location: "COORDINATES",
				coordinates: posLiner,
				callback: function(pos) {
					var lin = system.addShips("comlim", 1, pos, 0);
					if (!lin || lin.length === 0) log("commies.populator", "OOPS! No com liners spawned (1)");
				}}
			);
			//system.legacy_addSystemShips("comlim", 1, 0.3+i*0.05)
		}
	};
    if (system.techLevel > 6 && Math.random() > 0.90) {
		var pos2 = Vector3D(0, 0.6, 2.8).fromCoordinateSystem("sps");
		system.setPopulator("commies_comlin_a", {
			location: "COORDINATES",
			coordinates: pos2,
			callback: function(pos) {
				var lin = system.addShips("comlim", 1, pos, 0);
				if ((!lin || lin.length === 0) && worldScripts.communist_population._debug === true) log("commies.populator", "OOPS! No com liners spawned (a)");
			}}
		);
		//system.legacy_addShipsAt("comlim", 1, "sps", [0, 0.6, 2.8]);
	}
    if (Math.random() > 0.75) {
		var posViper = Vector3D.interpolate(wpPos, system.mainStation.position, 0.47);
		system.setPopulator("commies_comviper", {
			location: "COORDINATES",
			coordinates: posViper,
			callback: function(pos) {
				var vp = system.addShips("comviper", 5, pos, 0);
				if ((!vp || vp.length === 0) && worldScripts.communist_population._debug === true) log("commies.populator", "OOPS! No com vipers spawned");
			}}
		);
		//system.legacy_addSystemShips("comviper", 5, 0.47);
	}
    if (Math.random() > 0.10) {
		var posPol = Vector3D.interpolate(wpPos, system.mainStation.position, 0.48);
		system.setPopulator("commies_politicop", {
			location: "COORDINATES",
			coordinates: posPol,
			callback: function(pos) {
				var pc = system.addShips("politicop", 1, pos, 0);
				if ((!pc || pc.length === 0) && worldScripts.communist_population._debug === true) log("commies.populator", "OOPS! No politicops spawned (1)");
			}}
		);
		//system.legacy_addSystemShips("politicop", 1, 0.48);
	}
    if (system.techLevel > 6 && Math.random() > 0.95) {
		var posPol2 = Vector3D(0, 0.45, 2.7).fromCoordinateSystem("sps");
		system.setPopulator("commies_politicop_a", {
			location: "COORDINATES",
			coordinates: posPol2,
			callback: function(pos) {
				var pc = system.addShips("politicop", 1, pos, 0)[0];
				if ((!pc || pc.length === 0) && worldScripts.communist_population._debug === true) log("commies.populator", "OOPS! No politicops spawned");
			}}
		);
		//system.legacy_addShipsAt("politicop", 1, "sps", [0, 0.45, 2.7]);
	}
    if (system.techLevel > 6 && system.techLevel < 10) {
		if (!worldScripts.station_validator || worldScripts.station_validator.$deaths("comczgf").length === 0) {
			var posFct = Vector3D(0, 0.40, 2.6).fromCoordinateSystem("sps");
			system.setPopulator("commies_comczgf", {
				location: "COORDINATES",
				coordinates: posFct,
				deterministic: true,
				callback: function(pos) {
					var fct = system.addShips("comczgf", 1, pos, 0)[0];
					if ((!fct || fct.length === 0) && worldScripts.communist_population._debug === true) log("commies.populator", "OOPS! No factories spawned");
				}}
			);
		}
		//system.legacy_addShipsAt("comczgf", 1, "sps", [0, 0.40, 2.6]);
	}
    if (system.techLevel > 9) {
		if (!worldScripts.station_validator || worldScripts.station_validator.$deaths("comslapu").length === 0) {
			var posSlapu = Vector3D(0, 0.40, 2.6).fromCoordinateSystem("sps");
			system.setPopulator("commies_slapu", {
				location: "COORDINATES",
				coordinates: posSlapu,
				deterministic: true,
				callback: function(pos) {
					var sla = system.addShips("comslapu", 1, pos, 0)[0];
					if ((!sla || sla.length === 0) && worldScripts.communist_population._debug === true) log("commies.populator", "OOPS! No slapu's spawned");
				}}
			);
		}
		//system.legacy_addShipsAt("comslapu", 1, "sps", [0, 0.40, 2.6]);
	}
	// note: astromines are not spawned directly, but are set up to be the Rock Hermits in the system.
}

/*this.witchspacePopulator = function() {
    if (Math.random() > 0.80)  {
		system.addShips("comgrc", 1);
        //system.legacy_addShips("comgrc", 1);
		system.addShips("comgrc-defender", 2);
        //system.legacy_addShips("comgrc-defender", 2);
    }
    if (Math.random() > 0.90) {
		system.addShips("comgrc", 1);
        //system.legacy_addShips("comgrc", 1);
		system.addShips("comgrc-defender", 3);
        //system.legacy_addShips("comgrc-defender", 3);
    }
}*/

