"use strict";
this.name = "GalCopBB_GoonSquads";
this.author = "phkb";
this.copyright = "2017 phkb";
this.description = "Looks after all investigation missions (130-139)";
this.license = "CC BY-NC-SA 4.0";

this._goonSquads = []; // array of goon squad and lurk positions
this._goonSquadSetup = null; // timer used to configure goon squads

//-------------------------------------------------------------------------------------------------------------
this.systemWillRepopulate = function () {
	// give good squad their lurk position
	if (this._goonSquads.length > 0 && (this._goonSquadSetup == null || this._goonSquadSetup.isRunning === false)) {
		this._goonSquadSetup = new Timer(this, this.$giveGoonSquadLurkPosition, 1, 0);
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$createGoonSquad = function $createGoonSquad(goons, pos, spread) {
	var pop = worldScripts["oolite-populator"];
	var grp = system.addGroup("pirate", goons, pos, spread);
	var gn = grp.ships;
	if (gn && gn.length > 0) {
		for (var j = 0; j < gn.length; j++) {
			// configure our pirates
			gn[j].setBounty(20 + system.info.government + goons + Math.floor(Math.random() * 8), "setup actions");
			// make sure the pilot has a bounty
			gn[j].setCrew({
				name: randomName() + " " + randomName(),
				bounty: gn[j].bounty,
				insurance: 0
			});
			if (gn[j].hasHyperspaceMotor) {
				pop._setWeapons(gn[j], 1.75); // bigger ones sometimes well-armed
			} else {
				pop._setWeapons(gn[j], 1.3); // rarely well-armed
			}
			// in the safer systems, rarely highly skilled (the skilled ones go elsewhere)
			pop._setSkill(gn[j], 4 - system.info.government);
			if (Math.random() * 16 < system.info.government) {
				pop._setMissiles(gn[j], -1);
			}
			// make sure the AI is switched
			gn[j].switchAI("gcm-pirateAI.js");
		}
		this._goonSquads.push({
			group: grp,
			position: pos
		});
	} else {
		log(this.name, "!!ERROR: Goon squad not spawned!");
	}
}

//-------------------------------------------------------------------------------------------------------------
// makes the goon squads lurk in a particular position
this.$giveGoonSquadLurkPosition = function $giveGoonSquadLurkPosition() {
	var retry = false;
	for (var i = 0; i < this._goonSquads.length; i++) {
		var grp = this._goonSquads[i].group;
		var pos = this._goonSquads[i].position;
		if (grp.leader) {
			if (grp.leader.AIScript.oolite_priorityai) {
				grp.leader.AIScript.oolite_priorityai.setParameter("oolite_pirateLurk", pos);
				grp.leader.AIScript.oolite_priorityai.reconsiderNow();
				for (var j = 0; j < grp.ships.length; j++) {
					if (grp.leader !== grp.ships[j]) {
						var shp = grp.ships[j];
						if (shp.AIScript.oolite_priorityai) {
							shp.AIScript.oolite_priorityai.setParameter("oolite_pirateLurk", pos);
							shp.AIScript.oolite_priorityai.reconsiderNow();
						} else {
							retry = true;
							break;
						}
					}
				}
			} else {
				retry = true;
				break;
			}
		}
		if (retry === true) break;
	}
	if (retry === true) {
		this._goonSquadSetup = new Timer(this, this.$giveGoonSquadLurkPosition, 1, 0);
	} else {
		this._goonSquads.length = 0;
	}
}