/*

gcm-attackerAI.js

Priority-based AI for GalCop Mission attackers, adjusted from the core Assassins AI.

Oolite
Copyright © 2004-2013 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.


TODO: 
    make ship head for next satellite if current one destroyed

*/

"use strict";

this.name = "GCM Attacker AI";

//-------------------------------------------------------------------------------------------------------------
this.aiStarted = function() {
	var ai = new worldScripts["oolite-libPriorityAI"].PriorityAIController(this.ship);

	ai.setWaypointGenerator(ai.waypointsWitchpointPatrol);

	ai.setParameter("oolite_personalityMatchesLeader",0.9);
	ai.setCommunicationsRole("gcm-assassin");

	ai.setParameter("oolite_flag_witchspacePursuit",true);
	ai.setParameter("oolite_flag_surrendersLate",true);

    // add our custom AI so we can use all the AI properties via "this"
    ai.conditionSatelliteNearby = this.$conditionSatelliteNearby;
    ai.configurationAcquireSatelliteAsTarget = this.$configurationAcquireSatelliteAsTarget;
    ai.configurationResetWaypoint = this.$configurationResetWaypoint;

	ai.setPriorities([
        /* Fight */
        /* removed, so the attackers should fight to the death rather than run away */
		/*{
			condition: ai.conditionLosingCombat,
			behaviour: ai.behaviourFleeCombat,
			reconsider: 5
		},*/
		{
			condition: ai.conditionInCombat,
			configuration: ai.configurationAcquireCombatTarget,
			behaviour: ai.behaviourDestroyCurrentTarget,
			reconsider: 5
		},
		/* Check for target satellite and attack */
		{
			preconfiguration: ai.configurationCheckScanner,
			condition: ai.conditionSatelliteNearby,
			truebranch: [
				{
					configuration: ai.configurationAcquireSatelliteAsTarget,
					behaviour: ai.behaviourDestroyCurrentTarget,
					reconsider: 5
				}
            ],
            falsebranch: [
                {
                    preconfiguration: ai.configurationResetWaypoint,
                    configuration: ai.configurationSetDestinationToWaypoint,
                    behaviour: ai.behaviourApproachDestination,
                    reconsider: 5
                }
            ]
		},
		/* Check for player and attack */
		{
			preconfiguration: ai.configurationCheckScanner,
			condition: ai.conditionPlayerNearby,
			truebranch: [
				{
					preconfiguration: ai.configurationAcquirePlayerAsTarget,
					condition: ai.conditionCombatOddsGood,
					behaviour: ai.behaviourAssassinateCurrentTarget,
					reconsider: 10
				}
			]
		},
		{
			condition: ai.conditionHasRememberedTarget,
			behaviour: ai.behaviourFollowCurrentTarget,
			reconsider: 15
		},
		{
			preconfiguration: ai.configurationAppointGroupLeader,
			condition: ai.conditionIsGroupLeader,
			truebranch: ai.templateLeadHuntingMission(),
			/* then follow the group leader */
			falsebranch: [
				{
					behaviour: ai.behaviourFollowGroupLeader,
					reconsider: 15
				}
			],
		}
	].concat(ai.templateWitchspaceJumpAnywhere()));
}

//-------------------------------------------------------------------------------------------------------------
this.$conditionSatelliteNearby = function() {
    var tgt = this.getParameter("oolite_attackTarget");
    if (!tgt) return false;
    if (this.distance(tgt) > this.scannerRange) return false;
    return true;
}

//-------------------------------------------------------------------------------------------------------------
this.$configurationAcquireSatelliteAsTarget = function() {
    var tgt = this.getParameter("oolite_attackTarget");
    if (!tgt) return;
    this.ship.target = tgt;
}

//-------------------------------------------------------------------------------------------------------------
this.$configurationResetWaypoint = function() {
    var tgt = this.getParameter("oolite_attackTarget");
    if (!tgt) return;
    this.setParameter("oolite_waypoint", tgt.position);
    this.setParameter("oolite_waypointRange", 2000);
}