/*

gcm-assassinAI.js

Priority-based AI for GalCop Mission assassins, adjusted from the core Assassins AI.

Oolite
Copyright © 2004-2013 Giles C Williams and contributors

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
MA 02110-1301, USA.

*/

"use strict";

this.name = "GCM Assassin AI";

//-------------------------------------------------------------------------------------------------------------
this.aiStarted = function() {
	var ai = new worldScripts["oolite-libPriorityAI"].PriorityAIController(this.ship);

	ai.setWaypointGenerator(ai.waypointsWitchpointPatrol);

	ai.setParameter("oolite_personalityMatchesLeader",0.9);
	ai.setCommunicationsRole("gcm-assassin");

	ai.setParameter("oolite_flag_witchspacePursuit",true);
	ai.setParameter("oolite_flag_surrendersLate",true);

    // add our custom AI so we can use all the AI properties via "this"
	ai.conditionScannerContainsPlayer = this.$conditionScannerContainsPlayer;

	ai.setPriorities([
		/* Fight */
		{
			condition: ai.conditionLosingCombat,
			behaviour: ai.behaviourFleeCombat,
			reconsider: 5
		},
		{
			condition: ai.conditionInCombat,
			configuration: ai.configurationAcquireCombatTarget,
			behaviour: ai.behaviourDestroyCurrentTarget,
			reconsider: 5
		},
		{
			condition: ai.conditionInNovaSpace,
			truebranch: ai.templateWitchspaceJumpAnywhere()
		},
		/* Follow targets to witchspace */
		{
			condition: ai.conditionWitchspaceEntryRequested,
			behaviour: ai.behaviourEnterWitchspace,
			reconsider: 15
		},
		/* Check for player and attack */
		{
			preconfiguration: ai.configurationCheckScanner,
			condition: ai.conditionScannerContainsPlayer,
			truebranch: [
				{
					preconfiguration: ai.configurationAcquirePlayerAsTarget,
					condition: ai.conditionCombatOddsGood,
					behaviour: ai.behaviourAssassinateCurrentTarget,
					reconsider: 15
				}
			]
		},
		/* Check for couriers */
		{
			preconfiguration: ai.configurationCheckScanner,
			condition: ai.conditionScannerContainsCourier,
			truebranch: [
				{
					condition: ai.conditionStationNearby,
					truebranch: [
						{
							configuration: ai.configurationAcquireScannedTarget,
							behaviour: ai.behaviourFollowCurrentTarget,
							reconsider: 15
						}
					],
					falsebranch: [
						{
							preconfiguration: ai.configurationAcquireScannedTarget,
							condition: ai.conditionCombatOddsGood,
							behaviour: ai.behaviourAssassinateCurrentTarget,
							reconsider: 10
						}
					]
				}
			]
		},
		/* Shoot the escape pods */
		{
			condition: ai.conditionScannerContainsAssassinationTarget,
			configuration: ai.configurationAcquireScannedTarget,
			behaviour: ai.behaviourDestroyCurrentTarget,
			reconsider: 20
		},
		{
			condition: ai.conditionHasRememberedTarget,
			behaviour: ai.behaviourFollowCurrentTarget,
			reconsider: 15
		},
		{
			preconfiguration: ai.configurationAppointGroupLeader,
			condition: ai.conditionIsGroupLeader,
			truebranch: ai.templateLeadHuntingMission(),
			/* then follow the group leader */
			falsebranch: [
				{
					behaviour: ai.behaviourFollowGroupLeader,
					reconsider: 15
				}
			],
		}
	].concat(ai.templateWitchspaceJumpAnywhere()));
}

this.$conditionScannerContainsPlayer = function()
{
	return this.checkScannerWithPredicate(function(s) { 
		return s.isPlayer;
	});
}
