"use strict";
this.name = "jaguar_company_market_normal";
this.author = "spara";
this.copyright = "2014 spara";
this.license     = "CC BY-NC-SA 4.0";

this.$originalDefs =                                        /*         Prices               Quantities    */
{                                                           /*   Low    (Avg)    High  |  Low ( Avg) High */
    "food":         [0, 0,  17, -1, -1,   0,  7,  1, 0],    /*  4.0Cr ( 6.8Cr)   9.6Cr |  0TC ( 4TC)  8TC */
    "textiles":     [0, 0,  23, -1, -1,   0,  3,  3, 0],    /*  6.4Cr ( 8.4Cr)  10.4Cr |  0TC ( 5TC) 10TC */
    "radioactives": [0, 0,  52, -3, -3,   7,  7,  7, 0],    /* 12.4Cr (18.0Cr)  23.6Cr |  7TC (21TC) 35TC */
    "slaves":       [0, 0,  15, -2,  0,   0, 15,  0, 0],    /*  0.4Cr ( 6.2Cr)  12.0Cr |  0TC ( 0TC)  0TC */
    "liquor_wines": [0, 0,  96, -5, -5, 215, 15, 15, 0],    /* 24.4Cr (34.4Cr)  44.4Cr |  0TC ( 4TC)  9TC */
    "luxuries":     [0, 0, 203,  7,  8,   4,  3,  3, 0],    /* 81.2Cr (91.6Cr) 102.0Cr |  0TC ( 3TC)  7TC */
    "narcotics":    [0, 0,  22, -3,  0,   0,  3,  0, 0],    /*  0.4Cr ( 5.2Cr)  10.0Cr |  0TC ( 0TC)  0TC */
    "computers":    [0, 0, 164, 12, 14,   8,  7,  3, 0],    /* 65.6Cr (83.8Cr) 102.0Cr |  0TC ( 5TC) 11TC */
    "machinery":    [0, 0, 127,  6,  6,   0,  7,  7, 0],    /* 50.8Cr (60.6Cr)  70.4Cr |  0TC ( 3TC)  7TC */
    "alloys":       [0, 0,  72,  1,  1,  22, 31, 31, 0],    /* 28.8Cr (36.4Cr)  44.0Cr | 15TC (34TC) 53TC */
    "firearms":     [0, 0, 104, 13, -1,  18,  7, 15, 0],    /* 41.6Cr (61.2Cr)  80.8Cr | 18TC (29TC) 40TC */
    "furs":         [0, 0, 184, -9, -7, 160, 63, 63, 0],    /* 48.4Cr (73.6Cr)  98.8Cr |  0TC ( 8TC) 16TC */
    "minerals":     [0, 0,  27, -1, -1,  53,  3,  3, 0],    /*  8.0Cr (10.0Cr)  12.0Cr | 53TC (58TC) 63TC */
    "gold":         [0, 0,  73, -1, -1,  69,  7,  7, 1],    /* 26.4Cr (29.2Cr)  32.0Cr |  5kg (12kg) 19kg */
    "platinum":     [0, 0, 159, -2, -4,   4, 31, 31, 1],    /* 58.0Cr (67.0Cr)  76.0Cr |  4kg (33kg) 63kg */
    "gem_stones":   [0, 0,  35, -1, -1,   3, 15,  7, 2],    /* 11.2Cr (15.6Cr)  20.0Cr |  3g  (10g ) 17g  */
    "alien_items":  [0, 0,  69, 15,  0,   0,  7,  0, 0]     /* 27.6Cr (50.0Cr)  72.4Cr |  0TC ( 0TC)  0TC */
};

this.updateLocalCommodityDefinition = function(goodDefinition) {
	var commodity = goodDefinition.key;
	var oldDefs = this.$originalDefs[commodity];
	//old style definition found for the good. calculate it the old way
	if (oldDefs) {
		var market_base_price = oldDefs[2];
		var market_eco_adjust_price = oldDefs[3];
		var market_eco_adjust_quantity = oldDefs[4];
		var market_base_quantity = oldDefs[5];
		var market_mask_price = oldDefs[6];
		var market_mask_quantity = oldDefs[7];
		var market_rnd = Math.floor(Math.random() * 256);

		var economy = system.economy;

		var price = (market_base_price + (market_rnd & market_mask_price) + (economy * market_eco_adjust_price)) & 255;
		price *= 0.4;

		var quantity = (market_base_quantity + (market_rnd & market_mask_quantity) - (economy * market_eco_adjust_quantity)) & 255;
		if (quantity > 127) quantity = 0;
		quantity &= 63;

		goodDefinition.price = price * 10;
		goodDefinition.quantity = quantity;
	}
	//no definition found. nullify the goods (cannot trade them here).
	else {
		goodDefinition.price = 0;
		goodDefinition.quantity = 0;
	}
	return goodDefinition;
};
