"use strict";
this.name = "jaguar_company_market_normal";
this.author = "spara";
this.copyright = "2014 spara";
this.license     = "CC BY-NC-SA 4.0";

this.$originalDefs =                                        /*         Prices               Quantities    */
{                                                           /*   Low    (Avg)    High  |  Low ( Avg) High */
	"food":         [0, 0,  20, -1, -2,   0,  7,  1, 0],    /*  5.2Cr ( 8.0Cr)  10.8Cr |  0TC ( 7TC) 15TC */
	"textiles":     [0, 0,  26, -1, -2,   0,  3,  3, 0],    /*  7.6Cr ( 9.6Cr)  11.6Cr |  0TC ( 8TC) 17TC */
	"radioactives": [0, 0,  42, -3, -3,  15,  7,  7, 0],    /*  8.4Cr (14.0Cr)  19.6Cr | 15TC (29TC) 43TC */
	"slaves":       [0, 0,  15, -2,  0,   0, 15,  0, 0],    /*  0.4Cr ( 6.2Cr)  12.0Cr |  0TC ( 0TC)  0TC */
	"liquor_wines": [0, 0, 108, -5, -5, 223, 15, 15, 0],    /* 29.2Cr (39.2Cr)  49.2Cr |  0TC ( 8TC) 17TC */
	"luxuries":     [0, 0, 217,  5,  8,  12,  3,  3, 0],    /* 86.8Cr (94.4Cr) 102.0Cr |  0TC ( 7TC) 15TC */
	"narcotics":    [0, 0,  22, -3,  0,   0,  3,  0, 0],    /*  0.4Cr ( 5.2Cr)  10.0Cr |  0TC ( 0TC)  0TC */
	"computers":    [0, 0, 185,  9, 14,  15,  7,  3, 0],    /* 74.0Cr (88.0Cr) 102.0Cr |  0TC ( 9TC) 18TC */
	"machinery":    [0, 0, 137,  6,  6,   6,  7,  7, 0],    /* 54.8Cr (64.6Cr)  74.4Cr |  0TC ( 6TC) 13TC */
	"alloys":       [0, 0,  63,  1,  1,  32, 31, 31, 0],    /* 25.2Cr (32.8Cr)  40.4Cr | 25TC (44TC) 63TC */
	"firearms":     [0, 0,  90, 13, -1,  27,  7, 15, 0],    /* 36.0Cr (55.6Cr)  75.2Cr | 27TC (38TC) 49TC */
	"furs":         [0, 0, 192, -9, -7, 169, 63, 63, 0],    /* 51.6Cr (76.8Cr) 102.0Cr |  0TC (12TC) 25TC */
	"minerals":     [0, 0,  22, -1, -1,  56,  3,  0, 0],    /*  6.0Cr ( 8.0Cr)  10.0Cr | 56TC (59TC) 63TC */
	"gold":         [0, 0,  85, -1, -1,  77,  7,  7, 1],    /* 31.2Cr (34.0Cr)  36.8Cr | 13kg (20kg) 27kg */
	"platinum":     [0, 0, 150, -2, -3,  11, 31, 31, 1],    /* 54.4Cr (63.4Cr)  72.4Cr | 11kg (37kg) 63kg */
	"gem_stones":   [0, 0,  25, -1, -1,  15, 15,  7, 2],    /*  7.2Cr (11.6Cr)  16.0Cr | 15g  (22g ) 29g  */
	"alien_items":  [0, 0,  96, 15,  0,   0,  7,  0, 0]     /* 38.4Cr (60.8Cr)  83.2Cr |  0TC ( 0TC)  0TC */
};

this.updateLocalCommodityDefinition = function(goodDefinition) {
	var commodity = goodDefinition.key;
	var oldDefs = this.$originalDefs[commodity];
	//old style definition found for the good. calculate it the old way
	if (oldDefs) {
		var market_base_price = oldDefs[2];
		var market_eco_adjust_price = oldDefs[3];
		var market_eco_adjust_quantity = oldDefs[4];
		var market_base_quantity = oldDefs[5];
		var market_mask_price = oldDefs[6];
		var market_mask_quantity = oldDefs[7];
		var market_rnd = Math.floor(Math.random() * 256);

		var economy = system.economy;

		var price = (market_base_price + (market_rnd & market_mask_price) + (economy * market_eco_adjust_price)) & 255;
		price *= 0.4;

		var quantity = (market_base_quantity + (market_rnd & market_mask_quantity) - (economy * market_eco_adjust_quantity)) & 255;
		if (quantity > 127) quantity = 0;
		quantity &= 63;

		goodDefinition.price = price * 10;
		goodDefinition.quantity = quantity;
	}
	//no definition found. nullify the goods (cannot trade them here).
	else {
		goodDefinition.price = 0;
		goodDefinition.quantity = 0;
	}
	return goodDefinition;
};
