"use strict";
this.name        = "ShipRespray_Conditions";
this.author      = "phkb";
this.copyright   = "2015 phkb";
this.license     = "CC BY-NC-SA 4.0";

this.allowAwardEquipment = function(equipment, ship, context) {

	// the respray equipment can only happen via the ship outfitting, and the equipment item is removed straight away anyway, so only allow the purchase context
	if (context != "purchase") return false;
	if (equipment === "EQ_SHIP_RESPRAY_180" && oolite.compareVersion("1.80") < 0) return false;
	if (equipment === "EQ_SHIP_RESPRAY" && oolite.compareVersion("1.80") >= 0) return false;
	// because some ships only have 1 type, but multiple personalities, I've commented this restriction out
	//if (worldScripts.ShipRespray._data.length <= 1) return false;

	// it's actually unlikely rockhermits would offer repainting services...
	if (player.ship.dockedStation.hasRole("rockhermit") === true) return false;
	
	// otherwise allowed
	return true;
}

