"use strict";
this.name = "stealth_base";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Script for stealth base";
this.version = "1.06";

this.shipSpawned = function () {
	worldScripts.stealth_missionScript.stealth_stealthGroup.leader = this.ship;
	this.ship.scannerDisplayColor1 = "whiteColor";
	this.ship.scannerDisplayColor2 = "grayColor";
	system.addShips("asteroid", 30, this.ship.position, player.ship.scannerRange); // add the asteroid field
	system.addShips("stealth_mine", 10, this.ship.position, player.ship.scannerRange * 0.785); // and the mines hidden in it
	this.watchTimer = new Timer(this, this.checkPlayer, 0, 1);
}

this.checkPlayer = function () {
	if (system.countShipsWithRole("player") == 0) { this.stopWatch(); }

	this.distanceToPlayer = this.ship.position.distanceTo(player.ship.position);
	if (this.distanceToPlayer < player.ship.scannerRange) {
		this.ship.target = player.ship;
		this.ship.alertCondition = 3;
		this.ship.launchDefenseShip();
		this.ship.launchDefenseShip();
		this.stopWatch();
	}
}

this.playerWillEnterWitchspace = function () {
	this.stopWatch();
	if (missionVariables.stealth_mission != "BASE_DESTROYED") {
		missionVariables.stealth_mission = "BASE_INTACT";
		mission.setInstructionsKey("stealth_backToBaseFailure", "stealth_missionScript");
	}
}

this.stopWatch = function () {
	if (this.watchTimer && this.watchTimer.isRunning) {
		this.watchTimer.stop();
		delete this.watchTimer;
	}
}

this.shipBeingAttacked = this.shipBeingAttackedByCloaked = function () {
	this.launchChance = (this.ship.maxEnergy - this.ship.energy) / this.ship.maxEnergy;
	if (Math.random() < this.launchChance) { this.ship.launchDefenseShip(); }
}

this.shipEnergyIsLow = function () {
	this.ship.commsMessage(expandMissionText("stealth_toast"));
	if (missionVariables.stealth_barraCount < 6) {
		for (var i = 0; i < (6 - missionVariables.stealth_barraCount); i++) {
			this.ship.launchDefenseShip();
		}
	}
	delete this.shipEnergyIsLow;
}

this.shipDied = function (who, why) {
	this.stopWatch();

	if (this.scanTimer && this.scanTimer.isRunning) {
		this.scanTimer.stop();
		delete this.scanTimer;
	}

	if (why && why != "removed") {
		missionVariables.stealth_mission = "BASE_DESTROYED";
		mission.setInstructionsKey("stealth_backToBaseSuccess", "stealth_missionScript");
		mission.unmarkSystem(131);
		mission.markSystem(116);
	}
}

this.otherShipDocked = function (whom) {
	if (whom.isPlayer) { // if the player was dumb enough to dock
		mission.runScreen({ title: expandMissionText("stealth_bad_move"), messageKey: "stealth_getHim" }, this.damagePlayer);
	}
}

this.damagePlayer = function () {
	player.ship.launch();
	player.ship.takeInternalDamage();
	player.ship.takeInternalDamage();
	player.ship.energy *= (0.5 + (Math.random() * 0.5));
	player.ship.aftShield *= (0.1 + (Math.random() * 0.8));
	player.ship.forwardShield *= (0.1 + (Math.random() * 0.8));
}