"use strict";
this.name = "stealth_missionScript";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Mission script for Stealth OXP.";
this.version = "1.06";

this._resetSettings = false;
this._padInfo = [];

// configuration settings for use in Lib_Config
this._smConfig = {
	Name: this.name,
	Alias: expandMissionText("stealth_config_alias"),
	Display: expandMissionText("stealth_config_display"),
	Alive: "_smConfig",
	Notify: "$resetSettings",
	Bool: {
		B0: { Name: "_resetSettings", Def: false, Desc: expandMissionText("stealth_config_reset") },
		Info: expandMissionText("stealth_config_info")
	},
};

//-------------------------------------------------------------------------------------------------------------
this.$resetSettings = function() {
	if (this._resetSettings && missionVariables.stealth_mission == "CASE_CLOSED") {
		missionVariables.stealth_mission = "OFFER";
		missionVariables.stealth_barraCount = 0; 
		missionVariables.stealth_barraKills = 0;
		player.consoleMessage(expandMissionText("stealth_reset"), 6);
		log(this.name, expandMissionText("stealth_reset_confirm"));
		this._resetSettings = false;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
	if (missionVariables.stealth_padchars) {
		this._padInfo = JSON.parse(missionVariables.stealth_padchars);
		for (var i = 0; i < this._padInfo.length; i++) {
			this.$addPadCharacter(this._padInfo[i]);
		}
	}
	// mission has already been rejected or completed, clean up and remove active script parts
	if (missionVariables.stealth_mission == "CASE_CLOSED") {
		this.cleanUp();
		return;
	}

	//initialise mission variables
	if (!missionVariables.stealth_mission) // mission general status
	{ missionVariables.stealth_mission = "OFFER"; }

	if (!missionVariables.stealth_barraCount) // how many barracuda's launched
	{ missionVariables.stealth_barraCount = 0; }

	if (!missionVariables.stealth_barraKills) // and how many killed by the player
	{ missionVariables.stealth_barraKills = 0; }
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {
    if (worldScripts.Lib_Config && missionVariables.stealth_mission == "CASE_CLOSED") {
        worldScripts.Lib_Config._registerSet(this._smConfig);
		var pad = worldScripts.Lib_PAD;
		pad.$config.defOrgs[21] = "lib_pad_org_navy.png";
	}
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function() {
	missionVariables.stealth_padchars = JSON.stringify(this._padInfo);
}

//-------------------------------------------------------------------------------------------------------------
this.cleanUp = function () { // get rid of active script elements if no longer needed.
	delete this.startUp;
	delete this.playerEnteredNewGalaxy;
	delete this.missionScreenOpportunity;
	delete this.choice;
	mission.setInstructionsKey(null);
	return;
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreenOpportunity = function () {
	// next check if we have any conditions preventing the offering or continuing of the mission
	if (!player.ship.docked // we're in space
		|| player.score < 512 // need to be dangerous rank to begin
		|| galaxyNumber != 2 // we're not in G3
		|| !player.ship.dockedStation.isMainStation // if we're not at the main station
		|| (missionVariables.TCAT_mission && missionVariables.TCAT_mission != "OFFER" && missionVariables.TCAT_mission != "CASE_CLOSED") // don't run at same time as TCAT
	) return;

	if (system.ID === 131) { // if we're at Lequena
		if (player.ship.docked && player.ship.dockedStation.isMainStation && missionVariables.stealth_mission === "GO_GET_EM" && this.dockHint === "NO") {
			this.dockHint = "YES";
			mission.runScreen({ title: expandMissionText("stealth_old_jeeq"), messageKey: "stealth_hint", overlay: {name:"stealth_galcop.png", height:546}});
			this.$addPadCharacter("ward");
			return;
		}
	}

	if (system.ID === 116) { // if we're at Beenboer
		switch (missionVariables.stealth_mission) {
			case "OFFER": // make the initial offer
				mission.runScreen({ title: expandMissionText("stealth_barracuda"), messageKey: "stealth_initialOffer", overlay: {name:"stealth_navy.png", height:546}, choicesKey: "stealth_choices" }, this.choice);
				this.$addPadCharacter("raines");
				break;
			case "REJECTED": // player said no
				missionVariables.stealth_mission = "CASE_CLOSED";
				mission.setInstructionsKey(null);
				mission.runScreen({ title: expandMissionText("stealth_declined"), messageKey: "stealth_rejected", overlay: {name:"stealth_navy.png", height:546}});
				break;
			case "ACCEPTED": // player said yes
				missionVariables.stealth_mission = "GO_GET_EM";
				mission.setInstructionsKey("stealth_missionShort");
				mission.markSystem(131);
				mission.runScreen({ title: expandMissionText("stealth_final_brief"), messageKey: "stealth_accepted", overlay: {name:"stealth_navy.png", height:546}});
				break;
			case "BASE_DESTROYED": // mission over - base destroyed
				missionVariables.stealth_mission = "CASE_CLOSED";
				mission.setInstructionsKey(null);
				mission.unmarkSystem(116);
				switch (missionVariables.stealth_barraKills) {
					case (6):
						mission.runScreen({ title: expandMissionText("stealth_success"), messageKey: "stealth_allBarraDestroyed", overlay: {name:"stealth_navy.png", height:546}});
						player.credits += 2000;
						break;
					case (5):
					case (4):
					case (3):
						missionVariables.stealth_award = missionVariables.stealth_barraKills * 250;
						mission.runScreen({ title: expandMissionText("stealth_debrief"), messageKey: "stealth_someBarraDestroyed", overlay: {name:"stealth_navy.png", height:546}});
						player.credits += missionVariables.stealth_award;
						break;
					case (2):
					case (1):
						mission.runScreen({ title: expandMissionText("stealth_debrief"), messageKey: "stealth_fewBarraDestroyed", overlay: {name:"stealth_navy.png", height:546}});
						break;
					case (0):
						mission.runScreen({ title: expandMissionText("stealth_debrief"), messageKey: "stealth_noBarraDestroyed", overlay: {name:"stealth_navy.png", height:546}});
						break;
				}
				break;
			case "BASE_INTACT": // mission over - base intact
				missionVariables.stealth_mission = "CASE_CLOSED";
				mission.setInstructionsKey(null);
				mission.unmarkSystem(116);
				switch (missionVariables.stealth_barraKills) {
					case (6):
						mission.runScreen({ title: expandMissionText("stealth_debrief"), messageKey: "stealth_allBarraIntact", overlay: {name:"stealth_navy.png", height:546}});
						player.credits += 1000;
						break;
					case (5):
					case (4):
					case (3):
						missionVariables.stealth_award = missionVariables.stealth_barraKills * 100;
						mission.runScreen({ title: expandMissionText("stealth_debrief"), messageKey: "stealth_someBarraIntact", overlay: {name:"stealth_navy.png", height:546}});
						player.credits += missionVariables.stealth_award;
						break;
					case (2):
					case (1):
						mission.runScreen({ title: expandMissionText("stealth_debrief"), messageKey: "stealth_fewBarraIntact", overlay: {name:"stealth_navy.png", height:546}});
						break;
					case (0):
						mission.runScreen({ title: expandMissionText("stealth_failed"), messageKey: "stealth_noBarraIntact", overlay: {name:"stealth_navy.png", height:546}});
						break;
				}
				break;
		}
		return;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.choice = function (choice) {
	switch (choice) {
		case "STEALTH_1_ACCEPTED":
			missionVariables.stealth_mission = "ACCEPTED";
			break;
		case "STEALTH_2_REJECTED":
			missionVariables.stealth_mission = "REJECTED";
			break;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.playerEnteredNewGalaxy = function (galaxyNumber) { // if we jump galaxies whilst mission is running or after rejection
	if (galaxyNumber == 3 && missionVariables.stealth_mission != "OFFER") {
		missionVariables.stealth_mission = "CASE_CLOSED";
		this.cleanUp();
	}
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate = function() {
	if (galaxyNumber == 2 && system.ID == 131 && missionVariables.stealth_mission && missionVariables.stealth_mission == "GO_GET_EM" && system.countShipsWithRole("stealth_base") == 0) {
		this.location = (Math.random() * 0.5) + 0.25;
		system.addShipsToRoute("stealth_base", 1, this.location, "ws");
		this.dockHint = "NO";
		this.stealth_stealthGroup = new ShipGroup();
	}
}

//-------------------------------------------------------------------------------------------------------------
this.playerStartedJumpCountdown = function () {
	if (galaxyNumber == 2 && system.ID == 131 && missionVariables.stealth_mission && missionVariables.stealth_mission == "GO_GET_EM") {
		player.commsMessage(expandMissionText("stealth_insufficient_time"));
		delete this.playerStartedJumpCountdown;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$addPadCharacter = function(person) {
    var pad = worldScripts.Lib_PAD;
	if (!pad) return;
	var dta = {};
	var cat = [];
	if (!this._padInfo) {
		this._padInfo = [];
	}
	if (this._padInfo.indexOf(person) == -1) this._padInfo.push(person);

	var dta = {};
	switch (person) {
		case "ward":
			dta = {
				name: expandMissionText("stealth_ward_name"), 
				origin: expandMissionText("stealth_generic_unknown"),
				rank:expandMissionText("stealth_ward_rank"), 
				species:expandMissionText("LIB_PAD_SPECIES_HUMAN"), 
				gender:expandMissionText("LIB_PAD_GENDER_MALE"), 
				ship:expandMissionText("stealth_generic_unknown"),
				age:35, 
				t0:"lib_pad_org_galcop.png", 
				t1:64, 
				t2:10
			};
			break;
		case "raines":
			dta = {
				name:expandMissionText("stealth_raines_name"), 
				origin: expandMissionText("stealth_generic_unknown"),
				rank:expandMissionText("stealth_raines_rank"), 
				species:expandMissionText("LIB_PAD_SPECIES_HUMAN"), 
				gender:expandMissionText("LIB_PAD_GENDER_MALE"), 
				ship:expandMissionText("stealth_generic_unknown"),
				age:35, 
				t0:21, 
				t1:91, 
				t2:7
			};
			break;
	}
    dta.info = [];
    cat.push("GALCOP.GENERIC");

	var namesplit = dta.name.split(" ");
	var id = "PERSONS." + (dta.rank != "" ? dta.rank.toUpperCase() + " " : namesplit[0].toUpperCase()) + namesplit[namesplit.length - 1].toUpperCase();
	pad._addPageInCategory(id, dta, cat, false);
}

