"use strict";
this.name = "EquipmentStorage_Book";
this.author = "phkb";
this.description = "Adds the Equipment Storage Handbook to the Ship's Library";

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
    if (worldScripts["Ships Library"]) this._registerESBook();
}

//-------------------------------------------------------------------------------------------------------------
this._registerESBook = function () {

    var contents = [
        { level: 0, key: "equipstorage_intro" },
        { level: 1, key: (worldScripts.ShipConfiguration_Core ? "equipstorage_chap1_sc" : "equipstorage_chap1") },
        { level: 1, key: "equipstorage_chap2", params: [function() { return formatCredits(worldScripts.EquipmentStorage._establishmentFee, false, true);}]},
        { level: 1, key: "equipstorage_chap3", params: [function() { return formatCredits(0.1, true, true);}]},
        { level: 1, key: "equipstorage_chap4", params: [function() { return (worldScripts.EquipmentStorage._refundPct * 100).toFixed(0) ;}]},
        { level: 1, key: "equipstorage_chap5" },
    ];
    worldScripts["Ships Library"]._registerBook("equip_storage", expandMissionText("equipstorage_title"), contents, 22);
}
