"use strict";
this.name = "GETter HUD";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "1.5";


this.startUpComplete = function() {
	this._ghlistGoods();
	this._ghlistOwner();
	this._ghlistCap();
	this._ghlistSystem();
}


this.playerBoughtNewShip = function(ship, price) {
	this._ghlistGoods();
	this._ghlistOwner();
	this._ghlistCap();
	this._ghlistSystem();
}


this.playerBoughtEquipment = function(equipment, paid) {
	this._ghlistGoods();
	this._ghlistOwner();
	this._ghlistCap();
	this._ghlistSystem();
}


this.equipmentAdded = function(equipmentKey) {
	this._ghlistGoods();
	this._ghlistOwner();
	this._ghlistCap();
	this._ghlistSystem();
}


this.shipWillLaunchFromStation = function() {
	if(!this.$Timer) this.$Timer = new Timer(this,this._ghupdateSpeed.bind(this),0,0.25);
	if(!this.$Timer1) this.$Timer1 = new Timer(this,this._ghshowWeps.bind(this),0,0.25);
	if(!this.$Timer2) this.$Timer2 = new Timer(this,this._ghupdateDistance.bind(this),0,0.5);
	this._ghlistGoods();
	this._ghlistOwner();
	this._ghlistCap();
	this._ghlistSystem();
}


this.shipExitedWitchspace = function() {
	this._ghlistSystem();
}
	
	
this.guiScreenChanged = function(to, from) {
	if ((from=="GUI_SCREEN_MARKET")||(from=="GUI_SCREEN_MANIFEST")) {
		this._ghlistGoods();
		this._ghlistOwner();
		this._ghlistCap();
		this._ghlistSystem();
	}
}


this._ghcenteredText = function(txt, width) {
	var t = ""+txt; // force to string, else txt.length is undefined for numbers
	var w = width / 2;
	while( t && t.length < w ) { // for fixed width font in setCustomHUDDial
		t = " " + t;
	}
	return(t);
}


this._ghupdateSpeed = function () {
	var p = player.ship;
	if((!p) || (!p.isValid)) return; // player died

	var setd = p.setCustomHUDDial;
	if (setd) {
		var sp = p.speed;
		sp = this._ghcenteredText(sp.toFixed(1), 28); // default width
		setd("shipSpeed", sp);
	}
}


this._ghupdateDistance = function () {
	var p = player.ship;
	if((!p) || (!p.isValid)) return; // player died

	var setd = p.setCustomHUDDial;
	if (setd) {
		var sd = p.position.distanceTo(system.mainStation.position)/100;
		sd = this._ghcenteredText(sd.toFixed(0), 28); // default width
		setd("stationDistance", sd);
	}
}



// output System name to HUD
this._ghlistSystem = function() {
	var p = player.ship;
	if((!p) || (!p.isValid)) return; // player died

	var setd = p.setCustomHUDDial;
	if (setd) {
		var s = this._ghsystemList();
		setd("systemList", s);
	}
}


// show System name
this._ghsystemList = function() {
	var result = "";
	result += System.systemNameForID(system.ID);
	return result;
}


// output capList to HUD
this._ghlistCap = function() {
	var p = player.ship;
	if((!p) || (!p.isValid)) return; // player died

	var setd = p.setCustomHUDDial;
	if (setd) {
		var cap = this._ghcapList();
		setd("capList", cap);
	}
}


// show ship's TC capacity
this._ghcapList = function() {
	var result = "";
	result += "Capacity: ";
	result += player.ship.cargoSpaceCapacity+" TC";
	return result;
}


// output ownerList to HUD
this._ghlistOwner = function() {
	var p = player.ship;
	if((!p) || (!p.isValid)) return; // player died

	var setd = p.setCustomHUDDial;
	if (setd) {
		var owner = this._ghownerList();
		setd("ownerList", owner);
	}
}


// show ship, class, name, owner
this._ghownerList = function() {
	var result = "";
	result += "Cdr. ";
	result += player.name + ", ";
	result += player.ship.displayName;
	return result;
}


// output goods list to HUD
this._ghlistGoods = function() {
	var p = player.ship;
	if((!p) || (!p.isValid)) return; // player died

	var setd = p.setCustomHUDDial;
	if (setd) {
		var goods = this._ghgoodsList();
		setd("goodsList", goods);
	}
}


// list commodities in ship's hold
this._ghgoodsList = function() {
	var result = "";
	var m = manifest.list;
	for (var i=0; i<m.length; i++) {
		var q = m[i].commodity;
		if (q) result += q + " ("+m[i].quantity+")  ";
	}	
	if (result=="") result = "EMPTY";
	return result;
}


// weapons online indicator
this._ghshowWeps = function() {
	var p = player.ship;
	if((!p) || (!p.isValid)) return; // player died

	var setd = p.setCustomHUDDial;
	if (setd) {
		var weps = "";
		if (p.weaponsOnline) weps="W";
		setd("showWeapons", weps);
	}
}


