"use strict";
this.name = "lave_missions";
this.author = "phkb";
this.copyright = "2024 phkb";
this.description = "Missions for Lave";
this.license = "CC-BY-NC-SA 4.0";

/*
    Mission 1: help a flight of students who have fallen under pirate attack on their way to the sun.
    Mission 2: find lost student who fell through wormhole and got stranded.
    Mission 3: rescue a learner who has broken down and docked at a Rock Hermit. Deliver parts to rock hermit so Learner can repair ship
*/
this._checkForMission = false;
this._missionStatus = {};
this._forceStart = "";
this._hold = "";

//-------------------------------------------------------------------------------------------------------------
this.startUp = function() {
    if (missionVariables.LaveMissions) {
        this._missionStatus = JSON.parse(missionVariables.LaveMissions);
    } else {
        this._missionStatus["mission_1"] = "NOT_STARTED";
        this._missionStatus["mission_2"] = "NOT_STARTED";
        this._missionStatus["mission_3"] = "NOT_STARTED";
    }
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {
    if (player.ship.dockedStation.dataKey == "laveAcademy_academy") {
        this._checkForMission = true;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function() {
    missionVariables.LaveMissions = JSON.stringify(this._missionStatus);
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillDockWithStation = function(station) {
    this._checkForMission = false;
    if (station.dataKey == "laveAcademy_academy") {
        this._checkForMission = true;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreenOpportunity = function() {
    if (this._checkForMission == true) {
        this._checkForMission = false;
        if ((player.score >= 128 && Math.random() > 0.9) || this._forceStart != "") {
            this._hold = this.$availableMission();
            if (this._forceStart != "" && this._hold != "NONE") this._hold = this._forceStart;
            if (this._hold == "NONE") return;
            if (this._hold == "mission_3") {
                missionVariables.LaveMission3_RockHermitSummary = this.$rhSummary();
            }
            // start the mission
            mission.runScreen({ title: expandMissionText("lave_missions_urgent_help"), messageKey: "lave_" + this._hold + "_briefing", choicesKey: "lave_mission_options", screenID:"lave_missions" },
                function (choice) {
                    var lm = worldScripts.lave_missions;
                    if (!choice) choice = "02_NO";
                    if (choice == "01_YES") {
                        this._missionStatus[lm._hold] = "STARTED";
                        worldScripts["lave_" + lm._hold].$setupMission();
                        mission.runScreen({ title: expandMissionText("lave_missions_urgent_help"), messageKey: "lave_" + this._hold + "_briefing_yes", screenID:"lave_missions"});
                    }
                    if (choice == "02_NO") {
                        this._missionStatus[lm._hold] = "SKIPPED";
                        mission.runScreen({ title: expandMissionText("lave_missions_urgent_help"), messageKey: "lave_" + this._hold + "_briefing_no", screenID:"lave_missions"});
                    }
                });
            delete missionVariables.LaveMission3_RockHermitSummary;
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$availableMission = function() {
    var avail = "";
    var missions = Object.keys(this._missionStatus);
    var finishedTypes = ["SKIPPED", "FINISHED", "NOT_STARTED"];
    for (var i = 0; i < missions.length; i++) {
        if (this._missionStatus[missions[i]] == "NOT_STARTED" && avail == "") avail = missions[i];
        // if we're part way through a mission, always return "NONE"
        if (finishedTypes.indexOf(this._missionStatus[missions[i]]) == -1) {avail = "NONE"; break; }
    }
    if (avail == "") avail = "NONE";
    return avail;
}

//-------------------------------------------------------------------------------------------------------------
this.$rhSummary = function() {
    var text = "";
    var rhlist = [].concat(system.shipsWithRole("rockhermit")).concat(system.shipsWithRole("rockhermit-chaotic")).concat(system.shipsWithRole("rockhermit-pirate"));
    if (rhlist.length == 1) text = expandMissionText("lave_mission_rockhermits_one");
    if (rhlist.length == 2) text = expandMissionText("lave_mission_rockhermits_two");
    if (rhlist.length > 2) text = expandMissionText("lave_mission_rockhermits_three");
    if (rhlist.length > 3) text += expandMissionText("lavel_mission_rockhermits_more");
    return text;
}