"use strict";
this.name = "Smugglers_Oolite_Contracts_Fix";
this.author = "phkb";
this.description = "Fixes the Oolite Cargo contracts system so it doesn't pick illegal commodities.";
this.licence = "CC BY-NC-SA 3.0";

this.startUp = function () {
	var w = worldScripts["oolite-contracts-cargo"];
	w.$hide = w._initialiseCargoContractsForSystem;
	if (w.author.indexOf("Switeck") >= 0) {
		log(this.name, "Monkey-patching Cargo-Contract-mod to not use illegal commodities at the destination");
		w._initialiseCargoContractsForSystem = this.$switech_initialiseCargoContractsForSystem;
	} else {
		log(this.name, "Monkey-patching core cargo contracts script to not use illegal commodities at the destination");
		w._initialiseCargoContractsForSystem = this.$core_initialiseCargoContractsForSystem;
	}
}

// initialise a new cargo contract list for the current system
this.$core_initialiseCargoContractsForSystem = function $core_initialiseCargoContractsForSystem() {
	// clear list
	this.$contracts = [];

	// this is not the same algorithm as in 1.76, but should give
	// similar results with comparable efficiency.

	// no point in generating too many, as route-finding is slow
	var numContracts = Math.floor(5 * Math.random() + 5 * Math.random() + 5 * Math.random() + (player.contractReputationPrecise * Math.random()));
	if (player.contractReputationPrecise >= 0 && numContracts < 5) {
		numContracts += 5;
	}
	if (numContracts > 16) {
		numContracts = 16;
	} else if (numContracts < 0) {
		numContracts = 0;
	}
	// some of these possible contracts may be discarded later on

	for (var i = 0; i < numContracts; i++) {
		var cargo = new Object;

		// pick a random system to take the goods to
		var destination = Math.floor(Math.random() * 256);

		// discard if chose the current system
		if (destination === system.ID) {
			continue;
		}

		// get the SystemInfo object for the destination
		var destinationInfo = System.infoForSystem(galaxyNumber, destination);
		if (destinationInfo.sun_gone_nova) {
			continue;
		}
		var daysUntilDeparture = 1 + (Math.random() * (7 + player.contractReputationPrecise - destinationInfo.government));
		if (daysUntilDeparture <= 0) {
			// loses some more contracts if reputation negative
			continue;
		}

		var si = worldScripts.Smugglers_Illegal;
		var illegal = null;
		if (si) {
			illegal = si.$illegalGoodsListCommodityOnly(destination, true);
			// add slaves to the list
			illegal.push("slaves");
		}

		var commodities = Object.keys(system.mainStation.market);
		var attempts = 0;
		do {
			var remotePrice = 0;
			attempts++;
			var commodity = commodities[Math.floor(Math.random() * commodities.length)];
			// sub-tc contracts only available for top rep
			if (system.mainStation.market[commodity]["quantity_unit"] != 0 && player.contractReputationPrecise < 6.5) { }
			// ignore commodities with 0 availability here
			else if (system.mainStation.market[commodity].quantity === 0) { }
			// ignore any illegal goods
			else if (illegal && illegal.indexOf(commodity) >= 0) { } else {
				remotePrice = this._priceForCommodity(commodity, destinationInfo);
			}
		} while (remotePrice < system.mainStation.market[commodity].price / 20 && attempts < 10);
		if (attempts === 10) {
			// failed to find a good one.
			continue;
		}
		cargo.commodity = commodity;

		var amount = 0;
		while (amount < 30) {
			var unitsize = 1;
			// larger unit sizes for kg/g commodities
			if (system.mainStation.market[commodity]["quantity_unit"] === 1) {
				unitsize += Math.floor(Math.random() * 6) + Math.floor(Math.random() * 6) + Math.floor(Math.random() * 6);
			} else if (system.mainStation.market[commodity]["quantity_unit"] === 2) {
				unitsize += Math.floor(Math.random() * 16) + Math.floor(Math.random() * 11) + Math.floor(Math.random() * 6);
			}
			amount += (1 + Math.floor(Math.random() * 32)) * (1 + Math.floor(Math.random() * 16)) * unitsize;
		}

		if (amount > 125 && system.mainStation.market[commodity]["quantity_unit"] === 0) {
			// reduce the number of contracts only suitable for Anacondas
			amount = Math.floor(amount / Math.floor(1 + (Math.random() * 4)));
		}
		cargo.size = amount;

		// adjustment to prices based on quantity (larger = more profitable)
		var discount = Math.min(10 + Math.floor(amount / 10), 35);

		var unitPrice = system.mainStation.market[commodity].price * (100 - discount) / 1000;
		var localValue = Math.floor(unitPrice * amount);
		remotePrice = remotePrice * (200 + discount) / 200;
		var remoteValue = Math.floor(remotePrice * amount);
		var profit = remoteValue - localValue;

		// skip if unprofitable
		if (profit <= 100) {
			continue;
		}

		// check that a route to the destination exists
		// route calculation is expensive so leave this check to last
		var routeToDestination = system.info.routeToSystem(destinationInfo);

		// if the system cannot be reached, ignore this contract
		if (!routeToDestination) {
			continue;
		}

		// we now have a valid destination, so generate the rest of
		// the parcel details

		cargo.destination = destination;
		// we'll need this again later, and route calculation is slow
		cargo.route = routeToDestination;

		// higher share for transporter for longer routes, less safe systems
		var share = 100 + destinationInfo.government - (10 * routeToDestination.route.length);
		if (share < 10) {
			share = 10;
		}
		share = 100 - share;

		// safety: now multiply the fee by 2 compared with 1.76 contracts
		// prevents exploit discovered by Mad Hollander at
		// http://bb.oolite.space/viewtopic.php?p=188127
		localValue *= 2;
		// this may need to be raised further

		// absolute value of profit remains the same
		var fee = localValue + Math.floor(profit * (share / 100));
		fee -= fee % 20; // round to nearest 20 credits;

		cargo.payment = fee;
		cargo.deposit = localValue - (localValue % 20);
		if (cargo.deposit >= cargo.payment) {
			// rare but not impossible; last safety check
			return;
		}

		// time allowed for delivery is time taken by "fewest jumps"
		// route, plus timer above. Higher reputation makes longer
		// times available.
		cargo.deadline = clock.adjustedSeconds + Math.floor(daysUntilDeparture * 86400) + (cargo.route.time * 3600);

		// add parcel to contract list
		this._addCargoContractToSystem(cargo);
	}

}

// initialise a new cargo contract list for the current system
this.$switech_initialiseCargoContractsForSystem = function $switech_initialiseCargoContractsForSystem() {
	// clear list
	this.$contracts = [];
	// this is not the same algorithm as in 1.76, but should give similar results with comparable efficiency.
	// no point in generating too many, as route-finding is slow

	var scratchval = system.info.systemsInRange(80 - player.contractReputationPrecise * 7); // 31 LY range at 7 Rep, 80 LY range at 0 Rep, 129 LY range at -7 Rep...done here to save recalculations time.
	var nearbysystems = [];
	for (var i = 0; i < scratchval.length; i++) {	// this loop removes 'bad' nearby systems from being chosen
		var destination = scratchval[i].systemID;
		if (destination != system.ID) {	// discard if chose the current system
			var destinationInfo = System.infoForSystem(galaxyNumber, destination);	// get the SystemInfo object for the destination
			if (!destinationInfo.sun_gone_nova) {	// Discarded, since novas tend to eliminate markets!
				var routeToDestination = system.info.routeToSystem(destinationInfo);	// check that a route to the destination exists
				if (routeToDestination) nearbysystems = nearbysystems.concat([destination]);	 // if the system cannot be reached, ignore this contract
			}
		}
	}
	if (nearbysystems.length < 1) return;	// failed to find a good destination. Should only happen with Oresrati in Gal. Chart 8!

	// system.economy	0=RI, 7=PA		0=RI and 5=RA should increase contracts, 2=PI and 7=PA should decrease contracts
	// system.government	0=Anarchy, 7=Corporate State	"higher"-numbered governments should increase contracts, up to 7 more for CS
	// system.techLevel	0=TL1, 14=TL15		<TL6 should reduce contracts, >TL10 should increase contracts
	//	var numContracts =0;
	var numContracts = system.techLevel * 0.2 + 3;
	if (system.economy == 0 || system.economy == 5) numContracts++;
	if (system.economy == 2 || system.economy == 7) numContracts--;

	//	var numContracts = Math.max(0,Math.min(18,Math.ceil((numContracts+system.techLevel*0.2+3)*(Math.random()+Math.random())+(system.government*0.5+player.contractReputationPrecise-player.bounty*0.02)*(Math.random()+Math.random()))));
	var numContracts = Math.max(0, Math.min(18, Math.ceil(numContracts * (Math.random() + Math.random()) + (system.government * 0.5 + player.contractReputationPrecise - player.bounty * 0.05) * (Math.random() + Math.random()))));
	if (player.contractReputationPrecise > 1 && numContracts < 5 && nearbysystems.length > 5) numContracts += Math.ceil(player.contractReputationPrecise * 0.5 + Math.random() * (5 - numContracts));	// ORG was always +5 at Rep >= 0;
	//	if(player.contractReputationPrecise > numContracts) numContracts += Math.ceil(player.contractReputationPrecise*Math.random());	// ORG was always +5 at Rep >= 0;
	var numContracts = Math.min(Math.max(Math.ceil(player.contractReputationPrecise * 0.5), nearbysystems.length), numContracts);	// to limit number of contracts in 2-system unreachable locations!
	//	if(nearbysystems.length == 0) numContracts = 0;	// Oresrati gets none -- nowhere to deliver them to!
	// some of these possible contracts may be discarded later on

	log(this.name, " player.contractReputation= " + player.contractReputationPrecise + " player.bounty= " + player.bounty + " numContracts= " + numContracts + " Gov.type= " + system.government + " Eco.type= " + system.economy + " TL= " + system.techLevel + " nearbysystems.length= " + nearbysystems.length);

	//	var numContracts = 21;	// FOR TESTING ONLY! Placed here so logging will still record how many contracts there is supposed to be.

	for (var i = 0; i < numContracts; i++) {
		var cargo = new Object;
		if (nearbysystems.length == 1) var destination = nearbysystems[0];
		else var destination = nearbysystems[Math.floor(Math.random() * nearbysystems.length)];
		var destinationInfo = System.infoForSystem(galaxyNumber, destination);	// get the SystemInfo object for the destination
		var routeToDestination = system.info.routeToSystem(destinationInfo);	// check that a route to the destination exists
		var routeJumps = routeToDestination.route.length;
		var daysUntilDeparture = 1 + Math.random() * Math.max(-1, routeJumps + player.contractReputationPrecise - destinationInfo.government + system.government * 0.5);

		//	log(this.name," attempts = "+attempts+" destination = "+destination+" destinationInfo = "+destinationInfo);

		// we now have a valid destination, so generate the rest of the cargo contract details
		var attempts = 0;
		do {
			var remotePrice = 0;
			var scratchval = 0;
			var unitPrice = 0;
			attempts++;

			// good luck on the fixes needed here!
			if (player.contractReputationPrecise - player.bounty * 0.01 + Math.random() * 3 < 0) {	// negative reputation and/or high bounty gets awful choices.
				var commodities = ["food", "textiles", "radioactives", "slaves", "liquor_wines", "luxuries", "narcotics", "computers", "machinery", "alloys", "firearms", "furs", "minerals", "gold", "platinum", "gem_stones"];	// 16 entries, missing alien items
				var preccutoff = 13;
				var scratchval = Math.floor(Math.random() * commodities.length);
			} else {
				if (system.economy < 4 || system.economy + 1 < destinationInfo.economy) { // more Industrial eco. only!
					if (system.economy >= destinationInfo.economy && player.contractReputationPrecise + Math.random() * 2 > 0) {	// Eliminates marginal profit commodities from "wrong way" Ind to Ind economies
						var commodities = ["narcotics", "liquor_wines", "alloys", "furs", "gold", "platinum", "gem_stones"]; // 7 entries
						var preccutoff = 4;
						var scratchval = Math.floor(Math.random() * (commodities.length - 2) + 2); // Drops the controlled and low profit items at high rep.
					} else if (system.economy > destinationInfo.economy - Math.floor((Math.random() + player.contractReputationPrecise) * 0.3)) {	// Eliminates low-profit commodities when start economy is only slightly more industrial than destination.
						var commodities = ["firearms", "narcotics", "furs", "machinery", "computers", "alloys", "platinum", "gem_stones"]; // 8 entries, removed Gold!
						var preccutoff = 6;
						var scratchval = Math.floor(Math.random() * (commodities.length - 2) + 2); // Drops the controlled items.
					} else {
						var commodities = ["firearms", "narcotics", "alloys", "machinery", "luxuries", "computers", "platinum", "gem_stones"];	// 8 entries, sorted from worst to best, removed Gold!
						var preccutoff = 6;
						var scratchval = Math.floor(Math.random() * (commodities.length - 2) + 2); // Drops the controlled item.
					}
				} else if (system.economy <= destinationInfo.economy && player.contractReputationPrecise + Math.random() * 2 > 0) {	// Eliminates low-profit commodities when start economy >= destination (similar/identical agri economies)
					var commodities = ["slaves", "narcotics", "liquor_wines", "alloys", "furs", "platinum", "gem_stones"]; // 7 entries, removed Gold!
					var preccutoff = 5;
					var scratchval = Math.floor(Math.random() * (commodities.length - 3) + 3); // Drops the controlled and low profit items at high rep.
				} else {
					var commodities = ["slaves", "narcotics", "minerals", "textiles", "food", "radioactives", "liquor_wines", "furs", "gold", "platinum", "gem_stones"]; // 11 entries, sorted from worst to best
					var preccutoff = 8;
					var scratchval = Math.floor(Math.random() * (commodities.length - 5) + 5); // Drops the controlled and low profit items at high rep.
				}
			}

			// At rep>3, there's a chance of getting ONLY good contracts. The odds of this are much better by rep>5.
			if (player.contractReputationPrecise - player.bounty * 0.01 + Math.sqrt(routeJumps + Math.random() * 5) < 8) var scratchval = Math.max(0, Math.floor(Math.random() * (preccutoff + player.contractReputationPrecise * 0.1 - player.bounty * 0.01)));
			if (scratchval >= preccutoff && player.contractReputationPrecise < 6.5) var scratchval = preccutoff - 1;	// sub-TC contracts only available for top rep
			if (scratchval > commodities.length - 1) var scratchval = commodities.length - 1;	// If high rep pushes off rightside of the chart, give player "best" contract.

			var commodity = commodities[scratchval];

			var si = worldScripts.Smugglers_Illegal;
			var illegal = null;
			if (si) {
				illegal = si.$illegalGoodsListCommodityOnly(destination, true);
				// add slaves to the list
				illegal.push("slaves");
			}

			if (illegal && illegal.indexOf(commodity) >= 0) { // don't pick commodities illegal at the destination
				if (system.mainStation.market[commodity].quantity > 0) {	// Do not use commodities with 0 availability
					//				log(this.name," # "+attempts+", "+commodities+", "+commodity+", "+system.economy+", "+destinationInfo.economy+" , "+destinationInfo+" , "+destination);

					var exDiff = Math.abs(system.economy - system.mainStation.market[commodity]["peak_export"]) * 2;
					var imDiff = Math.abs(system.economy - system.mainStation.market[commodity]["peak_import"]) * 2;
					var ecoDiff = (exDiff + imDiff) * 0.5;
					var efactor;
					if (exDiff == imDiff) efactor = 0	// neutral economy
					else if (exDiff > imDiff) efactor = (imDiff / ecoDiff) - 1	// closer to the importer, so return -ve
					else efactor = 1 - (exDiff / ecoDiff);	// closer to the exporter, so return +ve

					var unitPrice = Math.ceil(parseFloat(system.mainStation.market[commodity]["price_average"]) * (1 - (efactor * parseFloat(system.mainStation.market[commodity]["price_economic"])) - parseFloat(system.mainStation.market[commodity]["price_random"]))) * 0.1;
					var unitOrgPrice = Number((system.mainStation.market[commodity].price * 0.1)).toFixed(1);

					exDiff = Math.abs(destinationInfo.economy - system.mainStation.market[commodity]["peak_export"]) * 2;
					imDiff = Math.abs(destinationInfo.economy - system.mainStation.market[commodity]["peak_import"]) * 2;
					ecoDiff = (exDiff + imDiff) * 0.5;
					if (exDiff == imDiff) efactor = 0
					else if (exDiff > imDiff) efactor = (imDiff / ecoDiff) - 1
					else efactor = 1 - (exDiff / ecoDiff);

					var remotePrice = Math.ceil(parseFloat(system.mainStation.market[commodity]["price_average"]) * (1 - (efactor * parseFloat(system.mainStation.market[commodity]["price_economic"])) + parseFloat(system.mainStation.market[commodity]["price_random"]))) * 0.1;
					var remotePrice2 = Number(this._priceForCommodity(commodity, destinationInfo)).toFixed(1); // Random price only!
				}
			}
		} while ((remotePrice - Math.max(1, (player.contractReputationPrecise + Math.sqrt(routeJumps)) * (0.5 - (0.2 * parseFloat(system.mainStation.market[commodity]["quantity_unit"])))) < unitPrice || remotePrice == 0) && attempts < Math.max(1, (player.contractReputationPrecise + 3)));	// remotePrice must be at least 1 credit more than unitPrice

		if (remotePrice <= unitPrice) continue; // failed to find a good one. Comment out for testing!
		cargo.commodity = commodity;

		var unitsize = 1;	// larger unit sizes for kg/g commodities
		var amount = Math.max(Math.ceil((1 + Math.random() * 32) * (1 + Math.random() * 16)), Math.floor(30 + Math.random() * 6)); // forced minimum amount to always be at least 30-35. Eliminates while-looping here!
		if (system.mainStation.market[commodity]["quantity_unit"] != 0) {	// this covers Gold, Plat, and Gems
			if (routeJumps > 4) amount = Math.max(amount, Math.ceil((1 + Math.random() * 32) * (1 + Math.random() * 16)));	// precious metals contracts get an extra chance to be large amounts, since original used a while loop ADDITION...but only if they're more than 4 jumps.
			unitsize += Math.ceil((Math.random() + Math.random() + Math.random()) * Math.min(10, Math.max(1, routeJumps - player.bounty * 0.04)));	// Multiplying by routeJumps HAS an upper+lower limit because routeJumps=2 for a 1-jump route. Original used x6 but rounded down on each random part.
			if (system.mainStation.market[commodity]["quantity_unit"] == 2) unitsize *= 2;	// Gems get twice as many as Gold and Platinum!
			amount *= unitsize;
		}

		if (amount > 125 && amount > player.ship.cargoSpaceCapacity && player.contractReputationPrecise - player.bounty * 0.02 >= 0 && unitsize == 1) amount = Math.floor(amount / Math.floor(1 + Math.random() * 4));	// reduce the number of contracts only suitable for Anacondas - poor rep or high bounty leaves more huge+unusable contract visible
		cargo.size = amount;

		//		var discount2 = Math.min(10+Math.floor(amount*0.1),35);	// Original discount adjustment to prices based on quantity (larger = more profitable)
		var discount2 = Math.min(10 + Math.floor(amount / unitsize * 0.1), 35);	// Original discount adjustment to prices based on base quantity (larger = more profitable)

		var localValue = Math.ceil(unitOrgPrice * amount * 0.1) * 10; // round to nearest 10 credits
		var localValue2 = Math.ceil(unitPrice * amount * 0.1) * 10;
		var remoteValue = Math.ceil(remotePrice * amount * 0.1) * 10;
		var remoteValue2 = Math.ceil(remotePrice2 * amount * 0.1) * 10;
		var profit2 = Math.floor((remoteValue2 * (200 + discount2) * 0.0005) - (localValue * (100 - discount2) * 0.001)) * 10;	// nearly original profit given by original/official old version of cargo contracts.
		var profit = remoteValue - localValue2;

		var discount = Math.ceil(30 + player.contractReputationPrecise * 8 + routeJumps * 5 + (amount / unitsize) * 0.1 + 10000 / profit - player.bounty * 0.2 - destinationInfo.government - system.government);
		var profit3 = Math.ceil(profit * Math.min(100, Math.max(50, discount)) * 0.001) * 10;
		if (profit2 < 100 && profit < 100) continue;	// skip if unprofitable - comment out for TESTING ONLY!

		// we have a valid destination, so generate the rest of the parcel details
		cargo.destination = destination;
		cargo.route = routeToDestination;	// we'll need this again later, and route calculation is slow

		// higher share for transporter for longer routes, less safe systems
		var share = Math.min(90, (10 * routeJumps) - destinationInfo.government);

		if ((profit2 * (share * 0.01) > profit3 && (system.mainStation.market[commodity]["quantity_unit"] == 0 || profit3 < 100) && player.contractReputationPrecise - player.bounty * 0.02 > 3) || (profit2 * (share * 0.01) < profit3 && profit2 * (share * 0.01) > 100 && commodity != "narcotics" && commodity != "slaves" && commodity != "firearms" && player.contractReputationPrecise - player.bounty * 0.02 < -2)) {	// Uses most profitable method at high Rep for all regular contracts and Switeck method for most Gold/Plat/Gems contracts.
			cargo.payment = Math.ceil((localValue + profit2) * 0.1) * 10; // round to nearest 10 credits
			cargo.deposit = Math.ceil((cargo.payment - Math.floor(profit2 * share * 0.01)) * 0.1) * 10;
		} else {
			cargo.payment = Math.ceil((localValue + profit) * 0.1) * 10; // round to nearest 10 credits - profit3 is often < profit due to discount being 100% or less!
			cargo.deposit = Math.ceil((cargo.payment - profit3) * 0.1) * 10;
		}

		if (cargo.deposit > cargo.payment) continue; // rare but not impossible; last safety check

		// time allowed for delivery is time taken by "fewest jumps" route, plus timer above. Higher reputation makes longer times available.
		cargo.deadline = clock.adjustedSeconds + Math.floor(daysUntilDeparture * 86400) + (cargo.route.time * 3600);

		// logs nearly everything
		log(this.name,
			(i + 1) + ". "
			+ cargo.size + " " + commodity
			+ " multi=" + unitsize
			+ " Eco=" + system.economy
			+ " Dest=" + destinationInfo.economy
			+ " Jumps=" + routeJumps
			+ " unitP=" + Number(unitPrice).toFixed(1)
			+ "-" + unitOrgPrice
			+ " remP=" + Number(remotePrice2).toFixed(1)
			+ "-" + Number(remotePrice).toFixed(1)
			+ " Pr=" + profit
			+ " *" + discount
			+ "%=" + profit3
			+ " PrDif=" + (profit3 - Math.floor(profit2 * share * 0.01))
			+ " NetPr=" + (Math.floor(profit2 * share * 0.01))
			+ " =" + profit2
			+ " *1." + discount2
			+ " *" + share + "%"
			+ " locVal=" + localValue
			+ "-" + localValue2
			+ "=" + (localValue - localValue2)
			+ " Dep=" + cargo.deposit
			+ " remVal=" + remoteValue
			+ " Pay=" + cargo.payment
		);

		this._addCargoContractToSystem(cargo);	// add parcel to contract list
	}
}
