"use strict";
this.name = "Smugglers_Conditions";
this.author = "phkb";
this.copyright = "2015 phkb";
this.description = "Condition script for determining when to include smuggling equipment (compartment, scanner, tech version upgrade)";
this.licence = "CC BY-NC-SA 3.0";

this._debug = false;

// station roles to be excluded
this._excludeRoles = ["rescue_station"];

//-------------------------------------------------------------------------------------------------------------
this.allowAwardEquipment = function (equipment, ship, context) {
	if (context === "scripted") return true;
	if (context === "npc") return false;

	if (equipment === "EQ_SMUGGLING_COMP_STORAGE") return false;

	var result = true;

	var se = worldScripts.Smugglers_Equipment;
	var existing = se.$getSmugglingCompartmentEquipment();

	var alleg = ship.dockedStation.allegiance;
	if (alleg == null) alleg = "neutral";

	// is this station likely to have the equipment?
	if (context === "purchase" && ship && ship.dockedStation && this._debug === false) {
		if (se._equipmentList.indexOf(equipment) >= 0 && (existing === "" || player.ship.equipmentStatus(existing) === "EQUIPMENT_OK")) result = false;
		if (se._smugglingAllegiance.indexOf(alleg) === -1 || this._excludeRoles.indexOf(ship.dockedStation.primaryRole) != -1) result = false;
		if (result === false) {
			return result;
		}
	}

	// version 1.83 and above fix the issue with repair to items that take cargo space
	if (oolite.compareVersion("1.83") <= 0) {
		if (player.ship.equipmentStatus(equipment) === "EQUIPMENT_DAMAGED" && system.info.techlevel >= 2) {
			return true;
		}
	}

	if (equipment.indexOf("COMPARTMENT_REPAIR") >= 0 && oolite.compareVersion("1.83") > 0) {
		if (system.info.techlevel < 2) result = false;
		if (se.$isCompartmentDamaged() === false) result = false;
	}

	switch (equipment) {
		case "EQ_SMUGGLING_COMPARTMENT":
			// not available if there's no cargo space at all
			if (ship.cargoSpaceCapacity === 0) result = false;
			if (system.info.techlevel < 3) result = false;
			if (se.$hasSmugglingCompartment() === true && se.$isCompartmentDamaged() === true && oolite.compareVersion("1.83") > 0) result = false;
			// we should always be able to adjust the tonnage, even if the only way is down.
			break;
		case "EQ_PHASE_SCANNER":
			var tl = 7;
			if (ship.equipmentStatus(equipment) === "EQUIPMENT_DAMAGED") tl = 6;
			if (system.government != 0) result = false;
			if (system.info.techlevel < tl) result = false;
			if (se._phaseScannerAvailable === false) result = false;
			break;
		case "EQ_SMUGGLING_PHASE_ADJUSTMENT":
			if (system.info.techlevel < 6) result = false;
			break;
		case "EQ_SMUGGLING_VERSION_UPGRADE":
			// higher techlevel systems will get the upgrade sooner
			if (system.info.techlevel < 4) result = false;
			if (se._sc_Days < (60 * ((60 - system.info.techlevel) / 60))) result = false;
			break;
		default:
			// is this item damaged?
			if (ship.equipmentStatus(equipment) === "EQUIPMENT_DAMAGED") {
				// return true so that the "Repair" items are displayed.
				result = true;
			} else {
				result = false;
			}
	}
	return result;
}