"use strict";
this.name = "Feudal_PlanetFall2";
this.author = "phkb";
this.copyright = "CC-BY-SA-NC 4.0";
this.description = "Allows for full customisations of Feudal systems";

this.debug = true;
this.rsnInUse = false;
this.nameStore = null;

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
    var pf = worldScripts.PlanetFall2;
    pf._locationOverrides["0 96"] = {
        main: [
            {
                roles: ["planetFall2_mainSurface_FSRoyalCourt", "capitalCity", "planetFall2_mainSurface_FSCathedral", "capitalCity", "planetFall2_mainSurface_FSEstate"],
                names: [expandMissionText("fs_pf2_0_96_0"), expandMissionText("fs_pf2_0_96_1"), expandMissionText("fs_pf2_0_96_2"), expandMissionText("fs_pf2_0_96_3"), expandMissionText("fs_pf2_0_96_4")],
            }
        ],
    };

    pf._landingImages["feudalCourt"] = [
        { name: "feudalCourt_1.png", height: 568 }, { name: "feudalCourt_2.png", height: 568 }, { name: "feudalCourt_3.png", height: 568 },
        { name: "feudalCourt_4.png", height: 568 }, { name: "feudalCourt_5.png", height: 568 }, { name: "feudalCourt_6.png", height: 568 },
        { name: "feudalCourt_7.png", height: 568 }, { name: "feudalCourt_8.png", height: 568 }, { name: "feudalCourt_9.png", height: 568 },
        { name: "feudalCourt_10.png", height: 568 }, { name: "feudalCourt_11.png", height: 568 }, { name: "feudalCourt_12.png", height: 568 },
        { name: "feudalCourt_13.png", height: 568 }, { name: "feudalCourt_14.png", height: 568 }, { name: "feudalCourt_15.png", height: 568 }
    ];
    pf._landingImages["feudalCathedral"] = [
        { name: "feudalCathedral_1.png", height: 568 }, { name: "feudalCathedral_2.png", height: 568 }, { name: "feudalCathedral_3.png", height: 568 }, 
        { name: "feudalCathedral_4.png", height: 568 }, { name: "feudalCathedral_5.png", height: 568 }
    ];
    pf._landingImages["feudalEstate"] = [
        { name: "feudalCathedral_1.png", height: 568 }, { name: "feudalCathedral_2.png", height: 568 }, { name: "feudalCathedral_3.png", height: 568 }, 
        { name: "feudalCathedral_4.png", height: 568 }, { name: "feudalCathedral_5.png", height: 568 }
    ];

    if (worldScripts["feudal-planetfall.js"]) {
        pf.$addPrepopulationFunction("feudal-planetfall.js", "extraPopulation");
        if (this.debug) log(this.name, "Monkey-patching shipWillEnterWitchspace, shipWillLaunchFromStation, and shipWillExitWitchspace functions of Feudal states PlanetFall script");
        var f = worldScripts["feudal-planetfall.js"];
        delete f.shipWillLaunchFromStation;
        delete f.shipWillExitWitchspace;
        f.extraPopulation = this.feudalstates_extraPopulation;
        f.shipWillEnterWitchspace = this.feudalstates_shipWillEnterWitchspace;
    }

    this._phraseGen = worldScripts.GNN_PhraseGen;
    // link into the PF name store
    var ns = worldScripts.PlanetFall2_Names;
    // make sure the nameStore dictionary has been populated
    if (Object.keys(ns.nameStore).length == 0) {
        // if the number of keys in the nameStore object is zero, it means the startUp function in PlanetFall2_Names 
        // hasn't been run yet (this one has been run first).// so run it now, and delete it so it doesn't get run twice.
        ns.startUp();
        delete ns.startUp;
    }
    this.nameStore = ns.nameStore;

	if (worldScripts.RandomStationNames) this.rsnInUse = true;
	// override the rsn flag if we've specifically turned it off.
	if (worldScripts.PlanetFall2._config.useGANames == false) this.rsnInUse = false;
}

//-------------------------------------------------------------------------------------------------------------
this.feudalstates_extraPopulation = function () {
    if (system.government == 1 && worldScripts.PlanetFall2) {
        if ((galaxyNumber == 0 && system.techLevel >= 7) || (galaxyNumber == 1 && system.techLevel >= 5) || (galaxyNumber == 2 && system.techLevel >= 7) || (galaxyNumber == 4 && system.techLevel >= 7) || (galaxyNumber == 5 && system.techLevel >= 8) || (galaxyNumber == 6 && system.techLevel >= 7) || (galaxyNumber == 7 && system.techLevel >= 7)) {
        //if ((galaxyNumber == 0 && system.techLevel >= 7) || (galaxyNumber == 1 && system.techLevel >= 5) || (galaxyNumber == 2 && system.techLevel >= 7) || (galaxyNumber == 4 && system.techLevel >= 7) || (galaxyNumber == 5 && system.techLevel >= 8)) {
            var pf = worldScripts.PlanetFall2;
            var key = galaxyNumber + " " + system.ID;
            // if we have a full custom setup, don't use the override method
            if (pf._locationOverrides[key]) return;
            worldScripts.PlanetFall2.planetFallOverride = true; // set the override, so only external OXP locations appear
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
// just pointing this at the correct worldscript name
this.feudalstates_shipWillEnterWitchspace = function (cause, destination) {
    if (system.government == 1 && worldScripts.PlanetFall2) {
        worldScripts.PlanetFall2.planetFallOverride = false;
    }
}

//-------------------------------------------------------------------------------------------------------------
// reproduction of Galactic Almanac's naming method for Royal Courts
this.planetFall_mainSurface_FSRoyalCourt1 = expandMissionText("fs_pf2_royalcourt1").split("|");
this.planetFall_mainSurface_FSRoyalCourt2 = expandMissionText("fs_pf2_royalcourt2").split("|");
this.planetFall_mainSurface_FSRoyalCourt3a = expandMissionText("fs_pf2_royalcourt3a").split("|");
this.planetFall_mainSurface_FSRoyalCourt3b = expandMissionText("fs_pf2_royalcourt3b").split("|");

//-------------------------------------------------------------------------------------------------------------
this.$PF_RoyalCourt = function $PF_RoyalCourt(dataKey) {
	if (!this.rsnInUse) return "";
    // do we have a stored name for this key
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
    // if not, generate one
	if (!stored) {
		var def = {
			fieldA: [].concat(this.planetFall_mainSurface_FSRoyalCourt1),
			fieldB: [].concat(this.planetFall_mainSurface_FSRoyalCourt2),
			fieldC: [].concat(this.planetFall_mainSurface_FSRoyalCourt3a),
			fieldD: [].concat(this.planetFall_mainSurface_FSRoyalCourt3b),
			fieldE: ["[3] [4]"],
			fieldF: [],
			fieldG: [],
			fieldH: [],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				expandMissionText("fs_pf2_namegen")
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
        // otherwise, use the stored value
		var text = stored;
	}
    return text;
}
