"use strict";
this.name = "sodalite_station_script";
this.author = "phkb";
this.copyright = "2024 phkb";
this.license = "CC BY-NC-SA 4.0";

this._types = ["cb68_pitviper-player", "cb68_pitviper-beast-player",
    "cb68_pitviper2-player", "cb68_pitviper2b-player", "cb68_pitviper2c-player", "cb68_pitviper2d-player", "cb68_pitviper2e-player",
    "cb68_blue_racer-player", "cb68_red_racer-player", "cb68_yellowbelly_racer-player", "cb68_yellowbelly_racer-player2", "cb68_black_racer-player"];

//-------------------------------------------------------------------------------------------------------------
this.shipSpawned = function () {
    var sy = this.ship.shipyard;
    var i = sy.length;
    // look for an existing coluber ships in the shipyard
    while (i--) {
        if (this._types.indexOf(sy[i].shipdata_key) >= 0) {
            // there are already coluber ships
            return;
        }
    }
    // make sure we only have spawnable ships in the _types array
    i = this._types.length;
    while (i--) {
        if (!Ship.shipDataForKey(this._types[i])) this._types.splice(i, 1);
    }
    // if we don't have any coluber ship oxps installed, exit at this point
    if (this._types.length == 0) return;
    // if we get here, there were no coluber ships in the shipyard, but there are some oxps installed
    // first, make sure there aren't many other ships
    i = sy.length;
    while (i--) {
        if (Math.random() > 0.25) this.ship.removeShipFromShipyard(i);
    }
    // now go and add some ships
    this.$addPitvipersToShipyard();
}

//-------------------------------------------------------------------------------------------------------------
this.$addPitvipersToShipyard = function () {
    var optional = ["EQ_ECM", "EQ_ADVANCED_NAVIGATIONAL_ARRAY", "EQ_PASSENGER_BERTH", "EQ_ENERGY_UNIT", "EQ_FUEL_INJECTION",
        "EQ_SCANNER_SHOW_MISSILE_TARGET", "EQ_MULTI_TARGET", "EQ_GAL_DRIVE", "EQ_SHIELD_BOOSTER", "EQ_HEAT_SHIELD"];

    var forSale = parseInt(Math.random() * 5) + 6; // something between 6 and 10 ships for sale
    for (var shps = 0; shps <= forSale; shps++) {
        var s = this._types[parseInt(Math.random() * this._types.length)];
        var extras = [];
        var txt = "";
        var extrasCount = parseInt(Math.random() * 3);
        var extrasCost = 0;

        for (var i = 1; i <= extrasCount; i++) {
            if (Math.random() > 0.75) {
                // pick a piece of equipment to add
                var itm = optional[parseInt(Math.random() * optional.length)];
                var eq = EquipmentInfo.infoForKey(itm);
                if (eq.techLevel <= system.techLevel && eq.techLevel <= this.ship.equivalentTechLevel) {
                    extras.push(itm);
                    txt += (txt == "" ? expandDescription("[riredi_includes]") : expandDescription("[riredi_and]")) + eq.name;
                    extrasCost += (eq.price / 10);
                }
            }
        }
        if (txt != "") txt += ". ";
        this.$addShip(s, extras, txt, extrasCost);
        this._types.splice(this._types.indexOf(s), 1);
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$addShip = function (shipKey, extras, extrasText, extrasCost) {
    var shp = Ship.shipDataForKey(shipKey);
    if (!shp) return;
    var price = (parseInt(shp._oo_shipyard.price) + extrasCost) * 0.9; // discounted when buying at a Sodalite station
    this.ship.addShipToShipyard({
        short_description: expandDescription("[riredi_ship]", { name: shp.name, extras: extrasText, price: formatCredits(price, false, true) }),
        shipdata_key: shipKey,
        price: price,
        personality: Math.floor(Math.random() * 32768),
        extras: extras
    });
}