"use strict";
this.author = "cim";
this.copyright = "© 2011-2014 cim.";
this.license = "CC-BY-SA 3.0";
this.name = "CargoTypeExtension-Station-Sodalite";
this.description = "Sodalite station market definition";

this.startUp = function () {
	if (!worldScripts.CargoTypeExtension) {
		for (var prop in this) {
			if (prop !== 'name' && prop !== 'version' && prop !== "oolite_manifest_identifier") {
				delete this[prop];
			}
		}
		return;
	}
	else {
        if (!worldScripts["RandomStationNames"]) {
            worldScripts["CargoTypeExtension"].registerOXPStation(this.name, "cb68_sodalite_station-riredi-coluber");
        } else {
            worldScripts["CargoTypeExtension"].registerOXPStation(this.name, "cb68_sodalite_station-riredi-coluber_no_beacon_version");
        }
		this.$registerNewCargoTypes();
	}
}

this.$registerNewCargoTypes = function () {
	var obj = new Object;
	obj.ID = "RC-MGE1";
	obj.genericType = "luxuries";
	obj.specificType = expandDescription("[riredi_newcargo]");
	obj.buySystems = [[210], [], [], [], [], [], [], []];
	obj.sellSystems = [[5,57,59,60,69,78,92,99,156,167,218,223,231,241,249,253,], 
        [14,53,81,89,113,115,144,224], 
        [31,53,67,84,95,107,127,195,198,212,223], 
        [25,46,47,51,56,72,89,104,111,115,120,121,153,174,175,179,184,200,217,232,239,243,248,249], 
        [5,34,35,43,44,47,48,51,105,191,196,212,216,239,240], 
        [22,34,35,53,59,80,96,110,119,132,159,204,227,232,234,242], 
        [0,3,17,39,84,87,97,106,124,129,162,179,184,222,233,241], 
        [0,19,22,54,67,72,73,87,135,142,143,154,156,184,209,241,252]];
	obj.desc = expandDescription("[riredi_newcargo_desc]");

	worldScripts["CargoTypeExtension"].registerCargoType(obj);
}


/* Station API */


this.randomCargoChance = function (good) {
	var generic = worldScripts["CargoTypeExtension"].cargoDefinition(good, "genericType");
	if (generic == "luxuries") {
		return 0.75;
	}
	return 0;
}

this.randomCargoAmount = function (good) {
	return 3;
}

this.exportCargoAmount = function (good) {
	var generic = worldScripts["CargoTypeExtension"].cargoDefinition(good, "genericType");
	if (good == "RC-MGE1") return 2;
	return 0;
}

this.exportCargoPrice = function (good) {
	return 0.9 + (Math.random() * 0.2);
}

this.randomImportChance = function (good) {
	return 0;
}

this.systemImportChance = function (good) {
	var generic = worldScripts["CargoTypeExtension"].cargoDefinition(good, "genericType");
	if (generic == "luxuries") {
		return 1;
	} else {
		return 0;
	}
}

this.importCargoPrice = function (good) {
	return 0.9 + (Math.random() * 0.2);
}

// they have police patrol ships, so they probably obey Galcop rules here
this.importPermitCheck = function () {
	return true;
}

this.exportPermitCheck = function () {
	return true;
}

this.stationGossip = function () {
	return false;
}
