"use strict";
this.name = "riredi_navbuoy";
this.author = "phkb";
this.copyright = "2024";
this.license = "CC BY-NC-SA 4.0";

this._key = "oolite";
this._diffuse = "cb68_navbuoy.png";
this._emission = "cb68_navbuoy_illumination.png";
this._normal = "oolite_buoy_normal.png";
this._specular = "oolite_buoy_specular.png";

//-------------------------------------------------------------------------------------------------------------
this.startUp = function() {
    // check if the DHI Nav Buoy is installed
    if (Ship.shipDataForKey("DHI_Nav_Buoy")) {
        this._normal = "DHI_Nav_Buoy_Normal.png";
        this._specular = "DHI_Nav_Buoy_Specular.png";
        this._key = "DHI";
    }

	var pf = worldScripts.PlanetFall2;
	if (!pf) return;
    pf._locationOverrides["0 210"] = {
        main: [
            {
                roles: ["capitalCity", "capitalCity", "leisureComplex", "leisureComplex", "factory", "factory"],
                names: expandDescription("[riredi_planet_locations]").split("|"),
            },
        ],
    };
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {
    // make sure our texture wins any races to be the last texture installed
    var info = System.infoForSystem(0, 210);
    info.texture = "riredi_diffuse.png";
}

//-------------------------------------------------------------------------------------------------------------
this.shipSpawned = function(ship) {
    if (galaxyNumber == 0 && system.ID == 210) {
        switch (ship.dataKey) {
            case "buoy":
            case "buoy-witchpoint":
            case "DHI_Nav_Buoy":
            case "DHI_Nav_Buoy-witchpoint":
                if (this._key == "oolite") {
                    ship.setMaterials({"oolite_buoy_diffuse.png": {
                        shininess:20, gloss:0.65, specular_color:[0.8, 0.83, 0.85, 1.0], 
                        diffuse_map:this._diffuse, 
                        emission_map:this._emission, 
                        normal_map:this._normal, 
                        specular_map:this._specular}});
                } else {
                    ship.setMaterials({"DHI_Nav_Buoy.png": {
                        shininess:20, gloss:0.65, specular_color:[0.8, 0.83, 0.85, 1.0], 
                        diffuse_map:this._diffuse, 
                        emission_map:this._emission, 
                        normal_map:this._normal, 
                        specular_map:this._specular}});
                }
                break;
        }
    }
}