this.name			= "GalTech_constitution_class";
this.author			= "Montana05";
this.description	= "event handler for constitution class heavy cruiser OXP";
this.version		= "0.51";
this.copyright		= "2020 Montana05";
this.licence   		= "CC BY-NC-SA 4.0";
"use strict";

this.shipSpawned = function(ship)
{
	this.$GalTech_shipType = this.ship.dataKey;
	this.$GalTech_msgCount = 0;
	var $GalTech_shipID = " ";
	
	// individual names based on constitution class ships from Star Trek (new feature, will be removed if Shipbuilder disagrees)
	if(this.$GalTech_shipType === "constitutionclassheavycruiser")
	{
		this.$GalTech_constitution_class_name_Array = 
		["Exeter", "Essex", "Excalibur", "Lexington", "Yorktown", "Endeavor", "El Dorado", "Excelsior", "Saratoga", "Constellation", "Hornet", "Wasp", "Hood", "Lafayette", "Defiant", "Republic", "Kongo", "Enterprise", "Valiant", "Intrepid"];
		var $GalTech_constitution_class_name = $GalTech_constitution_class_name_Array[Math.floor(Math.random() * $GalTech_constitution_class_name_Array.length)];

		this.$GalTech_constitution_class_number_Array = 
		["I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"];
		var $GalTech_constitution_class_number = $GalTech_constitution_class_number_Array[Math.floor(Math.random() * $GalTech_constitution_class_number_Array.length)];

		$GalTech_shipID = " " + $GalTech_constitution_class_name + " " + $GalTech_constitution_class_number;

		// if the ship got no cargo some containers are added (new feature, will be removed if Shipbuilder disagrees)
		if(this.ship.cargoSpaceUsed === 0)
		{	
			// likely_cargo = 6, cargo_carried = computers
			var dice = this.$getRndInteger(4, 8);
			this.ship.adjustCargo("computers", dice);	
		};
	};	
	
	// individual number prefixes for shuttles based on the registration system from Star Trek (new feature, will be removed if Shipbuilder disagrees)
	if(this.$GalTech_shipType === "GalTech_shuttlecraft_class_G")
	{
		$GalTech_shipID = " NCC-" + this.$getRndInteger(1000, 9999) + "/G-SC";
	};
	
	if(this.$GalTech_shipType === "GalTech_ufp_escape_pod")
	{ 
		var dice = this.$getRndInteger(1, 100);
		var $GalTech_fleetRank = " ";
		
		// adds ranks to the crew and identifies them as starfleet members (new feature, will be removed if Shipbuilder disagrees)
		if(dice >= 95)
		{
			this.$GalTech_constitution_class_ranks01_Array = ["Lt. Commander", "Commander", "Space Captain"];
			$GalTech_fleetRank = $GalTech_constitution_class_ranks01_Array[Math.floor(Math.random() * $GalTech_constitution_class_ranks01_Array.length)];
		};

		if(dice >= 85 && dice < 95)
		{
			this.$GalTech_constitution_class_ranks02_Array = ["Ensign", "Space Junior Lieutenant", "Space Lieutenant"];
			$GalTech_fleetRank = $GalTech_constitution_class_ranks02_Array[Math.floor(Math.random() * $GalTech_constitution_class_ranks02_Array.length)];
		};

		if(dice >= 70 && dice < 85)
		{
			this.$GalTech_constitution_class_ranks03_Array = ["Petty Officer 1st Class", "Chief Petty Officer", "Snr. Chief Petty Officer", "Master Chief Petty Officer"];
			$GalTech_fleetRank = $GalTech_constitution_class_ranks03_Array[Math.floor(Math.random() * $GalTech_constitution_class_ranks03_Array.length)];
		};

		if(dice < 70)
		{
			this.$GalTech_constitution_class_ranks04_Array = ["Crewman 3rd Class", "Crewman 2nd Class", "Crewman 1st Class", "Petty Officer 3rd Class", "Petty Officer 2nd Class"];
			$GalTech_fleetRank = $GalTech_constitution_class_ranks04_Array[Math.floor(Math.random() * $GalTech_constitution_class_ranks04_Array.length)];
		};

		var $GalTech_crewName = ($GalTech_fleetRank + " " + expandDescription("[nom]"));

		this.ship.setCrew
		(
			{
				name: $GalTech_crewName,
				short_description: "a crew member of a UFP starfleet ship",
				role: "police"
			}
		);
				
		// individual number prefixes for pods based on the registration system from Star Trek (new feature, will be removed if Shipbuilder disagrees)
		$GalTech_shipID = " NCC-" + this.$getRndInteger(10000, 99999) + "/EP-01";
	};

	this.ship.displayName = this.ship.name + $GalTech_shipID;
};


this.shipBeingAttacked = function(whom)
{
	// death messages adjusted to max 2 messages when being attacked 
	if(this.$GalTech_shipType === "constitutionclassheavycruiser" && this.$GalTech_msgCount < 2)
	{
		this.ship.commsMessage(expandDescription("[constitutionclassheavycruiser-plea]"), player.ship);
		this.$GalTech_msgCount += 1;
	}
	else return;	
};

this.shipDied = function(whom, why)
{
	var debrisCount = 0;
	
	if(this.$GalTech_shipType === "constitutionclassheavycruiser")
	{
		// added death message to synchronize with original OXP
		this.ship.commsMessage("This is the Captain, matter/antimatter reactor unrepairable damaged, all crew abandon ship"), player.ship;
		
		// added explosive shrapnels to support death actions
		debrisCount = this.$getRndInteger(4, 8);
		system.addShips("GalTech_effects_explosive_shrapnel", debrisCount, this.ship.position);

		// added burning fuel (new feature, will be removed if Shipbuilder disagrees)
		debrisCount = (this.ship.fuel.toFixed(0)) * 2;	
		system.addShips("GalTech_effects_burningFuel", debrisCount, this.ship.position);

		// ejects cargopods (new feature, will be removed if Shipbuilder disagrees)
		debrisCount = this.ship.cargoSpaceUsed;
		while(debrisCount > 0)
		{
			this.ship.ejectSpecificItem("GalTech_ufp_container_computers");
			debrisCount = debrisCount - 1;
		};

		// launches 2 - 4 shuttlecrafts (new feature, will be removed if Shipbuilder disagrees)
		debrisCount = this.$getRndInteger(2, 4);
		system.addShips("GalTech_shuttlecraft_class_G", debrisCount, this.ship.position);

		// launches 4 - 6 escape pods (synchronize with original OXP)
		debrisCount = this.$getRndInteger(4, 6);
		system.addShips("GalTech_ufp_escape_pod", debrisCount, this.ship.position);
	}

	if(this.$GalTech_shipType === "GalTech_shuttlecraft_class_G")
	{
		// added explosive shrapnels
		debrisCount = this.$getRndInteger(2, 4);
		system.addShips("GalTech_effects_explosive_shrapnel", debrisCount, this.ship.position);
	}
	else return;
};	

this.$getRndInteger = function(min, max)
{
	return Math.floor(Math.random() * (max - min + 1) ) + min;
};
	
	
