"use strict";
this.name = "ore_processor_equipment";
this.author = "spara";
this.copyright = "2014 Mika Spara";
this.licence = "CC BY-NC-SA 3.0";
this.description = "Equipment activation script for ore processor";
this.version = "2.3";

// equipment activation n
this.activated = function () {
	worldScripts.oreProcessor.$extract();
}

// equipment activation b
this.mode = function () {
	if (player.ship.equipmentStatus("EQ_ORE_SCANNER") === "EQUIPMENT_OK" && player.ship.equipmentStatus("EQ_ORE_PROCESSOR") === "EQUIPMENT_OK")
		worldScripts.oreProcessor.$activateScan();
}

// hard-wiring can be bought from hermits only
this.allowAwardEquipment = function (equipKey, ship, context) {
	if (context == "scripted") return true;
	if (equipKey == "EQ_ORE_PROCESSOR_FULLAUTO") return false;
	var checkRole = player.ship.dockedStation.primaryRole;
	if (["rockhermit", "rockhermit-chaotic", "rockhermit-pirate", "[pirate-cove-single]"].indexOf(checkRole) >= 0) {
		return true;
	}
	return false;
}