"use strict";
this.name = "lave_populator";
this.author = "phkb";
this.copyright = "2024 phkb";
this.description = "Makeover for the Lave System in Chart One";
this.license = "CC-BY-NC-SA 4.0";

//-------------------------------------------------------------------------------------------------------------
this.startUp = function() {
    this.blockSystemRedux();
	if (worldScripts["Famous Planets Overhaul"]) {
		// we want to keep our texture for the planet
		var fpo = worldScripts["Famous Planets Overhaul"];
		var idx = fpo.planetList[0].indexOf(7);
		fpo.planetList.splice(idx, 1);
	}

	var pf = worldScripts.PlanetFall2;
	if (!pf) return;
    pf._locationOverrides["0 7"] = {
        main: [
            {
                roles: ["capitalCity", "capitalCity", "leisureComplex", "factory"],
                names: expandDescription("[lave_pf_city_names]").split("|"),
            },
        ],
        moon: [
            {
                roles: ["colonyDome"],
                names: [expandDescription("[lave_pf_moon_city_name]")],
            }
        ],
    };
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {
    // make sure our texture wins any races to be the last texture installed
    var info = System.infoForSystem(0, 7);
    info.texture = "lave_planet_diffuse.png";
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate = function() {
    if (galaxyNumber == 0 && system.ID == 7) {
        var mn = system.addMoon("murgh_moon_lave");
        if (worldScripts.PlanetFall2) {
            var pf = worldScripts.PlanetFall2;
            pf.$addExtraPlanetDocksForPlanet(mn);
        }
        var pl;
        if (system.countShipsWithRole("liner") < 1) {
            pl = Vector3D(14000, 50720, 34350).fromCoordinateSystem("pwm");
            system.addShips("lave_liner", 1, pl);
        }
        if (system.countShipsWithRole("junk") < 1) {
            pl = Vector3D(18730, 62700, 2500).fromCoordinateSystem("pwm");
            system.addShips("junk", 1, pl);
        }
        if (system.countShipsWithRole("junk1") < 1) {
            pl = Vector3D(16650, 70000, 17700).fromCoordinateSystem("pwm");
            system.addShips("junk1", 1, pl);
        }
        if (system.countShipsWithRole("eatcobra") < 1) {
            pl = Vector3D(31410, 71830, 20120).fromCoordinateSystem("pwm");
            system.addShips("eatcobra", 1, pl);
        }
        if (system.countShipsWithRole("bugtran") < 1) {
            pl = Vector3D(13935, 41730, 14230).fromCoordinateSystem("pwm");
            system.addShips("bugtran", 1, pl);
        }
        if (system.countShipsWithRole("ophidianpt") < 1) {
            pl = Vector3D(18935, 41730, 14230).fromCoordinateSystem("pwm");
            system.addShips("ophidianpt", 1, pl);
        }
        if (system.countShipsWithRole("trainee") < 3) {
            pl = Vector3D(16585, 59787, 20280).fromCoordinateSystem("pwm");
            system.addShips("trainee", 3, pl, 2000);
        }
        if (system.countShipsWithRole("instructor") < 1) {
            pl = Vector3D(16585, 59787, 20280).fromCoordinateSystem("pwm");
            system.addShips("instructor", 1, pl, 2000);
        }
        if (system.countShipsWithRole("lave_add1") < 1) {
            pl = Vector3D(18015, 66700, 22486).fromCoordinateSystem("pwm");
            system.addShips("lave_add1", 1, pl, 10000);
        }
        if (system.countShipsWithRole("lave_add2") < 1) {
            pl = Vector3D(18015, 66700, 22486).fromCoordinateSystem("pwm");
            system.addShips("lave_add2", 1, pl, 10000);
        }
        if (system.countShipsWithRole("lave_add3") < 1) {
            pl = Vector3D(18015, 66700, 22486).fromCoordinateSystem("pwm");
            system.addShips("lave_add3", 1, pl, 10000);
        }
        if (system.countShipsWithRole("lave_add4") < 1) {
            pl = Vector3D(18015, 66700, 22486).fromCoordinateSystem("pwm");
            system.addShips("lave_add4", 1, pl, 10000);
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
this.blockSystemRedux = function () {
	if (worldScripts["System Redux"]) {
		var sr = worldScripts["System Redux"];
		// make sure system redux startup script has been run before we try to add moon exclusions
		if (!sr.excl) {
			sr.startUp();
		}
		delete sr.startUp;
		if (sr.excl[0].indexOf(7) == -1) sr.excl[0].push(7);
	}
}
