"use strict";
this.name = "lave_mission_3";
this.author = "phkb";
this.copyright = "2024 phkb";
this.description = "Mission type 3 for Lave system";
this.license = "CC-BY-NC-SA 4.0";

this._rhRoles = ["rockhermit", "rockhermit-chaotic", "rockhermit-pirate"];

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
    if (missionVariables.LaveMission3_SourceSystemID) {
        if (system.ID == missionVariables.LaveMission3_SourceSystemID) {
            this.$setupMission();
        } else {
            this.systemWillPopulate = this.systemWillPopulate_hold;
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$setupMission = function () {
    this.missionScreenOpportunity = this.missionScreenOpportunity_hold;
    this.playerEnteredNewGalaxy = this.playerEnteredNewGalaxy_hold;

    var rhlist = [].concat(system.shipsWithRole("rockhermit")).concat(system.shipsWithRole("rockhermit-chaotic")).concat(system.shipsWithRole("rockhermit-pirate"));
    var idx = parseInt(Math.random() * rhlist.length);
    rhlist[idx]._laveMission3 = true;
    mission.setInstructionsKey(this.name + "_instructions", this.name);
    missionVariables.LaveMission3_SourceSystemID = system.ID;
}

//-------------------------------------------------------------------------------------------------------------
this.$cleanUp = function () {
    delete missionVariables.LaveMission3_SourceSystemID;
    delete this.missionScreenOpportunity;
    delete this.playerEnteredNewGalaxy;
    delete this.systemWillPopulate;
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate_hold = function () {
    if (missionVariables.LaveMission3_SourceSystemID && system.ID == missionVariables.LaveMission3_SourceSystemID) {
        this.$setupMission();
    }
}

//-------------------------------------------------------------------------------------------------------------
this.playerEnteredNewGalaxy_hold = function () {
    if (worldScripts.lave_missions._missionStatus["mission_3"] == "STARTED") {
        worldScripts.lave_missions._missionStatus["mission_3"] = "FINISHED";
        mission.setInstructionsKey(null, this.name);
        this.$cleanUp();
    }
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreenOpportunity_hold = function () {
    var stn = player.ship.dockedStation;
    if (this._rhRoles.indexOf(stn.primaryRole) >= 0) {
        if (stn.hasOwnProperty("_laveMission3") && stn._laveMission3 == true) {
            stn._laveMission3 = false;
            worldScripts.lave_missions._missionStatus["mission_3"] = "COMPLETE";
            mission.runScreen({ title: expandMissionText("lave_mission_3_title_1"), messageKey: "lave_mission_3_found", screenID: "lave_missions" });
            mission.setInstructionsKey(this.name + "_instructions_complete", this.name);
            this._missionShip = stn.launchShipWithRole("trainee_repaired");
            this._delay = new Timer(this, this.$sendFlightHome, 10, 0);
            return;
        }
    }
    if (player.ship.dockedStation.dataKey == "laveAcademy_academy") {
        var status = worldScripts.lave_missions._missionStatus["mission_3"];
        if (status == "NOT_STARTED" || status == "FINISHED" || status == "STARTED") return; // player redocked for some reason
        // otherwise, we're finished
        switch (status) {
            case "COMPLETE":
                mission.runScreen({ title: expandMissionText("lave_mission_3_title_2"), messageKey: "lave_mission_3_complete", screenID: "lave_missions" });
                player.credits += 200;
                break;
        }
        worldScripts.lave_missions._missionStatus["mission_3"] = "FINISHED";
        mission.setInstructionsKey(null, this.name);
        this.$cleanUp();
        worldScripts.lave_missions._checkForMission = false; // so we don't get asked about a new mission when we finish this one
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$sendFlightHome = function $sendFlightHome() {
    var stnLoc = system.shipsWithRole("laveAcademy_academy")[0];
    // check if we got an actual ship location returned
    if (stnLoc) {
        if (this._missionShip.isValid) {
            // send ship back to academy
            this._missionShip.AIScript.oolite_priorityai.setParameter("oolite_selectedPlanet", null);
            this._missionShip.AIScript.oolite_priorityai.setParameter("oolite_selectedStation", stnLoc);
            this._missionShip.AIScript.oolite_priorityai.reconsiderNow();
        }
    }
}