this.name      = "buoyRepairStation"; 
this.author    = "eric walch"; 
this.copyright = " 2008 the autors.";
this.description = "station for assambly Buoy's";
this.version   = "1.02.1";

this.grsClamp =[false, false]

this.shipSpawned = function()
{
    system.legacy_addShipsAtPrecisely("GRS-factory-buoy", 1, "abs", this.ship.position.add(this.ship.heading.multiply(10000)))
}

this.shipDied = function()
{
    worldScripts.buoyRepair.grsStation = false
}

this.callForHelp = function()
{
    system.legacy_addShipsAtPrecisely("buoy_repair_viper", 2, "abs", worldScripts.buoyRepair.launchSite)
    if(worldScripts.buoyRepair.logging) log("buoyRepair", "adding Viper near surface")
    worldScripts.buoyRepair.viperTarget = this.ship.target.ID
}

this.addShuttle = function()
{
    if(worldScripts.buoyRepair.shuttle > 7) return
    system.legacy_addShipsAtPrecisely("buoy_repair_shuttle_u", 1, "abs", worldScripts.buoyRepair.launchSite)
    worldScripts.buoyRepair.shuttle++
    if(worldScripts.buoyRepair.logging) log("buoyRepair", "adding Shuttle near surface")
}

this.addTugger = function()
{
    if(Math.random() < 0.5 && worldScripts.buoyRepair.tugger < 3)
    {
        system.legacy_addShips("repairBuoyTugger", 1);
        worldScripts.buoyRepair.tugger++
        if(worldScripts.buoyRepair.logging) log("buoyRepair", "adding Tugger at witchpoint")
    }
}

this.launchTugger = function()
{
    if(worldScripts.buoyRepair.tuggerE < 3)
    {
    if(worldScripts.buoyRepair.logging) log("buoyRepair", "adding Tugger to launch queue")
    worldScripts.buoyRepair.tuggerE++
    this.ship.reactToAIMessage("LAUNCH_TUGGER");
    }
}

this.launchShuttle = function()
{
    if(worldScripts.buoyRepair.shuttle > 7) return
    if(worldScripts.buoyRepair.logging) log("buoyRepair", "adding Shuttle to launch queue")
    worldScripts.buoyRepair.shuttle++
    this.ship.reactToAIMessage("LAUNCH_SHUTTLE");
}

this.launchTrader = function()
{
    if(worldScripts.buoyRepair.logging) log("buoyRepair", "adding Trader to launch queue")
}

this.launchController = function()
{
    if(worldScripts.buoyRepair.controller > 0) return
    if(worldScripts.buoyRepair.logging) log("buoyRepair", "adding Controller to launch queue")
    worldScripts.buoyRepair.controller++
    this.ship.reactToAIMessage("LAUNCH_CONTROLLER");
}

this.launchDocker = function()
{
    if(worldScripts.buoyRepair.controller > 0) return
    if(worldScripts.buoyRepair.logging) log("buoyRepair", "adding Docker to launch queue")
    worldScripts.buoyRepair.docker++
    this.ship.reactToAIMessage("LAUNCH_DOCKER");
}

this.otherShipDocked = function(ship)
{
    if(worldScripts.buoyRepair.logging) log("buoyRepair", ship.displayName + " with role "+ ship.primaryRole +" docked at the GRS station")
    if(ship.isPlayer) player.consoleMessage(expandDescription("[GRS_Welcome]"), 3);
}

this.requestFreeClamp = function()
{
    var clamp = 0;
    if(!this.grsClamp[0]) clamp +=1
    if(!this.grsClamp[1]) clamp +=2
    if (clamp == 3) clamp = Math.ceil(Math.random()*2)
    return clamp;
}

// subentity.fuel is used by shaders to control lights
this.clampOn = function(clamp)
{
    this.ship.subEntities[8-clamp].fuel = 1;
    this.grsClamp[clamp-1] = true
}

this.clampOff = function(clamp)
{
    this.ship.subEntities[8-clamp].fuel = 0;
    this.grsClamp[clamp-1] = false
}

this.raiseLightning = function(clamp)
{
    if(clamp) {this.ship.subEntities[8-clamp].fuel++}
}
this.lowerLightning = function(clamp)
{
    if(clamp) {this.ship.subEntities[8-clamp].fuel--}
}