this.name      = "buoyRepair"; 
this.author    = "eric walch (script), Svengali (artwork)"; 
this.copyright = " 2008 the autors.";
this.description = "This script adds buoy repairships when one of the two main navigation buoys gets destroyed";
this.version   = "1.02.1";

this.startUp = function()
{
    this.NLaunchQueueAdded = false
    if(worldScripts.transportSchedule || worldScripts.transportschedule !== undefined)  // has Transports.OXP installed
        this.external_fuelship = "buoy_repair_woma_fuelship"; else this.external_fuelship = "buoy_repair_fuelship"
    this.grsStation = false
    this.logging = false // "this.logging" must be "false" for a release.
    this.extraA = false; // Must also be false for a release version.
    /* for OXP-Config:
    logging - Switch on extended loging for the oxp added ships and the grs station.
    extraA - Add the GRS station in all average- and high economic systems + more testships round the station."
    */
}

this.reset = function()
{
    this.NLaunchQueueAdded = false
    this.resetTimer = new Timer(this, this.addStation, 0.1) // already add station before first launch
    // a delay greater than 0 is needed to get OXP-Config a chance to change the settings.
}

this.statusCheck = function()
{
    if(player.ship.docked) this.buoyStatusTimer.stop()
    else
    {
        if(!system.isInterstellarSpace && system.countShipsWithRole("buoy-witchpoint") == 0 && system.countShipsWithRole("repairBuoyTuggerW") == 0)
            system.legacy_addShips("repairBuoyTuggerW", 1)
        if(!system.isInterstellarSpace && !this.NLaunchQueueAdded && system.shipsWithRole("buoy", system.mainStation, 15000).length == 0 && system.countShipsWithRole("repairBuoyTuggerN") == 0)
        {
            system.legacy_addSystemShips("repairBuoyTuggerL", 1, 21) // far away 
            this.NLaunchQueueAdded = true
            if(this.logging) log("buoyRepair", "adding repairBuoyTuggerN to launch queue")
        }
    }
}

this.shipLaunchedFromStation = function()
{
    if(this.buoyStatusTimer)
        this.buoyStatusTimer.start()
    else
        this.buoyStatusTimer = new Timer(this, this.statusCheck, 15, (this.extraA ? 15 : 120))
}

this.shipExitedWitchspace = function()
{
    this.grsStation = false
    if(system.isInterstellarSpace) return
    this.addStation()
    this.NLaunchQueueAdded = false
}

this.addStation = function()
{
    if(system.economy < 2 && ((system.government > 3 && system.techLevel < 11 && system.techLevel > 4) || this.extraA) && !system.gonenova)
    {
        this.grsVector = new Vector3D(system.ID, system.ID, system.ID-256).direction();
        system.legacy_addShipsAtPrecisely("repaired-buoy-station", 1, "abs", system.mainPlanet.position.add(this.grsVector.multiply(system.mainPlanet.radius * 2)))
        this.grsStation = system.shipsWithPrimaryRole("repaired-buoy-station")[0];
        var upVector = this.grsStation.orientation.vectorUp()
        var angle = upVector.angleTo(this.grsVector)
        var cross = upVector.cross(this.grsVector).direction()
        // align the upVector to the this.grsvector
        var quaternion = this.grsStation.orientation.rotate(cross, -angle)
        // set up alignment towards main station
        var mainStatVector = system.mainStation.position.subtract(this.grsStation.position)
        cross = quaternion.vectorUp().cross(mainStatVector).direction()
        angle = quaternion.vectorRight().angleTo(cross)
        var angle2 = quaternion.vectorRight().angleTo(mainStatVector)
        if(angle2 < 0.5*Math.PI) angle=-angle
        quaternion = quaternion.rotate(quaternion.vectorUp(), angle + 0.07) // docking bay roughly towards main station. (0.07 rad or 4 degr. off for a better look)
        if(system.economy == 1) // tilt the station dock towards the planet in average industrial
            quaternion = quaternion.rotate(quaternion.vectorRight(), -1.1) // good values are -1.05 till -1.15
        this.grsStation.setOrientation(quaternion)
        // within a system the station now has always the same orientation
        this.launchSite = system.mainPlanet.position.add(this.grsVector.multiply(system.mainPlanet.radius + 500))
        this.addShips()
    }
}

this.addShips = function()
{
    // add rising shuttles
    this.shuttle = 2
    system.legacy_addShipsAtPrecisely("buoy_repair_shuttle_u", 2, "abs", this.launchSite)
    // add returning armandillos
    this.tugger = 0
    if(Math.random()< 0.75) {system.legacy_addShipsAt("repairBuoyTugger", 1, "pwu", [0.0, 0.0, 0.25]); ++this.tugger}
    if(Math.random()< 0.50) {system.legacy_addShipsAt("repairBuoyTugger", 1, "pwu", [0.0, 0.0, 0.50]); ++this.tugger}
    if(Math.random()< 0.35) {system.legacy_addShipsAt("repairBuoyTugger", 1, "pwu", [0.0, 0.0, 0.75]); ++this.tugger}
    // add big traders
    if(Math.random()< 0.5) system.legacy_addSystemShips("buoy_repair_big_trader", 1, Math.random()*0.8+0.1)
    if(Math.random()< 0.5) system.legacy_addSystemShips("buoy_repair_big_trader", 1, Math.random()*0.8+0.1)
    var sunVector = system.sun.position.subtract(this.grsStation.position).direction()
    // add repeating dockers
    this.docker = 2
    system.legacy_addShipsWithinRadius("buoy_repair_docker", 1, "abs", this.grsStation.position.add(sunVector.multiply(40E3)), 1E4)
    system.legacy_addShipsWithinRadius("buoy_repair_docker", 1, "abs", this.grsStation.position.add(sunVector.multiply(80E3)), 1E4)
    // add fuel ships
    if(this.extraA || Math.random()>0.5) this.addFuelShip(this.grsStation.position.add(sunVector.multiply(50E3)))
    if(this.extraA || Math.random()>0.5) this.addFuelShip(this.grsStation.position.add(sunVector.multiply(100E3)))
    if(this.extraA || Math.random()>0.25) this.addFuelShip(this.grsStation.position.add(sunVector.multiply(250E3)))
    if(this.extraA || Math.random()>0.25) this.addFuelShip(this.grsStation.position.add(sunVector.multiply(350E3)))
    this.controller = 0
    this.tuggerE = 0
}

this.addFuelShip = function(position)
{
    if(Math.random() > 0.4) system.legacy_addShipsWithinRadius("buoy_repair_fuelship", 1, "abs", position, 1E4)    
        else system.legacy_addShipsWithinRadius(this.external_fuelship, 1, "abs", position, 1E4)   
}

// below is code used only by ship scripts.
this.addShipnumber = function(name)
{
    var list = ["NL", "DG", "RF", "PH", "TZ"]
    return name + " " + list[Math.floor(Math.random() * list.length)] + Math.ceil(Math.random()*127);
}

this.switch = function(oldShip, buoyName, buoyRole, newAIState)
{
    var subentities = oldShip.subEntities
    for (var i=0; i<subentities.length; i++)
    {
        if(subentities[i].name == buoyName) // Only release beacon if still present.
        {
            var newShip = oldShip.spawnOne("switchedRepairBuoyTugger"); // add replacement ship to system.
            var buoy = oldShip.spawnOne(buoyRole);
            buoy.AIState = "LIGHTS_OFF"
            var target = player.ship.target
            var oldOrientation = oldShip.orientation
            var oldPosition = oldShip.position
            var oldVector = oldShip.heading //vector with lenght 1 meter
            newShip.displayName = oldShip.displayName
            oldShip.setPosition(oldShip.position.multiply(100)) // to deep space
            newShip.setOrientation(oldOrientation)
            buoy.setOrientation(oldOrientation)
            newShip.setPosition(oldPosition)
            buoy.setPosition(oldPosition.add(oldVector.multiply(subentities[i].position.z)))
            if(target == oldShip) newShip.script.playerTarget = true
            newShip.primaryRole = "repairBuoyTugger" // in case there are more switchings going on.
            newShip.AIState = newAIState
            oldShip.AIState = "DISAPPEAR"
            if(this.logging) log("buoyRepair", "Replaced: " + buoyRole)
        }
    }
}

// routes for controll ship
/*
// Next two positions are within the bounding box and regularly lead to random collisions
this.positions1 = [
                new Vector(-200, 100, 5000), //nav1
                new Vector(-200, 1200, 3500), //stationapproach
                new Vector(-200, 1200, 1000), //basement
                new Vector(200, 700, 800), //above bay
                new Vector(450, 1250, 625), // above arch high
                new Vector(800, 1150, 500), // above arch low
                new Vector(600, 600, -800), // behind arch
                new Vector(500, 0, -1100), // behind station
                new Vector(600, -450, -300), // under station
                new Vector(1100, -150, 1500) // bolow rescue kit
                ];
this.positions2 = [
                new Vector(-200, 100, 5000), //nav1
                new Vector(-200, 1200, 3500), //stationapproach
                new Vector(-200, 1200, 1000), //basement
                new Vector(200, 600, 800), //above bay
                new Vector(400, 900, 400), // above arch
                new Vector(500, 550,-800), // behind arch
                new Vector(-100, 700, -400), // above explosives
                new Vector(-400, 1000, 100), // between poles
                new Vector(-900, 500, 900), // above grs logo
                new Vector(-900, 100, 1200), // in front of grs logo
                new Vector(-950, -400, 500), // heading to clamp 2
                new Vector(-950, -500, 000), // below clamp 2
                new Vector(-100, -700, -300), // below station back
                new Vector(700, -700, -200), // below station back
                new Vector(900, -600, 900) // below station front
                ];
*/
this.positions3 = [
                new Vector(-200, 100, 5000), //nav1
                new Vector(-200, 1200, 3500), //stationapproach
                new Vector(-1700, -1000, 1700),
                new Vector(-1700, 500, -1700),
                new Vector(1700, 1000, -1700),
                new Vector(1700, 500, 1700),
                new Vector(-1700, 500, 1700),
                new Vector(-1700, 1700, 1700),
                new Vector(0, 1700, 0),
                new Vector(1700, 1700, 1700),
                new Vector(1700, -1700, 1700),
                new Vector(0, -1700, 0),
                new Vector(-500, -1700, 2000)
                ];
this.positions4 = [
                new Vector(-200, 100, 5000), //nav1
                new Vector(-200, 1200, 3500), //stationapproach
                new Vector(-500, -1700, 2000),
                new Vector(0, -1700, 0),
                new Vector(1700, -1700, 1700),
                new Vector(1700, 1700, 1700),
                new Vector(0, 1700, 0),
                new Vector(-1700, 1700, 1700),
                new Vector(-1700, 500, 1700),
                new Vector(1700, 500, 1700),
                new Vector(1700, 1000, -1700),
                new Vector(-1700, 500, -1700),
                new Vector(-1700, -1000, 1700),
                new Vector(-200, 1200, 3500)
                ];
this.routes = [this.positions3, this.positions4]
// worldScripts.buoyRepair.routes[0][0]=new Vector(00,00,00)