"use strict";
this.name = "Cargo Pod 60 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "1.1";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_60TC_POD") {		
		pc("Attaching one 60 TC Pod to auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity += 60;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
		// always 1 because only one pod can be fitted
		this.$cp6Pods=1;
	} else
	// pod removal and refund
	if (equipment == "EQ_60TC_POD_REM") {
		player.ship.removeEquipment("EQ_60TC_POD");
		player.ship.removeEquipment("EQ_60TC_POD_REM");
		pc("Detaching 60 TC Pod from auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity -= 60;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
		this.$cp6Pods=0;
		player.credits += this.$cp6Cost;
		pc("Amount refunded: "+ this.$cp6Cost,9);
	}
}



this.startUpComplete = function () {
	var pc = player.consoleMessage;
	if (missionVariables.cp6Pods != null) 
		this.$cp6Pods = missionVariables.cp6Pods;
	// Load total fees taken
	if (missionVariables.cp6HandlingFeeTotal != null)
		this.$cp6HandlingFeeTotal = missionVariables.cp6HandlingFeeTotal;
	if (missionVariables.cp6HandlingPaid != null)
		this.$cp6HandlingPaid = missionVariables.cp6HandlingPaid;
	if (missionVariables.cp6MaintenanceFeeTotal != null)
		this.$cp6MaintenanceFeeTotal = missionVariables.cp6MaintenanceFeeTotal;
	if (missionVariables.cp6DismantlingFeeTotal != null)
		this.$cp6DismantlingFeeTotal = missionVariables.cp6DismantlingFeeTotal; 
    // Load system-to-system runs w/pod
	if (missionVariables.cp6Runs != null)
		this.$cp6Runs = missionVariables.cp6Runs;
	// Load Handling fee count
	if (missionVariables.cp6HandlingCount != null)
		this.$cp6HandlingCount = missionVariables.cp6HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.cp6HFExempt != null)
		this.$cp6HFExempt = missionVariables.cp6HFExempt;
	// Load Maintenance fee count
	if (missionVariables.cp6MaintenanceCount != null)
		this.$cp6MaintenanceCount = missionVariables.cp6MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// prepare pod Account screen
	var sta = player.ship.dockedStation;
	if (this.$cp6Pods>0) this._cp6PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$cp6Pods>0) this._cp6PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$cp6ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$cp6ET = true;
	// TEST	
	if (this.$cp6ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$cp6FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$cp6FES = true;
	// TEST	
	if (this.$cp6ET) log(this.name, "Finds FE Ships Player present");
	// number of pods - when fitted, always 1
	this.$cp6Pods = 0;
	// purchase cost of pod in cr
	this.$cp6Cost = 60000;
	// handling fee
	this.$cp6HandlingFee = 0.005*this.$cp6Cost; // 0.005 of cost
	this.$cp6HandlingFeeTotal = 0;
	this.$cp6HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$cp6HandlingCount = 0;
	this.$cp6HFExempt = "no";
	// maintenance fee
	this.$cp6MaintenanceFee = 0.05*this.$cp6Cost; // 0.05 of cost
	this.$cp6MaintenanceFeeTotal = 0;
	this.$cp6MaintenancePaid = "no" // or "yes"
	this.$cp6MaintenanceInterval = 60; // in runs (according to cost)
	this.$cp6MaintenanceCount = 0;
	// dismantling fee
	this.$cp6DismantlingFee = 0.1*this.$cp6Cost; // 0.1 of cost
	this.$cp6DismantlingFeeTotal = 0.0;
	// system-to-system runs w/pod
	this.$cp6Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.cp6Pods = this.$cp6Pods;
	// save total fees taken
	missionVariables.cp6HandlingFeeTotal = this.$cp6HandlingFeeTotal;
	missionVariables.cp6MaintenanceFeeTotal = this.$cp6MaintenanceFeeTotal;
	missionVariables.cp6DismantlingFeeTotal = this.$cp6DismantlingFeeTotal;
	missionVariables.cp6HandlingPaid = this.$cp6HandlingPaid;
	// system-to-system runs w/pod
	missionVariables.cp6Runs =this.$cp6Runs;
	// handling fee count
	missionVariables.cp6HandlingCount = this.$cp6HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.cp6HFExempt = this.$cp6HFExempt;
	// maintenance fee count
	missionVariables.cp6MaintenanceCount = this.$cp6MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$cp6HFExempt;
	// check we have pods, the fee is not paid, and we're not exempt
	if ((this.$cp6Pods>0) && (this.$cp6HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$cp6Pods; x++)
			fee += this.$cp6HandlingFee;
		// record fee and debit trader's account
		this.$cp6HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$cp6HandlingPaid = "yes";
		pc("60 TC Pod handling fees: "+fee+" cr",9);
		this.$cp6HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$cp6Pods>0) this._cp6DoMaintenance();
	
	// prepare pod Account and Licence page
	if (this.$cp6Pods>0) this._cp6PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$cp6Pods>0) this._cp6PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$cp6HandlingPaid = "no";
	this.$cp6Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._cp6DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$cp6Runs;
	var intv = this.$cp6MaintenanceInterval;
	var mfee = this.$cp6MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x pods
		var fee = 0;
		for (var x=1; x<= this.$cp6Pods; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$cp6MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("60 TC Pod Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$cp6MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._cp6PrepAcc = function(station) {
	station.setInterface("cp6Acc",{
	title: "Your FE Shipyards 60 TC Pod Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 60 TC Pod account screen shows terms, fees paid, load, and other useful information.",
	callback: this._cp6ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._cp6ShowAcc = function() {
	var hfc = this.$cp6HandlingCount;
	var mfc = this.$cp6MaintenanceCount;
	var mfi = this.$cp6MaintenanceInterval;
	var hft = this.$cp6HandlingFeeTotal;
	var mft = this.$cp6MaintenanceFeeTotal;
	var dft = this.$cp6DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$cp6Pods>0) 
		parameters.message +="Your Account and Licence for 60 TC Class Goods Pods x "+this.$cp6Pods+": \n\n"; 
	 else
		parameters.message +="You have no 60 TC Class Pods licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our pods are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Pod account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylon for weapons-use. \n";
	
	parameters.choicesKey = "cp6Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._cp6PrepEx = function(station) {
	station.setInterface("cp6Ex",{
	title: "Your FE Shipyards Pod Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 60-ton pod class." ,
	callback: this._cp6ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._cp6ShowEx = function() {
	var priv = ((this.$cp6ET)||(this.$cp6FES));
	var privo = "";
	if (this.$cp6FES) privo="FE shipowner";
	if (this.$cp6ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 60 TC pod fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "cp6YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$cp6HFExempt = "yes"; else this.$cp6HFExempt = "no";
		} else this.$cp6HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}
