"use strict";
this.name = "Cargo Pod 50 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "1.1";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_50TC_POD") {		
		pc("Attaching one 50 TC Pod to auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity += 50;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
		// always 1 because only one pod can be fitted
		this.$cp5Pods=1;
	} else
	// pod removal and refund
	if (equipment == "EQ_50TC_POD_REM") {
		player.ship.removeEquipment("EQ_50TC_POD");
		player.ship.removeEquipment("EQ_50TC_POD_REM");
		pc("Detaching 50 TC Pod from auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity -= 50;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
		this.$cp5Pods=0;
		player.credits += this.$cp5Cost;
		pc("Amount refunded: "+ this.$cp5Cost,9);
	}
}



this.startUpComplete = function () {
	var pc = player.consoleMessage;
	if (missionVariables.cp5Pods != null) 
		this.$cp5Pods = missionVariables.cp5Pods;
	// Load total fees taken
	if (missionVariables.cp5HandlingFeeTotal != null)
		this.$cp5HandlingFeeTotal = missionVariables.cp5HandlingFeeTotal;
	if (missionVariables.cp5HandlingPaid != null)
		this.$cp5HandlingPaid = missionVariables.cp5HandlingPaid;
	if (missionVariables.cp5MaintenanceFeeTotal != null)
		this.$cp5MaintenanceFeeTotal = missionVariables.cp5MaintenanceFeeTotal;
	if (missionVariables.cp5DismantlingFeeTotal != null)
		this.$cp5DismantlingFeeTotal = missionVariables.cp5DismantlingFeeTotal; 
    // Load system-to-system runs w/pod
	if (missionVariables.cp5Runs != null)
		this.$cp5Runs = missionVariables.cp5Runs;
	// Load Handling fee count
	if (missionVariables.cp5HandlingCount != null)
		this.$cp5HandlingCount = missionVariables.cp5HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.cp5HFExempt != null)
		this.$cp5HFExempt = missionVariables.cp5HFExempt;
	// Load Maintenance fee count
	if (missionVariables.cp5MaintenanceCount != null)
		this.$cp5MaintenanceCount = missionVariables.cp5MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// prepare pod Account screen
	var sta = player.ship.dockedStation;
	if (this.$cp5Pods>0) this._cp5PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$cp5Pods>0) this._cp5PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$cp5ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$cp5ET = true;
	// TEST	
	if (this.$cp5ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$cp5FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$cp5FES = true;
	// TEST	
	if (this.$cp5ET) log(this.name, "Finds FE Ships Player present");
	// number of pods - when fitted, always 1
	this.$cp5Pods = 0;
	// purchase cost of pod in cr
	this.$cp5Cost = 50000;
	// handling fee
	this.$cp5HandlingFee = 0.005*this.$cp5Cost; // 0.005 of cost
	this.$cp5HandlingFeeTotal = 0;
	this.$cp5HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$cp5HandlingCount = 0;
	this.$cp5HFExempt = "no";
	// maintenance fee
	this.$cp5MaintenanceFee = 0.05*this.$cp5Cost; // 0.05 of cost
	this.$cp5MaintenanceFeeTotal = 0;
	this.$cp5MaintenancePaid = "no" // or "yes"
	this.$cp5MaintenanceInterval = 50; // in runs (according to cost)
	this.$cp5MaintenanceCount = 0;
	// dismantling fee
	this.$cp5DismantlingFee = 0.1*this.$cp5Cost; // 0.1 of cost
	this.$cp5DismantlingFeeTotal = 0.0;
	// system-to-system runs w/pod
	this.$cp5Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.cp5Pods = this.$cp5Pods;
	// save total fees taken
	missionVariables.cp5HandlingFeeTotal = this.$cp5HandlingFeeTotal;
	missionVariables.cp5MaintenanceFeeTotal = this.$cp5MaintenanceFeeTotal;
	missionVariables.cp5DismantlingFeeTotal = this.$cp5DismantlingFeeTotal;
	missionVariables.cp5HandlingPaid = this.$cp5HandlingPaid;
	// system-to-system runs w/pod
	missionVariables.cp5Runs =this.$cp5Runs;
	// handling fee count
	missionVariables.cp5HandlingCount = this.$cp5HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.cp5HFExempt = this.$cp5HFExempt;
	// maintenance fee count
	missionVariables.cp5MaintenanceCount = this.$cp5MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$cp5HFExempt;
	// check we have pods, the fee is not paid, and we're not exempt
	if ((this.$cp5Pods>0) && (this.$cp5HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$cp5Pods; x++)
			fee += this.$cp5HandlingFee;
		// record fee and debit trader's account
		this.$cp5HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$cp5HandlingPaid = "yes";
		pc("50 TC Pod handling fees: "+fee+" cr",9);
		this.$cp5HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$cp5Pods>0) this._cp5DoMaintenance();
	
	// prepare pod Account and Licence page
	if (this.$cp5Pods>0) this._cp5PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$cp5Pods>0) this._cp5PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$cp5HandlingPaid = "no";
	this.$cp5Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._cp5DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$cp5Runs;
	var intv = this.$cp5MaintenanceInterval;
	var mfee = this.$cp5MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x pods
		var fee = 0;
		for (var x=1; x<= this.$cp5Pods; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$cp5MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("50 TC Pod Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$cp5MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._cp5PrepAcc = function(station) {
	station.setInterface("cp5Acc",{
	title: "Your FE Shipyards 50 TC Pod Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 50 TC Pod account screen shows terms, fees paid, load, and other useful information.",
	callback: this._cp5ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._cp5ShowAcc = function() {
	var hfc = this.$cp5HandlingCount;
	var mfc = this.$cp5MaintenanceCount;
	var mfi = this.$cp5MaintenanceInterval;
	var hft = this.$cp5HandlingFeeTotal;
	var mft = this.$cp5MaintenanceFeeTotal;
	var dft = this.$cp5DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$cp5Pods>0) 
		parameters.message +="Your Account and Licence for 50 TC Class Goods Pods x "+this.$cp5Pods+": \n\n"; 
	 else
		parameters.message +="You have no 50 TC Class Pods licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our pods are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Pod account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylon for weapons-use. \n";
	
	parameters.choicesKey = "cp5Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._cp5PrepEx = function(station) {
	station.setInterface("cp5Ex",{
	title: "Your FE Shipyards Pod Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 50-ton pod class." ,
	callback: this._cp5ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._cp5ShowEx = function() {
	var priv = ((this.$cp5ET)||(this.$cp5FES));
	var privo = "";
	if (this.$cp5FES) privo="FE shipowner";
	if (this.$cp5ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 50 TC pod fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "cp5YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$cp5HFExempt = "yes"; else this.$cp5HFExempt = "no";
		} else this.$cp5HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}
