"use strict";
this.name = "Cargo Pod 40 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "1.1";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_40TC_POD") {		
		pc("Attaching one 40 TC Pod to auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity += 40;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
		// always 1 because only one pod can be fitted
		this.$cp4Pods=1;
	} else
	// pod removal and refund
	if (equipment == "EQ_40TC_POD_REM") {
		player.ship.removeEquipment("EQ_40TC_POD");
		player.ship.removeEquipment("EQ_40TC_POD_REM");
		pc("Detaching 40 TC Pod from auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity -= 40;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
		this.$cp4Pods=0;
		player.credits += this.$cp4Cost;
		pc("Amount refunded: "+ this.$cp4Cost,9);
	}
}



this.startUpComplete = function () {
	var pc = player.consoleMessage;
	if (missionVariables.cp4Pods != null) 
		this.$cp4Pods = missionVariables.cp4Pods;
	// Load total fees taken
	if (missionVariables.cp4HandlingFeeTotal != null)
		this.$cp4HandlingFeeTotal = missionVariables.cp4HandlingFeeTotal;
	if (missionVariables.cp4HandlingPaid != null)
		this.$cp4HandlingPaid = missionVariables.cp4HandlingPaid;
	if (missionVariables.cp4MaintenanceFeeTotal != null)
		this.$cp4MaintenanceFeeTotal = missionVariables.cp4MaintenanceFeeTotal;
	if (missionVariables.cp4DismantlingFeeTotal != null)
		this.$cp4DismantlingFeeTotal = missionVariables.cp4DismantlingFeeTotal; 
    // Load system-to-system runs w/pod
	if (missionVariables.cp4Runs != null)
		this.$cp4Runs = missionVariables.cp4Runs;
	// Load Handling fee count
	if (missionVariables.cp4HandlingCount != null)
		this.$cp4HandlingCount = missionVariables.cp4HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.cp4HFExempt != null)
		this.$cp4HFExempt = missionVariables.cp4HFExempt;
	// Load Maintenance fee count
	if (missionVariables.cp4MaintenanceCount != null)
		this.$cp4MaintenanceCount = missionVariables.cp4MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// prepare pod Account screen
	var sta = player.ship.dockedStation;
	if (this.$cp4Pods>0) this._cp4PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$cp4Pods>0) this._cp4PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$cp4ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$cp4ET = true;
	// TEST	
	if (this.$cp4ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$cp4FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$cp4FES = true;
	// TEST	
	if (this.$cp4ET) log(this.name, "Finds FE Ships Player present");
	// number of pods - when fitted, always 1
	this.$cp4Pods = 0;
	// purchase cost of pod in cr
	this.$cp4Cost = 40000;
	// handling fee
	this.$cp4HandlingFee = 0.005*this.$cp4Cost; // 0.005 of cost
	this.$cp4HandlingFeeTotal = 0;
	this.$cp4HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$cp4HandlingCount = 0;
	this.$cp4HFExempt = "no";
	// maintenance fee
	this.$cp4MaintenanceFee = 0.05*this.$cp4Cost; // 0.05 of cost
	this.$cp4MaintenanceFeeTotal = 0;
	this.$cp4MaintenancePaid = "no" // or "yes"
	this.$cp4MaintenanceInterval = 40; // in runs (according to cost)
	this.$cp4MaintenanceCount = 0;
	// dismantling fee
	this.$cp4DismantlingFee = 0.1*this.$cp4Cost; // 0.1 of cost
	this.$cp4DismantlingFeeTotal = 0.0;
	// system-to-system runs w/pod
	this.$cp4Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.cp4Pods = this.$cp4Pods;
	// save total fees taken
	missionVariables.cp4HandlingFeeTotal = this.$cp4HandlingFeeTotal;
	missionVariables.cp4MaintenanceFeeTotal = this.$cp4MaintenanceFeeTotal;
	missionVariables.cp4DismantlingFeeTotal = this.$cp4DismantlingFeeTotal;
	missionVariables.cp4HandlingPaid = this.$cp4HandlingPaid;
	// system-to-system runs w/pod
	missionVariables.cp4Runs =this.$cp4Runs;
	// handling fee count
	missionVariables.cp4HandlingCount = this.$cp4HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.cp4HFExempt = this.$cp4HFExempt;
	// maintenance fee count
	missionVariables.cp4MaintenanceCount = this.$cp4MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$cp4HFExempt;
	// check we have pods, the fee is not paid, and we're not exempt
	if ((this.$cp4Pods>0) && (this.$cp4HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$cp4Pods; x++)
			fee += this.$cp4HandlingFee;
		// record fee and debit trader's account
		this.$cp4HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$cp4HandlingPaid = "yes";
		pc("40 TC Pod handling fees: "+fee+" cr",9);
		this.$cp4HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$cp4Pods>0) this._cp4DoMaintenance();
	
	// prepare pod Account and Licence page
	if (this.$cp4Pods>0) this._cp4PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$cp4Pods>0) this._cp4PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$cp4HandlingPaid = "no";
	this.$cp4Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._cp4DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$cp4Runs;
	var intv = this.$cp4MaintenanceInterval;
	var mfee = this.$cp4MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x pods
		var fee = 0;
		for (var x=1; x<= this.$cp4Pods; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$cp4MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("40 TC Pod Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$cp4MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._cp4PrepAcc = function(station) {
	station.setInterface("cp4Acc",{
	title: "Your FE Shipyards 40 TC Pod Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 40 TC Pod account screen shows terms, fees paid, load, and other useful information.",
	callback: this._cp4ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._cp4ShowAcc = function() {
	var hfc = this.$cp4HandlingCount;
	var mfc = this.$cp4MaintenanceCount;
	var mfi = this.$cp4MaintenanceInterval;
	var hft = this.$cp4HandlingFeeTotal;
	var mft = this.$cp4MaintenanceFeeTotal;
	var dft = this.$cp4DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$cp4Pods>0) 
		parameters.message +="Your Account and Licence for 40 TC Class Goods Pods x "+this.$cp4Pods+": \n\n"; 
	 else
		parameters.message +="You have no 40 TC Class Pods licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our pods are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Pod account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylon for weapons-use. \n";
	
	parameters.choicesKey = "cp4Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._cp4PrepEx = function(station) {
	station.setInterface("cp4Ex",{
	title: "Your FE Shipyards Pod Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 40-ton pod class." ,
	callback: this._cp4ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._cp4ShowEx = function() {
	var priv = ((this.$cp4ET)||(this.$cp4FES));
	var privo = "";
	if (this.$cp4FES) privo="FE shipowner";
	if (this.$cp4ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 40 TC pod fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "cp4YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$cp4HFExempt = "yes"; else this.$cp4HFExempt = "no";
		} else this.$cp4HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}
