this.name        = "OXPConfig";
this.author      = "svengali";
this.copyright   = "CC-by-nc-sa-3.0";
this.description = "Configuration Tool for oxps";
this.version     = "1.02";

this.startUp = function()
{
	this.oxpConfigTimer = new Timer(this, this.oxpConfigTimer, 0, 10);
	this.shouldShow = false; this.showsNow = false; this.started = false; this.currentPage = 0; this.currentCommander = "";
	this.settings = new Array(); this.defaults = new Array(); this.selectiveLoad = new Array(0,0,0,0); this.oxpMax = 7; this.dImplant = "|0|0|0|0";
	this.logging = false;	// Logging on/off
	this.audio = true;		// Reset on next startup for database updates - Only internaly used!
	this.extraA = true;		// Automatic load on starting Oolite, after dying and loading new savedgame on/off
	this.extraB = true;		// Selective load on/off
}

this.reset = function()
{
this.getArrays();
	// Oolite start check - prepare everything here that only has to be done once
	if (!this.started) { this.getArrays();
		this.numberOfOxps = expandDescription("[OXPCONFIG_OVERALLB]");
		this.currentOxp = new Array(); this.started = true; }
	// Check here if database is bigger than stored value - disable this.audio to avoid complete reset
	if (missionVariables.oxpConfig_storedOxps && missionVariables.oxpConfig_storedOxps < this.numberOfOxps && missionVariables.oxpConfig_defaults) {
		this.audio = false; player.consoleMessage('OXPConfig database updated. Please configure new entries.',8); }
	// Check the reset flag - set when database changed. It only works if database is bigger than last stored number of oxps
	if (this.audio) {
		if ((!(this.settings[0]&2) && missionVariables.oxpConfig_storedOxps !=this.numberOfOxps) || !missionVariables.oxpConfig_settings) {
			missionVariables.oxpConfig_settings = null; missionVariables.oxpConfig_storedOxps = null;
			missionVariables.oxpConfig_selectiveLoad = null; missionVariables.oxpConfig_defaults = null;
			if (this.logging) log('OXPConfig reset for database rebuilt and preparing selective loading.');
			this.audio = false; this.extraB = false; // Reset and selectiveLoad disabled
			this.storeSettings(1); // This will store only default values, a user has to configure the oxps again - normal behaviour of a reset :-)
			player.consoleMessage('OXPConfig reset/updated.',8); }
		else { this.audio = false; }}
	this.getArrays();
	// Set flags depending on stored value - can override settings in startUp
	if (missionVariables.oxpConfig_settings && this.numberOfOxps > 6) {
		if (this.logging) log('OXPConfig setting flags.');
		if ((this.settings[0]&1)) this.logging = true;
		else this.logging = false;
		if ((this.settings[0]&2)) this.audio = true;
		else this.audio = false;
		if ((this.settings[0]&4)) this.extraA = true;
		else this.extraA = false;
		if ((this.settings[0]&8)) this.extraB = true;
		else this.extraB = false;
		// Check for automatic load
		if (this.extraA) {
			if (this.logging) log('OXPConfig','OXPConfig automatic loading initiated...');
			this.loadSettings(null); }}
	this.oxpConfigTimer.start(); this.oxpOverride = 0;
}

this.getArrays = function()
{
	// Get pseudo arrays from missionVariables
	if (missionVariables.oxpConfig_settings) {
		if (!parseInt(missionVariables.oxpConfig_settings)) this.settings = missionVariables.oxpConfig_settings.split("|");
		else { let convert = parseInt(missionVariables.oxpConfig_settings); convert <<= 4;
			convert &= (Math.pow(2,(this.oxpMax*4+1))-1); convert |= 4; this.settings[1] = convert; missionVariables.oxpConfig_settings = "|"+convert; }
		this.settings.shift(); }
	else { this.settings[0] = 0; this.audio = true; }
	if (missionVariables.oxpConfig_defaults) {
		if (!parseInt(missionVariables.oxpConfig_defaults)) this.defaults = missionVariables.oxpConfig_defaults.split("|");
		else this.defaults[1] = parseInt(missionVariables.oxpConfig_defaults);
		this.defaults.shift(); }
	else { let convert = parseInt(missionVariables.oxpConfig_settings); convert <<= 4;
		convert &= (Math.pow(2,(this.oxpMax*4+1))-1); convert |= 4; this.defaults[0] = convert; missionVariables.oxpConfig_defaults = "|"+convert; }
	if (missionVariables.oxpConfig_selectiveLoad) {
		if (!parseInt(missionVariables.oxpConfig_selectiveLoad)) this.selectiveLoad = missionVariables.oxpConfig_selectiveLoad.split("|");
		else this.selectiveLoad[1] = parseInt(missionVariables.oxpConfig_selectiveLoad);
		this.selectiveLoad.shift(); }
	else { missionVariables.oxpConfig_selectiveLoad = this.dImplant; this.selectiveLoad = missionVariables.oxpConfig_selectiveLoad.split("|");
		this.settings[0] &= (Math.pow(2,(this.oxpMax*4+1))-9); this.extraB = false; }
	return;
}

this.oxpConfigTimer = function()
{
	if (player.status == "STATUS_DOCKED" && guiScreen == "GUI_SCREEN_GAMEOPTIONS") { this.shouldShow = true; this.oxpConfigTimer.stop();
		player.consoleMessage('OXPConfig activated.\nStep to SYSTEM_DATA_SCREEN for configuration screens.', 2); }
}

this.guiScreenChanged = function(to)
{
	if (this.shouldShow && player.status == "STATUS_DOCKED") {
		if (to == "GUI_SCREEN_SYSTEM_DATA") { this.showConfigScreens(); return; }
		else if(to != "GUI_SCREEN_SYSTEM_DATA" && !this.showsNow) {
			this.currentPage = 0; this.shouldShow = false; this.oxpConfigTimer.start();
			player.consoleMessage('OXPConfig de-activated.', 3);
			missionVariables.offering = null; mission.choice = null; } }
}

this.showConfigScreens = function(stored,loaded)
{
	missionVariables.offering = "OXP-CONFIG"; this.showsNow = true;
	mission.runMissionScreen("OXPCONFIG_FIRST", null, "OXPCONFIG_TOPLEVEL", null, null);
	if (loaded == 1) { mission.addMessageTextKey("OXPCONFIG_LOADED"); }
	if (loaded == 2) { mission.addMessageTextKey("OXPCONFIG_LOADEDERROR"); }
	if (stored == 1) { mission.addMessageTextKey("OXPCONFIG_STORED"); }
	if (stored == 2) { mission.addMessageTextKey("OXPCONFIG_STOREDERROR"); }
	mission.addMessageTextKey("OXPCONFIG_WELCOMEA"); mission.addMessageTextKey("OXPCONFIG_WELCOMEB");
	mission.addMessageTextKey("OXPCONFIG_QUEST");
}

this.showNextScreen = function(nextchoice,oxp)
{
	this.oxpOverride = 0;
	if (oxp) { let checkoxp = expandDescription("[OXPCONFIG"+oxp+"_INFO0]");
		if (!worldScripts[checkoxp]) { this.changedOxp = oxp; mission.runMissionScreen("OXPCONFIG_FIRST", null, null, null, null);
			mission.addMessageText(expandDescription("[OXPCONFIG"+oxp+"_INFO0]")+' is not installed.'); mission.setChoicesKey("OXPCONFIG_CHANGE0"); return; }
		if (typeof(worldScripts[checkoxp].logging) == 'undefined') this.oxpOverride |= 1;
		if (typeof(worldScripts[checkoxp].audio) == 'undefined') this.oxpOverride |= 2;
		if (typeof(worldScripts[checkoxp].extraA) == 'undefined') this.oxpOverride |= 4;
		if (typeof(worldScripts[checkoxp].extraB) == 'undefined') this.oxpOverride |= 8;
		if (this.oxpOverride == 15) { this.changedOxp = oxp; mission.runMissionScreen("OXPCONFIG_FIRST", null, null, null, null);
			mission.addMessageText('This version of '+checkoxp+' is not compatible. Maybe it is an older version.'); mission.setChoicesKey("OXPCONFIG_CHANGE0"); return; } }
	if (!nextchoice || nextchoice == "") { mission.runMissionScreen("OXPCONFIG_FIRST", null, null, null, null); }
	else { mission.runMissionScreen("OXPCONFIG_FIRST", null, nextchoice, null, null); }
	if (oxp) { this.changedOxp = oxp;
		for (let i = 0; i != 3; i++) { this.currentOxp[i] = expandDescription("[OXPCONFIG"+oxp+"_INFO"+i+"]"); }
		mission.addMessageText('Current OXP: '+worldScripts[this.currentOxp[0]].name+' '+worldScripts[this.currentOxp[0]].version+'\r\r\rAuthor:'+worldScripts[this.currentOxp[0]].author+' #'+oxp);
		mission.addMessageTextKey("OXPCONFIG_DIVIDE");
		if ((this.currentOxp[1]&1) && !(this.oxpOverride&1)) { mission.addMessageText('logging : '+worldScripts[this.currentOxp[0]].logging); }
		if ((this.currentOxp[1]&2) && !(this.oxpOverride&2)) { mission.addMessageText('audio     : '+worldScripts[this.currentOxp[0]].audio); }
		if ((this.currentOxp[1]&4) && !(this.oxpOverride&4)) { mission.addMessageText('extraA   : '+worldScripts[this.currentOxp[0]].extraA); }
		if ((this.currentOxp[1]&8) && !(this.oxpOverride&8)) { mission.addMessageText('extraB   : '+worldScripts[this.currentOxp[0]].extraB); }
		let a = "OXPCONFIG_CHANGE"+((~this.oxpOverride)&this.currentOxp[1]); mission.setChoicesKey(a);
		if (this.currentOxp[2] != "" && this.currentOxp[2]) { mission.addMessageTextKey("OXPCONFIG_DIVIDE"); mission.addMessageText("\nOptions info:\n"+this.currentOxp[2]); }
		if ((this.oxpOverride&this.currentOxp[1])) mission.addMessageText('Not supported options disabled.'); }
	mission.addMessageTextKey("OXPCONFIG_QUEST");
}

this.missionScreenEnded = function()
{
    if(mission.choice && missionVariables.offering == "OXP-CONFIG" && this.shouldShow && this.showsNow) this.choiceEvaluation();
	else if (missionVariables.offering != "OXP-CONFIG" && this.shouldShow && !this.showsNow) this.shouldShow = false;
}

this.missionChoiceWasReset = function()
{
   if(mission.choice && missionVariables.offering == "OXP-CONFIG" && this.shouldShow && this.showsNow) this.choiceEvaluation();
}

this.choiceEvaluation = function()
{
	if (missionVariables.offering == "OXP-CONFIG") {
		switch (mission.choice) {
			case "OXPCONFIG_CHANGE":
				this.showNextScreen("OXPCONFIG_PAGE1"); this.currentPage = 1; break;
			case "OXPCONFIG_RELOAD":
				if (this.loadSettings()) { this.showConfigScreens(null,1); break; }
				else { this.showConfigScreens(null,2); break; }
			case "OXPCONFIG_SAVE":
				if (this.storeSettings()) { this.showConfigScreens(1,null); break; }
				else { this.showConfigScreens(2,null); break; }
			case "OXPCONFIG_ZLOADDEFAULT":
				if (this.loadSettings(1)) { this.showConfigScreens(null,1); break; }
				else { this.showConfigScreens(null,2); break; }
			case "OXPCONFIG_ZQUIT":
				missionVariables.offering = null; mission.choice = null; this.showsNow = false; break;
			case "OXPCONFIG_PAGEA0":
				this.showNextScreen(null,"0"); this.currentPage = 1; break;
			case "OXPCONFIG_PAGEA1":
				this.showNextScreen(null,"1"); this.currentPage = 1; break;
			case "OXPCONFIG_PAGEA2":
				this.showNextScreen(null,"2"); this.currentPage = 1; break;
			case "OXPCONFIG_PAGEA3":
				this.showNextScreen(null,"3"); this.currentPage = 1; break;
			case "OXPCONFIG_PAGEB0":
				this.showNextScreen(null,"4"); this.currentPage = 2; break;
			case "OXPCONFIG_PAGEB1":
				this.showNextScreen(null,"5"); this.currentPage = 2; break;
			case "OXPCONFIG_PAGEB2":
				this.showNextScreen(null,"6"); this.currentPage = 2; break;
			case "OXPCONFIG_PAGEB3":
				this.showNextScreen(null,"7"); this.currentPage = 2; break;
			case "OXPCONFIG_PAGEC0":
				this.showNextScreen(null,"8"); this.currentPage = 3; break;
			case "OXPCONFIG_PAGEC1":
				this.showNextScreen(null,"9"); this.currentPage = 3; break;
			case "OXPCONFIG_PAGEC2":
				this.showNextScreen(null,"10"); this.currentPage = 3; break;
			case "OXPCONFIG_PAGEC3":
				this.showNextScreen(null,"11"); this.currentPage = 3; break;
			case "OXPCONFIG_PAGED0":
				this.showNextScreen(null,"12"); this.currentPage = 4; break;
			case "OXPCONFIG_PAGED1":
				this.showNextScreen(null,"13"); this.currentPage = 4; break;
			case "OXPCONFIG_PAGED2":
				this.showNextScreen(null,"14"); this.currentPage = 4; break;
			case "OXPCONFIG_PAGED3":
				this.showNextScreen(null,"15"); this.currentPage = 4; break;
			case "OXPCONFIG_PAGEE0":
				this.showNextScreen(null,"16"); this.currentPage = 5; break;
			case "OXPCONFIG_PAGEE1":
				this.showNextScreen(null,"17"); this.currentPage = 5; break;
			case "OXPCONFIG_PAGEE2":
				this.showNextScreen(null,"18"); this.currentPage = 5; break;
			case "OXPCONFIG_PAGEE3":
				this.showNextScreen(null,"19"); this.currentPage = 5; break;
			case "OXPCONFIG_PAGEF0":
				this.showNextScreen(null,"20"); this.currentPage = 6; break;
			case "OXPCONFIG_PAGEF1":
				this.showNextScreen(null,"21"); this.currentPage = 6; break;
			case "OXPCONFIG_PAGEF2":
				this.showNextScreen(null,"22"); this.currentPage = 6; break;
			case "OXPCONFIG_PAGEF3":
				this.showNextScreen(null,"23"); this.currentPage = 6; break;
			case "OXPCONFIG_PAGEX":
				this.currentPage++; this.showNextScreen("OXPCONFIG_PAGE"+this.currentPage); break;
			case "OXPCONFIG_PAGEY":
				this.currentPage--; this.showNextScreen("OXPCONFIG_PAGE"+this.currentPage); break;
			case "OXPCONFIG_PAGEZ":
				this.showConfigScreens(null,null); break;
			case "OXPCONFIG_CHANGEA":
				if (!worldScripts[this.currentOxp[0]].logging) worldScripts[this.currentOxp[0]].logging = true;
				else worldScripts[this.currentOxp[0]].logging = false;
				this.setChangedFlag(this.changedOxp); this.showNextScreen(null,this.changedOxp); break;
			case "OXPCONFIG_CHANGEB":
				if (!worldScripts[this.currentOxp[0]].audio) worldScripts[this.currentOxp[0]].audio = true;
				else worldScripts[this.currentOxp[0]].audio = false;
				this.setChangedFlag(this.changedOxp); this.showNextScreen(null,this.changedOxp); break;
			case "OXPCONFIG_CHANGEC":
				if (!worldScripts[this.currentOxp[0]].extraA) worldScripts[this.currentOxp[0]].extraA = true;
				else worldScripts[this.currentOxp[0]].extraA = false;
				this.setChangedFlag(this.changedOxp); this.showNextScreen(null,this.changedOxp); break;
			case "OXPCONFIG_CHANGED":
				if (!worldScripts[this.currentOxp[0]].extraB) worldScripts[this.currentOxp[0]].extraB = true;
				else worldScripts[this.currentOxp[0]].extraB = false;
				this.setChangedFlag(this.changedOxp); this.showNextScreen(null,this.changedOxp); break;
			case "OXPCONFIG_ZA":
				if (this.changedOxp >= 0 && this.changedOxp <= 3) { this.showNextScreen("OXPCONFIG_PAGE1"); break; }
				if (this.changedOxp >= 4 && this.changedOxp <= 7) { this.showNextScreen("OXPCONFIG_PAGE2"); break; }
				if (this.changedOxp >= 8 && this.changedOxp <= 11) { this.showNextScreen("OXPCONFIG_PAGE3"); break; }
				if (this.changedOxp >= 12 && this.changedOxp <= 15) { this.showNextScreen("OXPCONFIG_PAGE4"); break; }
				if (this.changedOxp >= 16 && this.changedOxp <= 19) { this.showNextScreen("OXPCONFIG_PAGE5"); break; }
				if (this.changedOxp >= 20 && this.changedOxp <= 23) { this.showNextScreen("OXPCONFIG_PAGE6"); break; }
			default:
				break;
	} }
}

this.setChangedFlag = function(flag)
{
	let selector = 0; if (flag > this.oxpMax ) selector = Math.floor(flag/this.oxpMax);
	this.selectiveLoad[selector] |= Math.pow(2,(flag-(selector*this.oxpMax)));
	missionVariables.oxpConfig_selectiveLoad = "|"+this.selectiveLoad.join("|");
	// Check for default and if so delete from selectiveLoad
	if (missionVariables.oxpConfig_defaults) { let b = 0;
		if (typeof(worldScripts[this.currentOxp[0]].logging) != 'undefined') { if (worldScripts[this.currentOxp[0]].logging) b = 1; }
		if (typeof(worldScripts[this.currentOxp[0]].audio) != 'undefined') { if (worldScripts[this.currentOxp[0]].audio) b += 2; }
		if (typeof(worldScripts[this.currentOxp[0]].extraA) != 'undefined') { if (worldScripts[this.currentOxp[0]].extraA) b += 4; }
		if (typeof(worldScripts[this.currentOxp[0]].extraB) != 'undefined') { if (worldScripts[this.currentOxp[0]].extraB) b += 8; }
		let c = this.defaults[selector]; c = c>>>(4*(flag-(selector*this.oxpMax))); c &= 15;
		if (c == b) { let maxAnd = (Math.pow(2,(this.oxpMax+1))-1)-Math.pow(2,(flag-(selector*this.oxpMax)));
			this.selectiveLoad[selector] &= maxAnd; missionVariables.oxpConfig_selectiveLoad = "|"+this.selectiveLoad.join("|"); }}
	if (this.logging) log('OXPConfig','OXPConfig changed oxp:'+this.currentOxp[0]+' #:'+flag+' New value:'+this.selectiveLoad.join(" "));
	return;
}

this.shipWillDockWithStation = function()
{
	this.oxpConfigTimer.start();
}

this.shipWillLaunchFromStation = function()
{
	if (missionVariables.offering) log('OXPConfig','OXPConfig: missionVariables.offering not cleared - '+missionVariables.offering);
	if (typeof(mission.choice) != 'object') log('OXPConfig','OXPConfig: mission.choice not cleared - '+mission.choice);
	this.oxpConfigTimer.stop(); this.shouldShow = false; this.showsNow = false; this.currentPage = 0; this.oxpOverride = 0;
}

this.loadSettings = function(loadDefaults)
{
	if (!this.numberOfOxps) { log('OXPConfig','OXPConfig: Can not load settings. No Number of oxps available.'); return (false); }
	let settings = 0; let oxp = 0; let checkoxp = ''; let maxValue = 0; let maxOxps = 0; let loadIt = 0;
	let outerLoop = Math.ceil(this.numberOfOxps/this.oxpMax);  let loadsettings = new Array(); let innerLoop = 0; let dataload = '';
	if (loadDefaults) { if (this.logging) log('OXPConfig','OXPConfig default loading...');
		if (missionVariables.oxpConfig_defaults) { dataload = missionVariables.oxpConfig_defaults; }
		else { log('OXPConfig','OXPConfig: Can not find default settings.'); return (false); } }
	else { if (this.logging) log('OXPConfig','OXPConfig loading...');
		if (missionVariables.oxpConfig_settings) dataload = missionVariables.oxpConfig_settings;
		else { log('OXPConfig','OXPConfig: Can not load settings. No stored value found.'); return (false); } }
	loadsettings = dataload.split("|");	outerLoop = loadsettings.length-1;
	if (missionVariables.oxpConfig_storedOxps) {
		if (this.numberOfOxps > missionVariables.oxpConfig_storedOxps) { maxOxps = missionVariables.oxpConfig_storedOxps;
			if (this.logging) { log('OXPConfig','OXPConfig: Updated database found. OXPConfig only changes '+maxOxps+' oxps.'); } }
		else { maxOxps = this.numberOfOxps; } }
	else maxOxps = this.numberOfOxps;
	if (this.logging) { log('OXPConfig','OXPConfig: settings found:'+loadsettings.join(" "));
		if (this.extraB) { log('OXPConfig','OXPConfig: selectiveLoad found:'+this.selectiveLoad.join(" ")); }}
	for (let o = 0; o < outerLoop; o++) {
		settings = loadsettings[o+1]; innerLoop = maxOxps-(o*this.oxpMax); if (innerLoop > this.oxpMax) innerLoop = this.oxpMax;
		maxValue = Math.pow(2,(innerLoop*4+1)); loadIt = this.selectiveLoad[o];
		if (settings >= maxValue && maxOxps > 6) { log('OXPConfig','OXPConfig: Stored value is not valid. Abort loading.'); return (false); }
		for (let i = 0; i < (innerLoop*4); i += 4) {
			checkoxp = expandDescription("[OXPCONFIG"+oxp+"_INFO0]");
			if (!worldScripts[checkoxp]) { oxp++; settings = settings>>>4; continue; }
			if (this.extraB) {
				if (!loadDefaults && !(loadIt&(Math.pow(2,(oxp-(o*this.oxpMax)))))) { oxp++; settings = settings>>>4; continue; }
				if (this.logging) { log('OXPConfig','Selective load for oxp:'+oxp+' on page:'+(o*7)+' bit:'+i+' loadIt:'+loadIt); }}
			if (typeof(worldScripts[checkoxp].logging) != 'undefined') {
				if ((settings&1)) worldScripts[checkoxp].logging = true;
				else worldScripts[checkoxp].logging = false; }
			if (typeof(worldScripts[checkoxp].audio) != 'undefined') {
				if ((settings&2)) worldScripts[checkoxp].audio = true;
				else worldScripts[checkoxp].audio = false; }
			if (typeof(worldScripts[checkoxp].extraA) != 'undefined') {
				if ((settings&4)) worldScripts[checkoxp].extraA = true;
				else worldScripts[checkoxp].extraA = false; }
			if (typeof(worldScripts[checkoxp].extraB) != 'undefined') {
				if ((settings&8)) worldScripts[checkoxp].extraB = true;
				else worldScripts[checkoxp].extraB = false; }
			oxp++; settings = settings>>>4;
		}
	}
	if (this.logging) log('OXPConfig','OXPConfig: settings done. Loading finished.');
	return (true);
}

this.storeSettings = function(storeDefault)
{
	if (!this.numberOfOxps) { log('OXPConfig','OXPConfig: Can not store settings. No Number of oxps available.'); return (false); }
	let settings = 0; let oxp = 0; let checkoxp = '';
	let outerLoop = Math.ceil(this.numberOfOxps/this.oxpMax); let storage = new Array(outerLoop); let innerLoop = 0;
	for (let o = 0; o < outerLoop; o++) {
		settings = 0; innerLoop = this.numberOfOxps-(o*this.oxpMax); if (innerLoop > this.oxpMax) innerLoop = this.oxpMax;
		for (let i = 0; i < (innerLoop*4); i += 4) {
			checkoxp = expandDescription("[OXPCONFIG"+oxp+"_INFO0]");
			if (!worldScripts[checkoxp]) { oxp++; continue; }
			if (typeof(worldScripts[checkoxp].logging) != 'undefined') {
				if (worldScripts[checkoxp].logging) settings |= Math.pow(2,i); }
			if (typeof(worldScripts[checkoxp].audio) != 'undefined') {
				if (worldScripts[checkoxp].audio) settings |= Math.pow(2,i+1); }
			if (typeof(worldScripts[checkoxp].extraA) != 'undefined') {
				if (worldScripts[checkoxp].extraA) settings |= Math.pow(2,i+2); }
			if (typeof(worldScripts[checkoxp].extraB) != 'undefined') {
				if (worldScripts[checkoxp].extraB) settings |= Math.pow(2,i+3); }
			oxp++; }
		storage[o] = String(settings); }
	let storeComplete = "|"+storage.join("|");
	if (this.logging) log('OXPConfig','OXPConfig: settings:'+storeComplete+' done. Storing complete.');
	missionVariables.oxpConfig_settings = storeComplete; missionVariables.oxpConfig_storedOxps = oxp;
	if (storeDefault) { missionVariables.oxpConfig_defaults = storeComplete;
		missionVariables.oxpConfig_selectiveLoad = this.dImplant; }
	if (!missionVariables.oxpConfig_selectiveLoad) missionVariables.oxpConfig_selectiveLoad = this.dImplant;
	if (!storeDefault) this.getArrays();
	return (true);
}
