"use strict";

this.name = "Companion Trader";
this.author = "Reval";
this.description = "Recruit one or more Cobra III companion traders to accompany you in convoy from witchpoint to Main Station. Choose how many to hire. You are their leader and you must pay them, but they pay you a percentage of their trade earnings on every successful run.";
this.license = "CC-BY-NC-SA 4.0";
this.version = "1.0.0";

/* 


*/


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_CT_COBRA_COMPANION") {		
		pc("Recruiting "+this.$ctNumCompanion+"x Cobra III convoy-companions.",9);
		pc("Please verify details on your M.L. F4 Interface.",9);
		this.$ctCompanionEnabled="yes";
	} else
	// Service cancellation removal and refund
	if (equipment == "EQ_CT_COBRA_COMPANION_REM") {
		player.ship.removeEquipment("EQ_CT_COBRA_COMPANION");
		player.ship.removeEquipment("EQ_CT_COBRA_COMPANION_REM");
		pc("Dismissing your Cobra III Companion convoy.",9);
		player.credits += this.$ctCost/2;
		pc("Amount refunded: "+ this.$ctCost/2,9);
	}
}



this.shipDockedWithStation = function(station) {
	var pc = player.consoleMessage;
	var ex = this.$ctHFExempt;
	// check we have Convoy service, the fee is not paid, and we're not exempt
	// pay handling fee (wage) to all ships contracted
	if ((this.$ctHasCompanion) && (this.$ctNumCompanion>0) && (this.$ctHandlingPaid==="no") && (this.$ctShips.length>0)) {
		var fee = 0;
		for (var x=1; x<= this.$ctNumCompanion; x++)
			fee += this.$ctHandlingFee;
		// record fee and debit trader's account
		this.$ctHandlingFeeTotal += fee;
		player.credits -= fee;
		this.$ctHandlingPaid = "yes";
		pc(this.$ctNumCompanion+" x Cobra III Convoy wages: "+fee+" cr",9);
		this.$ctHandlingCount++;
		// Leader pays Convoy 3% of earnings per system
		var bonus = Math.floor(this.$ctLeaderEarnings*0.03);
		player.credits -= bonus;
		this.$ctLeaderBonus = bonus;
		// add it to Total bonuses paid since contract
		this.$ctLeaderTotal += bonus;
		pc("Leader bonus for Cobra III Convoy: "+bonus+" cr",9);
	}
	// Convoy pays leader 10% of trade earnings
	if ((this.$ctHasCompanion) && (this.$ctNumCompanion>0) && (!this.$ctConvoyPaidMe)) {
		var percentpay = Math.floor(this.$ctConvoyTotal*0.1);
		if (percentpay>0) pc("COBRA Convoy percentage: "+percentpay+" cr",9);
		this.$ctConvoyEarnings += percentpay;
		player.credits += percentpay;
		this.$ctConvoyPercent = percentpay;
		this.$ctConvoyPaidMe = true;
	}
	
	if (this.$ctHasCompanion) {
		// conditionally take periodic maintenance fee
		if (this.$ctNumCompanion>0) this._ctDoMaintenance();
		// prepare Companion Contract and Options pages
		this._ctPrepAcc(station);
		this._ctPrepOpt(station);
		this._ctShowStatus();	
	}
}



this.shipLaunchedFromStation = function(stationLaunchedFrom) {
	var pc = player.commsMessage;
	// have convoy Companions been hired?
	this.$ctHasCompanion = (player.ship.equipmentStatus ("EQ_CT_COBRA_COMPANION") === "EQUIPMENT_OK");
	if (this.$ctHasCompanion && this.$ctNumCompanion>0) {
		pc("COBRA convoy will rendezvous after Jump.",6);
	} else pc("COBRA Convoys are hirable from Station!");
}



this.shipEnteredStationAegis = function(station) {
	var pc = player.commsMessage, ps = player.ship, notwith=0;
	if (this.$ctHasCompanion && this.$ctNumCompanion>0) {
		pc("COBRA convoy thanks you for your protection!",9);
		// switch convoy AI to 'dock'
		for (var x = 0; x<this.$ctShips.length; x++) {
			this.$ctShips[x].switchAI("dockingAI.plist");
		}
	
		// No percentage if most are not with you!
		try {
			var count = 0, psp = ps.position;
			for (var x = 0; x<this.$ctShips.length; x++) {
				if (this.$ctShips[x] != null) {
					var dist = Math.floor(psp.distanceTo(this.$ctShips[x].position)/100);
					if (dist>500) notwith++;
					count++;
				}
			}
		} catch(err) { /* ship destroyed */ }
		
		if (notwith > (count / 2)) {
			pc("COBRA Convoy: Leader is not with us. No percentage!");
			this.$ctConvoyPaidMe = true;
		}
	}
}



this.shipExitedWitchspace = function() {
	var pc = player.commsMessage, s=system.stations;
	// are we monitoring the convoy?
	this.$ctMonitor = true;
	// start the Monitor timer, if already created
	if (this.$ctTimer) this.$ctTimer.start();
	// muster convoy Companions somewhere near witchpoint
	if (this.$ctHasCompanion && this.$ctNumCompanion>0) {
		pc("COBRA Companion convoy arriving...",6);
		this.$ctShips = system.addShips("ct_convoy", this.$ctNumCompanion);
		var ships = this.$ctShips;
		// Count the convoy ships that turned up
		pc(ships.length+" COBRA Convoy ships have called in.");
		this.$ctConvoyStrength = ships.length;
		// Convoy reports-in with applicable information
		var main = system.mainStation.name;
		this.$ctConvoyTotal = 0.0;
		// make each Companion a member of a Group
		this.$ctGroup = new ShipGroup("COBRA Convoy",player.ship);
		for(var x=0; x<ships.length; x++) {
			ships[x].setCargoType("SCARCE_GOODS");
			// Convoy's likely earnings: for percentage payment to Leader
			for(var y=0; y<ships[x].cargoList.length; y++) {
				var sc = ships[x].cargoList[y];
				this.$ctConvoyTotal += this._ctMarketPriceByName(main, sc.commodity, sc.quantity);
			}
			// Leader's likely earnings: for Bonus payment to convoy
			this.$ctLeaderEarnings = 0.0;
			for(var m=0; m<manifest.list.length; m++) {
				var mc = manifest.list[m];
				this.$ctLeaderEarnings += this._ctMarketPriceByName(main, mc.commodity, mc.quantity);
			}
			// TEST 
			this.$ctLeaderEarnings = Math.floor(this.$ctLeaderEarnings);
			pc("COBRA Leader earnings this system: "+this.$ctLeaderEarnings);
			// add each companion to a Group
			this.$ctGroup.addShip(ships[x]);
		}
		// Assess total earnings for convoy at Main Station
		this.$ctConvoyTotal = Math.floor(this.$ctConvoyTotal);
		pc("COBRA Convoy Earnings this system: "+this.$ctConvoyTotal+" cr",9);
	} else pc("COBRA Convoys are hirable from Station!");
	// set handling paid to 'no'
	this.$ctHandlingPaid = "no";
	this.$ctRuns ++;
	this.$ctConvoyPaidMe = false;
}



this.shipWillDockWithStation = function(station) {
	// remove fast-docking equipment
	player.ship.removeEquipment("EQ_ET_AUTODOCK");
	// stop the Monitor timer
	if (this.$ctTimer) this.$ctTimer.stop();
	// disable convoy monitor
	this.$ctMonitor = false;
	// nullify Group
	this.$ctGroup = null;
}


this.shipWillLaunchFromStation = function(station) {
	// enable fast docking
	this._installAutoDock();
	// set up 'Convoy Monitor' (fires once per second)
	if(!this.$ctTimer) this.$ctTimer=new Timer(this,this._ctMonitorConvoy.bind(this),0,1.0);
}


this._ctMonitorConvoy = function() {
var ps = player.ship;

// present distance to station
var spos = system.mainStation.position;
// time to Station at current speed, in minutes
var timetoStation = null;
if (ps.speed>0.0) // avoid division by zero
	 timetoStation = Math.floor((ps.position.distanceTo(spos) / ps.speed) / 60);
// periodically, check distances to each ship
if ((clock.secondsComponent === 1) && (this.$ctShips != null) && (this.$ctMonitor)) {
	var pc = player.consoleMessage;
	// show time to main Station, at current speed
	if (timetoStation != null) pc("Time to Station: "+timetoStation+" minutes.",9);
	
	pc(" "); // line-break before list
	for (var x = 0; x<this.$ctShips.length; x++) {
		if (this.$ctShips[x] != null) {
			try {
				var dist = Math.floor(ps.position.distanceTo(this.$ctShips[x].position)/100);
				if (dist>300)pc("Convoy-COBRA #"+(x+1)+": I am "+dist+" Lk from you - off scan.");
				// retrieve ship if stuck more than 2000 Lk away
				if ((dist>1500) && (!ps.torusEngaged) && (!ps.injectorsEngaged) && (!(ps.speed>ps.maxSpeed))) 
					this.$ctShips[x].position = this.$ctLastPos;
			} catch(err) {
				player.commsMessage("COBRA Convoy ship #"+(x+1)+" is not responding.",9);
			}
		}
	}
}
if ((clock.secondsComponent === 10) && (this.$ctShips != null) && (this.$ctMonitor)) {
	var pcm = player.consoleMessage;
	var ds = Math.floor(this.$ctShips[0].desiredSpeed);
	if (ds>0) pcm("COBRA Convoy: Our designated speed is "+ds,9);
}
// note ship-position one second ago
this.$ctLastPos = ps.position;

}



this.playerWillSaveGame = function(message) {
	missionVariables.ctNumCompanion = this.$ctNumCompanion;
	missionVariables.ctCompanionEnabled = this.$ctCompanionEnabled;
	// save total fees taken
	missionVariables.ctHandlingFeeTotal = this.$ctHandlingFeeTotal;
	missionVariables.ctMaintenanceFeeTotal = this.$ctMaintenanceFeeTotal;
	missionVariables.ctDismantlingFeeTotal = this.$ctDismantlingFeeTotal;
	missionVariables.ctHandlingPaid = this.$ctHandlingPaid;
	// system-to-system runs w/pod
	missionVariables.ctRuns =this.$ctRuns;
	// handling fee count
	missionVariables.ctHandlingCount = this.$ctHandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.ctHFExempt = this.$ctHFExempt;
	// maintenance fee count
	missionVariables.ctMaintenanceCount = this.$ctMaintenanceCount;
	// Cumulative total earned from convoy
	missionVariables.ctConvoyEarnings = this.$ctConvoyEarnings;
	// Cumulative bonuses paid to convoy
	missionVariables.ctLeaderTotal = this.$ctLeaderTotal;
}


this.startUpComplete = function () {
	var pc = player.consoleMessage;
	if (missionVariables.ctNumCompanion != null) 
		this.$ctNumCompanion = missionVariables.ctNumCompanion;
	if (missionVariables.ctCompanionEnabled != null) 
		this.$ctCompanionEnabled = missionVariables.ctCompanionEnabled;
	// Load total fees taken
	if (missionVariables.ctHandlingFeeTotal != null)
		this.$ctHandlingFeeTotal = missionVariables.ctHandlingFeeTotal;
	if (missionVariables.ctHandlingPaid != null)
		this.$ctHandlingPaid = missionVariables.ctHandlingPaid;
	if (missionVariables.ctMaintenanceFeeTotal != null)
		this.$ctMaintenanceFeeTotal = missionVariables.ctMaintenanceFeeTotal;
	if (missionVariables.ctDismantlingFeeTotal != null)
		this.$ctDismantlingFeeTotal = missionVariables.ctDismantlingFeeTotal; 
    // Load system-to-system runs w/pod
	if (missionVariables.ctRuns != null)
		this.$ctRuns = missionVariables.ctRuns;
	// Load Handling fee count
	if (missionVariables.ctHandlingCount != null)
		this.$ctHandlingCount = missionVariables.ctHandlingCount;
	// Load handling fee exemption status
	if (missionVariables.ctHFExempt != null)
		this.$ctHFExempt = missionVariables.ctHFExempt;
	// Load Maintenance fee count
	if (missionVariables.ctMaintenanceCount != null)
		this.$ctMaintenanceCount = missionVariables.ctMaintenanceCount;
	// Cumulative total earned from convoy
	if (missionVariables.ctConvoyEarnings != null)
		this.$ctConvoyEarnings = missionVariables.ctConvoyEarnings;
	// Cumulative bonuses paid to convoy
	if (missionVariables.ctLeaderTotal != null)
		this.$ctLeaderTotal = missionVariables.ctLeaderTotal;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// CompanionS PRESENT?
	this.$ctHasCompanion = (player.ship.equipmentStatus ("EQ_CT_COBRA_COMPANNION") === "EQUIPMENT_OK");
	if (this.$ctHasCompanion) {
		// prepare pod Account screen
		var sta = player.ship.dockedStation;
		this._ctPrepAcc(sta);
		this._ctPrepOpt(sta);
		this._ctShowStatus();
	}
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// declare & initialize globals
	// Trader may be provided with Cobra III Companion ships
	this.$ctHasCompanion = false;
	// Traders have the option to disable the service
	this.$ctCompanionEnabled = "no";
	// Traders may choose the number of ships to accompany them
	this.$ctNumCompanion = 3;
	// purchase cost of Companion contract
	this.$ctCost = 700;
	// handling fee for Companion Service
	this.$ctHandlingFee = 0.05*this.$ctCost; 
	this.$ctHandlingFeeTotal = 0;
	this.$ctHandlingPaid = "yes"; // or "no" - easier than boolean
	this.$ctHandlingCount = 0;
	this.$ctHFExempt = "no";
	// maintenance fees and wages for convoy Companions
	this.$ctMaintenanceFee = 0.075*this.$ctCost;
	this.$ctMaintenanceFeeTotal = 0;
	this.$ctMaintenancePaid = "no" // or "yes"
	this.$ctMaintenanceInterval = 10; // in runs (according to cost)
	this.$ctMaintenanceCount = 0;
	// fee for cancellation of Companion contract
	this.$ctDismantlingFee = 0.5*this.$ctCost; 
	this.$ctDismantlingFeeTotal = 0.0;
	// Total cumulative earnings from convoy
	this.$ctConvoyEarnings = 0;
	this.$ctConvoyPaidMe = false;
	// Total convoy earnings this system
	this.$ctConvoyTotal = 0.0;
	// Leader earnings this system
	this.$ctLeaderEarnings = 0.0;
	// Leader total earnings since Convoy contract
	this.$ctLeaderTotal = 0.0;
	// Bonus paid by Leader to Convoy this system
	this.$ctLeaderBonus = 0.0;
	// Percentage paid by Convoy to Leader this system
	this.$ctConvoyPercent = 0.0;
	// how many companions turn up and/or survive
	this.$ctConvoyStrength = 0;
	// system-to-system runs w/service
	this.$ctRuns = 0;
	// global array to hold the convoy
	this.$ctShips = null;
	// convoy's Group
	this.$ctGroup = null;
	// Are we monitoring?
	this.$ctMonitor = false;
}


// assess and take maintenance fee
this._ctDoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$ctRuns;
	var intv = this.$ctMaintenanceInterval;
	var mfee = this.$ctMaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x pods
		var fee = 0;
		for (var x=1; x<= this.$ctNumCompanion; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$ctMaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc(this.$ctNumCompanion,"x Cobra III Convoy wages: "+fee+" cr",9);
		// update Maintenance count
		this.$ctMaintenanceCount++;
	}
}


this._installAutoDock = function() {
	var p = player.ship;
	// give the Companion-contracted trader free fast-docking facilities at any station
	if (p.equipmentStatus("EQ_DOCK_COMP") != "EQUIPMENT_OK") {
			p.awardEquipment("EQ_ET_AUTODOCK");
	}
}



this._ctGetRandomInt = function(min, max) {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}



// price of a good at a given station, in cr
this._ctMarketPrice = function(sta, good) {
	var price=0.0, mar=sta.market;
	price = mar[good].price/10;
	return price.toFixed(1);
}



// price of <quantity> <named> good, ie. "furs", at a <named> station, ie. "Coriolis Station"
this._ctMarketPriceByName = function(namesta, namegood, quant) {
	var price=0, s=system.stations;
		
	for (var i=0; i<s.length; i++)  {
		if (s[i].name === namesta) { 
			price = this._ctMarketPrice(s[i], namegood);
			break;
		}
	}
	return price*quant;
}	
	


// Convoy earnings staus for F5 Missions screen

this._ctShowStatus = function() {
	
	var lbs = this.$ctLeaderBonus;
	var cps = this.$ctConvoyPercent;
	
	var status_LBS = "Bonus paid to Convoy: "+formatCredits(lbs,true,true);
	var status_CPS = "Percentage paid by Convoy: "+formatCredits(cps,true,true);
	
	mission.setInstructions(["COBRA Convoy:",status_LBS,status_CPS], this.name);
}


	
/* F4 Interfaces */


// create M.L.S.S. 'Contract & Account' page 
this._ctPrepAcc = function(station) {
	station.setInterface("ctAcc",{
	title: "Your Cobra III Companion convoy Contract",
	category: "C.S.A.",
	summary: "Your Convoy Services Agency Cobra III Companion(s) account screen shows terms, wages, convoy earnings, and other pertinent information.",
	callback: this._ctShowAcc.bind(this)
	});	
}


// show M.L.S.S. 'Contract & Account' page
this._ctShowAcc = function() {
	var hfc = this.$ctHandlingCount;
	var mfc = this.$ctMaintenanceCount;
	var mfi = this.$ctMaintenanceInterval;
	var hft = this.$ctHandlingFeeTotal;
	var mft = this.$ctMaintenanceFeeTotal;
	var dft = this.$ctDismantlingFeeTotal;
	// Total Leader bonuses to convoy since contract
	var lbc = this.$ctLeaderTotal;
		
	var parameters = new Object();
	
	parameters.title = "Convoy Services Agency (C.S.A.)";
	
	parameters.message = "Dear Convoy Leader, \n\n";
	
	if (this.$ctNumCompanion>0) 
		parameters.message +="This constitutes your Contract and Account for Cobra III convoy companion(s) x "+this.$ctNumCompanion+": \n\n"; 
	 else
		parameters.message +="You have no Convoy Service contract with us at this time. \n\n";
	
	parameters.message +="Convoy wages paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Convoy maintenance paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Convoy Leader bonuses paid: "+lbc+" cr ("+hfc+") \n"; 
	parameters.message +="Total earnings from Convoy: "+this.$ctConvoyEarnings+" cr. \n\n";
	
	parameters.message += "Convoy companions expect wages and regular maintenance for their ships, which you, as part of your contract with our Agency, and as convoy leader, have contracted to cover from your account. In addition, you have agreed to pay the convoy 3% of your station earnings, as bonus and incentive. In return for your protection, each companion will pay you 10% of their trade-earnings. \n\n";
	
	parameters.message += "The wage (0.05 of cost) is levied upon docking, the maintenance fee (0.075 of cost) every "+mfi+" trading runs. \n\n"
	
	parameters.message += "On termination, we must charge a dismissal fee (0.5 of cost) to cover any losses or legal fees incurred during service. \n";
	
	parameters.choicesKey = "ctAcknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("Convoy Services Agency thanks you for your attention.");
	}
}



// create M.L.S.S. 'Companion Options' page 
this._ctPrepOpt = function(station) {
	station.setInterface("ctOpt",{
	title: "Your C.S.A. Cobra III Convoy Options",
	category: "C.S.A.",
	summary: "C.S.A. Convoy Services Agency offers you these choices in regard to your Cobra III convoy Companion contract.",
	callback: this._ctShowOpt.bind(this)
	});	
}


// Offer M.L.S.S. Options for Mamba Companion Service
this._ctShowOpt = function() {
		
	var parameters = new Object();
	var pc = player.commsMessage;
	
	parameters.title = "Convoy Services Agency (C.S.A.)";
	
	parameters.message = "Dear trader, \n\n";
	
	if (this.$ctNumCompanion>0) 
		parameters.message +="C.S.A. Convoy Services Agency is pleased to offer you the following options as to the numbert of Companion craft to be deployed with your ship: \n\n"; 
	 else
		parameters.message +="You have no convoy Companion ships in your employ for this trade-run at this time. Please select from the options below: \n\n";
		
	
	parameters.choicesKey = "ctOptions";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "0_NONE") this.$ctNumCompanion=0; else 
		if (choice === "1_ONE")  this.$ctNumCompanion=1; else
		if (choice === "2_TWO")  this.$ctNumCompanion=2; else
		if (choice === "3_THREE")this.$ctNumCompanion=3; else
		if (choice === "4_FOUR") this.$ctNumCompanion=4; else
		if (choice === "5_FIVE") this.$ctNumCompanion=5; else
		if (choice === "6_SIX")  this.$ctNumCompanion=6;
			
		if (this.$ctNumCompanion<1) { 
			this.$ctCompanionEnabled="no";
			pc("C.S.A. notes your preference for no convoy."); 
		} else {
			this.$ctCompanionEnabled="yes";
			pc("C.S.A. notes your preference for "+this.$ctNumCompanion+" convoy Companions.");
		}
	}
}

