this.name = "Deep Horizon - Systems - Engine";
this.author	= "Blake Deakins - a.k.a. Cmd. Cheyd";
this.description = "Texture the home planet, add a textured planet/moon combination to each system.  Based on System Redux 1.0.0 by CaptKev and Kaks";
this.version = "0.0.4";
this.copyright = " Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License";


//*************************************************************************************************************
//************************************           Event Functions           ************************************
//*************************************************************************************************************
this.startUp = function() {
	delete this.startUp;
	this.declareStartingVariables();
	log(this.name,"-------- StartUp complete ----------");
}

this.guiScreenChanged = function(to, from) {
	if (this.Loaded) return;
	else {
		log(this.name,"-------- guiScreenChanged started ----------");
		this.setDefaults();
		this.generateSystemSeeds(galaxyNumber);
		this.loadSystemInfo(galaxyNumber);
		this.textureMainPlanets (galaxyNumber);
		this.designTargetSystem(galaxyNumber,system.ID)
		this.populateSystem();
		this.Loaded = true;
		log(this.name,"-------- guiScreenChanged Completed ----------");
	}
}

this.playerEnteredNewGalaxy = function(galaxyNumber) {
     this.textureMainPlanets (galaxyNumber);
}


this.playerStartedJumpCountdown = function(type) {
	if(type === "standard") {
		if (!this.DH_Systems[gID][player.ship.targetSystem].Designed) {
			this.designTargetSystem(gID,player.ship.targetSystem)
		}
	}
	log(this.name,"-------- playerStartedJumpCountdown Completed ----------");
}

this.shipWillLaunchFromStation  =  function() {
	if (!this.DH_Systems[galaxyNumber][system.ID].Designed) this.designTargetSystem(galaxyNumber,system.ID);
	if (!this.systemDone) this.populateSystem();
	log(this.name,"-------- shipWillLaunchFromStation Completed ----------");
}

this.shipWillExitWitchspace = function() {
	this.systemDone = false;
	if (!this.DH_Systems[gID][system.ID].Designed) this.designTargetSystem(galaxyNumber,system.ID);
	this.populateSystem();
	log(this.name,"-------- shipWillExitWitchspace Completed ----------");
}

this.shipDied = function(whom, why) {
	if (whom == Player) {
		this.Loaded = false;
		log(this.name,"-------- shiDied Completed ----------");
	}

}

//*************************************************************************************************************
//************************************            OXP Functions            ************************************
//*************************************************************************************************************
this.declareStartingVariables = function() {
	this.Max_Moons = 6;  // Set to 0 to disable.
	this.Max_Planets = 4; // Set to 0 to disable.
	this.Corona_Changes = true;  // This can either be true or false.
	this.DHSys_plists = new Object();
	this.DHSys_plists.planets = new Array();
	this.DHSys_plists.moons = new Array ();
	this.DHSys_plists.complex_Planets = new Object();
	this.DHSys_Textures = new Object();
	this.DHSys_Textures.mainPlanets = [[],[],[],[],[],[],[],[],[]];
	this.DHSys_Textures.planets = new Array();
	this.DHSys_Textures.moons = new Array();
	this.DHSys_Textures.gas_Giants = new Array();
	this.DHSys_Textures.invalidKeywords = new Object();
	this.DHSys_Textures.validKeywords = new Object();
	this.systemSettings = new Array();
	this.overrideOXPList = new Array ();
	this.Loaded = false;
	this.systemDone = false;
	this.Planets_Enabled = true;
	this.Moons_Enabled = true;
	this.helper = new Cabal_Common();
	//Call function to build complex object
	this.createDH_SystemsObject();
	log(this.name,"-------- declareStartingVariables Completed ----------");
}

this.createDH_SystemsObject = function () {
	this.DH_Systems= [[],[],[],[],[],[],[],[]];

	var system_object = new Object();
	system_object.planets = new Array();
	system_object.mainPlanet = new Object();
	system_object.mainPlanet.texture = null;
	system_object.mainPlanet.isGasGiant = new Boolean;
	system_object.moons = new Array();
	system_object.isDesigned = false;
	system_object.isExcluded = false;
	system_object.systemSeeds = new Array();
	system_object.seedGovernment = 0;
	system_object.seedEconomy = 0;
	system_object.seedTechLevel = 0;
	system_object.seedPopulation = 0;
	system_object.seedRadius = 0;
	system_object.seedDescription = 0;
	system_object.systemSettings = new Object();
	system_object.canTextureMP = new Boolean;
	system_object.canAddPlanets = new Boolean;
	system_object.canAddMoons = new Boolean;
	system_object.canTextureAP = new Boolean;
	system_object.canTextureAM = new Boolean;
	system_object.canReduxSun = new Boolean;

	var i = 256;
	while (i--) {
		this.DH_Systems[7].push(this.extend(system_object, null));
		this.DH_Systems[7].excludedSystems = new Array();
	}
	var j = 7;
	while (j--) {
		this.DH_Systems[j] = this.extend(this.DH_Systems[7], null);
		this.DH_Systems[j].excludedSystems = new Array();
	}
	delete system_object;
	log(this.name,"-------- createDH_SystemObject Completed ----------");
}

this.extend = function(from, to) {
    if (from == null || typeof from != "object") return from;
    if (from.constructor != Object && from.constructor != Array) return from;
    if (from.constructor == Date || from.constructor == RegExp || from.constructor == Function ||
        from.constructor == String || from.constructor == Number || from.constructor == Boolean)
        return new from.constructor(from);
    to = to || new from.constructor();
    for (var name in from)     {
        to[name] = typeof to[name] == "undefined" ? this.extend(from[name], null) : to[name];
    }
    return to;
}

this.setDefaults = function() {
	if(this.Max_Planets <= 0 || this.Max_Planets > this.DHSys_plists.planets.length) this.Planets_Enabled = false;
	if(this.Max_Moons <= 0 || this.Max_Moons > this.DHSys_plists.moons.length) this.Moons_Enabled = false;
	log(this.name,"-------- setDefaults Completed ----------");
}

this.generateSystemSeeds = function (gID) {
	//Generate the system seeds used in all future random number groups for each system
	var galaxySeeds = new Array;
	galaxySeeds[0] = {LowerLimit: 1, UpperLimit: 1048575, HowMany: 2304, Seed_1: 11177, Seed_2: 100511, Seed_3: 6619, MaxSeed:104729};
	galaxySeeds[1] = {LowerLimit: 3, UpperLimit: 1048575, HowMany: 2304, Seed_1: 78979, Seed_2: 83137, Seed_3: 91099, MaxSeed:104723};
	galaxySeeds[2] = {LowerLimit: 5, UpperLimit: 1048575, HowMany: 2304, Seed_1: 25919, Seed_2: 97, Seed_3: 36599, MaxSeed:104717};
	galaxySeeds[3] = {LowerLimit: 7, UpperLimit: 1048575, HowMany: 2304, Seed_1: 21179, Seed_2: 20747, Seed_3: 66413, MaxSeed:104711};
	galaxySeeds[4] = {LowerLimit: 11, UpperLimit: 1048575, HowMany: 2304, Seed_1: 64633, Seed_2: 77323, Seed_3: 86753, MaxSeed:104707};
	galaxySeeds[5] = {LowerLimit: 13, UpperLimit: 1048575, HowMany: 2304, Seed_1: 92369, Seed_2: 59561, Seed_3: 38053, MaxSeed:104701};
	galaxySeeds[6] = {LowerLimit: 17, UpperLimit: 1048575, HowMany: 2304, Seed_1: 55103, Seed_2: 55217, Seed_3: 55337, MaxSeed:104693};
	galaxySeeds[7] = {LowerLimit: 19, UpperLimit: 1048575, HowMany: 2304, Seed_1: 101939, Seed_2: 68713, Seed_3: 32719, MaxSeed:104683};
	
	var seedArray = this.generateUniquePseudoRandomArray(galaxySeeds[gID]);
	var i = 256;
	while (i--) {
		this.DH_Systems[gID][i].systemSeeds = seedArray.slice(seedArray.length-9);
		seedArray.splice(seedArray.length-9,9);
	}
	log(this.name,"-------- generateSystemSeeds Completed ----------");
}

this.loadSystemInfo = function (gID){
	var i = 256;
	while (i--) {
		this.setSysInfo(gID,i);
	}
	log(this.name,"-------- loadSystemInfo Completed ----------");
}

this.textureMainPlanets = function(gID) {
	var i = 256;  //for each planet in the galaxy
	var arrTexturePool = 0;  
	var parameters = new Array();
	var textureSelected = null;
	var textureNumberSelected = 0;
	while (i--) {
		if (this.DH_Systems[gID][i].canTextureMP) {
			if(this.DH_Systems[gID][i].seedDescription.indexOf("pink oceans")!==-1)arrTexturePool = 8;
			else arrTexturePool = this.DH_Systems[gID][i].seedEconomy;
			this.DH_Systems[gID][i].mainPlanet.texture = "" + this.buildCompositePools(arrTexturePool,gID,i);
			System.infoForSystem(gID, i).texture = this.DH_Systems[gID][i].mainPlanet.texture;
			if(this.DHSys_Textures.gas_Giants.indexOf(this.DH_Systems[gID][i].mainPlanet.texture) !== -1) this.DH_Systems[gID][i].mainPlanet.gasGiant = true;
		}
	}
	log(this.name,"-------- textureMainPlanets Completed ----------");
} 

this.buildCompositePools = function(selectionPoolNumber,gID,i) {
	var CompositeRestrictions = new Array();
	var CompositeAlternatives = new Array();
	CompositeAlternatives = this.DHSys_Textures.mainPlanets[selectionPoolNumber].slice(0);  //Populate texture pool with textures based on economy
	//this whole function needs to be rewritten for the new object-based model
	var j = this.DHSys_Textures.invalidKeywords.length;
	while(j--){  		//loop through all restricted combinations of keywords and textures
		if(DH_Systems[gID][i].seedDescription.indexOf(RestrictedCombos[j][0])!==-1){ //Does the keyword appear in the description?  If Yes:
			var k = RestrictedCombos[j][1].length;
			while(k--){		//for every texture associated with the keyword
				if(CompositeRestrictions.indexOf(RestrictedCombos[j][1][k])===-1) CompositeRestrictions.push(RestrictedCombos[j][1][k]);  //Add texture to list of restricted textures
			}
			var l = AlternativeTextures[i][1].length;
			while(l--){		//for each alternatively suggested textures associated with the keyword
				if(CompositeAlternatives.indexOf(AlternativeTextures[j][1][l])===-1) CompositeAlternatives.push(AlternativeTextures[j][1][l]);		//Add the texture to the list of possible alternative textures
			}
		}		//If there are no matching keywords, just the original textures selected by economy are in the list of possible-to-use textures
	}
	if(CompositeRestrictions.length){ //If there were restrictions made, make sure none of the restrictions are in the list of possible-to-use textures
		var m = CompositeRestrictions.length;
		while(m--){
			if(CompositeAlternatives.indexOf(CompositeRestrictions[m])!==-1){
				var filteredRestrictions = CompositeAlternatives.indexOf(CompositeRestrictions[m])
				CompositeAlternatives.splice(filteredRestrictions,1)
			}
		}
	}		//At this point, we have a list of all possible-to-use textures for this planet
			//Select a random texture from the pool  and return the value to the caller uniquely using the 21 seeds we have for each system...
	parameters = {
		LowerLimit: 0,
		UpperLimit: CompositeAlternatives.length-1,
		HowMany: 1,
		Seed_1: this.DH_Systems[gID][i].systemSeeds[0],
		Seed_2: this.DH_Systems[gID][i].systemSeeds[1],
		Seed_3: this.DH_Systems[gID][i].systemSeeds[2],
		MaxSeed:16777215
	};
	textureNumberSelected = generateUniquePseudoRandomArray(parameters);  //This is returning an array, need to get the singular value from it.
	textureSelected = CompositeAlternatives.valueOf(textureNumberSelected[0].valueOf());
	//clean up variables before we leave...
	CompositeRestrictions = [];
	CompositeAlternatives = [];
	//Done
	return textureSelected;
}

this.designTargetSystem = function(gID, sysID) {
	//Pick Number of Moons
	if(this.Moons_Enabled && this.DH_Systems[gID][sysID].canAddMoons) this.selectMoons(gID, sysID);

	//Pick Number of extra Planets
	if (this.Planets_Enabled && this.DH_Systems[gID][sysID].canAddPlanets) this.selectExtraPlanets(gID, sysID);

	//Assign Textures to moons
	if (this.DH_Systems[gID][sysID].moons.length > 0) this.selectMoonTextures(gID, sysID);

	//Assign textures to extra planets
	if (this.DH_Systems[gID][sysID].planets.length > 0) this.selectExtraPlanetTextures(gID, sysID);

	//Set Designed flag to true for system
	this.DH_Systems[gID][sysID].Designed = true;
	log(this.name,"-------- designTargetSystem Completed ----------");
}

this.setSysInfo = function(gID,sysID) { 
	// Load system seed values from Mission Variables if specified, or System.info if not
		this.info = this.getParametersForSystem(gID, sysID);
		this.DH_Systems[gID][sysID].seedGovernment = this.info.government;
		this.DH_Systems[gID][sysID].seedEconomy = this.info.economy;
		this.DH_Systems[gID][sysID].seedTechLevel = this.info.techLevel;
		this.DH_Systems[gID][sysID].seedPopulation = this.info.population;
		this.DH_Systems[gID][sysID].seedRadius = this.info.radius;
		this.DH_Systems[gID][sysID].seedDescription = this.info.description;
		
	// Load Exclusionary information for system from API
		this.systemSettings = this.getExclusionDetails(gID, sysID);
		this.DH_Systems[gID][sysID].canTextureMP = this.systemSettings.TextureMP;
		this.DH_Systems[gID][sysID].canAddPlanets = this.systemSettings.AddPlanets;
		this.DH_Systems[gID][sysID].canAddMoons = this.systemSettings.AddMoons;
		this.DH_Systems[gID][sysID].canTextureAP = this.systemSettings.TxtPlanets;
		this.DH_Systems[gID][sysID].canTextureAM = this.systemSettings.TxtMoons;
		this.DH_Systems[gID][sysID].canReduxSun = this.systemSettings.ReduSun;
}

this.selectMoons = function(gID, sysID) {
	//Determine how many moons will be in the target system
	var Num_Moons = this.generateUniquePseudoRandomArray({
												LowerLimit: 0,
												UpperLimit: this.Max_Moons,
												HowMany: 1,
												Seed_1: this.DH_Systems[gID][sysID].systemSeeds[0],
												Seed_2: this.DH_Systems[gID][sysID].systemSeeds[4],
												Seed_3: this.DH_Systems[gID][sysID].systemSeeds[8],
												MaxSeed:16777215
											});
	//If Qty > 0
	if (Num_Moons > 0) {
		//Determine which moons will be added
		var Moon_IDs = this.generateUniquePseudoRandomArray({
												LowerLimit: 0,
												UpperLimit: this.DHSys_plists.moons.length -1,
												HowMany: Num_Moons,
												Seed_1: this.DH_Systems[gID][sysID].systemSeeds[1],
												Seed_2: this.DH_Systems[gID][sysID].systemSeeds[4],
												Seed_3: this.DH_Systems[gID][sysID].systemSeeds[7],
												MaxSeed:16777215
											});
		//Add moon ID's to DH_Systems object for system
		var i = Num_Moons;
		while (i--) {
			if (typeof(this.DH_Systems[gID][sysID].moons[i]) == 'undefined') this.DH_Systems[gID][sysID].moons[i] = new Object();
			this.DH_Systems[gID][sysID].moons[i].plistName = this.DHSys_plists.moons[Moon_IDs[i]];
		}
	}
	log(this.name,"-------- selectMoons Completed ----------");
}

this.selectExtraPlanets = function (gID, sysID) {
	//Determine how many planets will be in the target system
	var Num_Planets = this.generateUniquePseudoRandomArray({
												LowerLimit: 0,
												UpperLimit: this.Max_Planets,
												HowMany: 1,
												Seed_1: this.DH_Systems[gID][sysID].systemSeeds[6],
												Seed_2: this.DH_Systems[gID][sysID].systemSeeds[7],
												Seed_3: this.DH_Systems[gID][sysID].systemSeeds[8],
												MaxSeed:16777215
											});
	//If Qty > 0
	if (Num_Planets > 0) {
		//Determine which moons will be added
		var Planet_IDs = this.generateUniquePseudoRandomArray({
												LowerLimit: 0,
												UpperLimit: this.DHSys_plists.planets.length -1,
												HowMany: Num_Planets,
												Seed_1: this.DH_Systems[gID][sysID].systemSeeds[1],
												Seed_2: this.DH_Systems[gID][sysID].systemSeeds[4],
												Seed_3: this.DH_Systems[gID][sysID].systemSeeds[7],
												MaxSeed:16777215
											});
		//Add moon ID's to DH_Systems object for system
		var i = Num_Planets;
		while (i--) {
			if (typeof(this.DH_Systems[gID][sysID].planets[i]) == 'undefined') this.DH_Systems[gID][sysID].planets[i] = new Object();
			this.DH_Systems[gID][sysID].planets[i].plistName = this.DHSys_plists.planets[Planet_IDs[i]];
		}
	}
	log(this.name,"-------- selectExtraPlanets Completed ----------");
}

this.selectMoonTextures = function (gID,sysID) {
	//Select a random texture for each moon in the target system
	var MoonTextures = this.generateUniquePseudoRandomArray({
												LowerLimit: 0,
												UpperLimit:this.DHSys_Textures.moons.length -1,
												HowMany: this.DH_Systems[gID][sysID].moons.length,
												Seed_1: this.DH_Systems[gID][sysID].systemSeeds[0],
												Seed_2: this.DH_Systems[gID][sysID].systemSeeds[3],
												Seed_3: this.DH_Systems[gID][sysID].systemSeeds[6],
												MaxSeed:16777215
	});
	var i = this.DH_Systems[gID][sysID].moons.length
	while (i--) {
		this.DH_Systems[gID][sysID].moons[i].texture = this.DHSys_Textures.moons[MoonTextures[i]];
	}
	log(this.name,"-------- selectMoonTextures Completed ----------");
}

this.selectExtraPlanetTextures = function (gID,sysID) {
	//Select a random texture for each additional planet in the target system
	var PlanetTextures = this.generateUniquePseudoRandomArray({
												LowerLimit: 0,
												UpperLimit:this.DHSys_Textures.planets.length -1,
												HowMany: this.DH_Systems[gID][sysID].planets.length,
												Seed_1: this.DH_Systems[gID][sysID].systemSeeds[3],
												Seed_2: this.DH_Systems[gID][sysID].systemSeeds[4],
												Seed_3: this.DH_Systems[gID][sysID].systemSeeds[5],
												MaxSeed:16777215
	});
	var i = this.DH_Systems[gID][sysID].planets.length
	while (i--) {
		this.DH_Systems[gID][sysID].planets[i].texture = this.DHSys_Textures.planets[PlanetTextures[i]];
		if(this.DHSys_Textures.gas_Giants.indexOf(this.DH_Systems[gID][sysID].planets[i].texture) !== -1) this.DH_Systems[gID][sysID].planets[i].gasGiant = true;
	}
	log(this.name,"-------- selectExtraPlanetTextures Completed ----------");
}


this.populateSystem = function() {
	// Make sure system is not interstellar space, or is devoid of a star
	if (this.systemDone || system.isInterstellarSpace || system.sun.hasGoneNova) return;
	
	if (this.DH_Systems[galaxyNumber][system.ID].moons.length > 0) this.addMoons();
	if (this.DH_Systems[galaxyNumber][system.ID].planets.length > 0) this.addExtraPlanets();
	log(this.name,"-------- populateSystem Completed ----------");
}

this.addMoons = function () {
	var i = this.DH_Systems[galaxyNumber][system.ID].moons.length;
	var newMoon = new Object();
	while (i--) {
		newMoon = system.addMoon(this.DH_Systems[galaxyNumber][system.ID].moons[i].plistName);
		newMoon.texture = this.DH_Systems[galaxyNumber][system.ID].moons[i].texture;
		//Needs check for Pirate_Ambush
		if (this.DH_Systems[galaxyNumber][system.ID].moons[i] === "DeepHorizon_moon11" && this.DH_Systems[galaxyNumber][system.ID].seedGovernment <= 2 && worldScripts["Pirate_Ambushes"]) {
			worldScripts["Pirate_Ambushes"].checkForAmbush(this.DH_Systems[galaxyNumber][system.ID].seedGovernment);
		}
	}
	log(this.name,"-------- addMoons Completed ----------");
}

this.addExtraPlanets = function() {
	var i = this.DH_Systems[galaxyNumber][system.ID].planets.length;
	var newPlanet = new Object();
	while (i--) {
		newPlanet = system.addPlanet(this.DH_Systems[galaxyNumber][system.ID].planets[i].plistName);
		newPlanet.texture = this.DH_Systems[galaxyNumber][system.ID].planets[i].texture;
		//Add Gas Giant Check Here and set in DH_Systems Object if true
		if(this.DH_Systems[galaxyNumber][system.ID].planets[i].isGasGiant) newPlanet.isGasGiant = true;
	}
	log(this.name,"-------- addExtraPlanets Completed ----------");
}

//*************************************************************************************************************
//***************************************          API Functions        ***************************************
//*************************************************************************************************************
this.setParametersForSystem = function(galaxyID, systemID, parameters) {
	var government = +parameters.Government;
	var economy = +parameters.Economy;
	var techLevel = +parameters.techLevel;
	var population = +parameters.Population;
	var radius = +parameters.Raduis;
	var description = parameters.Description;
	// Note: prefixing a variable with + converts it to a number.
	var key = "DH_Systems_Engine_" + +galaxyID + "_" +systemID;
	var data = "" + government + "," + economy  + "," + techLevel + "," + population + "," + radius + "," + description;
	
	missionVariables[key] = data;
}

this.getParametersForSystem = function(galaxyID, systemID) {
	// Look for a saved override.
	var key = "DH_Systems_Engine_DATA_" + +galaxyID + "_" +systemID;
	var data = missionVariables[key];
	
	if (data)
	{
		var items = data.split(",", 6);
		if (items.length == 6)
		{
			return {
				government: items[0],
				economy: items[1],
				techLevel: items[2],
				population: items[3],
				radius: items[4],
				description: items[5]
			};
		}
	}
	
	// If we got here, there's no valid override.
	var info = System.infoForSystem(galaxyID, systemID);
	return {
		government: info.government,
		economy: info.economy,
		techLevel: info.techlevel,
		population: info.population,
		radius: info.radius,
		description: info.description
	};
}


this.getParametersForThisSystem = function() {
	return this.getParametersForSystem(galaxyNumber, system.ID);
}


this.freezeParametersForSystem = function(galaxyID, systemID) {
	var params = this.getParametersForSystem(galaxyID, systemID);
	this.setParametersForSystem(galaxyID, systemID, [Governement = params.government, Economy = params.economy, techLevel = params.techLevel, Population = params.population, Radius = params.radius, Description = params.description]);
}

this.excludeSystem = function(galaxyID, systemID, parameters) {
	var TextureMP = parameters.TextureMP;
	var AddPlanets = parameters.AddPlanets;
	var AddMoons = parameters.AddMoons;
	var TxtPlanets = parameters.TxtPlanets;
	var TxtMoons = parameters.TxtMoons;
	var ReduSun= parameters.ReduSun;
	var Exclusion = "" +systemID + "," + TextureMP + "," + AddPlanets + "," + AddMoons + "," + TxtPlanets + "," + TxtMoons + "," + ReduSun;
	this.DH_Systems[galaxyID].excludedSystems.push(Exclusion);
}

this.excludeThisSystem = function(parameters) {
	this.excludeSystem(galaxyNumber, system.ID, parameters);
}

this.isSystemExcluded = function(galaxyID, systemID) {
	var abort = 0;
	var i = this.DH_Systems[galaxyID].excludedSystems.length;
	for (i; i > abort; i--) {
		var details = DH_Systems[galaxyID].excludedSystems[i].split(",", 7);
		if (details.length == 7 && systemID == details[0]) return true;
	}
	return false;
}

this.isThisSystemExcluded = function() {
	this.isSystemExcluded(galaxyNumber, system.ID);
}

this.getExclusionDetails = function(galaxyID, systemID) {
	var i,details;
	for (var i = 0; i<this.DH_Systems[galaxyID].excludedSystems.length; i++) {
		details = this.DH_Systems[galaxyID].excludedSystems[i].split(",", 7);
		if (details.length == 7 && systemID == details[0]) {
			log (this.name + ":  Returning Exclusion Details");
			var d1,d2,d3,d4,d5,d6;
			if (details[1]=="true") d1 = true;
			else d1 = false;
			if (details[2]=="true") d2 = true;
			else d2 = false;
			if (details[3]=="true") d3 = true;
			else d3 = false;
			if (details[4]=="true") d4 = true;
			else d4 = false;
			if (details[5]=="true") d5 = true;
			else d5 = false;
			if (details[6]=="true") d6 = true;
			else d6 = false;
			return {
				TextureMP: d1,
				AddPlanets: d2,
				AddMoons: d3,
				TxtPlanets: d4,
				TxtMoons: d5,
				ReduSun: d6
			};
		}
	}
	return {
		TextureMP: true,
		AddPlanets: true,
		AddMoons: true,
		TxtPlanets: true,
		TxtMoons: true,
		ReduSun: true
	};
}


this.registerOverrideOXP = function(oxpName, restoreFunctionName) {
	this.overrideOXPList.push([oxpName, restoreFunctionName]);
}

this.generateUniquePseudoRandomArray = function(parameters) {
	/*
	This function was provided by PhantorGorth (Paul Cooper) and is
	licensed under Creative Commons Attribution-Non-Commercial 2.5 UK: Scotland Licence.
	Full license and acknowledgement details are available in the ReadMe.
	*/
	
	
	// Break out passed parameters into individual components
	var intLower = parameters.LowerLimit;	// Minimum Value for the random numbers selected
	var intUpper = parameters.UpperLimit;	// Maximum Value for the random numbers selected
	var intSize = parameters.HowMany;		// How many results do you want returned?
	var intSeed = parameters.Seed_1;			// Seed value from Global array
	var intMaxInternalSeed = parameters.MaxSeed
	var SeedVal1 = parameters.Seed_2;	// Prime Number
	var SeedVal2 = parameters.Seed_3;	// Second Prime Number

	
	//Initialise List
	var List = new Array();
	var Tree = new Array();
	if (SeedVal1 == undefined) SeedVal1 = 3631;
	if (SeedVal2 == undefined) SeedVal2 = 761;

	Tree[0] = {"Value" : undefined, "Lower" : -1, "Higher": -1, "CountBelow" : 0};

	function AddSeedToTree(inValue, NodeRef)
	{
		if ((NodeRef.Lower == -1) && (NodeRef.Higher == -1) && (NodeRef.Value == undefined))
		{
			NodeRef.Value = inValue;
			return;
		}
		if (inValue < NodeRef.Value)
		{
			NodeRef.CountBelow++;
			if (NodeRef.Lower == -1)
			{
				//Create and Intialise New NodeRef
				var obj = {"Value" : undefined, "Lower" : -1, "Higher": -1, "CountBelow" : 0};
				NodeRef.Lower = Tree.push(obj) - 1;
			}
			AddSeedToTree(inValue, Tree[NodeRef.Lower]);
		}
		else if (inValue > NodeRef.Value)
		{
			if (NodeRef.Higher == -1)
			{
				//Create and Intialise New NodeRef
				var obj = {"Value" : undefined, "Lower" : -1, "Higher": -1, "CountBelow" : 0};
				NodeRef.Higher = Tree.push(obj) - 1;
			}
			AddSeedToTree(inValue, Tree[NodeRef.Higher]);
		}
		else
		{
			return //Shouldn't happen as no two values in tree should be the same
		}
		return; 
	}

	function CountSeedsBelow(inValue, NodeRef)
	{
		if (NodeRef.Value == inValue)
		{
			return NodeRef.CountBelow + 1;
		}
		else if (inValue < NodeRef.Value)
		{
			if (NodeRef.Lower == -1)
			{
				return 0;
			}
			else
			{
				return CountSeedsBelow(inValue, Tree[NodeRef.Lower]);
			}
		}
		if (inValue > NodeRef.Value)
		{
			if (NodeRef.Higher == -1)
			{
				return NodeRef.CountBelow + 1;
			}
			else
			{
				return NodeRef.CountBelow + 1 + CountSeedsBelow(inValue, Tree[NodeRef.Higher]);
			}
		}
		else
		{
			return 0; // shouldn't get here
		}
	} 

	var newSeed = intSeed;
	var count = 0;
	var skipbase = 0;
	var lastvalue = 0;
	
	while (count < intSize)
	{	
		var c2 = 1;
		skipbase = lastvalue;
		newSeed = ((SeedVal1 * newSeed + SeedVal2) % (intMaxInternalSeed + 1));
		var trynewvalue = lastvalue + newSeed;
		if (trynewvalue > intUpper)
		{
			trynewvalue = (trynewvalue - intUpper) % (intUpper-intLower+1-count) + intUpper + 1;
		}
		if (count > 0)
		{
			var tryoldvalue = trynewvalue +1; // Just to make it different for the while test.
			while (trynewvalue != tryoldvalue)
			{
				if (tryoldvalue < trynewvalue) skipbase = tryoldvalue;
				var tryoldvalue = trynewvalue;
				var trynewvalue = trynewvalue + CountSeedsBelow(trynewvalue, Tree[0]) - CountSeedsBelow(skipbase, Tree[0]);
				if (trynewvalue > intUpper)  // To deal with wrapping
				{
					trynewvalue = (trynewvalue - (intUpper-intLower+1));
					skipbase = intLower - 1;
				}
				c2++;
			}
		}
		else
		{
			trynewvalue = ((newSeed) % (intUpper-intLower+1)) + intLower;
		}
		//Add newSeed to List
		List.push(trynewvalue);
		lastvalue = trynewvalue
		AddSeedToTree(trynewvalue, Tree[0]);
		count++;
	} 
	return List;
}


//*************************************************************************************************************
//********************************            ArtPack Registration            *********************************
//*************************************************************************************************************

this.registerArtPack = function(artPack) {
	if(this.startUp) this.startUp();
	if(typeof(artPack)!=='object') return;
	//Merge Plist Values with master list
	if (artPack.arrMainPlanetMoonNames !== 'undefined') {
		this.DHSys_plists.moons = this.DHSys_plists.moons.concat(artPack.arrMainPlanetMoonNames);
	};
	if (artPack.arrPlanetNames !== 'undefined') {
		this.DHSys_plists.planets = this.DHSys_plists.planets.concat(artPack.arrPlanetNames);
	};
	if (artPack.arrComplexPlanetCombos !== 'undefined') {
		this.copyComplexObject(artPack.arrComplexPlanetCombos,this.DHSys_plists.complex_Planets);
	};
	
	//Merge Texture Names with master list
	if (artPack.arrEcon0Textures !== 'undefined') this.DHSys_Textures.mainPlanets[0] = this.DHSys_Textures.mainPlanets[0].concat(artPack.arrEcon0Textures);
	if (artPack.arrEcon1Textures !== 'undefined') this.DHSys_Textures.mainPlanets[1] = this.DHSys_Textures.mainPlanets[1].concat(artPack.arrEcon1Textures);
	if (artPack.arrEcon2Textures !== 'undefined') this.DHSys_Textures.mainPlanets[2] = this.DHSys_Textures.mainPlanets[2].concat(artPack.arrEcon2Textures);
	if (artPack.arrEcon3Textures !== 'undefined') this.DHSys_Textures.mainPlanets[3] = this.DHSys_Textures.mainPlanets[3].concat(artPack.arrEcon3Textures);
	if (artPack.arrEcon4Textures !== 'undefined') this.DHSys_Textures.mainPlanets[4] = this.DHSys_Textures.mainPlanets[4].concat(artPack.arrEcon4Textures);
	if (artPack.arrEcon5Textures !== 'undefined') this.DHSys_Textures.mainPlanets[5] = this.DHSys_Textures.mainPlanets[5].concat(artPack.arrEcon5Textures);
	if (artPack.arrEcon6Textures !== 'undefined') this.DHSys_Textures.mainPlanets[6] = this.DHSys_Textures.mainPlanets[6].concat(artPack.arrEcon6Textures);
	if (artPack.arrEcon7Textures !== 'undefined') this.DHSys_Textures.mainPlanets[7] = this.DHSys_Textures.mainPlanets[7].concat(artPack.arrEcon7Textures);
	if (artPack.arrEcon8Textures !== 'undefined') this.DHSys_Textures.mainPlanets[8] = this.DHSys_Textures.mainPlanets[8].concat(artPack.arrPinkOceanTextures);
	if (artPack.arrGasGiantTextures !== 'undefined') this.DHSys_Textures.gas_Giants = this.DHSys_Textures.gas_Giants.concat(artPack.arrGasGiantTextures);
	if (artPack.arrMoonTextures !== 'undefined') this.DHSys_Textures.moons = this.DHSys_Textures.moons.concat(artPack.arrMoonTextures);
	if (artPack.arrPlanetTextures !== 'undefined') this.DHSys_Textures.planets = this.DHSys_Textures.planets.concat(artPack.arrPlanetTextures);
	
	//Merge Keyword Lists
	if (artPack.arrValidKeywordList !== 'undefined') this.copyComplexObject(artPack.arrValidKeywordList,this.DHSys_Textures.validKeywords);
	if (artPack.arrInvalidKeywordList !== 'undefined') this.copyComplexObject(artPack.arrInvalidKeywordList,this.DHSys_Textures.invalidKeywords);
}


this.copyComplexObject = function (sourceObject, destinationObject) {
	//for(let prop in sourceObject) log(this.name,"Current property:"+prop+" with value:"+sourceObject[prop]);
	var allowedProps = ["invalidKeywords","validKeywords"], tempA, tempB, tempC;
	if(typeof(sourceObject)!=='object') return;
	for(let prop in sourceObject){
		if(typeof(sourceObject[prop])==='object'){
			for(let dlProp in sourceObject[prop]){
				tempA = sourceObject[prop];
				if (!destinationObject.hasOwnProperty(prop)) destinationObject[prop] = tempA;
				if(typeof(sourceObject[prop][dlProp])==='object'){
					tempB = sourceObject[prop][dlProp];
					if(!destinationObject[prop].hasOwnProperty(dlProp)){
						// Create new
						destinationObject[prop][dlProp] = tempB;
					} else {
						// Combine
						tempC = destinationObject[prop][dlProp].concat(tempB);
						// Make unique - needs library
						tempC = this.helper.arrUnique(tempC);
						// Attach
						destinationObject[prop][dlProp] = tempC;
					}
				} else {
					if(typeof(sourceObject[prop][dlProp])==='string'){
						// Push in
						destinationObject[prop].push(sourceObject[prop][dlProp]);
						// Make unique
						destinationObject[prop] = this.helper.arrUnique(destinationObject[prop]);
					}
				}
			}
		}
	}
/*	// Control - only to show that it gets merged or new created
	log(this.name,"-------- Examine storage ----------");
	for(let prop in destinationObject){
		log(this.name,"Property:"+prop);
		if(typeof(destinationObject[prop])==='object'){
			for(let dlProp in destinationObject[prop]){
				log(this.name,"Token:"+dlProp+" : "+destinationObject[prop][dlProp]);
			}
		}
	}*/
	return;
}


