"use strict";
this.name = "Goods Container 50 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "2.0";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	// keep tally of pylon accessories bought
	this.$gc5Count++;
    // and don't let them exceed ship's pylon-capacity
	if ((equipment == "EQ_GC5_MINE") && (this.$gc5Count<=this.$gc5MCap)) {
		player.ship.cargoSpaceCapacity += 50;
		this.$gc5Containers++;
		pc("Modifying pylon hardpoints for container clamping...",9);
		pc("Fitting 50 TC Class Container #"+this.$gc5Containers+"...",9);
		pc("F4 'Your FE Shipyards' to check your Licence.",9);
	} else
	// unmount & sell cancels all container additions
	if (equipment == "EQ_MISSILE_REMOVAL") {
		player.ship.cargoSpaceCapacity -= this.$gc5Containers*50;
		pc("Removing all 50 TC Class Containers...",9)
		pc("Restoring pylon hardpoints for weapons-use...",9);
		if ((this.$gc5Containers>0) && (!this.$gc5HFExempt)) {
			// dismantling fee
			var dft = this.$gc5Containers*this.$gc5DismantlingFee;
			this.$gc5DismantlingFeeTotal += dft;
			player.credits -= dft;
			pc("Dismantling Fee: "+dft+" cr",9);
		}
		this.$gc5Count = 0;
		this.$gc5Containers = 0;
		// reset system-to-system runs w/containers
		this.$gc5Runs = 0;
		// reset fee totals
		this.$gc5HandlingFeeTotal = 0;
		this.$gc5MaintenanceFeeTotal = 0;
	}
}


this.playerBoughtNewShip = function(ship, price) {
	// missile capacity (not exceed)
	this.$gc5MCap = player.ship.missileCapacity;
	this.$gc5Count = 0;
	this.$gc5Containers = 0;
}


this.equipmentRemoved = function(equipmentKey) {
    if (equipmentKey == "EQ_GC5_MINE") {
		player.ship.cargoSpaceCapacity -= 50;
		this.$gc5Containers--;	
		player.consoleMessage("50 TC Goods Container removed.",5);
	}
}


this.shipReleasedEquipment = function(mine) {
	this.$gc5Count--;
    if (mine == "EQ_GC5_MINE") {
		player.ship.cargoSpaceCapacity -= 50;
		this.$gc5Containers--;
		player.commsMessage("50 TC Goods Container jettisoned.",5);
		// deduct container cost from credits
		player.credits -= 50000.0;
		player.commsMessage("Mishandling charge applied at cost.",9);
	}
}


this.shipFiredMissile = function(missile, target) {
	this.$gc5Count--;
    if (missile == "EQ_GC5_MINE") {
		player.ship.cargoSpaceCapacity -= 50;
		this.$gc5Containers--;	
		player.commsMessage("50 TC Goods Container jettisoned.",5);
		// deduct container cost from credits
		player.credits -= 50000.0;
		player.commsMessage("Mishandling charge applied at cost.",9);
	}
}


this.startUpComplete = function () {
	var pc = player.consoleMessage;
	// missile capacity (not exceed)
	this.$gc5MCap = player.ship.missileCapacity;
	this.$gc5Count = player.ship.missiles.length;
	// Load cargo space, missile & container counts if present
	if (missionVariables.gc5Cargo != null) 
		player.ship.cargoSpaceCapacity = missionVariables.gc5Cargo;
	if (missionVariables.gc5Count != null)
		this.$gc5Count = missionVariables.gc5Count;
	if (missionVariables.gc5Containers != null) 
		this.$gc5Containers = missionVariables.gc5Containers;
	// Load total fees taken
	if (missionVariables.gc5HandlingFeeTotal != null)
		this.$gc5HandlingFeeTotal = missionVariables.gc5HandlingFeeTotal;
	if (missionVariables.gc5HandlingPaid != null)
		this.$gc5HandlingPaid = missionVariables.gc5HandlingPaid;
	if (missionVariables.gc5MaintenanceFeeTotal != null)
		this.$gc5MaintenanceFeeTotal = missionVariables.gc5MaintenanceFeeTotal;
	if (missionVariables.gc5DismantlingFeeTotal != null)
		this.$gc5DismantlingFeeTotal = missionVariables.gc5DismantlingFeeTotal; 
    // Load system-to-system runs w/container
	if (missionVariables.gc5Runs != null)
		this.$gc5Runs = missionVariables.gc5Runs;
	// Load Handling fee count
	if (missionVariables.gc5HandlingCount != null)
		this.$gc5HandlingCount = missionVariables.gc5HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.gc5HFExempt != null)
		this.$gc5HFExempt = missionVariables.gc5HFExempt;
	// Load Maintenance fee count
	if (missionVariables.gc5MaintenanceCount != null)
		this.$gc5MaintenanceCount = missionVariables.gc5MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// TEST
	var sta = player.ship.dockedStation;
	if ((this.$gc5Containers<this.$gc5MCap) && (system.techLevel>=6))
		pc("Containers available in the Shipyard.");
	// prepare container Account screen
	this._gc5PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$gc5Containers>0) this._gc5PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$gc5ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$gc5ET = true;
	// TEST	
	if (this.$gc5ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$gc5FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$gc5FES = true;
	// TEST	
	if (this.$gc5ET) log(this.name, "Finds FE Ships Player present");
	// missile capacity (not exceed)
	this.$gc5MCap = 0;
	// pylon-use count
	this.$gc5Count = 0;
	// container count
	this.$gc5Containers = 0;
	// purchase cost of container in cr
	this.$gc5Cost = 50000;
	// handling fee
	this.$gc5HandlingFee = 0.005*this.$gc5Cost; // 0.005 of cost
	this.$gc5HandlingFeeTotal = 0;
	this.$gc5HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$gc5HandlingCount = 0;
	this.$gc5HFExempt = "no";
	// maintenance fee
	this.$gc5MaintenanceFee = 0.05*this.$gc5Cost; // 0.05 of cost
	this.$gc5MaintenanceFeeTotal = 0;
	this.$gc5MaintenancePaid = "no" // or "yes"
	this.$gc5MaintenanceInterval = 50; // in runs (according to cost)
	this.$gc5MaintenanceCount = 0;
	// dismantling fee
	this.$gc5DismantlingFee = 0.1*this.$gc5Cost; // 0.1 of cost
	this.$gc5DismantlingFeeTotal = 0.0;
	// system-to-system runs w/container
	this.$gc5Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.gc5Count = this.$gc5Count;
	missionVariables.gc5Cargo = player.ship.cargoSpaceCapacity;
	missionVariables.gc5Containers = this.$gc5Containers;
	// save total fees taken
	missionVariables.gc5HandlingFeeTotal = this.$gc5HandlingFeeTotal;
	missionVariables.gc5MaintenanceFeeTotal = this.$gc5MaintenanceFeeTotal;
	missionVariables.gc5DismantlingFeeTotal = this.$gc5DismantlingFeeTotal;
	missionVariables.gc5HandlingPaid = this.$gc5HandlingPaid;
	// system-to-system runs w/container
	missionVariables.gc5Runs =this.$gc5Runs;
	// handling fee count
	missionVariables.gc5HandlingCount = this.$gc5HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.gc5HFExempt = this.$gc5HFExempt;
	// maintenance fee count
	missionVariables.gc5MaintenanceCount = this.$gc5MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$gc5HFExempt;
	// check we have containers, the fee is not paid, and we're not exempt
	if ((this.$gc5Containers>0) && (this.$gc5HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$gc5Containers; x++)
			fee += this.$gc5HandlingFee;
		// record fee and debit trader's account
		this.$gc5HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$gc5HandlingPaid = "yes";
		pc("50 TC Container handling fees: "+fee+" cr",9);
		this.$gc5HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$gc5Containers>0) this._gc5DoMaintenance();

	// TEST
	if ((this.$gc5Containers<this.$gc5MCap) && (system.techLevel>=6))
		pc("Containers available in the Shipyard.");
	
	// prepare container Account and Licence page
	this._gc5PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$gc5Containers>0) this._gc5PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$gc5HandlingPaid = "no";
	this.$gc5Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._gc5DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$gc5Runs;
	var intv = this.$gc5MaintenanceInterval;
	var mfee = this.$gc5MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x containers
		var fee = 0;
		for (var x=1; x<= this.$gc5Containers; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$gc5MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("50 TC Container Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$gc5MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._gc5PrepAcc = function(station) {
	station.setInterface("gc5Acc",{
	title: "Your FE Shipyards 50 TC Container Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 50 TC Goods Container account screen shows terms, fees paid, load, and other useful information.",
	callback: this._gc5ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._gc5ShowAcc = function() {
	var hfc = this.$gc5HandlingCount;
	var mfc = this.$gc5MaintenanceCount;
	var mfi = this.$gc5MaintenanceInterval;
	var hft = this.$gc5HandlingFeeTotal;
	var mft = this.$gc5MaintenanceFeeTotal;
	var dft = this.$gc5DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$gc5Containers>0) 
		parameters.message +="Your Account and Licence for 50 TC Class Goods Containers x "+this.$gc5Containers+": \n\n"; 
	 else
		parameters.message +="You have no 50 TC Class Containers licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our containers are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Container account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylons for weapons-use. \n";
	
	parameters.choicesKey = "gc5Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._gc5PrepEx = function(station) {
	station.setInterface("gc5Ex",{
	title: "Your FE Shipyards Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 50-ton container class." ,
	callback: this._gc5ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._gc5ShowEx = function() {
	var priv = ((this.$gc5ET)||(this.$gc5FES));
	var privo = "";
	if (this.$gc5FES) privo="FE shipowner";
	if (this.$gc5ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 50 TC container fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "gc5YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$gc5HFExempt = "yes"; else this.$gc5HFExempt = "no";
		} else this.$gc5HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}



