"use strict";
this.name           = "assassins_rebooted_victim3.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script for the third Mission Ship - The Annaconda Trader - The Fair Wind.";

this.shipSpawned = function()
{
this.ship.bounty = 0;
// All Victims (except the first one) are offered as targets after the player recieves the Mark Transponder Scanner.
// Victims are marked in flashing red and blue, but you cannot use your cloak or energy bomb (if you have them) whilst you are in the same system as the victim.
// As the victims only appear at their respective system at the time their mission is running, their own script tests to see if the player has either item of equipment
// and replaces it with a dummy (which just appears adds the words '(Unavailable)' on the items F5 screen description, so that you no longer have a useable cloak or
// energy bomb. The dummy equipment is tested for under death actions and by the main script and rewards the real equipment and removes the dummy. The main script
// doesn't need to check for the presence of the victim as if he is there, his script disables the equipment when he spawns. The effect is that you can't use your cloak
// whilst you are in the victim's system and he is alive, but you get them back as soon as he dies or you leave his system.
//  Checks to see that the equipment is working. If it is damaged then it isn't removed, so you don't get a free repair
if (player.ship.equipmentStatus("EQ_CLOAKING_DEVICE") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_CLOAKING_DEVICE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK");
}
if (player.ship.equipmentStatus("EQ_ENERGY_BOMB") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ENERGY_BOMB");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB");
}
// Closing Bracket for This Ship Spawned.
}
// Only react to attacks from the player.
this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
player.bounty |= 51;
return;	
}
// As Victim 3 is a clean ship and none of the Assassins Victims ever attack NPC ships, lawful ships such as the police, bounty hunters and Assassins ships with a lawful
// Alignment will only have hit a Victim by accident. The Victim won't respond to an NPC hit except to move out of the way and breaking the target lock of the NPC which hit
// the Victim stops it shooting for a few seconds whilst it finds a new traget. If the Victim accidently hit a police ship, it's bounty is set back to 0, so it won't be attacked again
// by police or other ships which attack ships with bounties. If the lawful ship which hit the Victim got a bounty added to it for hitting a clean ship, its bounty is also set back to
// 0, so a hunter doesn't get attacked by other hunters or police ships for the fiendly fire incident.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1 || whom.roles.indexOf("hunter") > -1 
|| whom.roles.indexOf("assassins_rebooted_lawful_character") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// In the native game the only ship which could deliberatly find and target an assassins Victim ship would be a Thargoid. If the ship which hit the Victim ship is anything other
// than a police, hunter or lawful ship then it's AI is set to a customAI to flee 26kms from the Victim Ship, then return to its normal AI. If it is attacked by another ship whilst
// it is fleeing from the Victim Ship then it will fight that ship instead and exit the fleeingAI if it destroys its attacker.
else
{
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
// Same Tests as for being attacked above.
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
player.bounty |= 51;
return;	
}
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1 || whom.roles.indexOf("hunter") > -1 
|| whom.roles.indexOf("assassins_rebooted_lawful_character") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
else
{
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
// Same Tests as for being attacked above, but whilst the Victim will ignore a laser attack (as it won't be hit again), if an NPC has fired a missile at it, it will send
// a script message to the AI to flee the incoming missile and use ECM, but not to attack the other ship.
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_MISSILE"); 
player.bounty |= 51;
return;	
}
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1 || whom.roles.indexOf("hunter") > -1 
|| whom.roles.indexOf("assassins_rebooted_lawful_character") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("NPC_MISSILE"); 
return;		
}
else
{
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("NPC_MISSILE"); 
return;		
}
// End of this.shipAttackedWithMissile
}

this.shipDied = function (whom)
{
if (whom && whom.isPlayer)
{
player.bounty |= 70;
missionVariables.assassins_rebooted_stage = 15;
mission.setInstructionsKey("assassins_rebooted_mission_description_13", "AssassinsRebooted");
mission.unmarkSystem(203);
this.ship.commsMessage(expandDescription("[assassins-death-victim3]"), player.ship);
// Re-Award the Cloak and / or Energy Bomb if either or both were disabled (You don't get em back if you didn't have them in the first place).
if (player.ship.equipmentStatus("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK");
player.ship.awardEquipment("EQ_CLOAKING_DEVICE");
}
if (player.ship.equipmentStatus("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB");
player.ship.awardEquipment("EQ_ENERGY_BOMB");
}
// End of Killed by the Player.
}



// End of this.shipDied
}
