/*
	LOCALHERO I v1.03.10	FIRST ENCOUNTER	Made by Svengali Feb.2008
	This is the first part of the Localhero-Trilogy and currently only a testcase.
	After finishing all tests the code will become a little bit optimized so stay tuned...
	TODO:
	- Implement a version check - I'm not sure if I will do this. A player should be able to read
		the readme.txt or readme.rtf. And he should know what kind of version he uses (Oolite and Oxp).
		So why should I make a version check?
*/
this.name           = "localhero";
this.author         = "Svengali";
this.copyright      = "Feb2008";
this.description    = "Localhero Part I - V1.03.10";
this.version        = "1.03";

// ***********************  DECLARE VARS ********************************************
this.oxpLogging = false;			// Log infos to the stderr.txt. true or false.
this.localhero_screen = "LOOP";		// Indicator for MissionScreen
this.localhero_screenloop = 0;		// Loop-Counter for MissionScreen
// *********************** DECLARE TIMER *******************************************
this.startUp = function()
{
	if (this.oxpLogging) { LogWithClass('LOCALHERO','LOCALHERO LOGGING ON'); this.timer = new Timer(this, this.localheroScriptTimer, 0.5, 3); this.localhero_loopfactor = 4;}
	else { LogWithClass('LOCALHERO','LOCALHERO LOGGING OFF'); this.timer = new Timer(this, this.localheroScriptTimer, 0.5, 2); this.localhero_loopfactor = 2; }
	this.timer.stop();
}
// *********************** DECLARE FUNCTIONS *************************************
function LOCALHERO_LOGSTATS(from,info)
{
	if (oxpLogging)
	{
		let localhero_log = ' ST: '+missionVariables.localhero_status+' BA: '+missionVariables.localhero_backup+' HA: '+missionVariables.localhero_harkov+
			' SU: '+missionVariables.localhero_success+' SP: '+missionVariables.localhero_special+' GO: '+missionVariables.localhero_goal+
			' BO: '+missionVariables.localhero_bonus+' KI: '+missionVariables.localhero_kills+' IM: '+missionVariables.localhero_image+' ';
		let localhero_stat = '  LH: '+missionVariables.localhero+'  MC: '+mission.choice+'  MO: '+missionVariables.offering+'  MS: '+localhero_screen+
			' L-No.: '+localhero_screenloop+' D: '+missionVariables.localhero_dockings+' ';
		if (info) { LogWithClass('LOCALHERO', 'LOCALHERO Status: '+from+'\t\t'+guiScreen+'\t'+localhero_log+'\t'+localhero_stat+'\t'+info); }
		else { LogWithClass('LOCALHERO', 'LOCALHERO Status: '+from); }
	}
	return;
}

// galaxyNumber is GLOBAL and may change to player.galaxyNumber
function LOCALHERO_CHECKMAINCOND()
{
	if (galaxyNumber < 5 && system.government == 5 && system.techLevel > 7)	{ return true; }
	return false;
}

// Player docked at MainStation?
function LOCALHERO_CHECKMAINSTATION()
{
	if (System.mainStation == player.dockedStation) { return true; }
	return false;
}

function LOCALHERO_CHECKSCREEN()
{
	if (localhero_screen == "LOOP" || localhero_screen == "FIRST" || localhero_screen == "ONE")
	{
		if (!missionVariables.offering && !mission.choice && guiScreen != "GUI_SCREEN_MISSION") { LOCALHERO_LOGSTATS('CAN SHOW',1); return true; }
		else { LOCALHERO_LOGSTATS('SCREEN BLOCKED2',1); return false; }
	}
	else { LOCALHERO_LOGSTATS('SCREEN BLOCKED1',1); return false; }
}

// Show the mission screen
function LOCALHERO_SHOWSCREEN(kind,localheroKey1,localheroKey2)
{
	missionVariables.offering = "LOCALHERO";
	mission.clearMissionScreen();
	mission.setMusic();
	if (kind == 0) { mission.setBackgroundImage('localhero0.png'); localhero_screen = "FIRST"; }
	if (kind == 1)
	{
		if (missionVariables.localhero_image) {
			mission.setBackgroundImage('localhero'+missionVariables.localhero_image+'.png');
			if (timer.isRunning) { timer.stop(); }
		}
		else { mission.setBackgroundImage('localhero0.png'); }
		localhero_screen = "DONE";
	}
	mission.showShipModel();
	mission.showMissionScreen();
	if (localheroKey1) { mission.addMessageTextKey(localheroKey1); }
	if (localheroKey2) { mission.addMessageTextKey(localheroKey2); }
	LOCALHERO_LOGSTATS('SHOW SCREEN',1);
	return;
}

// Check if the player has an Energy-Bomb and if so give him a special message -> change
function LOCALHERO_BOMBTESTA()
{
	if (LOCALHERO_CHECKEQUIP("EQ_ENERGY_BOMB") == true)	{ mission.addMessageTextKey("LOCALHERO_PROTECT"); return; }
	mission.addMessageTextKey("LOCALHERO_NOPROTECT");
	return;
}

// CHECK FOR EQUIPMENT
function LOCALHERO_CHECKEQUIP(equip)
{
	if (player.hasEquipment(equip))	{ return true; }
	return false;
}

// REMOVE EQUIPMENT - IT IS NOT POSSIBLE TO CHECK FOR SPECIAL != "NO" BECAUSE SPECIAL IS SET LATER
function LOCALHERO_REMOVEEQUIP(equip, bonus)
{
	if (missionVariables.localhero)
	{
		if (player.hasEquipment(equip))
		{
			switch (parseInt(missionVariables.localhero_success))
			{
				case 3:
					player.removeEquipment(equip);
					missionVariables.localhero_bonus += bonus;
					break;
				case 8:
					player.removeEquipment(equip);
					missionVariables.localhero_bonus += bonus;
					break;
				case 15:
					player.removeEquipment(equip);
					missionVariables.localhero_bonus += bonus;
					break;
				case 22:
					player.removeEquipment(equip);
					missionVariables.localhero_bonus += bonus;
					break;
				case 30:
					player.removeEquipment(equip);
					missionVariables.localhero_bonus += bonus;
					break;
				default:
					break;
			}
			LOCALHERO_LOGSTATS('EQUIPMENT CHECKED');
		}
	}
	return;
}

function LOCALHERO_RESETTING(res1,res2,res3,res4,res5)
{
	// RESETMISSIONS
	if (res1 == 1) { missionVariables.localhero = null; mission.setInstructionsKey(); missionVariables.localhero_dockings = null; LOCALHERO_LOGSTATS('RESETTING DONE1',1.1); }
	//RESETVERSIONNEED - I LEAVE IT IN, MAY BE USEFUL FOR V1.71 - WE WILL SEE
	if (res2 == 1) { LOCALHERO_LOGSTATS('RESETTING DONE2',2.1); }
	// RESET TO OR FROM DATE
	if (res3 > 0) { missionVariables.localhero_backup = null; missionVariables.localhero_special = "NO"; missionVariables.localhero_goal = "999";
		missionVariables.localhero_bonus = "0"; LOCALHERO_LOGSTATS('RESETTING DONE3',3.1); }
	if (res3 == 1) { missionVariables.localhero_status = "DATE"; missionVariables.localhero_harkov = String(clock.days); }
	if (res3 == 2) { missionVariables.localhero_status = "COMPLETE"; missionVariables.localhero_harkov = "NO"; }
	// RESET OFFER - This depends on Eric Walchs MOP    
	if (res4 == 1) { missionVariables.offering = null; LOCALHERO_LOGSTATS('RESETTING DONE4',4.1); }
	if (res4 == 2) { mission.resetMissionChoice(); LOCALHERO_LOGSTATS('RESETTING DONE4',4.2); }
	if (res4 == 3) { missionVariables.offering = null; mission.resetMissionChoice(); LOCALHERO_LOGSTATS('RESETTING DONE4',4.3); }
	if (res4 == 4) { missionVariables.offering = null; mission.resetMissionChoice(); mission.clearMissionScreen(); mission.setMusic();
		mission.setBackgroundImage(); mission.showShipModel(); LOCALHERO_LOGSTATS('RESETTING DONE4',4.4); }
	// RESET LOOP
	if (res5 == 1) { localhero_screen = "DONE"; LOCALHERO_LOGSTATS('RESETTING DONE5',5.1); }
	if (res5 == 2) { localhero_screen = "FIRST"; LOCALHERO_LOGSTATS('RESETTING DONE5',5.2); }
	if (res5 == 3) { localhero_screen = "LOOP"; LOCALHERO_LOGSTATS('RESETTING DONE5',5.3); }
	if (res5 == 4) { localhero_screen = "ONE"; LOCALHERO_LOGSTATS('RESETTING DONE5',5.4); }
	return;
}

function LOCALHERO_RESETALL()
{
	missionVariables.localhero_status = null;
	missionVariables.localhero_success = null;
	missionVariables.localhero_kills = null;
	missionVariables.localhero_goal = null;
	missionVariables.localhero_bonus = null;
	missionVariables.localhero_special = null;
	missionVariables.localhero_harkov = null;
	missionVariables.localhero_backup = null;
	missionVariables.localhero_image = null;
	missionVariables.localhero_dockings = null;
	LOCALHERO_LOGSTATS('RESETTING ALL');
	return;
}

/*
	This was the most time intensive process on DEBRIEFING. I was always wondering about the long time it takes to get a debrief screen.
	So I've made some tests and found that the sendAllShipsAway-method has slowed down the processing. Sending 200 ships away needs time.
	All pods will stay untouched - so you can collect them after the debrief.
*/
function LOCALHERO_SENDAWAY()
{
	let a = system.countShipsWithRole('harkov_transporter');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkov_transporter')[0].fuel = 7.0; system.shipsWithRole('harkov_transporter')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkov_shuttle1');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkov_shuttle1')[0].fuel = 7.0; system.shipsWithRole('harkov_shuttle1')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkov_shuttle2');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkov_shuttle2')[0].fuel = 7.0; system.shipsWithRole('harkov_shuttle2')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkov_gl');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkov_gl')[0].fuel = 7.0; system.shipsWithRole('harkov_gl')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkov_glH');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkov_glH')[0].fuel = 7.0; system.shipsWithRole('harkov_glH')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkov_gm');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkov_gm')[0].fuel = 7.0; system.shipsWithRole('harkov_gm')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkov_general');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkov_general')[0].fuel = 7.0; system.shipsWithRole('harkov_general')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkovraidp_gl');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkovraidp_gl')[0].fuel = 7.0; system.shipsWithRole('harkovraidp_gl')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkovraidt_gl');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkovraidt_gl')[0].fuel = 7.0; system.shipsWithRole('harkovraidt_gl')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkovraidp_gm');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkovraidp_gm')[0].fuel = 7.0; system.shipsWithRole('harkovraidp_gm')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkovraids_gm');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkovraids_gm')[0].fuel = 7.0; system.shipsWithRole('harkovraids_gm')[0].switchAI('harkovleaveAI.plist'); a--; } }
	a = system.countShipsWithRole('harkovraidt_gm');
	if (a > 0) { while (a > 0) { system.shipsWithRole('harkovraidt_gm')[0].fuel = 7.0; system.shipsWithRole('harkovraidt_gm')[0].switchAI('harkovleaveAI.plist'); a--; } }
	return;
}

// Give numbers back 0= No Harkovian left
function LOCALHERO_CHECKSPACE()
{
	let a = system.countShipsWithRole('harkov_transporter');
	a += system.countShipsWithRole('harkov_shuttle1')+system.countShipsWithRole('harkov_shuttle2')+system.countShipsWithRole('harkov_gl');
	a += system.countShipsWithRole('harkov_glH')+system.countShipsWithRole('harkov_gm')+system.countShipsWithRole('harkov_general');
	a += system.countShipsWithRole('harkovraidp_gl')+system.countShipsWithRole('harkovraidt_gl')+system.countShipsWithRole('harkovraidp_gm');
	a += system.countShipsWithRole('harkovraids_gm')+system.countShipsWithRole('harkovraidt_gm');
	return(a);
}

function LOCALHERO_SETMISSION()
{
	mission.setInstructionsKey("LOCALHERO_MISSION_DESC");
	missionVariables.localhero = "CONFED Police Mission";
	return;
}

// Interactive parts (DOCKING WHILE MISSION and ..._status is RUNNING)
function LOCALHERO_DWMRUNNING()
{
	LOCALHERO_LOGSTATS('DWMRUN START',1);
	let goal = parseInt(missionVariables.localhero_goal);
	if (goal > 119)	{ missionVariables.localhero_status = "KILLED"; LOCALHERO_DWMKILLED(); return; }
	else
	{
		if (goal > 79)
		{
			if (missionVariables.localhero_special == "FAILED")	{ missionVariables.localhero_status = "KILLED"; LOCALHERO_DWMKILLED(); return; }
			else
			{
				if (LOCALHERO_CHECKSCREEN() == true)
				{
					LOCALHERO_SHOWSCREEN(1,"LOCALHERO_RUN_BUTESCORT2");
					missionVariables.localhero_status = "RUNAWAY";
					mission.setChoicesKey("LOCALHERO_MISSIONCHOICE");
					return;
				}
				else { return; }
			}
		}
		else
		{
			if (goal < 1) { missionVariables.localhero_status = "KILLED"; LOCALHERO_DWMKILLED(); return; }
			else
			{
				if (LOCALHERO_CHECKSCREEN() == true)
				{
					LOCALHERO_SHOWSCREEN(1);
					if (goal > 39)
					{
						if (missionVariables.localhero_special == "ESCORT1") { mission.addMessageTextKey("LOCALHERO_RUN_BUTESCORT1"); }
						if (missionVariables.localhero_special == "RESCUED") { mission.addMessageTextKey("LOCALHERO_RUN_SHUTTLE_BUTHARKOV"); }
						if (missionVariables.localhero_special == "ESCORT2" && missionVariables.localhero_harkov == "YES") { mission.addMessageTextKey("LOCALHERO_RUN_HARKOV_BUTESCORT2"); }
					}
					else
					{
						if (missionVariables.localhero_special == "NO")
						{
							if (missionVariables.localhero_backup == "CAPTURED") { mission.addMessageTextKey("LOCALHERO_RUN_BACKUPBUTGOAL"); }
							else { mission.addMessageTextKey("LOCALHERO_RUN_BUTGOAL"); }
						}
						if (missionVariables.localhero_special == "YES") { mission.addMessageTextKey("LOCALHERO_RUN_RAID_BUTGOAL"); }
						if (missionVariables.localhero_special == "RESCUED")
						{
							if (missionVariables.localhero_backup == "CAPTURED") { mission.addMessageTextKey("LOCALHERO_RUN_SHUTTLE_BACKUPBUTGOAL"); }
							else { mission.addMessageTextKey("LOCALHERO_RUN_SHUTTLE_BUTGOAL"); }
						}
					}
					missionVariables.localhero_status = "RUNAWAY";
					mission.setChoicesKey("LOCALHERO_MISSIONCHOICE");
					return;
				}
				else { return; }
			}
		}
	}
	LOCALHERO_LOGSTATS('DWMRUN ENDED',1);
	return;
}

// Interactive parts (DOCKING WHILE MISSION and ..._status is KILLED)
function LOCALHERO_DWMKILLED()
{
	LOCALHERO_LOGSTATS('DWMKIL START',1);
	let goal = parseInt(missionVariables.localhero_goal);
	if (goal > 0 && goal < 80) { missionVariables.localhero_status == "RUNNING"; LOCALHERO_DWMRUNNING(); return; }
	else
	{
		if (LOCALHERO_CHECKSCREEN() == true)
		{
			LOCALHERO_SENDAWAY();
			LOCALHERO_SHOWSCREEN(1);
			if (goal > 120)	{ mission.addMessageTextKey("LOCALHERO_DEBRIEF_LOST_ALL_PRIMARY_GOALS"); }
			if (goal > 80 && goal < 121 && missionVariables.localhero_special == "FAILED") { mission.addMessageTextKey("LOCALHERO_DEBRIEF_LOST_SHUTTLE_GOAL"); }
			if (goal < 1 && missionVariables.localhero_special == "NO")	{ mission.addMessageTextKey("LOCALHERO_DEBRIEF_LOST_NORMAL"); }
			if (goal < 1 && missionVariables.localhero_special == "YES") { mission.addMessageTextKey("LOCALHERO_DEBRIEF_LOST_RAID"); }
			missionVariables.localhero_bonus = "0";
			LOCALHERO_RESETTING(1,0,0,1,1);
			missionVariables.localhero_backup = null;
			missionVariables.localhero_goal = "999";
			missionVariables.localhero_status = "REFUSED";
			return;
		}
	}
	LOCALHERO_LOGSTATS('DWMKIL ENDED',1);
	return;
}

// Interactive parts (DOCKING WHILE MISSION and ..._status is CAPTURED)
function LOCALHERO_DWMCAPTURED()
{
	LOCALHERO_LOGSTATS('DWMCAP START',1);
	let goal = parseInt(missionVariables.localhero_goal);
	missionVariables.localhero_backup = "CAPTURED";
	if (goal > 119)	{ missionVariables.localhero_status = "KILLED"; LOCALHERO_DWMKILLED(); return; }
	else
	{
		if (goal > 79)
		{
			if (missionVariables.localhero_harkov == "NO")
			{
				if (missionVariables.localhero_special == "FAILED")	{ missionVariables.localhero_status == "KILLED"; LOCALHERO_DWMKILLED(); return; }
				if (missionVariables.localhero_special == "ESCORT2") { missionVariables.localhero_status = "RUNNING"; LOCALHERO_DWMRUNNINIG(); return; }
			}
			else
			{
				if (LOCALHERO_CHECKSCREEN() == true)
				{
					LOCALHERO_SENDAWAY();
					LOCALHERO_SHOWSCREEN(1,"LOCALHERO_DEBRIEF_LOST_HARKOV_ESCAPE","LOCALHERO_COMEBACK");
					LOCALHERO_RESETTING(1,0,1,1,1);
					return;
				}
			}
		}
		else
		{
			if (goal > 0) { missionVariables.localhero_status = "RUNNING"; LOCALHERO_DWMRUNNING(); return; }
		}
	}
	if (goal < 1)
	{
		if (LOCALHERO_CHECKSCREEN() == true)
		{
			LOCALHERO_SENDAWAY();
			if (missionVariables.localhero_special != "NO")	{ missionVariables.localhero_image++; }
			LOCALHERO_SHOWSCREEN(1);
			missionVariables.localhero_bonus++;
			missionVariables.localhero_bonus--;
			if (missionVariables.localhero_special == "NO") { mission.addMessageTextKey("LOCALHERO_DEBRIEF_NORMAL"); }
			if (missionVariables.localhero_special == "YES") { mission.addMessageTextKey("LOCALHERO_DEBRIEF_RAID"); }
			if (missionVariables.localhero_special == "RESCUED" && missionVariables.localhero_harkov == "NO") { mission.addMessageTextKey("LOCALHERO_DEBRIEF_ESCORT"); }
			if (missionVariables.localhero_special == "RESCUED" && missionVariables.localhero_harkov == "YES") { mission.addMessageTextKey("LOCALHERO_DEBRIEF_CAMPAIGN_OVER"); }
			let success = parseInt(missionVariables.localhero_success);
			switch (success)
			{
				case 3:
					mission.addMessageTextKey("LOCALHERO_PLUSRANK1");
					break;
				case 8:
					mission.addMessageTextKey("LOCALHERO_PLUSMEDAL1");
					break;
				case 15:
					mission.addMessageTextKey("LOCALHERO_PLUSRANK2");
					break;
				case 22:
					mission.addMessageTextKey("LOCALHERO_PLUSMEDAL2");
					break;
				case 30:
					mission.addMessageTextKey("LOCALHERO_PLUSMEDAL3");
					break
				default:
					break;
			}
			missionVariables.localhero_success++;
			success++;
			player.credits += parseInt(missionVariables.localhero_bonus);
			missionVariables.localhero_bonus = "0";
			missionVariables.localhero_special = "NO";
			mission.addMessageTextKey("LOCALHERO_CURRENT_STATUS");
			if (success < 32 && success > 15) { mission.addMessageTextKey("LOCALHERO_RANK2"); }
			else
			{
				if (success < 16 && success > 3) { mission.addMessageTextKey("LOCALHERO_RANK1"); }
				else { mission.addMessageTextKey("LOCALHERO_RANK0"); }
			}
			if (success < 31 && success > 22) { mission.addMessageTextKey("LOCALHERO_MEDAL2"); }
			else
			{
				if (success < 23 && success > 8) { mission.addMessageTextKey("LOCALHERO_MEDAL1"); }
				else
				{
					if (success == 31) { mission.addMessageTextKey("LOCALHERO_MEDAL3"); }
					else { mission.addMessageTextKey("LOCALHERO_MEDAL0"); }
				}
			}
			LOCALHERO_RESETTING(1,0,0,1,1);
			if (missionVariables.localhero_harkov == "NO")
			{
				LOCALHERO_RESETTING(0,0,1,0,0);
				mission.addMessageTextKey("LOCALHERO_COMEBACK");
			}
			missionVariables.localhero_backup = null;
			if (missionVariables.localhero_harkov == "YES")
			{
				// Reset everything except ..._harkov
				mission.addMessageTextKey("LOCALHERO_CAMPAIGNOVER");
				LOCALHERO_RESETALL();
				missionVariables.localhero_harkov = "YES";
			}
			else { LOCALHERO_RESETTING(0,0,1,0,0); }
			if (player.bounty >= 7) { player.bounty -= 7; }
			return;
		}
	}
	LOCALHERO_LOGSTATS('DWMCAP ENDED',1);
	return;
}

/* GENERATE MISSION SHIPS
	10 Arguments:		PGL, PGL_Dist, TGL, TGL_Dist, PGM, PGM_Dist, TGM, TGM_Dist, SGM, SGM_Dist
*/
function LOCALHERO_GENERATE_RAIDSHIPS(PGL, PGL_Dist, TGL, TGL_Dist, PGM, PGM_Dist, TGM, TGM_Dist, SGM, SGM_Dist)
{
	if (PGL > 0) { System.legacy_addSystemShips("harkovraidp_gl", PGL, PGL_Dist) }
	if (TGL > 0) { System.legacy_addSystemShips("harkovraidt_gl", TGL, TGL_Dist) }
	if (PGM > 0) { System.legacy_addSystemShips("harkovraidp_gm", PGM, PGM_Dist) }
	if (TGM > 0) { System.legacy_addSystemShips("harkovraidt_gm", TGM, TGM_Dist) }
	if (SGM > 0) { System.legacy_addSystemShips("harkovraids_gm", SGM, SGM_Dist) }
	return;
}
/* GENERATE MISSION SHIPS
	8 Arguments:		HAR, HAR_Dist, SHU, SHU_Dist, GOV, GOV_Dist, TRA, TRA_Dist
*/
function LOCALHERO_GENERATE_SPECIALSHIPS(HAR, HAR_Dist, SHU, SHU_Dist, GOV, GOV_Dist, TRA, TRA_Dist)
{
	if (HAR > 0) { System.legacy_addSystemShips("harkov_general", HAR, HAR_Dist) }
	if (SHU > 0) { System.legacy_addSystemShips("harkov_shuttle1", SHU, SHU_Dist) }
	if (GOV > 0) { System.legacy_addSystemShips("harkov_shuttle2", GOV, GOV_Dist) }
	if (TRA > 0) { System.legacy_addSystemShips("harkov_transporter", TRA, TRA_Dist) }
	return;
}
/* GENERATE MISSION SHIPS
	6 Arguments:		GLH, GLH_Dist, GLN, GLN_Dist, GM, GM_Dist
*/
function LOCALHERO_GENERATE_NORMALSHIPS(GLH, GLH_Dist, GLN, GLN_Dist, GM, GM_Dist)
{
	if (GLH > 0) { System.legacy_addSystemShips("harkov_glH", GLH, GLH_Dist) }
	if (GLN > 0) { System.legacy_addSystemShips("harkov_gl", GLN, GLN_Dist) }
	if (GM > 0) { System.legacy_addSystemShips("harkov_gm", GM, GM_Dist) }
	return;
}

function LOCALHERO_GENERATE_BONUSSHIPS(bonus)
{
	// Add Enemies based on the player skills and Mission-Nr.
	if (player.score > 200)
	{
		/*	Example: A player has a score = 290 and has done 6 missions		Example2: A player has a score = 2500 and has done 12 missions
				2*290-49 = 531 Math.log = 6,2747...						2*2500-49 = 4951 Math.log = 8,5073...
			+	6+2 = 8 Math.log = 2.07944...						+	12+2 = 14 Math.log = 2,6390...
			= 8,3542... * 0.5 (random) = 4,177						= 11,1464... * 0.8 (random) = 8,9171...
			= Math.ceil = 5 >>>2 = 1								= Math.ceil = 9>>>2 = 2
		*/
		let advance = (Math.ceil((Math.log(2*player.score-49)+Math.log(parseInt(missionVariables.localhero_success)+2))*Math.random()))>>>2;
		let advanceII = 0;
		if (bonus) { advance ^= bonus; }
		missionVariables.localhero_goal += advance;
		if (player.score > 500) { advance++; missionVariables.localhero_goal++; }
		if (advance > 1) { advanceII = advance>>>1; }
		switch (parseInt(missionVariables.localhero_success))
		{
			case 3:
				LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,0,0,advance,0.8,0,0);
				break;
			case 8:
				LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,0,0,0,0,advance,0.8);
				break;
			case 15:
				LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,0,0,0,0,advance,0.8);
				break;
			case 22:
				LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,0,0,advance,0.7,advanceII,0.9);
				break;
			case 30:
				LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,advanceII,0.5,advance,0.7,advanceII,0.8);
				break;
			default:
				LOCALHERO_GENERATE_NORMALSHIPS(0,0,0,0,advance,0.7);
				break;
		}
	}
	return;
}

/* Example: goal = 6, friends = 2, success =14
	goalMain = 6-2 (friends) = 4
	goalB = 4/2.5 = 1.6 Math.ceil = 2+1+ (14>>>4) = 3
	goalC = 4>>>2 = 1+1 = 2
	goalD = 4>>>1 = 3&3 = 3+1 = 4
*/
function LOCALHERO_RESTART_GENERATE(friends)
{
	let goalMain = missionVariables.localhero_goal;
	while (goalMain >= 40) { goalMain -= 40; }
	if (friends && goalMain > friends) { goalMain -= friends; }
	let success = missionVariables.localhero_success;
	let special = missionVariables.localhero_special;
	let goalB = Math.ceil(goalMain/2.5)+1+(success>>>4);
	let goalC = (goalMain>>>2)+1;
	let goalD = (goalMain>>>1)&3+1;
	let sum = (goalD*3+goalC*3+goalB)-goalMain;
	while (sum > 5) { goalB--; goalC--; sum = (goalD*3+Math.max(goalC, 0)*3+Math.max( 0, goalB))-goalMain; }
	LOCALHERO_LOGSTATS('***** RESTART_GENERATE *****'+player.score,sum);
	if (special == "NO")
	{
		if (success >= 11) { LOCALHERO_GENERATE_NORMALSHIPS(goalC,0.7,goalD,0.8,goalB,0.7); LOCALHERO_GENERATE_SPECIALSHIPS(0,0,0,0,0,0,1,0.85); }
		if (success < 11 && success > 3) { LOCALHERO_GENERATE_NORMALSHIPS(0,0,goalC,0.8,goalB,0.7); }
		if (success < 3) { LOCALHERO_GENERATE_NORMALSHIPS(0,0,0,0,(goalB+1),0.7); }
	}
	else
	{
		if (special == "ESCORT1") { LOCALHERO_GENERATE_SPECIALSHIPS(0,0,1,0.8,0,0,0,0); }
		if (special == "ESCORT2") { LOCALHERO_GENERATE_SPECIALSHIPS(0,0,0,0,1,0.8,0,0); }
		if (success == "30" && missionVariables.localhero_harkov == "NO") { LOCALHERO_GENERATE_SPECIALSHIPS(1,0.7,0,0,0,0,0,0); }
		LOCALHERO_GENERATE_RAIDSHIPS(goalD,0.75,goalC,0.7,goalC,0.8,goalB,0.8,goalD,0.7);
	}
	return;
}
// ******************************************************************************************************************
this.reset = function()
{
	this.localhero_screen = "LOOP";
	this.localhero_screenloop = 0;
	LOCALHERO_LOGSTATS('***** LOADING RESET START *****',1);
	this.timer.start();
}

// MAIN ROUTINE
this.shipDockedWithStation = function()
{
	if (LOCALHERO_CHECKMAINCOND() == true)
	{
		if (LOCALHERO_CHECKMAINSTATION() == true)
		{
			if (!this.localhero_screen) { this.localhero_screen = "LOOP";}
			if (!this.localhero_screenloop) { this.localhero_screenloop = 0; }
			LOCALHERO_LOGSTATS('***** DOCKED START *****',1);
			if (this.localhero_screen != "DONE" && this.timer.isRunning == false) { this.timer.start(); }
			if (!missionVariables.localhero)
			{
				LOCALHERO_LOGSTATS('DOCKED NOMIS',1);
				// Check for NOMISSION KILLS...
				if (missionVariables.localhero_bonus && parseInt(missionVariables.localhero_bonus) > 0)
				{
					if (LOCALHERO_CHECKSCREEN() == true)
					{
						LOCALHERO_SHOWSCREEN(1,"LOCALHERO_NOMISSION_BEGIN");
						if (missionVariables.localhero_status == "KILLED" || missionVariables.localhero_status == "CAPTURED") { mission.addMessageTextKey("LOCALHERO_NOMISSION_KILLS"); player.credits += 150; }
						if (missionVariables.localhero_special == "RESCUED") { mission.addMessageTextKey("LOCALHERO_NOMISSION_RESCUED"); }
						if (missionVariables.localhero_harkov == "YES") { mission.addMessageTextKey("LOCALHERO_NOMISSION_HARKOV"); }
						mission.addMessageTextKey("LOCALHERO_NOMISSION_END");
						LOCALHERO_RESETTING(0,0,1,1,1);
					}
				}
				// CHECK DATE
				if (missionVariables.localhero_status == "DATE")
				{
					let localhero_date = Math.floor(clock.days - parseInt(missionVariables.localhero_harkov));
					if (localhero_date > 8) { LOCALHERO_RESETTING(0,0,2,0,0); }
					else { this.localhero_screen = "DONE"; this.timer.stop(); }
				}
				// SETUP - THIS IS THE FIRST CONTACT
				if (!missionVariables.localhero_harkov)
				{
					if (missionVariables.localhero_status == "COMPLETE" || !missionVariables.localhero_success)
					{	
						if (LOCALHERO_CHECKSCREEN() == true)
						{
							LOCALHERO_SHOWSCREEN(0,"LOCALHERO_SETUP");
							missionVariables.localhero_status = "FIRST";
							missionVariables.localhero_backup = "NO";
							missionVariables.localhero_harkov = "NO";
							missionVariables.localhero_special = "NO";
							missionVariables.localhero_goal = "0";
							missionVariables.localhero_bonus = "0";
							missionVariables.localhero_success = "0";
							missionVariables.localhero_kills = "0";
							missionVariables.localhero_image = "0";
							// RESETTING THE OFFERING IS NECESSARY, BECAUSE WE NEED A SECOND SCREEN. BUT WE USE ANOTHER STATE FOR SCREEN
							LOCALHERO_RESETTING(0,0,0,3,4);
						}
						else { LOCALHERO_LOGSTATS('FIRST BLOCKED'); }
					}
				}
			}
			else
			{
				LOCALHERO_LOGSTATS('DOCKED  MISSIO',1);
				// CHECK DOCKING COUNTER
				if (parseInt(missionVariables.localhero_dockings) > 1 && parseInt(missionVariables.localhero_goal) > 0)
				{
					if (LOCALHERO_CHECKSCREEN() == true)
					{
						// ABORT MISSION
						LOCALHERO_SHOWSCREEN(1,"LOCALHERO_MISSION_ABORT");
						LOCALHERO_SENDAWAY();
						LOCALHERO_RESETTING(1,0,1,1,1);
					}
					else { LOCALHERO_LOGSTATS('ABORT BLOCKED'); }
				}
				else
				{
					// CHANGE BACK MESSAGES TO CAPTURED
					if (missionVariables.localhero_status == "MESSAGE")	{ missionVariables.localhero_status = "CAPTURED"; }
					// LEVELING
					if (parseInt(missionVariables.localhero_goal) < 1) { missionVariables.localhero_goal = "0"; }
					else
					{
						let success = parseInt(missionVariables.localhero_success);
						let goal = parseInt(missionVariables.localhero_goal);
						if (missionVariables.localhero_special == "FAILED")
						{
							if (missionVariables.localhero_harkov == "NO")
							{
								if (success == 30 && goal < 120) { missionVariables.localhero_goal = "120"; }
								if (success < 30 && goal < 80) { missionVariables.localhero_goal = "80"; }
							}
							else if (missionVariables.localhero_harkov == "YES" && goal < 80) { missionVariables.localhero_goal = "80"; }
							}
						else
						{
							if (missionVariables.localhero_special == "RESCUED")
							{
								if (missionVariables.localhero_success == "30")
								{
									if (missionVariables.localhero_harkov == "NO" && goal < 40) { missionVariables.localhero_goal = "40"; }
								}
							}
							else
							{
								if (missionVariables.localhero_special == "ESCORT1" && goal < 40) { missionVariables.localhero_goal = "40"; }
								if (missionVariables.localhero_special == "ESCORT2")
								{
									if (missionVariables.localhero_harkov == "NO" && goal < 80) { missionVariables.localhero_goal = "80"; }
									if (missionVariables.localhero_harkov == "YES" && goal < 40) { missionVariables.localhero_goal = "40"; }
								}
							}
						}
					}
					if (LOCALHERO_CHECKSCREEN() == true)
					{
						LOCALHERO_LOGSTATS('LOCALHERO STATUS: DOCKED MISSION SWITCH');
						switch(missionVariables.localhero_status)
						{
							case "RUNAWAY":
								LOCALHERO_DWMRUNNING();
								break;
							case "RUNNING":
								LOCALHERO_DWMRUNNING();
								break;
							case "KILLED":
								LOCALHERO_DWMKILLED();
								break;
							case "CAPTURED":
								LOCALHERO_DWMCAPTURED();
								break;
							default:
								break;
						}
					}
				}
			}
		}
	}
}

this.missionScreenEnded = function()
{
	if (LOCALHERO_CHECKMAINCOND() == true)
	{
		if (LOCALHERO_CHECKMAINSTATION() == true)
		{
			if (!this.localhero_screen) { this.localhero_screen = "LOOP";}
			if (!this.localhero_screenloop) { this.localhero_screenloop = 0; }
			LOCALHERO_LOGSTATS('CHOICES START',1);
			// Handle choices YES
			if (mission.choice == "LOCALHERO_ACCEPTED")
			{
				switch (missionVariables.localhero_status)
				{
					case "FIRST":
						missionVariables.localhero_status = "ACCEPT";
						LOCALHERO_SETMISSION();
						LOCALHERO_RESETTING(0,0,0,3,1);
						break;
					case "RUNAWAY":
						LOCALHERO_SENDAWAY();
						LOCALHERO_RESETTING(1,0,1,3,1);
						break;
					case "COMPLETE":
						missionVariables.localhero_status = "ACCEPT";
						LOCALHERO_SETMISSION();
						LOCALHERO_REMOVEEQUIP("EQ_ENERGY_BOMB",1000);
						LOCALHERO_RESETTING(0,0,0,3,1);
						break;
					default:
						break;
				}
				//LOCALHERO_RESETTING(0,0,0,4,1);
			}
			// Handle choices NO
			if (mission.choice == "LOCALHERO_REFUSED")
			{
				switch (missionVariables.localhero_status)
				{
					case "FIRST":
						//missionVariables.localhero_status = "REFUSED";
						LOCALHERO_RESETTING(0,0,0,3,1);
						break;
					case "RUNAWAY":
						missionVariables.localhero_status = "NOACTION";
						LOCALHERO_REMOVEEQUIP("EQ_ENERGY_BOMB",500);
						LOCALHERO_RESETTING(0,0,0,3,1);
						break;
					case "COMPLETE":
						missionVariables.localhero_status = "REFUSED";
						LOCALHERO_RESETTING(0,0,0,3,1);
						break;
					default:
						break;
				}
				//LOCALHERO_RESETTING(0,0,0,4,1);
			}
			LOCALHERO_LOGSTATS('CHOICES ENDED',1);
			// FIRST SCREEN?	LOCALHERO_RESETTING(0,0,0,1,3);
			if (this.localhero_screen == "FIRST") { LOCALHERO_RESETTING(0,0,0,3,3); }
			// LOOP THE WHOLE HANDLING ROUTINE?
			if (this.localhero_screen == "LOOP" && !mission.choice && guiScreen != "GUI_SCREEN_MISSION" && !missionVariables.offering)
			{
				//LOCALHERO_RESETTING(0,0,0,1,0);
				this.localhero_screenloop++;
				LOCALHERO_LOGSTATS('RESTART HANDLING1',1);
				this.shipDockedWithStation();
			}
			if (this.localhero_screen == "LOOP" && guiScreen != "GUI_SCREEN_MISSION" && missionVariables.offering != "LOCALHERO")
			{
				//LOCALHERO_RESETTING(0,0,0,1,0);
				this.localhero_screenloop++;
				LOCALHERO_LOGSTATS('RESTART HANDLING2',1);
				this.shipDockedWithStation();
			}
			LOCALHERO_LOGSTATS('CHOICES LOOPS',1);
		}
		// Help other Oxps to get their missionscreens
		// BUT I DON'T KNOW HOW A EVENT FOR OTHER SCRIPTS COULD BE TRIGGERED
	}
}

this.shipLaunchedFromStation = function()
{
	if (LOCALHERO_CHECKMAINCOND() == true)
	{
		LOCALHERO_LOGSTATS('*** LAUNCH START ***',1);
		LOCALHERO_RESETTING(0,0,0,4,3);
		if (this.timer.isRunning) { this.timer.stop(); }
		if (!this.localhero_screen) { this.localhero_screen = "LOOP"; }
		if (!this.localhero_screenloop) { this.localhero_screenloop = 0; }
		this.localhero_screenloop = 0;
		if (missionVariables.localhero)
		{
			// RELAUNCHED OR RELOADED
			if (missionVariables.localhero_status != "ACCEPT")
			{
				// BONUS ON RELAUNCH OR RELOADED
				missionVariables.localhero_bonus = Math.ceil(parseInt(missionVariables.localhero_bonus)*0.75);
				missionVariables.localhero_dockings++;
				// CHECK HARKOVS
				let harkovs = LOCALHERO_CHECKSPACE();
				let goal = missionVariables.localhero_goal;
				if (harkovs == 0)
				{
					// CREATE ENEMIES, BECAUSE OF LOADED SAVEGAME
					LOCALHERO_LOGSTATS('RELOADED MISSION CONTINUE'+harkovs);
					LOCALHERO_RESTART_GENERATE();
				}
				else if (harkovs != 0 && goal > harkovs)
				{
					// RELAUNCH - FILL IN MISSING SHIPS
					LOCALHERO_LOGSTATS('LAUNCH MISSION CONTINUE'+harkovs);
					LOCALHERO_RESTART_GENERATE(harkovs);
				}
				// Bonus ships, harr harr
				LOCALHERO_GENERATE_BONUSSHIPS(3);
				LOCALHERO_LOGSTATS('BONUSSHIPS ADDED');
			}
			// NEW MISSION
			else if (missionVariables.localhero_status == "ACCEPT")
			{
				LOCALHERO_LOGSTATS('LAUNCH MISSION GENERATE');
				/* Generating enemies
					10 Arguments:		PGL, PGL_Dist, TGL, TGL_Dist, PGM, PGM_Dist, TGM, TGM_Dist, SGM, SGM_Dist
					8 Arguments:		HAR, HAR_Dist, SHU, SHU_Dist, GOV, GOV_Dist, TRA, TRA_Dist
					6 Arguments:		GLH, GLH_Dist, GLN, GLN_Dist, GM, GM_Dist
				*/
				missionVariables.localhero_dockings = "0";
				missionVariables.localhero_bonus = "0";
				missionVariables.localhero_status = "RUNNING";
				let success = parseInt(missionVariables.localhero_success);
				// *** ESCORT GOVERNOR AND CAPTURE HARKOV ***  EQ_ENERGY_BOMB DISABLED
				if (success == 30)
				{
					missionVariables.localhero_special = "ESCORT2";
					missionVariables.localhero_goal = "95";
					LOCALHERO_GENERATE_RAIDSHIPS(2,0.6,3,0.8,4,0.8,3,0.6,2,0.6);
					LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,0,0,0,0,2,0.8);
					LOCALHERO_GENERATE_SPECIALSHIPS(1,0.7,0,0,1,0.9,0,0);
				}
				if (success > 22 && success < 30)
				{
					missionVariables.localhero_special = "NO";
					missionVariables.localhero_goal = "13";
					LOCALHERO_GENERATE_NORMALSHIPS(2,0.5,0,0,3,0.9);
					LOCALHERO_GENERATE_NORMALSHIPS(1,0.6,0,0,0,0);
					LOCALHERO_GENERATE_NORMALSHIPS(1,0.7,0,0,0,0);
					LOCALHERO_GENERATE_NORMALSHIPS(1,0.9,0,0,0,0);
					LOCALHERO_GENERATE_SPECIALSHIPS(0,0,0,0,0,0,1,0.77);
				}
				// STATION RAID 3 ***  EQ_ENERGY_BOMB DISABLED
				if (success == 22)
				{
					missionVariables.localhero_special = "YES";
					missionVariables.localhero_goal = "11";
					LOCALHERO_GENERATE_RAIDSHIPS(2,0.6,3,0.8,3,0.8,2,0.6,2,0.6);
					LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,0,0,0,0,2,0.8);
				}
				if (success > 15 && success < 22)
				{
					missionVariables.localhero_special = "NO";
					missionVariables.localhero_goal = "12";
					LOCALHERO_GENERATE_NORMALSHIPS(2,0.6,0,0,3,0.7);
					LOCALHERO_GENERATE_NORMALSHIPS(1,0.7,0,0,3,0.9);
					LOCALHERO_GENERATE_SPECIALSHIPS(0,0,0,0,0,0,1,0.77);
				}
				// *** STATION RAID 2 ***  EQ_ENERGY_BOMB DISABLED
				if (success == 15)
				{
					missionVariables.localhero_special = "YES";
					missionVariables.localhero_goal = "9";
					LOCALHERO_GENERATE_RAIDSHIPS(1,0.6,2,0.8,3,0.8,2,0.6,2,0.6);
					LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,0,0,0,0,2,0.8);
				}
				if (success > 10 && success <15)
				{
					missionVariables.localhero_special = "NO";
					missionVariables.localhero_goal = "10";
					LOCALHERO_GENERATE_NORMALSHIPS(1,0.9,0,0,2,0.9);
					LOCALHERO_GENERATE_NORMALSHIPS(1,0.6,0,0,2,0.7);
					LOCALHERO_GENERATE_NORMALSHIPS(0,0,0,0,2,0.6);
					LOCALHERO_GENERATE_SPECIALSHIPS(0,0,0,0,0,0,1,0.77);
				}
				if (success > 8 && success < 11)
				{
					missionVariables.localhero_special = "NO";
					missionVariables.localhero_goal = "9";
					LOCALHERO_GENERATE_NORMALSHIPS(0,0,1,0.9,2,0.9);
					LOCALHERO_GENERATE_NORMALSHIPS(0,0,1,0.6,1,0.6);
					LOCALHERO_GENERATE_NORMALSHIPS(0,0,0,0,2,0.6);
				}
				// ESCORT SHUTTLE MISSION ***  EQ_ENERGY_BOMB DISABLED
				if (success == 8)
				{
					missionVariables.localhero_special = "ESCORT1";
					missionVariables.localhero_goal = "50";
					LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,2,0.6,2,0.6,2,0.6);
					LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,2,0.8,3,0.8,2,0.8);
					LOCALHERO_GENERATE_SPECIALSHIPS(0,0,1,0.9,0,0,0,0);
				}
				if (success > 3 && success < 8)
				{
					missionVariables.localhero_special = "NO";
					missionVariables.localhero_goal = "6";
					LOCALHERO_GENERATE_NORMALSHIPS(0,0,1,0.7,3,0.9);
					LOCALHERO_GENERATE_NORMALSHIPS(0,0,0,0,2,0.7);
				}
				// *** STATION RAID 1 ***  EQ_ENERGY_BOMB DISABLED
				if (success  == 3)
				{
					missionVariables.localhero_special = "YES";
					missionVariables.localhero_goal = "9";
					LOCALHERO_GENERATE_RAIDSHIPS(2,0.6,0,0,3,0.8,2,0.6,2,0.6);
					LOCALHERO_GENERATE_RAIDSHIPS(0,0,0,0,0,0,2,0.8,1,0.8);
				}
				if (success < 3)
				{
					missionVariables.localhero_special = "NO";
					missionVariables.localhero_goal = "3";
					LOCALHERO_GENERATE_NORMALSHIPS(0,0,0,0,3,0.7);
					LOCALHERO_GENERATE_NORMALSHIPS(0,0,0,0,1,0.9);
				}
				LOCALHERO_GENERATE_BONUSSHIPS();
				LOCALHERO_LOGSTATS('BONUSSHIPS2 ADDED');
			}
			LOCALHERO_REMOVEEQUIP("EQ_ENERGY_BOMB",800);
		}
		// IF A MISSION IS LOST OR ABORTED ..._STATUS = "DATE"
		switch (missionVariables.localhero_status)
		{
			// RESET MISSION and RESET FROM DATE
			case "REFUSED":
				LOCALHERO_RESETTING(1,0,2,0,0);
				break;
			// CONTINUE MISSION
			case "NOACTION":
				missionVariables.localhero_status = "RUNNING";
				break;
			// IF PLAYER LAUNCHES WITHOUT CHOICE
			case "RUNAWAY":
				missionVariables.localhero_status = "RUNNING";
				break;
			// LAUNCH WITHOUT FIRST MISSION
			case "FIRST":
				LOCALHERO_RESETALL();
				break;
			default:
				break;
		}
		LOCALHERO_LOGSTATS('LAUNCH ENDED',1);
	}
	//LOCALHERO_GENERATE_SPECIALSHIPS(0,0.96,0,0.96,0,0.96,5,0.96);
	//LOCALHERO_GENERATE_NORMALSHIPS(0,0.96,0,0.96,10,0.96);
	//LOCALHERO_GENERATE_RAIDSHIPS(0,0.96,0,0.96,0,0.96,0,0.96,0,0.96);
}

this.shipExitedWitchspace = function()
{
	if (LOCALHERO_CHECKMAINCOND() == true)
	{
		if (missionVariables.localhero)
		{
			if (!this.localhero_screen) { this.localhero_screen = "LOOP";}
			if (!this.localhero_screenloop) { this.localhero_screenloop = 0; }
			player.commsMessage("Major Hurst: Hope you've enjoyed your holidays. We've cleaned up on our own! Hurst over and out.");
			LOCALHERO_RESETTING(1,0,1,0,0);
			LOCALHERO_LOGSTATS('EXIT  WITCH',1);
		}
	}
}

this.tickle = function()
{
	if (LOCALHERO_CHECKMAINCOND() == true)
	{
		// CHECK FOR MISSION GOALS
		if (player.status == "STATUS_IN_FLIGHT")
		{
			if (missionVariables.localhero)
			{
				// MISSION FAILED Message
				if (missionVariables.localhero_special == "FAILED") { player.commsMessage("CONFED POLICE MISSION "+missionVariables.localhero_success+" FAILED."); }
				// MISSION ACCOMPLISHED Message
				if (missionVariables.localhero_status == "CAPTURED" && parseInt(missionVariables.localhero_goal) <= 0)
				{
					player.call("playSound:", "harkov_comm.ogg");
					player.commsMessage("CONFED POLICE MISSION "+missionVariables.localhero_success+" ACCOMPLISHED.");
					missionVariables.localhero_status = "MESSAGE";
				}
			}
		}
		// NO MISSION AVAILABLE
		if (LOCALHERO_CHECKMAINSTATION() == true)
		{
			if (guiScreen == "GUI_SCREEN_SYSTEM_DATA")
			{
				if (missionVariables.localhero_status == "DATE")
				{
					player.call("playSound:", "harkov_phone.ogg");
					mission.addMessageTextKey("LOCALHERO_NOMISSION");
					this.localhero_screen = "DONE";
					this.timer.stop();
				}
			}
		}
	}
}

this.localheroScriptTimer = function()
{
	if (this.localhero_screen == "DONE") { this.timer.stop(); }
	else if (LOCALHERO_CHECKMAINCOND() == true)
	{
		if (LOCALHERO_CHECKMAINSTATION() == true)
		{
			if (guiScreen == "GUI_SCREEN_SYSTEM_DATA")
			{
				if (!this.localhero_screen) { this.localhero_screen = "LOOP";}
				if (!this.localhero_screenloop) { this.localhero_screenloop = 0; }
				if (player.bounty < 7)
				{
					// FIRST MISSION OFFER
					if (this.localhero_screen == "ONE" && missionVariables.localhero_status == "FIRST")
					{
						if (LOCALHERO_CHECKSCREEN() == true)
						{
							player.call("playSound:", "localhero.ogg");
							if (LOCALHERO_CHECKEQUIP("EQ_FUEL_SCOOPS") == true)
							{
								LOCALHERO_SHOWSCREEN(1,"LOCALHERO_FIRSTOFFER");
								mission.setChoicesKey("LOCALHERO_MISSIONCHOICE");
							}
							else { LOCALHERO_SHOWSCREEN(1,"LOCALHERO_NOEQUIP","LOCALHERO_NOEQUIP_COMEBACK"); LOCALHERO_RESETTING(0,0,0,1,3);}
						}
					}
					// ALL OTHER BRIEFINGS
					if (missionVariables.localhero_harkov == "NO" && missionVariables.localhero_status == "COMPLETE")
					{
						if (LOCALHERO_CHECKSCREEN() == true)
						{
							LOCALHERO_LOGSTATS('BRIEFS START',1);
							player.call("playSound:", "localhero.ogg");
							LOCALHERO_SHOWSCREEN(1);
							if (LOCALHERO_CHECKEQUIP("EQ_FUEL_SCOOPS") == true)
							{
								let success = parseInt(missionVariables.localhero_success);
								if (success < 3) { mission.addMessageTextKey("LOCALHERO_OFFERMISSION");	}
								if (success == 3) {	mission.addMessageTextKey("LOCALHERO_SPECIAL1"); LOCALHERO_BOMBTESTA();	}
								if (success > 3 && success < 8)	{ mission.addMessageTextKey("LOCALHERO_OFFERMISSION"); }
								// MAYBE CHECK FOR WEAPON_MILITARY_LASER in the next release
								// Currently not possible
								if (success == 8) { mission.addMessageTextKey("LOCALHERO_SPECIAL2"); LOCALHERO_BOMBTESTA();	}
								if (success > 8 && success < 11) { mission.addMessageTextKey("LOCALHERO_OFFERMISSION"); }
								if (success == 11)
								{
									if (LOCALHERO_CHECKEQUIP("EQ_ADVANCED_COMPASS") == true) { mission.addMessageTextKey("LOCALHERO_OFFERMISSIONEQUIP"); }
									else { mission.addMessageTextKey("LOCALHERO_OFFERMISSION");	}
								}
								if (success > 11 && success < 15) { mission.addMessageTextKey("LOCALHERO_OFFERMISSION"); }
								if (success == 15) { mission.addMessageTextKey("LOCALHERO_SPECIAL3"); LOCALHERO_BOMBTESTA(); }
								// Maybe Check for SHIELD_BOOSTER or ENERGY_UNIT or NAVAL_SHIELD_BOOSTER in the next release
								if (success > 15 && success < 22) { mission.addMessageTextKey("LOCALHERO_OFFERMISSION"); }
								if (success == 22) { mission.addMessageTextKey("LOCALHERO_SPECIAL4"); LOCALHERO_BOMBTESTA(); }
								// Maybe Check for MILITARY_SCANNER_FILTER in the next release
								if (success > 22 && success < 30) { mission.addMessageTextKey("LOCALHERO_OFFERMISSION"); }
								if (success == 30) { mission.addMessageTextKey("LOCALHERO_SPECIAL5"); LOCALHERO_BOMBTESTA(); }
								mission.setChoicesKey("LOCALHERO_MISSIONCHOICE");
							}
							else
							{
								missionVariables.localhero_status = "REFUSED";
								mission.addMessageTextKey("LOCALHERO_NOEQUIP");
								mission.addMessageTextKey("LOCALHERO_NOEQUIP_COMEBACK");
								LOCALHERO_RESETTING(0,0,0,1,3);
							}
							LOCALHERO_LOGSTATS('BRIEFS ENDED',1);
						}
					}
				}
			}
			// LOOP AND NOTIFICATION
			if (guiScreen != "GUI_SCREEN_MISSION")
			{
				if (this.localhero_screenloop < this.localhero_loopfactor) { this.localhero_screenloop++; }
				if (this.localhero_screenloop >= this.localhero_loopfactor)
				{
					LOCALHERO_RESETTING(0,0,0,3,0);
					LOCALHERO_LOGSTATS('RESTART HANDLING3',this.localhero_screenloop);
					this.localhero_screenloop++;
					if (this.localhero_screenloop == Math.ceil(10/(this.localhero_loopfactor)) || this.localhero_screenloop == Math.ceil(20/(this.localhero_loopfactor)))
					{
						player.call("playSound:", "harkov_suppress.ogg");
						if (missionVariables.localhero) { player.commsMessage("CONFED POLICE MISSION "+missionVariables.localhero_success+" RESTARTED."); }
						else { player.commsMessage("Incoming call. Check you System Data Screen."); }
					}
					this.shipDockedWithStation();
				}
			}
		}
	}
}
