"use strict";
this.name = "Goods Container 20 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "2.0";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	// keep tally of pylon accessories bought
	this.$gc2Count++;
    // and don't let them exceed ship's pylon-capacity
	if ((equipment == "EQ_GC2_MINE") && (this.$gc2Count<=this.$gc2MCap)) {
		player.ship.cargoSpaceCapacity += 20;
		this.$gc2Containers++;
		pc("Modifying pylon hardpoints for container clamping...",9);
		pc("Fitting 20 TC Class Container #"+this.$gc2Containers+"...",9);
		pc("F4 'Your FE Shipyards' to check your Licence.",9);
	} else
	// unmount & sell cancels all container additions
	if (equipment == "EQ_MISSILE_REMOVAL") {
		player.ship.cargoSpaceCapacity -= this.$gc2Containers*20;
		pc("Removing all 20 TC Class Containers...",9)
		pc("Restoring pylon hardpoints for weapons-use...",9);
		if ((this.$gc2Containers>0) && (!this.$gc2HFExempt)) {
			// dismantling fee
			var dft = this.$gc2Containers*this.$gc2DismantlingFee;
			this.$gc2DismantlingFeeTotal += dft;
			player.credits -= dft;
			pc("Dismantling Fee: "+dft+" cr",9);
		}
		this.$gc2Count = 0;
		this.$gc2Containers = 0;
		// reset system-to-system runs w/containers
		this.$gc2Runs = 0;
		// reset fee totals
		this.$gc2HandlingFeeTotal = 0;
		this.$gc2MaintenanceFeeTotal = 0;
	}
}


this.playerBoughtNewShip = function(ship, price) {
	// missile capacity (not exceed)
	this.$gc2MCap = player.ship.missileCapacity;
	this.$gc2Count = 0;
	this.$gc2Containers = 0;
}


this.equipmentRemoved = function(equipmentKey) {
    if (equipmentKey == "EQ_GC2_MINE") {
		player.ship.cargoSpaceCapacity -= 20;
		this.$gc2Containers--;	
		player.consoleMessage("20 TC Goods Container removed.",5);
	}
}


this.shipReleasedEquipment = function(mine) {
	this.$gc2Count--;
    if (mine == "EQ_GC2_MINE") {
		player.ship.cargoSpaceCapacity -= 20;
		this.$gc2Containers--;
		player.commsMessage("20 TC Goods Container jettisoned.",5);
		// deduct container cost from credits
		player.credits -= 20000.0;
		player.commsMessage("Mishandling charge applied at cost.",9);
	}
}


this.shipFiredMissile = function(missile, target) {
	this.$gc2Count--;
    if (missile == "EQ_GC2_MINE") {
		player.ship.cargoSpaceCapacity -= 20;
		this.$gc2Containers--;	
		player.commsMessage("20 TC Goods Container jettisoned.",5);
		// deduct container cost from credits
		player.credits -= 20000.0;
		player.commsMessage("Mishandling charge applied at cost.",9);
	}
}


this.startUpComplete = function () {
	var pc = player.consoleMessage;
	// missile capacity (not exceed)
	this.$gc2MCap = player.ship.missileCapacity;
	this.$gc2Count = player.ship.missiles.length;
	// Load cargo space, missile & container counts if present
	if (missionVariables.gc2Cargo != null) 
		player.ship.cargoSpaceCapacity = missionVariables.gc2Cargo;
	if (missionVariables.gc2Count != null)
		this.$gc2Count = missionVariables.gc2Count;
	if (missionVariables.gc2Containers != null) 
		this.$gc2Containers = missionVariables.gc2Containers;
	// Load total fees taken
	if (missionVariables.gc2HandlingFeeTotal != null)
		this.$gc2HandlingFeeTotal = missionVariables.gc2HandlingFeeTotal;
	if (missionVariables.gc2HandlingPaid != null)
		this.$gc2HandlingPaid = missionVariables.gc2HandlingPaid;
	if (missionVariables.gc2MaintenanceFeeTotal != null)
		this.$gc2MaintenanceFeeTotal = missionVariables.gc2MaintenanceFeeTotal;
	if (missionVariables.gc2DismantlingFeeTotal != null)
		this.$gc2DismantlingFeeTotal = missionVariables.gc2DismantlingFeeTotal; 
    // Load system-to-system runs w/container
	if (missionVariables.gc2Runs != null)
		this.$gc2Runs = missionVariables.gc2Runs;
	// Load Handling fee count
	if (missionVariables.gc2HandlingCount != null)
		this.$gc2HandlingCount = missionVariables.gc2HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.gc2HFExempt != null)
		this.$gc2HFExempt = missionVariables.gc2HFExempt;
	// Load Maintenance fee count
	if (missionVariables.gc2MaintenanceCount != null)
		this.$gc2MaintenanceCount = missionVariables.gc2MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// TEST
	var sta = player.ship.dockedStation;
	if ((this.$gc2Containers<this.$gc2MCap) && (system.techLevel>=6))
		pc("Containers available in the Shipyard.");
	// prepare container Account screen
	this._gc2PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$gc2Containers>0) this._gc2PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$gc2ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$gc2ET = true;
	// TEST	
	if (this.$gc2ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$gc2FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$gc2FES = true;
	// TEST	
	if (this.$gc2ET) log(this.name, "Finds FE Ships Player present");
	// missile capacity (not exceed)
	this.$gc2MCap = 0;
	// pylon-use count
	this.$gc2Count = 0;
	// container count
	this.$gc2Containers = 0;
	// purchase cost of container in cr
	this.$gc2Cost = 20000;
	// handling fee
	this.$gc2HandlingFee = 0.005*this.$gc2Cost; // 0.005 of cost
	this.$gc2HandlingFeeTotal = 0;
	this.$gc2HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$gc2HandlingCount = 0;
	this.$gc2HFExempt = "no";
	// maintenance fee
	this.$gc2MaintenanceFee = 0.05*this.$gc2Cost; // 0.05 of cost
	this.$gc2MaintenanceFeeTotal = 0;
	this.$gc2MaintenancePaid = "no" // or "yes"
	this.$gc2MaintenanceInterval = 20; // in runs (according to cost)
	this.$gc2MaintenanceCount = 0;
	// dismantling fee
	this.$gc2DismantlingFee = 0.1*this.$gc2Cost; // 0.1 of cost
	this.$gc2DismantlingFeeTotal = 0.0;
	// system-to-system runs w/container
	this.$gc2Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.gc2Count = this.$gc2Count;
	missionVariables.gc2Cargo = player.ship.cargoSpaceCapacity;
	missionVariables.gc2Containers = this.$gc2Containers;
	// save total fees taken
	missionVariables.gc2HandlingFeeTotal = this.$gc2HandlingFeeTotal;
	missionVariables.gc2MaintenanceFeeTotal = this.$gc2MaintenanceFeeTotal;
	missionVariables.gc2DismantlingFeeTotal = this.$gc2DismantlingFeeTotal;
	missionVariables.gc2HandlingPaid = this.$gc2HandlingPaid;
	// system-to-system runs w/container
	missionVariables.gc2Runs =this.$gc2Runs;
	// handling fee count
	missionVariables.gc2HandlingCount = this.$gc2HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.gc2HFExempt = this.$gc2HFExempt;
	// maintenance fee count
	missionVariables.gc2MaintenanceCount = this.$gc2MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$gc2HFExempt;
	// check we have containers, the fee is not paid, and we're not exempt
	if ((this.$gc2Containers>0) && (this.$gc2HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$gc2Containers; x++)
			fee += this.$gc2HandlingFee;
		// record fee and debit trader's account
		this.$gc2HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$gc2HandlingPaid = "yes";
		pc("20 TC Container handling fees: "+fee+" cr",9);
		this.$gc2HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$gc2Containers>0) this._gc2DoMaintenance();

	// TEST
	if ((this.$gc2Containers<this.$gc2MCap) && (system.techLevel>=6))
		pc("Containers available in the Shipyard.");
	
	// prepare container Account and Licence page
	this._gc2PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$gc2Containers>0) this._gc2PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$gc2HandlingPaid = "no";
	this.$gc2Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._gc2DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$gc2Runs;
	var intv = this.$gc2MaintenanceInterval;
	var mfee = this.$gc2MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x containers
		var fee = 0;
		for (var x=1; x<= this.$gc2Containers; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$gc2MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("20 TC Container Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$gc2MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._gc2PrepAcc = function(station) {
	station.setInterface("gc2Acc",{
	title: "Your FE Shipyards 20 TC Container Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 20 TC Goods Container account screen shows terms, fees paid, load, and other useful information.",
	callback: this._gc2ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._gc2ShowAcc = function() {
	var hfc = this.$gc2HandlingCount;
	var mfc = this.$gc2MaintenanceCount;
	var mfi = this.$gc2MaintenanceInterval;
	var hft = this.$gc2HandlingFeeTotal;
	var mft = this.$gc2MaintenanceFeeTotal;
	var dft = this.$gc2DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$gc2Containers>0) 
		parameters.message +="Your Account and Licence for 20 TC Class Goods Containers x "+this.$gc2Containers+": \n\n"; 
	 else
		parameters.message +="You have no 20 TC Class Containers licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our containers are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Container account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylons for weapons-use. \n";
	
	parameters.choicesKey = "gc2Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._gc2PrepEx = function(station) {
	station.setInterface("gc2Ex",{
	title: "Your FE Shipyards Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 20-ton container class." ,
	callback: this._gc2ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._gc2ShowEx = function() {
	var priv = ((this.$gc2ET)||(this.$gc2FES));
	var privo = "";
	if (this.$gc2FES) privo="FE shipowner";
	if (this.$gc2ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 20 TC container fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "gc2YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$gc2HFExempt = "yes"; else this.$gc2HFExempt = "no";
		} else this.$gc2HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}



