this.name        = "rockHermit_Locator"; 
this.author      = "eric walch"; 
this.copyright   = "� 2008 the Oolite team."; 
this.description = "This script places buoys at rockHermites and Pirate Coves.  It is a translation of the legacy code of Frame"; 
this.version     = "1.3.1"; 

this.startUp = function()
{
    this.reset()
}

this.reset = function()
{
    this.buoysAdded = false
}

this.shipExitedWitchspace = function()
{
    this.buoyTimer = new Timer(this, this.addBuoys, 1)
}

this.equipmentDamaged = this.equipmentDestroyed  = function(equipment)
{
    if(equipment == "EQ_ROCKHERMIT_SCANNER")
    {
        this.swichOffBuoys()
    }
}

this.addBuoys = function()
{
    if(player.ship.hasEquipment("EQ_ROCKHERMIT_SCANNER")) this.buoy = "rockbeacon"; else this.buoy = "rockbeacof"
    var rockHermits = system.shipsWithPrimaryRole("rockhermit");
    var pirateCoves = system.shipsWithPrimaryRole("pirate-cove");
    {
        for (var i=0; i<rockHermits.length;i++)
        {
            if(rockHermits[i].name == "Rock Hermit")
            system.legacy_addShipsAtPrecisely(this.buoy, 1, "abs", rockHermits[i].position.add(rockHermits[i].heading.multiply(10E3)))
        }
        for (var i=0; i<pirateCoves.length;i++)
        {
            if(pirateCoves[i].name == "Rock Hermit")
            system.legacy_addShipsAtPrecisely(this.buoy, 1, "abs", pirateCoves[i].position.add(pirateCoves[i].heading.multiply(10E3)))
        }
    }
    this.buoysAdded = true
}

this.swichOnBuoys = function()
{
    var buoys = system.shipsWithPrimaryRole("rockbeacof");
    var newBuoy = false;
    this.buoy = "rockbeacon"
    if(buoys.length>0) for (var i=0; i<buoys.length;i++)
        {
            newBuoy = buoys[i].spawnOne(this.buoy)
			if (0 < oolite.compareVersion("1.73"))
			{
				newBuoy.setPosition(buoys[i].position)
				newBuoy.setOrientation(buoys[i].orientation)
			}
			else
			{
				newBuoy.position = buoys[i].position
				newBuoy.orientation = buoys[i].orientation
			}
            buoys[i].remove()
        }
}

this.swichOffBuoys = function()
{
    var buoys = system.shipsWithPrimaryRole("rockbeacon");
    var newBuoy = false;
    this.buoy = "rockbeacof"
    if(buoys.length>0) for (var i=0; i<buoys.length;i++)
        {
            newBuoy = buoys[i].spawnOne(this.buoy)
			if (0 < oolite.compareVersion("1.73"))
			{
				newBuoy.setPosition(buoys[i].position)
				newBuoy.setOrientation(buoys[i].orientation)
			}
			else
			{
				newBuoy.position = buoys[i].position
				newBuoy.orientation = buoys[i].orientation
			}
            buoys[i].remove()
        }
}

this.shipLaunchedFromStation = function()
{
    if(this.buoysAdded && this.buoy == "rockbeacof" && player.ship.hasEquipment("EQ_ROCKHERMIT_SCANNER")) this.swichOnBuoys()
    if(!this.buoysAdded) this.addBuoys()
}