// *

this.name           = "oolite_oxp_QVE-Generator";
this.description    = "script for the QVE-Generator";
this.author         = "mattes";
this.copyright      = "© 2022 Slartibartfast";
this.license				= "?????";
this.version        = "0.0.3";

// #####  constants
this.qvegAddSpaceCap = 1;  //!! integer
this.qvegEnergyFactor = 0.3;
this.qveBaseSytemUnitFactor = 0.1; // the qveg-base-system itself produces 10% energy of one qveg-energy-module.
this.qvegShipRcRefund = 200;
this.qvegUnitRefund = 300;
this.qvegBoosterRefund = 30000;
this.qvegSytemRiscBonus = 1;  //!! integer  --  bonus qve-energy module
this.qvegNormalAmplifyFactor = 1.0;
this.qvegExtraAmplifyFactor = 1.8;
this.qvegNavalAmplifyFactor = 2.6;
this.qvegQvegAmplifyFactor = 3.0;

// #######  functions   #########

//  ###  createCargoStrings -- reads actual cargo from ship-manifest and returns useable output data   ###
// if choice is "NAME" it returns the commodity names, if "NUMBER" the quantity of each, if "SORT" the quantity of sorts
// the "parts" in the strings(NAME/NUMBER) are separated by ":" ---  for easy splitting later
this.createCargoStrings = function(choice)
{
	var manifestItem, itemNameString = "", itemName, itemNumberString = "", itemNumber, returnString = "", itemSortNumber, itemRemoveNumberString = "";

	itemSortNumber = manifest.list.length;
	for (let i = 0; i < itemSortNumber; i++)
	{
		manifestItem = manifest.list[i];
	  itemName = manifestItem.commodity;
  	itemNameString = itemNameString + itemName + ":";
  	itemNumber = manifestItem.quantity;
  	itemNumberString = itemNumberString + itemNumber + ":";
	}

	switch (choice)
	{
		case	"NAME":		returnString = itemNameString;		break;
		case	"NUMBER":	returnString = itemNumberString;	break;
		case	"SORT":		returnString = itemSortNumber;		break;
	}

return returnString;
};

// ###  check installed Energy-Unit (naval,extra,none) and sets the amplifying factor
this.check_e_unit = function()
{
	var rc_multi = this.qvegNormalAmplifyFactor;   //  set default for no special unit

	if (player.ship.equipmentStatus("EQ_ENERGY_UNIT")				=== "EQUIPMENT_OK") { rc_multi = this.qvegExtraAmplifyFactor };
	if (player.ship.equipmentStatus("EQ_NAVAL_ENERGY_UNIT")	=== "EQUIPMENT_OK") { rc_multi = this.qvegNavalAmplifyFactor };
	if (player.ship.equipmentStatus("EQ_NAVAL_ENERGY_UNIT")	=== "EQUIPMENT_OK")
		{if (player.ship.equipmentStatus("EQ_QVEG_BOOSTER")		=== "EQUIPMENT_OK") { rc_multi = this.qvegQvegAmplifyFactor }; };

	return rc_multi;
};

// ### event EQ management ###
// sets player and shipdata according new installed equipment and handles buy/sell
this.playerBoughtEquipment = function(equipmentKey, paid)
{
	if (equipmentKey == "EQ_QVED_BASE_SYSTEM")
	{
		var rc_multiplier = this.check_e_unit();
		var ship_rc_rate = player.ship.energyRechargeRate;
		var max_number_of_qveg = Math.round( ship_rc_rate / rc_multiplier / this.qvegEnergyFactor + this.qvegSytemRiscBonus);
		var cargoSpaceForModules = 0; // new variable here
		for (let i = 0; i < max_number_of_qveg; i++)
		{
			player.ship.awardEquipment("EQ_QVEGRACKSPACE");
			cargoSpaceForModules += this.qvegAddSpaceCap; // sum up how much space to give
			player.credits += this.qvegShipRcRefund;
		}
		this.qveCargoSpaceForModules = cargoSpaceForModules;
		player.ship.cargoSpaceCapacity += cargoSpaceForModules;
	};

	if (equipmentKey == "EQ_QVEG")
	{
		player.ship.removeEquipment("EQ_QVEGRACKSPACE");
	};

	if (equipmentKey == "EQ_QVEG_BOOSTER")
	{
		player.ship.removeEquipment("EQ_QVEGRACKSPACE");
	};

	if (equipmentKey == "EQ_QVEG_REM")
	{
		player.ship.removeEquipment("EQ_QVEG");
		player.ship.removeEquipment("EQ_QVEG_REM");
		player.ship.awardEquipment("EQ_QVEGRACKSPACE");
		player.credits += this.qvegUnitRefund;
	};

	if (equipmentKey == "EQ_QVEG_BOOSTER_REM")
	{
		player.ship.removeEquipment("EQ_QVEG_BOOSTER");
		player.ship.removeEquipment("EQ_QVEG_BOOSTER_REM");
		player.ship.awardEquipment("EQ_QVEGRACKSPACE");
		player.credits += this.qvegBoosterRefund;
	};
};


// #########  generator funktions    ########

// ### event: launch from station   ###
this.shipLaunchedFromStation = function(station)
{
	if (player.ship.equipmentStatus("EQ_QVED_BASE_SYSTEM")	=== "EQUIPMENT_OK")
	{
		var data = player.ship.equipmentStatus("EQ_QVEG", true);
		var eqnumber_io = ( data["EQUIPMENT_OK"] );

	// sets eq_multiplier_factor (base + units)
		var rc_multiplier = this.check_e_unit();
		log(this.name, "The boost-factor of the (qveg/naval/extra)-enery-units is: " + rc_multiplier);
		var eqnumberfactor = ( eqnumber_io + this.qveBaseSytemUnitFactor ); // adds the qve-base-system to the units

	// ###  set the qve-system recharge rate
		this.qveEnergyShipRateTmp = Math.round(100 * eqnumberfactor * this.qvegEnergyFactor * rc_multiplier);  // neu
		this.qveEnergyShipRate = (this.qveEnergyShipRateTmp / 100);
		player.ship.energyRechargeRate = this.qveEnergyShipRate;  // neu
		log(this.name, " Ships energy-recharge-rate is now: " + this.qveEnergyShipRate );
		player.consoleMessage(" Ships energy-recharge-rate is now: " + this.qveEnergyShipRate,8);
	};
};


// ### event new ship
// removes additional cargo-space
this.playerBoughtNewShip = function(ship, price)
{
	this.qveCargoSpaceForModules = 0;
	log(this.name, " ## have new ship: " + ship );
};


// ###  event startup
// sets cargospace as defined in savegame
this.startUp = function()
{
	this.qveCargoSpaceForModules = missionVariables.qve_generator_additionalSpace || 0; // if there is no saved value, then 0
	player.ship.cargoSpaceCapacity += this.qveCargoSpaceForModules; // increase, so it will work with capacity changes made from other sources
};


// ### event startup complete ###
// restores cargo as defined in savegame
this.startUpComplete = function()
{
	if (!missionVariables.qve_generator_CargoSorts || missionVariables.qve_generator_CargoSorts == "EMPTY")
	{ // if this is the first run of the OXP, or if there is nothing in storage from the last save game we don't need to restore anything
		log(this.name, " missionVariable <qvegCargoSorts> is empty");
		missionVariables.qve_generator_CargoSorts = "EMPTY";
		missionVariables.qve_generator_CargoNumbers = "EMPTY";
		missionVariables.qve_generator_CargoNames = "EMPTY";
	}
	else
	{
		this.cargoNumberArray = missionVariables.qve_generator_CargoNumbers.split(":");
		this.cargoNameArray   = missionVariables.qve_generator_CargoNames.split(":");
		this.cargoSortNumber	= missionVariables.qve_generator_CargoSorts;

  	var allItemsNumber = 0;
		for(let i = 0; i < this.cargoSortNumber; i++)
		{
			this.cargoNumberArray[i] *= 1;  // to swap value from string to number
			this.cargoItem = this.cargoNameArray[i];
			this.cargoNumber =	this.cargoNumberArray[i];   ////!!!
			player.ship.manifest[this.cargoItem] = this.cargoNumber;   ////!!!
			allItemsNumber += this.cargoNumber;
		}
		log(this.name, " Number of Cargo restored from Savegame: " + allItemsNumber + " t/kg/g");
	}
};


// ### event savegame   ###
// saves cargospace and cargo to savegame
this.playerWillSaveGame = function(message)
{
	missionVariables.qve_generator_additionalSpace = this.qveCargoSpaceForModules;
	missionVariables.qve_generator_CargoNumbers = "EMPTY";
	missionVariables.qve_generator_CargoNames = "EMPTY";
	missionVariables.qve_generator_CargoSorts = "EMPTY";

	if (player.ship.equipmentStatus("EQ_QVED_BASE_SYSTEM")	=== "EQUIPMENT_OK")
	{
		var handover = "NUMBER";
		var cargonumbers = this.createCargoStrings(handover);
		missionVariables.qve_generator_CargoNumbers = cargonumbers;

		var handover = "NAME";
		var cargonames = this.createCargoStrings(handover);
		missionVariables.qve_generator_CargoNames = cargonames;

		var handover = "SORT";
		var cargosorts = this.createCargoStrings(handover);
		missionVariables.qve_generator_CargoSorts = cargosorts;

		log(this.name, " missionvariables.qveg for cargo stored in savegame.");

/*   does not work as i want / if exit the game - o.k.  / else the cargo is gone !! i must restore on leaving F4  -but not to "exit"
// ----remove all Cargo from Ship before saving---- should help a little for passengers
		var freight, malile;
		const item_name_array = [];

		malile = manifest.list.length;
		for (let i = 0; i < malile; i++)
		{
			item_name_array[i] = manifest.list[i].commodity;
		};
		for (let j = 0; j < malile; j++)
		{
			freight = item_name_array[j];
			manifest[freight] = 0;
		};
		log(this.name, " Cargo removed from ships storage");
*/
	};
};
