"use strict";
this.name = "Cargo Pod 30 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "1.0";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_30TC_POD") {		
		pc("Attaching one 30 TC Pod to auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity += 30;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
		// always 1 because only one pod can be fitted
		this.$cp3Pods=1;
	}	
}


this.equipmentRemoved = function(equipmentKey) {
    var pc=player.consoleMessage;
	if (equipmentKey == "EQ_30TC_POD") {
		pc("Detaching one 30 TC Pod from auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity -= 30;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
	}
}



this.startUpComplete = function () {
	var pc = player.consoleMessage;
	if (missionVariables.cp3Pods != null) 
		this.$cp3Pods = missionVariables.cp3Pods;
	// Load total fees taken
	if (missionVariables.cp3HandlingFeeTotal != null)
		this.$cp3HandlingFeeTotal = missionVariables.cp3HandlingFeeTotal;
	if (missionVariables.cp3HandlingPaid != null)
		this.$cp3HandlingPaid = missionVariables.cp3HandlingPaid;
	if (missionVariables.cp3MaintenanceFeeTotal != null)
		this.$cp3MaintenanceFeeTotal = missionVariables.cp3MaintenanceFeeTotal;
	if (missionVariables.cp3DismantlingFeeTotal != null)
		this.$cp3DismantlingFeeTotal = missionVariables.cp3DismantlingFeeTotal; 
    // Load system-to-system runs w/pod
	if (missionVariables.cp3Runs != null)
		this.$cp3Runs = missionVariables.cp3Runs;
	// Load Handling fee count
	if (missionVariables.cp3HandlingCount != null)
		this.$cp3HandlingCount = missionVariables.cp3HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.cp3HFExempt != null)
		this.$cp3HFExempt = missionVariables.cp3HFExempt;
	// Load Maintenance fee count
	if (missionVariables.cp3MaintenanceCount != null)
		this.$cp3MaintenanceCount = missionVariables.cp3MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// prepare pod Account screen
	var sta = player.ship.dockedStation;
	this._cp3PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$cp3Pods>0) this._cp3PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$cp3ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$cp3ET = true;
	// TEST	
	if (this.$cp3ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$cp3FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$cp3FES = true;
	// TEST	
	if (this.$cp3ET) log(this.name, "Finds FE Ships Player present");
	// number of pods - when fitted, always 1
	this.$cp3Pods = 0;
	// purchase cost of pod in cr
	this.$cp3Cost = 30000;
	// handling fee
	this.$cp3HandlingFee = 0.005*this.$cp3Cost; // 0.005 of cost
	this.$cp3HandlingFeeTotal = 0;
	this.$cp3HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$cp3HandlingCount = 0;
	this.$cp3HFExempt = "no";
	// maintenance fee
	this.$cp3MaintenanceFee = 0.05*this.$cp3Cost; // 0.05 of cost
	this.$cp3MaintenanceFeeTotal = 0;
	this.$cp3MaintenancePaid = "no" // or "yes"
	this.$cp3MaintenanceInterval = 30; // in runs (according to cost)
	this.$cp3MaintenanceCount = 0;
	// dismantling fee
	this.$cp3DismantlingFee = 0.1*this.$cp3Cost; // 0.1 of cost
	this.$cp3DismantlingFeeTotal = 0.0;
	// system-to-system runs w/pod
	this.$cp3Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.cp3Pods = this.$cp3Pods;
	// save total fees taken
	missionVariables.cp3HandlingFeeTotal = this.$cp3HandlingFeeTotal;
	missionVariables.cp3MaintenanceFeeTotal = this.$cp3MaintenanceFeeTotal;
	missionVariables.cp3DismantlingFeeTotal = this.$cp3DismantlingFeeTotal;
	missionVariables.cp3HandlingPaid = this.$cp3HandlingPaid;
	// system-to-system runs w/pod
	missionVariables.cp3Runs =this.$cp3Runs;
	// handling fee count
	missionVariables.cp3HandlingCount = this.$cp3HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.cp3HFExempt = this.$cp3HFExempt;
	// maintenance fee count
	missionVariables.cp3MaintenanceCount = this.$cp3MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$cp3HFExempt;
	// check we have pods, the fee is not paid, and we're not exempt
	if ((this.$cp3Pods>0) && (this.$cp3HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$cp3Pods; x++)
			fee += this.$cp3HandlingFee;
		// record fee and debit trader's account
		this.$cp3HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$cp3HandlingPaid = "yes";
		pc("30 TC Pod handling fees: "+fee+" cr",9);
		this.$cp3HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$cp3Pods>0) this._cp3DoMaintenance();
	
	// prepare pod Account and Licence page
	this._cp3PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$cp3Pods>0) this._cp3PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$cp3HandlingPaid = "no";
	this.$cp3Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._cp3DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$cp3Runs;
	var intv = this.$cp3MaintenanceInterval;
	var mfee = this.$cp3MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x pods
		var fee = 0;
		for (var x=1; x<= this.$cp3Pods; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$cp3MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("30 TC Pod Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$cp3MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._cp3PrepAcc = function(station) {
	station.setInterface("cp3Acc",{
	title: "Your FE Shipyards 30 TC Pod Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 30 TC Pod account screen shows terms, fees paid, load, and other useful information.",
	callback: this._cp3ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._cp3ShowAcc = function() {
	var hfc = this.$cp3HandlingCount;
	var mfc = this.$cp3MaintenanceCount;
	var mfi = this.$cp3MaintenanceInterval;
	var hft = this.$cp3HandlingFeeTotal;
	var mft = this.$cp3MaintenanceFeeTotal;
	var dft = this.$cp3DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$cp3Pods>0) 
		parameters.message +="Your Account and Licence for 30 TC Class Goods Pods x "+this.$cp3Pods+": \n\n"; 
	 else
		parameters.message +="You have no 30 TC Class Pods licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our pods are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Pod account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylon for weapons-use. \n";
	
	parameters.choicesKey = "cp3Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._cp3PrepEx = function(station) {
	station.setInterface("cp3Ex",{
	title: "Your FE Shipyards Pod Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 30-ton pod class." ,
	callback: this._cp3ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._cp3ShowEx = function() {
	var priv = ((this.$cp3ET)||(this.$cp3FES));
	var privo = "";
	if (this.$cp3FES) privo="FE shipowner";
	if (this.$cp3ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 30 TC pod fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "cp3YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$cp3HFExempt = "yes"; else this.$cp3HFExempt = "no";
		} else this.$cp3HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}
