"use strict";
this.name = "Cargo Pod 20 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "1.0";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_20TC_POD") {		
		pc("Attaching one 20 TC Pod to auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity += 20;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
		// always 1 because only one pod can be fitted
		this.$cp2Pods=1;
	}	
}


this.equipmentRemoved = function(equipmentKey) {
    var pc=player.consoleMessage;
	if (equipmentKey == "EQ_20TC_POD") {
		pc("Detaching one 20 TC Pod from auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity -= 20;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
	}
}



this.startUpComplete = function () {
	var pc = player.consoleMessage;
	if (missionVariables.cp2Pods != null) 
		this.$cp2Pods = missionVariables.cp2Pods;
	// Load total fees taken
	if (missionVariables.cp2HandlingFeeTotal != null)
		this.$cp2HandlingFeeTotal = missionVariables.cp2HandlingFeeTotal;
	if (missionVariables.cp2HandlingPaid != null)
		this.$cp2HandlingPaid = missionVariables.cp2HandlingPaid;
	if (missionVariables.cp2MaintenanceFeeTotal != null)
		this.$cp2MaintenanceFeeTotal = missionVariables.cp2MaintenanceFeeTotal;
	if (missionVariables.cp2DismantlingFeeTotal != null)
		this.$cp2DismantlingFeeTotal = missionVariables.cp2DismantlingFeeTotal; 
    // Load system-to-system runs w/pod
	if (missionVariables.cp2Runs != null)
		this.$cp2Runs = missionVariables.cp2Runs;
	// Load Handling fee count
	if (missionVariables.cp2HandlingCount != null)
		this.$cp2HandlingCount = missionVariables.cp2HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.cp2HFExempt != null)
		this.$cp2HFExempt = missionVariables.cp2HFExempt;
	// Load Maintenance fee count
	if (missionVariables.cp2MaintenanceCount != null)
		this.$cp2MaintenanceCount = missionVariables.cp2MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// prepare pod Account screen
	var sta = player.ship.dockedStation;
	this._cp2PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$cp2Pods>0) this._cp2PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$cp2ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$cp2ET = true;
	// TEST	
	if (this.$cp2ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$cp2FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$cp2FES = true;
	// TEST	
	if (this.$cp2ET) log(this.name, "Finds FE Ships Player present");
	// number of pods - when fitted, always 1
	this.$cp2Pods = 0;
	// purchase cost of pod in cr
	this.$cp2Cost = 20000;
	// handling fee
	this.$cp2HandlingFee = 0.005*this.$cp2Cost; // 0.005 of cost
	this.$cp2HandlingFeeTotal = 0;
	this.$cp2HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$cp2HandlingCount = 0;
	this.$cp2HFExempt = "no";
	// maintenance fee
	this.$cp2MaintenanceFee = 0.05*this.$cp2Cost; // 0.05 of cost
	this.$cp2MaintenanceFeeTotal = 0;
	this.$cp2MaintenancePaid = "no" // or "yes"
	this.$cp2MaintenanceInterval = 20; // in runs (according to cost)
	this.$cp2MaintenanceCount = 0;
	// dismantling fee
	this.$cp2DismantlingFee = 0.1*this.$cp2Cost; // 0.1 of cost
	this.$cp2DismantlingFeeTotal = 0.0;
	// system-to-system runs w/pod
	this.$cp2Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.cp2Pods = this.$cp2Pods;
	// save total fees taken
	missionVariables.cp2HandlingFeeTotal = this.$cp2HandlingFeeTotal;
	missionVariables.cp2MaintenanceFeeTotal = this.$cp2MaintenanceFeeTotal;
	missionVariables.cp2DismantlingFeeTotal = this.$cp2DismantlingFeeTotal;
	missionVariables.cp2HandlingPaid = this.$cp2HandlingPaid;
	// system-to-system runs w/pod
	missionVariables.cp2Runs =this.$cp2Runs;
	// handling fee count
	missionVariables.cp2HandlingCount = this.$cp2HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.cp2HFExempt = this.$cp2HFExempt;
	// maintenance fee count
	missionVariables.cp2MaintenanceCount = this.$cp2MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$cp2HFExempt;
	// check we have pods, the fee is not paid, and we're not exempt
	if ((this.$cp2Pods>0) && (this.$cp2HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$cp2Pods; x++)
			fee += this.$cp2HandlingFee;
		// record fee and debit trader's account
		this.$cp2HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$cp2HandlingPaid = "yes";
		pc("20 TC Pod handling fees: "+fee+" cr",9);
		this.$cp2HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$cp2Pods>0) this._cp2DoMaintenance();
	
	// prepare pod Account and Licence page
	this._cp2PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$cp2Pods>0) this._cp2PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$cp2HandlingPaid = "no";
	this.$cp2Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._cp2DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$cp2Runs;
	var intv = this.$cp2MaintenanceInterval;
	var mfee = this.$cp2MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x pods
		var fee = 0;
		for (var x=1; x<= this.$cp2Pods; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$cp2MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("20 TC Pod Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$cp2MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._cp2PrepAcc = function(station) {
	station.setInterface("cp2Acc",{
	title: "Your FE Shipyards 20 TC Pod Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 20 TC Pod account screen shows terms, fees paid, load, and other useful information.",
	callback: this._cp2ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._cp2ShowAcc = function() {
	var hfc = this.$cp2HandlingCount;
	var mfc = this.$cp2MaintenanceCount;
	var mfi = this.$cp2MaintenanceInterval;
	var hft = this.$cp2HandlingFeeTotal;
	var mft = this.$cp2MaintenanceFeeTotal;
	var dft = this.$cp2DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$cp2Pods>0) 
		parameters.message +="Your Account and Licence for 20 TC Class Goods Pods x "+this.$cp2Pods+": \n\n"; 
	 else
		parameters.message +="You have no 20 TC Class Pods licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our pods are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Pod account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylon for weapons-use. \n";
	
	parameters.choicesKey = "cp2Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._cp2PrepEx = function(station) {
	station.setInterface("cp2Ex",{
	title: "Your FE Shipyards Pod Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 20-ton pod class." ,
	callback: this._cp2ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._cp2ShowEx = function() {
	var priv = ((this.$cp2ET)||(this.$cp2FES));
	var privo = "";
	if (this.$cp2FES) privo="FE shipowner";
	if (this.$cp2ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 20 TC pod fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "cp2YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$cp2HFExempt = "yes"; else this.$cp2HFExempt = "no";
		} else this.$cp2HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}
