"use strict";
this.name = "Cargo Pod 10 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "1.0";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_10TC_POD") {		
		pc("Attaching one 10 TC Pod to auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity += 10;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
		// always 1 because only one pod can be fitted
		this.$cp1Pods=1;
	}	
}


this.equipmentRemoved = function(equipmentKey) {
    var pc=player.consoleMessage;
	if (equipmentKey == "EQ_10TC_POD") {
		pc("Detaching one 10 TC Pod from auxiliary pylon.",9);
		player.ship.cargoSpaceCapacity -= 10;
		pc("Ship's total capacity = "+player.ship.cargoSpaceCapacity+" TC.",9);
	}
}



this.startUpComplete = function () {
	var pc = player.consoleMessage;
	if (missionVariables.cp1Pods != null) 
		this.$cp1Pods = missionVariables.cp1Pods;
	// Load total fees taken
	if (missionVariables.cp1HandlingFeeTotal != null)
		this.$cp1HandlingFeeTotal = missionVariables.cp1HandlingFeeTotal;
	if (missionVariables.cp1HandlingPaid != null)
		this.$cp1HandlingPaid = missionVariables.cp1HandlingPaid;
	if (missionVariables.cp1MaintenanceFeeTotal != null)
		this.$cp1MaintenanceFeeTotal = missionVariables.cp1MaintenanceFeeTotal;
	if (missionVariables.cp1DismantlingFeeTotal != null)
		this.$cp1DismantlingFeeTotal = missionVariables.cp1DismantlingFeeTotal; 
    // Load system-to-system runs w/pod
	if (missionVariables.cp1Runs != null)
		this.$cp1Runs = missionVariables.cp1Runs;
	// Load Handling fee count
	if (missionVariables.cp1HandlingCount != null)
		this.$cp1HandlingCount = missionVariables.cp1HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.cp1HFExempt != null)
		this.$cp1HFExempt = missionVariables.cp1HFExempt;
	// Load Maintenance fee count
	if (missionVariables.cp1MaintenanceCount != null)
		this.$cp1MaintenanceCount = missionVariables.cp1MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// prepare pod Account screen
	var sta = player.ship.dockedStation;
	this._cp1PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$cp1Pods>0) this._cp1PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$cp1ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$cp1ET = true;
	// TEST	
	if (this.$cp1ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$cp1FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$cp1FES = true;
	// TEST	
	if (this.$cp1ET) log(this.name, "Finds FE Ships Player present");
	// number of pods - when fitted, always 1
	this.$cp1Pods = 0;
	// purchase cost of pod in cr
	this.$cp1Cost = 10000;
	// handling fee
	this.$cp1HandlingFee = 0.005*this.$cp1Cost; // 0.005 of cost
	this.$cp1HandlingFeeTotal = 0;
	this.$cp1HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$cp1HandlingCount = 0;
	this.$cp1HFExempt = "no";
	// maintenance fee
	this.$cp1MaintenanceFee = 0.05*this.$cp1Cost; // 0.05 of cost
	this.$cp1MaintenanceFeeTotal = 0;
	this.$cp1MaintenancePaid = "no" // or "yes"
	this.$cp1MaintenanceInterval = 10; // in runs (according to cost)
	this.$cp1MaintenanceCount = 0;
	// dismantling fee
	this.$cp1DismantlingFee = 0.1*this.$cp1Cost; // 0.1 of cost
	this.$cp1DismantlingFeeTotal = 0.0;
	// system-to-system runs w/pod
	this.$cp1Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.cp1Pods = this.$cp1Pods;
	// save total fees taken
	missionVariables.cp1HandlingFeeTotal = this.$cp1HandlingFeeTotal;
	missionVariables.cp1MaintenanceFeeTotal = this.$cp1MaintenanceFeeTotal;
	missionVariables.cp1DismantlingFeeTotal = this.$cp1DismantlingFeeTotal;
	missionVariables.cp1HandlingPaid = this.$cp1HandlingPaid;
	// system-to-system runs w/pod
	missionVariables.cp1Runs =this.$cp1Runs;
	// handling fee count
	missionVariables.cp1HandlingCount = this.$cp1HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.cp1HFExempt = this.$cp1HFExempt;
	// maintenance fee count
	missionVariables.cp1MaintenanceCount = this.$cp1MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$cp1HFExempt;
	// check we have pods, the fee is not paid, and we're not exempt
	if ((this.$cp1Pods>0) && (this.$cp1HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$cp1Pods; x++)
			fee += this.$cp1HandlingFee;
		// record fee and debit trader's account
		this.$cp1HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$cp1HandlingPaid = "yes";
		pc("10 TC Pod handling fees: "+fee+" cr",9);
		this.$cp1HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$cp1Pods>0) this._cp1DoMaintenance();
	
	// prepare pod Account and Licence page
	this._cp1PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$cp1Pods>0) this._cp1PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$cp1HandlingPaid = "no";
	this.$cp1Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._cp1DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$cp1Runs;
	var intv = this.$cp1MaintenanceInterval;
	var mfee = this.$cp1MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x pods
		var fee = 0;
		for (var x=1; x<= this.$cp1Pods; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$cp1MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("10 TC Pod Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$cp1MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._cp1PrepAcc = function(station) {
	station.setInterface("cp1Acc",{
	title: "Your FE Shipyards 10 TC Pod Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 10 TC Pod account screen shows terms, fees paid, load, and other useful information.",
	callback: this._cp1ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._cp1ShowAcc = function() {
	var hfc = this.$cp1HandlingCount;
	var mfc = this.$cp1MaintenanceCount;
	var mfi = this.$cp1MaintenanceInterval;
	var hft = this.$cp1HandlingFeeTotal;
	var mft = this.$cp1MaintenanceFeeTotal;
	var dft = this.$cp1DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$cp1Pods>0) 
		parameters.message +="Your Account and Licence for 10 TC Class Goods Pods x "+this.$cp1Pods+": \n\n"; 
	 else
		parameters.message +="You have no 10 TC Class Pods licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our pods are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Pod account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylon for weapons-use. \n";
	
	parameters.choicesKey = "cp1Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._cp1PrepEx = function(station) {
	station.setInterface("cp1Ex",{
	title: "Your FE Shipyards Pod Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 10-ton pod class." ,
	callback: this._cp1ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._cp1ShowEx = function() {
	var priv = ((this.$cp1ET)||(this.$cp1FES));
	var privo = "";
	if (this.$cp1FES) privo="FE shipowner";
	if (this.$cp1ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 10 TC pod fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "cp1YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$cp1HFExempt = "yes"; else this.$cp1HFExempt = "no";
		} else this.$cp1HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}
