"use strict";
this.name = "assassins_rebooted_victim6_beacon.js";
this.author = "LittleBear, Eric Walch & Thargoid";
this.copyright = "November 2008 - But do what you like with it in your OXPs!";
this.description = "Stops the use of Quirium Weapons within scanning range and spawns mission ships for the 6th Assassination";
this.version = "2.2";

// This version of the script also spawns the 6th Victim and a small asteroid field as this version is used by the Guild Duelling Beacon.
this.shipSpawned = function()
{
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
// Add an asteroid field around the Beacon
system.addShips("assassins_rebooted_miner_rock",40,this.ship.position,40000);
// Add O-Ren Ishi flying a Cobra IX at the time of the mission. No separate check for mission stage is needed as the beacon is spawned by the main script only when
// the stage is at 30. (Spawns Victim 6 and escorts 10 kms ahead of the Beacon).
system.legacy_addShipsAtPrecisely("assassins_rebooted_victim6", 1, "abs", this.ship.position.add(this.ship.heading.multiply(10000)))
// Add Mining Drones with Pulse Lasers and an AI to patrol the asteroid field and attack the player.
system.addShips("assassins_rebooted_victim6_support",1,this.ship.position,5000);
system.addShips("assassins_rebooted_victim6_support",1,this.ship.position,10000);
system.addShips("assassins_rebooted_victim6_support",1,this.ship.position,15000);
delete this.shipSpawned; 
}

this.quirium = ["EQ_QC_MINE", "EQ_CASCADE_MISSILE", "EQ_LAW_MISSILE", "EQ_OVERRIDE_MISSILE", "energy-bomb", "RANDOM_HITS_MINE",  "EQ_MEGA_DEATH_MISSILE"];

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
}		
}
this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
}		
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
}		
}

this.doScan = function () 
{ 
// create an array with all weapons in range.
function allShips(entity) {return entity.isShip && entity.isWeapon}; 
var missiles = system.filteredEntities(this, allShips, this.ship, this.ship.scannerRange);
for (var i = 0; i < missiles.length; i++)
{
if (this.quirium.indexOf(missiles[i].primaryRole) > -1) 
{
missiles[i].explode();
this.ship.fireECM();
break; // found one
}
}
}
this.thargoidScan = function () 
{ 
// create an array with all thargoids in range.
function allShips(entity) {return entity.isShip && entity.isThargoid}; 
var thargoids = system.filteredEntities(this, allShips, this.ship, this.ship.scannerRange);
for (var i = 0; i < thargoids.length; i++)
{
if (thargoids[i].hasRole("secondWave_mineTharglet")) 
{
thargoids[i].explode();
this.ship.fireECM();
break; // found one
}
}
}
