"use strict";
this.name           = "assassins_rebooted_retirement_home.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script to rotate the station towards the main station and make attacking it a crime. Also spawns asscociated ships.";

this.shipSpawned = function()
{
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
var pos = this.ship.position;
// Add a Tourist Transporter with an AI to wait by the Retirement Home until the player arrives and then fly to the main station and dock with it.
system.addShips("assassins_rebooted_sunset_local_transporter_type1",1,pos,10000);
// Add a Tourist Shuttle with an AI to wait by the Retirement Home until the player arrives and then fly to the planet Appollodrus and land on it.
system.addShips("assassins_rebooted_sunset_local_shuttle_type1",1,pos,11000);
// Add a Tourist Worm Lander with an AI to wait by the Retirement Home until the player arrives and then fly to the planet Appollodrus and land on it.
system.addShips("assassins_rebooted_sunset_local_worm_type1",1,pos,12000);
// Add a Tourist Ophidian Yacht with an AI to wait by the Retirement Home until the player arrives and then dock with the Retirement Home.
system.addShips("assassins_rebooted_sunset_local_yacht",1,pos,13000);
// Add a Tourist Ophidian Yacht with an AI to wait by the Retirement Home until the player arrives and then fly to the main station and dock with it.
system.addShips("assassins_rebooted_sunset_local_yacht_type2",1,pos,14000);
// Add a Tourist Ophidian Yacht with an AI to wait by the Retirement Home until the player arrives and then fly to the wichpoint and dock with the nearest station there.
system.addShips("assassins_rebooted_sunset_local_yacht_type3",1,pos,15000);
// Add a Yacht 50 kms from the Retirement Home in a line with the main station, with an AI to go to the main station and dock with it. 
system.legacy_addShipsAtPrecisely("assassins_rebooted_sunset_planet_yacht", 1, "abs", this.ship.position.add(this.ship.heading.multiply(50000))) 
// Add a Yacht 100 kms from the Retirement Home in a line with the main station, with an AI to go to the Retirement Home and dock with it.
system.legacy_addShipsAtPrecisely("assassins_rebooted_sunset_homebound_yacht", 1, "abs", this.ship.position.add(this.ship.heading.multiply(100000))) 
// Add a Yacht 150 kms from the Retirement Home in a line with the main station, with an AI to go to the Retirement Home and dock with it.
system.legacy_addShipsAtPrecisely("assassins_rebooted_sunset_outbound_yacht", 1, "abs", this.ship.position.add(this.ship.heading.multiply(150000))) 
// Add a Yacht 300 kms from the Retirement Home in a line with the main station, with an AI to go to the nearest OXZ station within 500kms and dock. If there are none
// then it will go to either the main station or the Retirement Home.
system.legacy_addShipsAtPrecisely("assassins_rebooted_sunset_outbound_yacht", 1, "abs", this.ship.position.add(this.ship.heading.multiply(300000))) 
// Add Victim 1 - Be Soin in a Vintage Adder. Added within 20kms of the Retirement Home when the mission to kill him is running.
if (missionVariables.assassins_rebooted_stage === 1) {
system.addShips("assassins_rebooted_victim1",1,pos,20000);
}
delete this.shipSpawned; 
}

this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("ATTACKED"); 
player.bounty |= 51;
}
// Cause a police ship attacking a lawful ship to break off. If the lawful ship or attacking ship gained a bounty, both are reset to zero.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// If the attacker is another lawful ship, then it will only have hit by accident and the ship will not have been the attacker's current target.
// No need to break the attacker's target, but the ship will not respond to the accidental hit except by Idleing for 1.5 seconds before returning to its normal AI.
if (whom.roles.indexOf("assassins_rebooted_lawful_character") > -1 )  
{
whom.bounty = 0;
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}

// End of this.shipAttackedWithMissile
}
