"use strict";
this.name           = "assassins_rebooted_victim10.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script for the 10th (and Final) Mission Ship - Governor Tarkin in a Balrog Class Dreadnaught";

this.shipSpawned = function()
{
var targetVector = system.mainStation.position.subtract(this.ship.position).direction();
var angle = this.ship.heading.angleTo(targetVector);
var cross = this.ship.heading.cross(targetVector).direction();
this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
//  Checks to see that the equipment is working. If it is damaged then it isn't removed, so you don't get a free repair
if (player.ship.equipmentStatus("EQ_CLOAKING_DEVICE") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_CLOAKING_DEVICE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK");
}
if (player.ship.equipmentStatus("EQ_ENERGY_BOMB") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ENERGY_BOMB");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB");
}
// Add an asteroid field as the ship is spawned at the co-ordinatles of the former rebel held prison.
pos = this.ship.position;
system.addShips("assassins_rebooted_miner_rock",45,pos,25000);
// Add an Areon Class Friggate Target Dummy for the Dreadnaught to attack and keep the Dreadnaught in place until the player arrives.
// The Target Dummy and the Dreadnaught are both indestructable until the player arrives. Once the player comes within scanner range, the next attack on the target
// dummy will cause it to explode.
system.addShips("assassins_rebooted_victim10_target_dummy",1,pos,2000);
// Add a squad of 5 Imperial Shuttles to attack the target dummy.
system.addShips("assassins_rebooted_victim10_shuttle_squad",1,pos,3000);
// Add a second target dummy again with an AI to attack the Dreadnaught, but this one will jump out shortly after detecting the player.
system.addShips("assassins_rebooted_victim10_target_dummy_type2",1,pos,4000);
// Add a squad of 3 Mongoose Fighters to attack the target dummy.
system.addShips("assassins_rebooted_victim10_mongoose_squad",1,pos,5000);
// Add a third target dummy also with an AI to attack the Dreadnaught, when this one detects the player it will flee to 30kms from the player's position.
// When it reaches 30kms, it will jump out.
system.addShips("assassins_rebooted_victim10_target_dummy_type3",1,pos,6000);
// Add a squad of 3 Scorpion Frigates to attack the dummy.
system.addShips("assassins_rebooted_victim10_scorpion_squad",1,pos,7000);
// Add three groups of three Mongoose Fighters with AIs to patrol the asteroid field and attack the player.
system.addShips("assassins_rebooted_victim10_mongoose_player_killer_squad",1,pos,10000);
system.addShips("assassins_rebooted_victim10_mongoose_player_killer_squad",1,pos,15000);
system.addShips("assassins_rebooted_victim10_mongoose_player_killer_squad",1,pos,20000);
// Add three groups of three Imperial Shuttles with AIs to patrol the asteroid field and attack the player.
system.addShips("assassins_rebooted_victim10_shuttle_player_killer_squad",1,pos,8000);
system.addShips("assassins_rebooted_victim10_shuttle_player_killer_squad",1,pos,12000);
system.addShips("assassins_rebooted_victim10_shuttle_player_killer_squad",1,pos,18000);
// Add three indivual Imperial Scorpion Frigates with AIs to patrol the asteroid field and attack the player.
system.addShips("assassins_rebooted_victim10_scorpion_player_killer_squad",1,pos,10000);
system.addShips("assassins_rebooted_victim10_scorpion_player_killer_squad",1,pos,15000);
system.addShips("assassins_rebooted_victim10_scorpion_player_killer_squad",1,pos,25000);
// Add groups of ships to intercept the player flying from the Witchpoint.
system.addShips("assassins_rebooted_victim10_mongoose_player_killer_squad_witchpoint",3,pos,40000);
system.addShips("assassins_rebooted_victim10_scorpion_player_killer_squad_witchpoint",3,pos,45000);
system.addShips("assassins_rebooted_victim10_mongoose_player_killer_squad_witchpoint",3,pos,50000);
// Add groups of ships with AIs to go to either the witchpoint, main planet / main station looking for the player.
// Groups of three Mongoose Fighters. (12 in total)
system.addShips("assassins_rebooted_victim10_mongoose_player_killer_squad_witchpoint",1,pos,35000);
system.addShips("assassins_rebooted_victim10_mongoose_player_killer_squad_planet",1,pos,45000);
system.addShips("assassins_rebooted_victim10_mongoose_player_killer_squad_witchpoint",1,pos,55000);
system.addShips("assassins_rebooted_victim10_mongoose_player_killer_squad_planet",1,pos,65000);
// Groups of three Imperial Shuttles (6 in total)
system.addShips("assassins_rebooted_victim10_shuttle_player_killer_squad_witchpoint",1,pos,75000);
system.addShips("assassins_rebooted_victim10_shuttle_player_killer_squad_planet",1,pos,85000);
// Two Scorpions.
system.addShips("assassins_rebooted_victim10_scorpion_player_killer_squad_witchpoint",1,pos,95000);
system.addShips("assassins_rebooted_victim10_scorpion_player_killer_squad_planet",1,pos,105000);
// Add groups of Imperial Ships between the Dreadnaught's position and the main station with AIs to patrol and look for the player.
// These ships are added on the edge of the 105km sphere around the Dreadnaught and are likley to be encountered if the player is
// flying from the Main Station (other ships are added in the spacelane and witchpoint routes
// Add a group of 3 Mongoose fighters with AIs to fly to the planet or main station (125kms from the Dreadnaught).
system.legacy_addShipsAtPrecisely("assassins_rebooted_victim10_mongoose_player_killer_squad_planet", 1, "abs", this.ship.position.add(this.ship.heading.multiply(125000)))
// Add a group of 3 Imperial Shuttles with AIs to fly to the planet or main station (175kms from the Dreadnaught).
system.legacy_addShipsAtPrecisely("assassins_rebooted_victim10_shuttle_player_killer_squad_planet", 1, "abs", this.ship.position.add(this.ship.heading.multiply(175000)))
// Add a Scorpion with an AI to fly to the planet or main station (225kms from the Dreadnaught).
system.legacy_addShipsAtPrecisely("assassins_rebooted_victim10_scorpion_player_killer_squad_planet", 1, "abs", this.ship.position.add(this.ship.heading.multiply(225000)))
// Add another group of 3 Mongoose fighters with AIs to fly to the planet or main station (300kms from the Dreadnaught).
system.legacy_addShipsAtPrecisely("assassins_rebooted_victim10_mongoose_player_killer_squad_planet", 1, "abs", this.ship.position.add(this.ship.heading.multiply(300000)))
// Add a Deamon Class Cruiser with 4 Mongoose Escorts with AIs to fly to the planet or main station (400kms from the Dreadnaught).
system.legacy_addShipsAtPrecisely("assassins_rebooted_victim10_demon_player_killer_squad_planet", 1, "abs", this.ship.position.add(this.ship.heading.multiply(400000)))
// Add another group of 3 Imperial Shuttles with AIs to fly to the planet or main station (500kms from the Dreadnaught).
system.legacy_addShipsAtPrecisely("assassins_rebooted_victim10_shuttle_player_killer_squad_planet", 1, "abs", this.ship.position.add(this.ship.heading.multiply(500000)))
// Add another group of 3 Mongoose fighters with AIs to fly to the planet or main station (600kms from the Dreadnaught).
system.legacy_addShipsAtPrecisely("assassins_rebooted_victim10_mongoose_player_killer_squad_planet", 1, "abs", this.ship.position.add(this.ship.heading.multiply(600000)))
// Single Rebel ship to help the player.
system.legacy_addShipsAtPrecisely("police", 1, "abs", this.ship.position.add(this.ship.heading.multiply(605000)))
// Add another Scorpion with an AI to fly to the planet or main station (700kms from the Dreadnaught).
system.legacy_addShipsAtPrecisely("assassins_rebooted_victim10_scorpion_player_killer_squad_planet", 1, "abs", this.ship.position.add(this.ship.heading.multiply(700000)))
// Closing Bracket for This Ship Spawned.
}
// Will break off from its current target if the new attacker is the player.
this.shipBeingAttacked = function (whom)
{
if (!whom) return;
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
return;	
}
// Does not respond to accidental hits by its own side
if (whom.roles.indexOf("assassins_rebooted_chaotic_character") > -1)  
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
if (!whom) return;
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
return;	
}
// Does not respond to accidental hits by its own side
if (whom.roles.indexOf("assassins_rebooted_chaotic_character") > -1)  
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
if (!whom) return;
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_MISSILE"); 
return;	
}
if (whom.roles.indexOf("assassins_rebooted_chaotic_character") > -1)  
{
whom.target = null;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// End of this.shipAttackedWithMissile
}

this.shipDied = function (whom)
{
if (whom && whom.isPlayer)
{
missionVariables.assassins_rebooted_stage = 56;
missionVariables.assassins_rebooted_civil_war = 3;
mission.setInstructionsKey("assassins_rebooted_mission_description_37", "AssassinsRebooted");
mission.unmarkSystem(13);
System.infoForSystem(6,13).inhabitants = "Liberated Harmless Fat Birds";
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean. The death of Governor Tarkin has left the People's Popular Front victorious in the recent civil war, with demoralised imperial troops surrendering in droves. The interim government will shortly be organising free and fair elections and petitioning GalCop for formal recognition as a democratic system in the Galactic Registry.";
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. The inhabitants are known for assisting others to achieve democratic enlightenment, providing significant military aid to democratic forces during the recent Eszausveian civil war.";
this.ship.commsMessage(expandDescription("[assassins-death-victim10]"), player.ship);
// Re-Award the Cloak and / or Energy Bomb if either or both were disabled (You don't get em back if you didn't have them in the first place).
if (player.ship.equipmentStatus("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK");
player.ship.awardEquipment("EQ_CLOAKING_DEVICE");
}
if (player.ship.equipmentStatus("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB");
player.ship.awardEquipment("EQ_ENERGY_BOMB");
}
// Add 21 Navy Frigates (in seven wings of three) near the player's position to assist with the remaining imperial ships.
// These ships will go to the co-ordinates of the Dreadnaught's position and attack imperial ships. But they only jump in when the player has already succeeded!
system.addShips("assassins_rebooted_aeron_cavalry_type1",1,player.ship.position.add([27000,0,0]),1000)[0];
system.addShips("assassins_rebooted_aeron_cavalry_type1",1,player.ship.position.add([28000,0,0]),1000)[0];
system.addShips("assassins_rebooted_aeron_cavalry_type1",1,player.ship.position.add([29000,0,0]),1000)[0];
system.addShips("assassins_rebooted_aeron_cavalry_type1",1,player.ship.position.add([35000,0,0]),1000)[0];
system.addShips("assassins_rebooted_aeron_cavalry_type1",1,player.ship.position.add([40000,0,0]),1000)[0];
system.addShips("assassins_rebooted_aeron_cavalry_type1",1,player.ship.position.add([60000,0,0]),1000)[0];
system.addShips("assassins_rebooted_aeron_cavalry_type1",1,player.ship.position.add([80000,0,0]),1000)[0];
// Add more reinforcements at the main station with AIs to patrol around the main station.
system.addShips("assassins_rebooted_aeron_cavalry_type2",1,system.mainStation.position.add([5000,0,0]), 1000)[0];
system.addShips("assassins_rebooted_aeron_cavalry_type2",1,system.mainStation.position.add([10000,0,0]), 1000)[0];
system.addShips("assassins_rebooted_aeron_cavalry_type2",1,system.mainStation.position.add([15000,0,0]), 1000)[0];
// Add more reinforcements at the witchpoint with AIs to patrol the witchpoint and then patrol the system.
system.legacy_addShipsAt("assassins_rebooted_aeron_cavalry_type3", 3, "wpu", [0, 0, 0.0])
// Add more reinforcements in the spacelanes with AIs to patrol the system.
system.legacy_addShipsAt("assassins_rebooted_aeron_cavalry_type4", 1, "wpu", [0, 0, 0.10])
system.legacy_addShipsAt("assassins_rebooted_aeron_cavalry_type4", 1, "wpu", [0, 0, 0.30])
system.legacy_addShipsAt("assassins_rebooted_aeron_cavalry_type4", 1, "wpu", [0, 0, 0.60])
system.legacy_addShipsAt("assassins_rebooted_aeron_cavalry_type4", 1, "wpu", [0, 0, 0.90])
// Clear any bounty the player had in reward for taking out the Dreadnaught.
player.bounty = 0;
// End of Killed by the Player.
}

// End of this.shipDied
}
