"use strict";
this.name = "AssassinsRebooted";
this.author = "LittleBear";
this.copyright = "This script is hereby placed in the public domain.";
this.description = "Assassins Guild OXZ - Rebooted Version 2.2 - 18/04/25";
this.version = "2.2";
this.licence = "CC BY-NC-SA 4.0";

// Flag to Xenon OXZ (if installed) that the Images from Assassins take priority over the Xenon UI for selected Assassins Mission Briefing Screens.
// Some Assassins Mission Briefing Screens have background PNGs and without this flag Xenon would over-ride the Asassins briefing screen image and appear on top of it.
// All the Mission and News Broadcasts use transparent images, so the image appears in the background as the player reads the message and the Xenon UI
// remains on screen. However for briefings where the player is meant to be outside their ship rather than looking at a message on a monitor, the view of the station or
// hangar the player is walking around are shown full screen without the Xenon UI. 
var w = worldScripts.XenonUI;
if (w) w.$addMissionScreenException("AssassinsRebooted");
// End of Flag to Xenon OXZ.

this.startUp = function() {
// Clear the variables testing for whether Stranger's World or the Galactic Almanac is installed, as OXZs installed can change between loads.
// So we need to check this each time a new game is started or a game is loaded from a save file.
delete missionVariables.assassins_rebooted_stranger_installed;
delete missionVariables.assassins_rebooted_stranger_has_populated;
delete missionVariables.assassins_rebooted_almanac_installed;
// When first installed, delete all the variables from the old versions of Assassins.
if (!missionVariables.assassins_rebooted_stage) {
// Clean Up the Save File by Deleting all old assassins variables when the OXZ is first installed.
delete missionVariables.assassins;
delete missionVariables.assassins_basedeath;
delete missionVariables.assassins_bugattack;
delete missionVariables.assassins_card;
delete missionVariables.assassins_gotscan;
delete missionVariables.assassins_jumpcount;
delete missionVariables.assassins_killcount;
delete missionVariables.assassins_navybots;
delete missionVariables.assassins_robotescape;
delete missionVariables.assassins_robottimer;
delete missionVariables.assassins_trumble;
delete missionVariables.assassins_unlocked;
delete missionVariables.assassins_war;
// Re-set the Victim11 script to the start, so that (if installed) it will run after Assassins Rebooted is completed as intended.
// (Otherwise both OXPs could run at the same time, when Victim 11 is only meant to be offered when you have finished Assassins as
// its story follows on from the end of Assassins.
delete missionVariables.Victim11;
delete missionVariables.Victim11_pod_count;
// Define all the variables used by Assassins Rebooted to their starting values.
// The Set Up code above is only run when the Stage variable is undefined. Once it is defined, the set up code is not run again therefore.
missionVariables.assassins_rebooted_stage = 0;
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_interlude = "No";
missionVariables.assassins_rebooted_battlebot_development_level = 0;
missionVariables.assassins_rebooted_battlebot_escape_level = 0;
missionVariables.assassins_rebooted_battlebot_escape_timer = 0;
missionVariables.assassins_rebooted_thargoid_invasion = 0;
missionVariables.assassins_rebooted_navy_base_lockdown = "No";
missionVariables.assassins_rebooted_civil_war = 0;
}

// Modifing the Assassins systems is run on loading or starting a game.
// Set Up the Assassins Systems in their default starting states.
// Set Up Orramaor.
System.infoForSystem(6,73).description = "Orramaor is noted for the resort world of Apollodorus, where many of the residents of the nearby Sunset Retirement Home spend their days. It is reasonably well known as the corporate headquarters of Soin Classic Shipyards Ltd. In recent years, Soin Classic Shipyards have specialised in the development of improved versions of Serpent Class ships.";
System.infoForSystem(6,73).techlevel = 14;
System.infoForSystem(6,73).government = 6;
System.infoForSystem(6,73).economy = 0;
System.infoForSystem(6,73).inhabitants = "Small Rodent Scientists";
System.infoForSystem(6,73).productivity = 53489;
System.infoForSystem(6,73).population = 97;
System.infoForSystem(6,73).station = "assassins_rebooted_standard_dodecahedron_station";
// Set Up Esrire
System.infoForSystem(6,107).description = "Esrire is famous for its large gas giant, Cerberus. The system is however plagued by high levels of criminal activity, even by the standards of an anarchy system. GalCop Special Branch suspects that many criminal organizations make their home in this system but have thus far found no living witnesses to corroborate their theories.";
System.infoForSystem(6,107).economy = 5;
System.infoForSystem(6,107).techlevel = 9;
System.infoForSystem(6,107).population = 32;
System.infoForSystem(6,107).inhabitants = "Sinister Yellow Frogs";
System.infoForSystem(6,107).productivity = 97252;
// Set Up Tiared
System.infoForSystem(6,194).description = "Tiared is well known for the desert world Diomedes and its orbital stadium. The inhabitants have a passion for the sport of Zero-G Hockey, hosting the last five annual Galactic Cup competitions. The Galactic Zero-G Hockey Association have their headquarters on the northern continent of the planet.";
System.infoForSystem(6,194).inhabitants = "Hockey Obsessed Lizards";
System.infoForSystem(6,194).techlevel = 9;
// Set Up Beatle
System.infoForSystem(6,203).description = "Beatle is well known for its moon, Augeas. The Augeaian Orbital Repair Facility is famous for the affordable servicing facilities provided by its industrious work crews, although docking is only permitted by prior written appointment. The Augeaian Security Force maintains a strong presence of Phantom Interceptors and Minesweeper Satellites in the vicinity. Customers can rest assured that their craft will remain secure whilst in parking orbit.";
System.infoForSystem(6,203).techlevel = 14;
System.infoForSystem(6,203).government = 7;
System.infoForSystem(6,203).economy = 0;
System.infoForSystem(6,203).population = 52;
System.infoForSystem(6,203).inhabitants = "Feline Engineers";
System.infoForSystem(6,203).productivity = 39902;
System.infoForSystem(6,203).station = "assassins_rebooted_standard_icosahedron_station";
// Set Up Ateslete
System.infoForSystem(6,39).description = "The Ateslete System is reasonably noted for the ice-world, Stymphal. The well known robotics company, Griff Research Ltd, operates factories over most of the planet and maintains an orbital research station near Stymphal.";
System.infoForSystem(6,39).techlevel = 14;
System.infoForSystem(6,39).government = 7;
System.infoForSystem(6,39).economy = 0;
System.infoForSystem(6,39).inhabitants = "Mostly Robots";
System.infoForSystem(6,39).productivity = 78824;
System.infoForSystem(6,39).population = 72;
// Set Up Quandixe
System.infoForSystem(6,53).description = "Quandixe is well known for its tropical moon Hesperides, the climate of which is perfectly suited to the cultivation of Megaweed. Fleets of Anacondas move cargo continuously from the Darkside Waystation orbiting Hesperides across the system. Rumours circulate that the Quandixeian Corporation is in reality a front for a Mafia narcotics syndicate.";
System.infoForSystem(6,53).inhabitants = "Legitimate Businessmen";
System.infoForSystem(6,53).economy = 5;
System.infoForSystem(6,53).productivity = 84296;
System.infoForSystem(6,53).station = "assassins_rebooted_standard_icosahedron_station";
// Set Up Geteve
System.infoForSystem(6,18).description = "Geteve is reasonably well known for its large habitable moon, Hercules. GalCop Special Branch operates from a small outpost in orbit around Hercules. The main offices of the Galactic Prosecution Service are based on the moon's surface.";
System.infoForSystem(6,18).inhabitants = "Law Abiding Humans";
System.infoForSystem(6,18).government = 6;
System.infoForSystem(6,18).economy = 0;
System.infoForSystem(6,18).productivity = 58132;
System.infoForSystem(6,18).station = "assassins_rebooted_standard_dodecahedron_station";
// Set Up Zarausxe (No missions are scripted here, but the player will be pursued by angry sports fans from this system, so the description and inhabitants are tweaked.)
System.infoForSystem(6,184).description = "This planet is notable for its great tropical forests but is famous for its inhabitants passion for the sport of Zero-G Hockey.";
System.infoForSystem(6,184).inhabitants = "Hockey Obsessed Humans";
// Set Up Ataneris
System.infoForSystem(6,81).description = "Ataneris is famous for the forest world of Hippolyte but has a sinister reputation as a traditional place of bloodshed. In dark corners of disreputable space bars, it is whispered that, from time to time, duels between pilots of great skill take place near the asteroid fields of Hippolyte. Two ships enter the circle, one ship leaves.";
System.infoForSystem(6,81).inhabitants = "Bloodthirsty Furry Felines";
// Set Up Esreates (No missions are scripted here, but the player will be pursued by Triads from this system, so the description and inhabitants are tweaked.)
System.infoForSystem(6,100).description = "Formally a GalCop penal colony, a successful rebellion by the prisoners placed the system in the hands of felons. At present the system is run by the Yankisona Triad gang. In criminal circles, it is well known that relations with the Quandixeian Mafia are less than cordial. Many fear that all out gang warfare is imminent.";
System.infoForSystem(6,100).inhabitants = "Criminals of Many Species";
System.infoForSystem(6,100).productivity = 29127;
// Set Up Orreedon (No missions are scripted here, but a fellow assissin will make a hit involving a trained dealy goat, so the description is tweaked.)
System.infoForSystem(6,118).description = "The planet Orreedon is famous for its strange mountains but cursed by deadly goats. In criminal circles, it is said that an illegal trade in the export of Orreedonian deadly goats flourishes on the northern continent. Once domesticated, the deadly goat can be trained as a vicious attack beast.";
System.infoForSystem(6,118).inhabitants = "Nervous Human Colonials";
// Set Up Estiri
System.infoForSystem(6,82).description = "Estiri is noted for its large ocean covered moon, Nemean, and famous as the location of the Galactic Supreme Court. The Galactic Navy operates from a well defended base orbiting the moon. Law abiding civilians are normally welcome to visit the naval facility, but at times of heightened security the navy enforce a lockdown and ships approaching the base without the correct clearance codes will be fired upon.";
System.infoForSystem(6,82).inhabitants = "Impartial Furry Felines";
System.infoForSystem(6,82).government = 6;
System.infoForSystem(6,82).productivity = 27654;
System.infoForSystem(6,82).station = "assassins_rebooted_standard_dodecahedron_station";
// Set Up Sobeer (No missions are scripted here, but mention is made of someone being sent a spotted cod as a mafi warning, so the description is tweaked.)
System.infoForSystem(6,19).description = "Sobeer is famous for the delicious nature of its native marine life, particularly the exquisite Sobeerian spotted cod. Beings of a more sensitive nature decline however to partake in this delicacy, knowing its use in certain sinister Mafia rituals.";
System.infoForSystem(6,19).inhabitants = "Nautical Bony Felines";
// Set Up Eszausve
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. Although the People's Popular Front bravely resists the oppressive regime of Governor Tarkin, thus far they have made little progress in restoring freedom to the planet.";
System.infoForSystem(6,13).productivity = 98764;
System.infoForSystem(6,13).inhabitants = "Oppressed Harmless Fat Birds";
System.infoForSystem(6,13).population = 71;
System.infoForSystem(6,13).techlevel = 11;
System.infoForSystem(6,13).station = "assassins_rebooted_eszausve_station";
// Set Up Angeriri
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. Whilst this takes up a considerable amount of their free time, it is rumoured that they also provide covert support to the People's Popular Front of Eszausve.";
System.infoForSystem(6,71).inhabitants = "Cybernetic Red Lizards";
// Set Up Encezais (No missions are scripted here, but Ramon Security Ltd re-enforce the Eszausve Dictatorship, so this nearby system is modified to be the home system of Ramon Security Ltd).
System.infoForSystem(6,120).description = "The high technology world of Encezais is well known for the large shipbuilding factories of Ramon Security Ltd situated on the eastern continent. Whilst a major contributor to the wealth of the system, the company has been the subject of criticism due to its policy of selling military grade vessels and arms to morally questionable regimes.";
System.infoForSystem(6,120).inhabitants = "Amoral Fat Felines";
System.infoForSystem(6,120).government = 7;
System.infoForSystem(6,120).economy = 0;
System.infoForSystem(6,120).productivity = 63942;
System.infoForSystem(6,120).population = 63;
System.infoForSystem(6,120).techlevel = 13;
System.infoForSystem(6,120).station = "assassins_rebooted_standard_icosahedron_station";

// Changes from default states depending on where the player is in the story.
// Orramaor changes after the Guild destroys the Soin Clan family burrow.
if (missionVariables.assassins_rebooted_stage > 8 || missionVariables.assassins_rebooted_stage === "Complete") {
System.infoForSystem(6,73).description = "Orramaor is noted for the resort world of Apollodorus, where many of the residents of the nearby Sunset Retirement Home spend their days.  Formerly the corporate headquarters of Soin Classic Shipyards Ltd, the Planet Orramaor is now famous for a large crater on the southern continent.";
System.infoForSystem(6,73).productivity = 38535;
}

// Changes to Geteve when the Thargoid Invasion starts.
if (missionVariables.assassins_rebooted_thargoid_invasion === 1) {
System.infoForSystem(6,18).description = "Geteve is reasonably well known for its large moon, Hercules. GalCop Special Branch operates from a small outpost in orbit around Hercules. The main offices of the Galactic Prosecution Service are based on the moon's surface. A Thargoid invasion of the system is underway. Bugs commonly attack the Stations, but Special Branch Asps engaged in defence of the system have so far prevented any landings.";
System.infoForSystem(6,18).productivity = 49479;
}

// Changes to Geteve when the Navy deploy BattleBots and Control Drones to help fight off the Thargoids.
if (missionVariables.assassins_rebooted_thargoid_invasion === 2) {
System.infoForSystem(6,18).description = "Geteve is reasonably well known for its large moon, Hercules. GalCop Special Branch operates from a small outpost in orbit around Hercules. The main offices of the Galactic Prosecution Service are based on the moon's surface. A Thargoid invasion of the system is underway. Although Special Branch forces remain hard-pressed by Thargoid attacks, the deployment of Navy BattleBots has started to turn the tide against the Bugs.";
System.infoForSystem(6,18).productivity = 49841;
}

// Changes to Geteve when the Thargoid Invasion is over.
if (missionVariables.assassins_rebooted_thargoid_invasion === "Over") {
System.infoForSystem(6,18).description = "Geteve is reasonably well known for its large moon, Hercules. GalCop Special Branch operates from a small outpost in orbit around Hercules. The main offices of the Galactic Prosecution Service are based on the moon's surface. Although heavy causalities were suffered during the recent Thargoid Invasion, the combined efforts of Special Branch officers, Navy BattleBots and freelance civilian Commanders finally defeated the Bugs.";
System.infoForSystem(6,18).productivity = 49841;
}

// Changes to Ateslete when the Malfunctioning BattleBots escape.
if (missionVariables.assassins_rebooted_stage === 23 || missionVariables.assassins_rebooted_stage === 24 || missionVariables.assassins_rebooted_stage === 25) {
System.infoForSystem(6,39).description = "The Ateslete System is reasonably noted for the ice-world, Stymphal. The well known robotics company, Griff Research Ltd, operates factories over most of the planet and maintains an orbital research station near Stymphal. Although normally one of the safer systems in the Galaxy, pirates currently plague the main space lanes.";
}

// Changes to Ateslete when the Player destroys the Malfunctioning Control Drone
if (missionVariables.assassins_rebooted_stage > 25 && missionVariables.assassins_rebooted_stage < 33) {
System.infoForSystem(6,39).description = "The Ateslete System is reasonably noted for the ice-world, Stymphal. The well known robotics company, Griff Research Ltd, operates factories over most of the planet and maintains an orbital research station near Stymphal. The System was recently been beset by pirate activity. Rumors circulate of a mysterious Commander, flying a ship marked with the Red Hand, who destroyed all the pirate vessels and then vanished.";
}

// Changes to Ateslete when the govenment deploys its robotic police force.
if (missionVariables.assassins_rebooted_stage > 32 || missionVariables.assassins_rebooted_stage === "Complete") {
System.infoForSystem(6,39).description = "The Ateslete System is reasonably noted for the ice-world, Stymphal. The well known robotics company, Griff Research Ltd, operates factories over most of the planet and maintains an orbital research station near Stymphal. Crime in the system has fallen since the introduction of an entirely robotic police force, but members of the Butlerian Order now refuse to visit the system.";
}

// The Description of Estiri is changed whilst the Navy Outpost is in lockdown.
if (missionVariables.assassins_rebooted_navy_base_lockdown === "Yes") {
System.infoForSystem(6,82).description = "Estiri is noted for its large ocean covered moon, Nemean, and famous as the location of the Galactic Supreme Court. The Galactic Navy operates from a well defended base orbiting the moon. The Navy has imposed a 25 km exclusion zone around the base. Non-Military ships entering the zone will be fired upon without warning.";
}

// The Description and productivity of Esreates changes as the Triad's fortunes fall following the Assassination by the player of their leader.
if (missionVariables.assassins_rebooted_stage > 36 && missionVariables.assassins_rebooted_stage < 40) {
System.infoForSystem(6,100).description = "Formally a GalCop penal colony, a successful rebellion by the prisoners placed the system in the hands of felons. At present the system is run by the Yankisona Triad gang. Opinion in the criminal fraternity is divided on the future of the Triads, following the assassination of Boss Yankisona. Some feel that the Triads are finished. Others think that the promotion of henchman, Ni Katona, to gang leader, will ensure their reign of terror continues.";
System.infoForSystem(6,100).productivity = 27093;
}

// The Description and productivity of Esreates change again when the Triad leaders are arrested.
if (missionVariables.assassins_rebooted_stage > 39 && missionVariables.assassins_rebooted_stage < 43) {
System.infoForSystem(6,100).description = "Formally a GalCop penal colony, a successful rebellion by the prisoners placed the system in the hands of felons. At present the system is run by the Yankisona Triad gang, although their power currently hangs by a thread. Most of the criminal community have written off the Esreatesian Triads, following the arrest of the higher echelons by GalCop Special Branch. There are some who believe, that the Triads will yet manage to stage a miraculous return to power.";
System.infoForSystem(6,100).productivity = 23431;
}

// The Description, productivity of Esreates change again as the Triad's fortunes are restored.
if (missionVariables.assassins_rebooted_stage > 42 || missionVariables.assassins_rebooted_stage === "Complete") {
System.infoForSystem(6,100).description = "Formally a GalCop penal colony, a successful rebellion by the prisoners placed the system in the hands of felons. At present the system is run by the Yankisona Triad gang. Despite recent unfortunate setbacks, most professional gangsters regard their future as bright. The surprise decision of the Galactic Prosecution Service to offer no evidence in the case of R v Ni Katona & Others, has led many in the criminal community to treat the Triads with a healthy respect.";
System.infoForSystem(6,100).productivity = 28418;
}

// The Descriptions, productivity and population of Eszausve and Angeriri change as civil war breaks out.
if (missionVariables.assassins_rebooted_stage > 44 && missionVariables.assassins_rebooted_stage < 47) {
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. The People's Popular Front has made substantial gains in surface battles but remains out gunned by the imperial fleet in the spacelanes.";
System.infoForSystem(6,13).productivity = 93098;
System.infoForSystem(6,13).inhabitants = "Resisting Harmless Fat Birds";
System.infoForSystem(6,13).population = 70;
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. In response to the use of capital ships against civilian targets, the system is providing military aid to the Eszausveian People's Popular Front.";
}

// The Description, productivity and population of Eszausve changes again at the time of the 9th Assination
if (missionVariables.assassins_rebooted_stage === 47) {
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. The People's Popular Front has made substantial gains in surface battles but remains out gunned by the imperial fleet in the spacelanes. The gathering of an armada of Demon Class Cruisers near the Imperial Station may however spell the end for the rebellion.";
System.infoForSystem(6,13).productivity = 89153;
System.infoForSystem(6,13).population = 68; 
System.infoForSystem(6,13).inhabitants = "Resisting Harmless Fat Birds";
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. In response to the use of capital ships against civilian targets, the system is providing military aid to the Eszausveian People's Popular Front.";
}

// The Description of Eszausve changes again when the 9th Assassination is completed.
if (missionVariables.assassins_rebooted_stage > 47 && missionVariables.assassins_rebooted_stage < 50) {
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. The People's Popular Front has made substantial gains in surface battles but remains out gunned by the imperial fleet in the spacelanes. The recent destruction of the Imperial Flagship by a mysterious Commander has however rallied the rebels.";
System.infoForSystem(6,13).productivity = 89153;
System.infoForSystem(6,13).population = 68; 
System.infoForSystem(6,13).inhabitants = "Resisting Harmless Fat Birds";
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. In response to the use of capital ships against civilian targets, the system is providing military aid to the Eszausveian People's Popular Front.";
}

// The Description of Eszausve changes again after the 14th News Broadcast is seen.
if (missionVariables.assassins_rebooted_stage === 50) {
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. The People's Popular Front has taken control of much of the planetary surface with assaults upon the system main station and the imperial prison in progress. The whereabouts of the Governor and his fearsome Dreadnaught remain a mystery.";
System.infoForSystem(6,13).productivity = 73920;
System.infoForSystem(6,13).population = 67; 
System.infoForSystem(6,13).inhabitants = "Resisting Harmless Fat Birds";
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. In response to the use of capital ships against civilian targets, the system is providing military aid to the Eszausveian People's Popular Front.";
}

// The Description productivity, population and inhabitants of Eszausve changes again after the 15th News Broadcast is seen.
if (missionVariables.assassins_rebooted_stage > 50 && missionVariables.assassins_rebooted_stage < 55) {
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. The People's Popular Front has taken control of the main station and the former imperial prison. Whilst GalCop has recognised the rebels as the lawful government, imperial forces remain in control of much of the system and a bitter civil war is in progress.";
System.infoForSystem(6,13).productivity = 65246;
System.infoForSystem(6,13).population = 65; 
System.infoForSystem(6,13).inhabitants = "Waring Harmless Fat Birds";
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. In response to the use of capital ships against civilian targets, the system is providing military aid to the Eszausveian People's Popular Front.";
}

// The Description, productivity and population are changed again at the time of the OXZ's final mission to destroy the Imperial Dreadnaught.
if (missionVariables.assassins_rebooted_stage === 55) {
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. Although the rebels have fought bravely, the spark of freedom appears about to be snuffed out by the arrival in the system of the Imperial Dreadnaught. The rebels are making a desperate last stand against the Dreadnaught near the rocky moon, Columba.";
System.infoForSystem(6,13).productivity = 62131;
System.infoForSystem(6,13).population = 64; 
System.infoForSystem(6,13).inhabitants = "Waring Harmless Fat Birds";
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. In response to the use of capital ships against civilian targets, the system is providing military aid to the Eszausveian People's Popular Front.";
}

// The Description, productivity and population are changed again after the player destroys the Dreadnaught.
if (missionVariables.assassins_rebooted_civil_war === 3) {
System.infoForSystem(6,13).productivity = 62131;
System.infoForSystem(6,13).population = 64; 
System.infoForSystem(6,13).inhabitants = "Liberated Harmless Fat Birds";
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean. The death of Governor Tarkin has left the People's Popular Front victorious in the recent civil war, with demoralised imperial troops surrendering in droves. The interim government will shortly be organising free and fair elections and petitioning GalCop for formal recognition as a democratic system in the Galactic Registry.";
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. The inhabitants are known for assisting others to achieve democratic enlightenment, providing significant military aid to democratic forces during the recent Eszausveian civil war.";
}

// At the end of the OXZ Eszausve becomes a democracy and it is set to its final state. 
if (missionVariables.assassins_rebooted_civil_war === "Over") {
System.infoForSystem(6,13).government = 6;
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean. Following a long period of civil war, the former dictatorship was overthrown and replaced with a democratic republic under the guidance of elected First Citizen Lucien Lachance. Commercial research is underway within the system into using graviton powered reactors as a source of clean and sustainable energy.";
System.infoForSystem(6,13).productivity = 77203;
System.infoForSystem(6,13).population = 65;
System.infoForSystem(6,13).inhabitants = "Harmless Fat Birds";
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. The inhabitants are known for assisting others to achieve democratic enlightenment, providing significant military aid to democratic forces during the recent Eszausveian civil war.";
}

// Changes to the 6 systems within 7 light years of Ateslete as the Malfunctioning BattleBots escape and spread out.
// The Qudior system.
if (missionVariables.assassins_rebooted_battlebot_escape_level > 1 || missionVariables.assassins_rebooted_battlebot_escape_level === "Complete") {
System.infoForSystem(6,181).description = "This planet is beset by deadly earthquakes. Many Commanders have reported being attacked by groups of strange, wasp-like ships in this system.";
}
// The Erdiares system.
if (missionVariables.assassins_rebooted_battlebot_escape_level > 2 || missionVariables.assassins_rebooted_battlebot_escape_level === "Complete") {
System.infoForSystem(6,20).description = "This world is most fabled for Erdiaresian evil juice but cursed by dreadful solar activity. In addition to the ever present threat from pirates, Commanders travelling to this system often claim to have been attacked by tiny ships.";
}
// The Cemaer system.
if (missionVariables.assassins_rebooted_battlebot_escape_level > 3 || missionVariables.assassins_rebooted_battlebot_escape_level === "Complete") {
System.infoForSystem(6,171).description = "The planet Cemaer is mildly notable for Cemaerian Arusno water. Traders brave enough to enter this system often complain that the local pirates are assisted by swarms of small Thargon-like ships.";
}
// The Onarmala system.
if (missionVariables.assassins_rebooted_battlebot_escape_level > 4 || missionVariables.assassins_rebooted_battlebot_escape_level === "Complete") {
System.infoForSystem(6,185).description = "Whilst Onarmala is an unremarkable dump, swarms of aggressive tiny ships tend to provide some excitement for Commanders entering the System.";
}
// The Gegeso system.
if (missionVariables.assassins_rebooted_battlebot_escape_level > 5 || missionVariables.assassins_rebooted_battlebot_escape_level === "Complete") {
System.infoForSystem(6,65).description = "The world Gegeso is reasonably noted for its fabulous goat burgers and the Gegesoian evil poet. Whilst visitors to the system would be wise to exercise caution against the threat posed by evil poets, swarms of tiny ships lurking in the spacelanes are more perilous.";
}
// The Esleve system.
if (missionVariables.assassins_rebooted_battlebot_escape_level === "Complete") {
System.infoForSystem(6,44).description = "This world is most fabled for its inhabitants' ingrained silliness but scourged by deadly civil war. Groups of small wasp-like ships have been seen in this system.";
}
// Closing Bracket for StartUp
}

this.startUpComplete = function() {
// Check for Stranger's World and the Galactic Almanac being installed.
// As it moves planets under exiting hyperspace and launching, we have to wait until stanger's world has populated a system when launching from a saved game before
// Assassins adds any objects to a system, otherwise they will be moved to the wrong positions by strangers world. This check isn't necessary with any other OXZ so we
// only want to run this check when strangers world is installed.
delete missionVariables.assassins_rebooted_stranger_installed;
delete missionVariables.assassins_rebooted_stranger_has_populated;
delete missionVariables.assassins_rebooted_almanac_installed;
if (worldScripts.PlanetEngine) {
missionVariables.assassins_rebooted_stranger_installed = "Yes";
}
if (worldScripts.SpawnMoons) {
missionVariables.assassins_rebooted_stranger_installed = "Yes";
}
if (worldScripts.RandomStationNames) {
missionVariables.assassins_rebooted_almanac_installed = "Yes";
}
// Defined here so that the F4 Screen Status Page is set up. This is only available once you have joined the Guild and only whilst you are in Galaxy 7.
this.shipDockedWithStation(player.ship.dockedStation);
//Closing Bracket for StartUpComplete
}
// We are going to do all our adding of stuff under this.systemWillPopulate.
// On exiting hyperspace this system will populate runs and strangers world does it's moving stuff around.
// By scripting a 0.19 second delay, we ensure that we are only adding assassins stuff after stranger's world has run.
// However, when loading from a save game, strangers world will not run until the player launches.
// This means on loading from a save game we can't add anything until the player has launched for the first time.
// So the first time the player launches we are going to flag this with a mission variable.
this.shipWillLaunchFromStation = function() {
// Clear the Assassins Guild F4 Screen Interface when launching.
player.ship.dockedStation.setInterface("assassins_rebooted_death_note",null);
// Clear Variable for Assassins Stations docking fee.
delete missionVariables.assassins_rebooted_docking_fee;
// Only make this check if Stanger's World is installed and this is our first launch since loading a save game.
if (galaxyNumber === 6) {
if (missionVariables.assassins_rebooted_stranger_installed === "Yes" && !missionVariables.assassins_rebooted_stranger_has_populated) {
{ this.scriptDelay_assassins_populator = new Timer(this, this.assassins_populator, 0.19); }
missionVariables.assassins_rebooted_stranger_has_populated = "Yes";
}
// Attacks when launching from a station by revenge ships at various stages of the OXZ.
if (missionVariables.assassins_rebooted_interlude === "Yes") {
// Attacks by Inno Soin
if (missionVariables.assassins_rebooted_stage === 11 && missionVariables.assassins_rebooted_jumpcounter > 2) {
system.addShips("assassins_rebooted_inno_soin",1,player.ship.position.add([10000,0,0]),10560)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_stage = 11.5;
// Closing Bracket for attacks by Inno Soin.
}
// One Off Ambush by a Triad Hit Ship waiting for the player 8kms to 9kms from the station the player has just launched from.
if (missionVariables.assassins_rebooted_stage === 37 && missionVariables.assassins_rebooted_jumpcounter > 0) {
system.addShips("assassins_rebooted_triad_wasp_type1",1,player.ship.position.add([1000,0,0]),8560)[0];
missionVariables.assassins_rebooted_stage = 38;
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// Closing Bracket for all attacks upon launching.
}
// Closing Bracket for Galaxy 7.
}
// Closing Bracket for shipWillLaunchFromStation
}

// On each hyperspace jump made the jump counter is advanced, this is used to script short delays in events occuring.
// If the Corpse Bride Station was hostile to the player due to the player attacking it, then this is cleared on exiting hyperspace.
this.shipExitedWitchspace = function (){
delete missionVariables.assassins_rebooted_corpse_bride_hostile;
// Whilst the Assassins missions are running, increase the jump counter each time the player makes a hyperspace jump.
// Scripted events and offers of missions occur every so many jumps since the last event, so some playtime always passes between news broadcasts and
// offers of missions and updates on ongoing missions.
missionVariables.assassins_rebooted_jumpcounter++;
if (missionVariables.assassins_rebooted_stage !== "Complete") {
// Only increment the robot escape timer whilst the escape is in progress.
if (missionVariables.assassins_rebooted_battlebot_escape_level > 0 && missionVariables.assassins_rebooted_battlebot_escape_level !=="Complete") {
// The escape timer is never reset (unlike the jumpcounter). Once thiry jumps have been made, all systems within 7 light years of Ateslete will have become infested
// with Malfunctioning BattleBots. At this point the escape level reaches Complete. The timer variable is deleted and this section of the code is not run again.
// Malfunctioning BattleBots replace pirates at the infected systems. This is done with a shipdata conditions check that the player is at one of the 6 infected system and
// the escape level is either Complete or has reach the number needed to infest that system.
missionVariables.assassins_rebooted_battlebot_escape_timer++;
// The Qudior system becomes infested after 5 jumps.
if (missionVariables.assassins_rebooted_battlebot_escape_level === 1 && missionVariables.assassins_rebooted_battlebot_escape_timer > 4) {
missionVariables.assassins_rebooted_battlebot_escape_level = 2;
System.infoForSystem(6,181).description = "This planet is beset by deadly earthquakes. Many Commanders have reported being attacked by groups of strange, wasp-like ships in this system.";
}
// The Erdiares system becomes infested after 10 jumps.
if (missionVariables.assassins_rebooted_battlebot_escape_level === 2 && missionVariables.assassins_rebooted_battlebot_escape_timer > 9) {
missionVariables.assassins_rebooted_battlebot_escape_level = 3;
System.infoForSystem(6,20).description = "This world is most fabled for Erdiaresian evil juice but cursed by dreadful solar activity. In addition to the ever present threat from pirates, Commanders travelling to this system often claim to have been attacked by tiny ships.";
}
// The Cemaer system becomes infested after 15 jumps.
if (missionVariables.assassins_rebooted_battlebot_escape_level === 3 && missionVariables.assassins_rebooted_battlebot_escape_timer > 14) {
missionVariables.assassins_rebooted_battlebot_escape_level = 4;
System.infoForSystem(6,171).description = "The planet Cemaer is mildly notable for Cemaerian Arusno water. Traders brave enough to enter this system often complain that the local pirates are assisted by swarms of small Thargon-like ships.";
}
// The Onarmala system becomes infested after 20 jumps.
if (missionVariables.assassins_rebooted_battlebot_escape_level === 4 && missionVariables.assassins_rebooted_battlebot_escape_timer > 19) {
missionVariables.assassins_rebooted_battlebot_escape_level = 5;
System.infoForSystem(6,185).description = "Whilst Onarmala is an unremarkable dump, swarms of aggressive tiny ships tend to provide some excitement for Commanders entering the System.";
}
// The Gegeso system becomes infested after 25 jumps.
if (missionVariables.assassins_rebooted_battlebot_escape_level === 5 && missionVariables.assassins_rebooted_battlebot_escape_timer > 24) {
missionVariables.assassins_rebooted_battlebot_escape_level = 6;
System.infoForSystem(6,65).description = "The world Gegeso is reasonably noted for its fabulous goat burgers and the Gegesoian evil poet. Whilst visitors to the system would be wise to exercise caution against the threat posed by evil poets, swarms of tiny ships lurking in the spacelanes are more perilous.";
}
// The Esleve system becomes infested after 30 jumps.
if (missionVariables.assassins_rebooted_battlebot_escape_level === 6 && missionVariables.assassins_rebooted_battlebot_escape_timer > 29) {
missionVariables.assassins_rebooted_battlebot_escape_level = "Complete";
System.infoForSystem(6,44).description = "This world is most fabled for its inhabitants' ingrained silliness but scourged by deadly civil war. Groups of small wasp-like ships have been seen in this system.";
delete missionVariables.assassins_rebooted_battlebot_escape_timer;
}
// Closing Bracket for Code only run when the BattleBot escape is in progress.
}
// Closing Bracket for code only run whilst the Assassins Missions are running.
}
// Closing Bracket for exiting witchspace.
}

this.systemWillPopulate = function() {
// Always reaward disabled Clocking Devices and Energy Bombs whilst the Assassins missions are running.
// The Victim Ship's script disables only when it is spawned (IE the player is in the same system and the mission relating to it is running).
// The Victim Ship's scripted death actions also reaward if disabled.
if (missionVariables.assassins_rebooted_stage !== "Complete") {
if (player.ship.equipmentStatus("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_CLOAK");
player.ship.awardEquipment("EQ_CLOAKING_DEVICE");
}
if (player.ship.equipmentStatus("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB") === "EQUIPMENT_OK") {
player.ship.removeEquipment("EQ_ASSASSINS_REBOOTED_REMOVED_BOMB");
player.ship.awardEquipment("EQ_ENERGY_BOMB");
}
// Close of Bracket for Assassins not being Complete.
}
// The whole of the Assassins Script for adding planets, moons, stations and ships is bracketed off to only be checked in Galaxy 7.
if (galaxyNumber === 6) {
// Second Check that we are in not only in Galaxy 7 but we are also at one of the ten systems where assassins is adding stuff to the system.
// The assassins_populator function adds all the planets, moons stations and ships which are always present at the modified systems.
//  It also adds missions ships to particular systems when the stage variable is at the stage where they need to be added for the mission.
if (system.ID === 73 ||  system.ID === 107 || system.ID === 194 || system.ID === 203 || system.ID === 39 || system.ID === 53 || system.ID === 18 || 
system.ID === 81 || system.ID === 82 || system.ID === 13 || system.ID === 71) {
// Wait until OXZs such as Strangers World and Orbits have finished moving planets around before we add anything to the system.
// This makes sure that the Assassins objects are always added at the exact co-ordinates set in planetinfo and in this main script.
// Without this check Strangers World / Orbits will move the objects from their co-ordinates so neither the planets moons, stations or mission ships will be where they should be.
{ this.scriptDelay_assassins_populator = new Timer(this, this.assassins_populator, 0.19); } // Run the Populator Function.
// Closing Bracket for populating Assassins Systems.
}
// At certain stages of the OXZ the player may be attacked in any Galaxy 7 system by the Soin Clan, vengeful hocky fans or triad hitmen.
// During these phases of the OXZ, the interlude variable is set to Yes and ships are spawned in whichever system the player is in, depending on the stage the OXZ is at.
if (missionVariables.assassins_rebooted_interlude === "Yes") {
// Attack by Vengful Soin Clan Sisters in Micro Mambas
if (missionVariables.assassins_rebooted_stage === 9) {
// Nothing will happen on the first jump, but on the second jump a group of 3 Soin Clan Micro Mambas are added in the space lane. They will fly between the witchpoint and
// the main station. If they encounter the player they will attack. During the Soin Clan attack, the jump counter is not reset, so different groups of Soin Clan ships are added
// to the system on jumps 2 to 10. The player won't necessarily encounter any or all of the Soin Clan ships on each jump however.
// As the jump counter triggers after the script test here, the test is for one less than the value of the jump counter.
if (missionVariables.assassins_rebooted_jumpcounter === 1) {
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type1", 1, "wpu", [0, 0, 0.55])
}
// On the 3rd jump 3 groups of three ships are added in the spacelanes with AIs to go to the witchpoint, planet and sun respectively.
if (missionVariables.assassins_rebooted_jumpcounter === 2) {
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type1", 1, "wpu", [0, 0, 0.35])
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type2", 1, "wpu", [0, 0, 0.65])
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type3", 1, "wpu", [0, 0, 0.85])
}
// On the 4th jump, the player will be ambushed at the witchpoint by a group of 3 Micro Mambas. Another group of 3 Micro Mambas are also added in the spacelane.
if (missionVariables.assassins_rebooted_jumpcounter === 3) {
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type1", 1, "wpu", [0, 0, 0.0])
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type2", 1, "wpu", [0, 0, 0.45])
}
// On the 5th jump a group of 3 Micro Mambas with an AI to go to the sun are added near the witchpoint
if (missionVariables.assassins_rebooted_jumpcounter === 4) {
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type3", 1, "wpu", [0, 0, 0.10])
}
// On the 6th jump a group of 3 Micro Mambas will be lurking near the main station.
if (missionVariables.assassins_rebooted_jumpcounter === 5) {
system.addShips("assassins_rebooted_soin_sister_leader_type4",1,system.mainStation.position.add([20000,0,0]), 1000)[0];
}
// On the 7th jump a group of 3 Micro Mambas with an AI to go to the witchpoint are added 40.5kms from the witchpoint. 
// A second group with an AI to go to the nearest OXZ station and then go to the main station and wait there are added in the spacelane.
if (missionVariables.assassins_rebooted_jumpcounter === 6) {
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type1", 1, "wpu", [0, 0, 0.25])
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type4", 1, "wpu", [0, 0, 0.65])
}
// On the 8th jump a group of 3 Micro Mambas are added in the spacelane with an AI to go to the main planet.
if (missionVariables.assassins_rebooted_jumpcounter === 7) {
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type1", 1, "wpu", [0, 0, 0.30])
}
// On the 9th jump a group of 3 Micro Mambas with an Ai to go to the Main Station and wait there are added near the main station.
if (missionVariables.assassins_rebooted_jumpcounter === 8) {
system.legacy_addShipsAt("assassins_rebooted_soin_sister_leader_type4", 1, "wpu", [0, 0, 0.90])
}
// On the 10th jump no ships are added and the stage variable is advanced to 10.
// The next time the player docks anywhere after making 10 jumps, they will recieve an update on the Soin Clan situation from the Guild.
if (missionVariables.assassins_rebooted_jumpcounter === 9) {
missionVariables.assassins_rebooted_stage = 10;
}
// Closing Bracket for attacks by the Soin Clan Sisters.
}
// Attacks by Inno Soin at the witchpoint.
// If the player got away before he could detonate on his first attack on launching, he will reappear at the witchpoint two jumps later.
if (missionVariables.assassins_rebooted_stage === 11.5 && missionVariables.assassins_rebooted_jumpcounter >1) {
// Reset so that if he again does not detonate, he will attack again the next time the player launches after making at least three more jumps.
system.legacy_addShipsAt("assassins_rebooted_inno_soin", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_stage = 11;
missionVariables.assassins_rebooted_jumpcounter = 0;
// Closing Bracket for attacks by Inno Soin.
}
// Attacks by Zero-G Hocky Fans.
if (missionVariables.assassins_rebooted_stage === 28) {
// On the second jump since seeing the News Broadcast warning that Hocky Fans are hunting for the player, a group of 3 Hocky Fans will be lurking by the Main Station. 
if (missionVariables.assassins_rebooted_jumpcounter === 1) {
system.addShips("assassins_rebooted_hocky_fan_type1",1,system.mainStation.position.add([10000,0,0]), 1000)[0];
}
// On the third jump a group of 3 Hocky Fans are added in the spacelane fairly near the witchpoint with an AI to fly towards the witchpoint.
if (missionVariables.assassins_rebooted_jumpcounter === 2) {
system.legacy_addShipsAt("assassins_rebooted_hocky_fan_type2", 1, "wpu", [0, 0, 0.11])
}
// On the fourth jump a group of 3 Hocky Fans will ambush the player at the witchpoint.
if (missionVariables.assassins_rebooted_jumpcounter === 3) {
system.legacy_addShipsAt("assassins_rebooted_hocky_fan_type3", 1, "wpu", [0, 0, 0.00])
}
// On the 5th jump, no ships are added and the stage variable is advanced to 29. No more hocky fans will appear and the player will recieve an update from the guild.
// the next time they dock anywhere except Ataneris.
if (missionVariables.assassins_rebooted_jumpcounter > 3) {
missionVariables.assassins_rebooted_stage = 29;
missionVariables.assassins_rebooted_interlude = "No";
}
// Closing Bracket for attacks for Zero-G Hocky Fans.
}
// Attacks by Triad Wasps.
if (missionVariables.assassins_rebooted_stage === 38) {
// After the player has made one jump since being paid for killing the Triad Boss, the player will be attacked by a Triad Hit Ship the next time they launch from any
// Station. This is handled under this.ship.will.launch. Once this ship has attacked, the jump counter is set back to zero and the stage advances to 38.
// During this phase (until 4 jumps have been made), if the player goes to the Triad home system of Esreates, there will always be one Triad Hit Ship at the witchpoint. 
if (system.ID === 100) {
system.legacy_addShipsAt("assassins_rebooted_triad_wasp_type4", 1, "wpu", [0, 0, 0.0])
}
// On the 1st jump after being attacked outside the station, nothing will happen. On the second jump a Triad hit ship with an AI to go to the witchpoint and attack the player
// is added near to the witchpoint.
if (missionVariables.assassins_rebooted_jumpcounter === 1) {
system.legacy_addShipsAt("assassins_rebooted_triad_wasp_type2", 1, "wpu", [0, 0, 0.0])
}
// On the third jump the player will again be jumped at the witchpoint by a triad hit ship.
if (missionVariables.assassins_rebooted_jumpcounter === 2) {
system.legacy_addShipsAt("assassins_rebooted_triad_wasp_type3", 1, "wpu", [0, 0, 0.0])
}
// Once 4 jumps have been made, no more Triad Hit-Ships will appear and a News Broadcast reporting that the Triad Leaders have been arrested will be shown
// the next time the player docks at any station.
if (missionVariables.assassins_rebooted_jumpcounter > 3) {
missionVariables.assassins_rebooted_stage = 39;
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_interlude = "No";
}
// Closing Bracket for Triad Hit-Ship attacks.
}
// Imperial Mongoose attack.
if (missionVariables.assassins_rebooted_stage === 52) {
// Two jumps after seeing the 16th News Broadcast, the player will be attacked at the witchpoint by a group of Imperial Mongoose fighters trying to take revenge for the
// assassination of the Sky Marshal. This is a one off attack and the next mission is offered upon docking having made a total of 5 jumps since seeing the 16th News
// broadcast. The mission is offered after 5 jumps regardless of whether the player fights the attacking imperial ships or not. Once the ships have attacked the interlude
// variable is set to No, so this section of the script is not checked again. The jump counter is not reset, so the next event happens once 5 jumps have been made since
// the News Broadcast was seen.
if (missionVariables.assassins_rebooted_jumpcounter > 0) {
// Add the Mongoose Leader with 4 wingmen.
system.legacy_addShipsAt("assassins_rebooted_vengence_mongoose_fugitive_leader", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_interlude = "No";
}
// Closing Bracket for Imperial Mongoose attack.
}
//Closing Bracket for populating systems during interludes.
}
// Unlocked Ships
// Once the OXZ is completed, there is a small chance of encountering some of the ships from Assassins in any system whilst the
// player remains in Galaxy 7. A check is only made after 5 jumps. If the chance of a ship appearing is triggered then the
// jump counter is reset to zero and thus there is no chance of encountering a ship again until at least 5 more jumps have been
// made. The chance and which ships may be encountered also depends on system govenment type and tech level.
if (missionVariables.assassins_rebooted_stage === "Complete" && missionVariables.assassins_rebooted_jumpcounter > 4) {
// Roll a Twenty Sided Die.
var diceroll = expandDescription("[assassins-twenty-sided-dice-roll]");
// Anarchy & Feudal Systems
if (system.government === 0 || system.government === 1) {
// 5% Chance of a group of three Offender Mongoose Fighters appearing near the main station.
// These ships are not hostile to the player unless attacked, but will attack any traders they encounter.
if (diceroll === "1") {
system.addShips("assassins_rebooted_unlocked_mongoose_squad",1,system.mainStation.position.add([15000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Offender Mongoose Fighters appearing in the spacelane.
if (diceroll === "2") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_mongoose_squad", 1, "wpu", [0, 0, 0.55])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Offender Mongoose Fighters appearing at the witchpoint.
if (diceroll === "3") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_mongoose_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of a fugitive Scorpion and two Offender Mongoose escorts appearing near the main station.
// These ships are not hostile to the player unless attacked, but will attack any traders they encounter.
if (diceroll === "4") {
system.addShips("assassins_rebooted_unlocked_scorpion_squad",1,system.mainStation.position.add([18000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of a fugitive Scorpion and two Offender Mongoose escorts appearing in the spacelane.
if (diceroll === "5") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_scorpion_squad", 1, "wpu", [0, 0, 0.45])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of a fugitive Scorpion and two Offender Mongoose escorts appearing at the witchpoint.
if (diceroll === "6") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_scorpion_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of a fugitive Deamon and two Scorpion escorts appearing near the main station.
// These ships are not hostile to the player unless attacked, but will attack any traders they encounter.
if (diceroll === "7") {
system.addShips("assassins_rebooted_unlocked_deamon_squad",1,system.mainStation.position.add([15000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of a fugitive Deamon and two Scorpion escorts appearing in the spacelane.
if (diceroll === "8") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_deamon_squad", 1, "wpu", [0, 0, 0.35])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of a fugitive Deamon and two Scorpion escorts appearing at the witchpoint.
if (diceroll === "9") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_deamon_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Triad Wasps appearing near the main station.
// These ships are not hostile to the player unless attacked, but will attack any traders they encounter.
if (diceroll === "10") {
system.addShips("assassins_rebooted_unlocked_wasp_squad",1,system.mainStation.position.add([13000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Triad Wasps appearing in the spacelane.
if (diceroll === "11") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_wasp_squad", 1, "wpu", [0, 0, 0.25])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Triad Wasps appearing at the witchpoint.
if (diceroll === "12") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_wasp_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// Closing Bracket for Anarchy & Feudal Systems.
}
// Multi-Government & Dictatorship Systems.
if (system.government === 2 || system.government === 3) {
// 5% Chance of a group of 3 Military Aeron Class Frigates patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "1") {
system.addShips("assassins_rebooted_unlocked_aeron_station_patrol_squad",1,system.mainStation.position.add([12000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military Aeron Class Frigates appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "2") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_aeron_system_patrol_squad", 1, "wpu", [0, 0, 0.45])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military Aeron Class Frigates appearing at the witchpoint
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "3") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_aeron_system_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Offender Mongoose Fighters appearing near the main station.
// These ships are not hostile to the player unless attacked, but will attack any traders they encounter.
if (diceroll === "4") {
system.addShips("assassins_rebooted_unlocked_mongoose_squad",1,system.mainStation.position.add([20000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Offender Mongoose Fighters appearing in the spacelane.
if (diceroll === "5") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_mongoose_squad", 1, "wpu", [0, 0, 0.35])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Offender Mongoose Fighters appearing at the witchpoint.
if (diceroll === "6") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_mongoose_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three fugitive Scorpion Frigates appearing near the main station.
// These ships are not hostile to the player unless attacked, but will attack any traders they encounter.
if (diceroll === "7") {
system.addShips("assassins_rebooted_unlocked_scorpion_squad2",1,system.mainStation.position.add([10000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three fugitive Scorpion Frigates appearing in the spacelane.
if (diceroll === "8") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_scorpion_squad2", 1, "wpu", [0, 0, 0.55])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three fugitive Scorpion Frigates appearing at the witchpoint.
if (diceroll === "9") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_scorpion_squad2", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Triad Wasps appearing near the main station.
// These ships are not hostile to the player unless attacked, but will attack any traders they encounter.
if (diceroll === "10") {
system.addShips("assassins_rebooted_unlocked_wasp_squad",1,system.mainStation.position.add([16000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Triad Wasps appearing in the spacelane.
if (diceroll === "11") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_wasp_squad", 1, "wpu", [0, 0, 0.50])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Triad Wasps appearing at the witchpoint.
if (diceroll === "12") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_wasp_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// Closing bracket for Multi-Government & Dictatorship Systems.
}
// Communist & Confederacy Systems.
if (system.government === 4 || system.government === 5) {
// 5% Chance of a group of 3 Military Aeron Class Frigates patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "1") {
system.addShips("assassins_rebooted_unlocked_aeron_station_patrol_squad",1,system.mainStation.position.add([8000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military Aeron Class Frigates appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "2") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_aeron_system_patrol_squad", 1, "wpu", [0, 0, 0.15])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military Aeron Class Frigates appearing at the witchpoint
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "3") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_aeron_system_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military BattleBots patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "4") {
system.addShips("assassins_rebooted_unlocked_battlebot_station_patrol_squad",1,system.mainStation.position.add([8000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military BattleBots appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "5") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_system_patrol_squad", 1, "wpu", [0, 0, 0.35])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military BattleBots appearing at the Witchpoint.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "6") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_system_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Special Branch Courier appearing near the main station.
// This ship will pick a random station within 1,000km of its starting position, fly to it and dock with it. It will accept distress
// calls and attack any Thargoids or criminals it encounters.
if (diceroll === "7") {
system.addShips("assassins_rebooted_unlocked_special_branch_courier",1,system.mainStation.position.add([23000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Special Branch Courier appearing in the spacelane.
// This ship will pick a random station within 1,000km of its starting position, fly to it and dock with it. It will accept distress
// calls and attack any Thargoids or criminals it encounters.
if (diceroll === "8") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_special_branch_courier", 1, "wpu", [0, 0, 0.65])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Special Branch Courier appearing at the Witchpoint.
// This ship will pick a random station within 1,000km of its starting position, fly to it and dock with it. It will accept distress
// calls and attack any Thargoids or criminals it encounters.
if (diceroll === "9") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_special_branch_courier", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Nemesis Courier appearing near the main station.
// This ship will either go to the main station and dock with it or go to the witchpoint and dock with a random station within 500kms
// of the witchpoint. It will not attack any ship unless it is attacked first.
if (diceroll === "10") {
system.addShips("assassins_rebooted_unlocked_nemesis_courier",1,system.mainStation.position.add([19000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Nemesis Courier appearing in the spacelane.
// This ship will either go to the main station and dock with it or go to the witchpoint and dock with a random station within 500kms
// of the witchpoint. It will not attack any ship unless it is attacked first.
if (diceroll === "11") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_nemesis_courier", 1, "wpu", [0, 0, 0.25])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Nemesis Courier appearing at the Witchpoint.
// This ship will either go to the main station and dock with it or go to the witchpoint and dock with a random station within 500kms
// of the witchpoint. It will not attack any ship unless it is attacked first.
if (diceroll === "12") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_nemesis_courier", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// Closing bracket for Communist & Confederacy Systems.
}
// Democratic & Corporate States.
if (system.government === 6 || system.government === 7) {
// 5% Chance of a group of 3 Military Aeron Class Frigates patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "1") {
system.addShips("assassins_rebooted_unlocked_aeron_station_patrol_squad",1,system.mainStation.position.add([12000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military Aeron Class Frigates appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "2") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_aeron_system_patrol_squad", 1, "wpu", [0, 0, 0.55])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military Aeron Class Frigates appearing at the witchpoint
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "3") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_aeron_system_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military BattleBots patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "4") {
system.addShips("assassins_rebooted_unlocked_battlebot_station_patrol_squad",1,system.mainStation.position.add([16000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military BattleBots appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "5") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_system_patrol_squad", 1, "wpu", [0, 0, 0.40])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military BattleBots appearing at the Witchpoint.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "6") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_system_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Special Branch Courier appearing near the main station.
// This ship will pick a random station within 1,000km of its starting position, fly to it and dock with it. It will accept distress
// calls and attack any Thargoids or criminals it encounters.
if (diceroll === "7") {
system.addShips("assassins_rebooted_unlocked_special_branch_courier",1,system.mainStation.position.add([11000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Special Branch Courier appearing in the spacelane.
// This ship will pick a random station within 1,000km of its starting position, fly to it and dock with it. It will accept distress
// calls and attack any Thargoids or criminals it encounters.
if (diceroll === "8") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_special_branch_courier", 1, "wpu", [0, 0, 0.80])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Special Branch Courier appearing at the Witchpoint.
// This ship will pick a random station within 1,000km of its starting position, fly to it and dock with it. It will accept distress
// calls and attack any Thargoids or criminals it encounters.
if (diceroll === "9") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_special_branch_courier", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "10") {
system.addShips("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad",1,system.mainStation.position.add([10000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "11") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad", 1, "wpu", [0, 0, 0.65])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots appearing at the witchpoint
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "12") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// Closing bracket for Democratic & Corporate States.
}
// Tech Level of 10 or more.
if (system.techLevel > 9) {
// The same dice roll is used for all checks. A roll of 1 to 12 produces an encounter (but only every 5 jumps) as set out under
// the govenment types above. Regardless of the govenment type, a roll of 13 to 18 will result in battle bots appearing. In high
// tech systems therefore a roll of 1 to 18 rather than 1 to 12 produces an encounter.
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "13") {
system.addShips("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad",1,system.mainStation.position.add([14000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "14") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad", 1, "wpu", [0, 0, 0.75])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots appearing at the witchpoint
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "15") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Navy BattleBot Interceptors patrolling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "16") {
system.addShips("assassins_rebooted_unlocked_battlebot_interceptor_station_patrol_squad",1,system.mainStation.position.add([16000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Navy BattleBot Interceptors appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "17") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_interceptor_system_patrol_squad", 1, "wpu", [0, 0, 0.40])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Navy BattleBot Interceptors appearing at the witchpoint
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "18") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_interceptor_system_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// Closing Bracket for Tech Level of 10 or more.
}
// If 10 jumps or more have been made without an encounter then the chance of a ship being added becomes 100% as the die is
// re-rolled with an encounter on all numbers between 1 and 20.
if (missionVariables.assassins_rebooted_jumpcounter > 9) {
var diceroll = expandDescription("[assassins-twenty-sided-dice-roll]");
// 5% Chance of a group of 3 Military Aeron Class Frigates patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "1") {
system.addShips("assassins_rebooted_unlocked_aeron_station_patrol_squad",1,system.mainStation.position.add([19000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military Aeron Class Frigates appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "2") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_aeron_system_patrol_squad", 1, "wpu", [0, 0, 0.65])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military Aeron Class Frigates appearing at the witchpoint
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "3") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_aeron_system_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military BattleBots patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "4") {
system.addShips("assassins_rebooted_unlocked_battlebot_station_patrol_squad",1,system.mainStation.position.add([14000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military BattleBots appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "5") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_system_patrol_squad", 1, "wpu", [0, 0, 0.55])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Military BattleBots appearing at the Witchpoint.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "6") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_system_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Special Branch Courier appearing near the main station.
// This ship will pick a random station within 1,000km of its starting position, fly to it and dock with it. It will accept distress
// calls and attack any Thargoids or criminals it encounters.
if (diceroll === "7") {
system.addShips("assassins_rebooted_unlocked_special_branch_courier",1,system.mainStation.position.add([13000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Special Branch Courier appearing in the spacelane.
// This ship will pick a random station within 1,000km of its starting position, fly to it and dock with it. It will accept distress
// calls and attack any Thargoids or criminals it encounters.
if (diceroll === "8") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_special_branch_courier", 1, "wpu", [0, 0, 0.45])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Special Branch Courier appearing at the Witchpoint.
// This ship will pick a random station within 1,000km of its starting position, fly to it and dock with it. It will accept distress
// calls and attack any Thargoids or criminals it encounters.
if (diceroll === "9") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_special_branch_courier", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "10") {
system.addShips("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad",1,system.mainStation.position.add([11000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "11") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad", 1, "wpu", [0, 0, 0.35])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots appearing at the witchpoint
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "12") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots patroling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "13") {
system.addShips("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad",1,system.mainStation.position.add([8000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "14") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad", 1, "wpu", [0, 0, 0.25])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a Navy Control Drone escorted by 4 Navy BattleBots appearing at the witchpoint
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "15") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_control_drone_station_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Navy BattleBot Interceptors patrolling around the main station.
// These ships will attack any Thargoids or criminals they encounter.
if (diceroll === "16") {
system.addShips("assassins_rebooted_unlocked_battlebot_interceptor_station_patrol_squad",1,system.mainStation.position.add([7000,0,0]), 1000)[0];
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Navy BattleBot Interceptors appearing in the spacelane.
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "17") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_interceptor_system_patrol_squad", 1, "wpu", [0, 0, 0.15])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of 3 Navy BattleBot Interceptors appearing at the witchpoint
// These ships will patrol the system and attack any Thargoids or criminals they encounter.
if (diceroll === "18") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_battlebot_interceptor_system_patrol_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a single Nemesis Courier appearing in the spacelane.
// This ship will either go to the main station and dock with it or go to the witchpoint and dock with a random station within 500kms
// of the witchpoint. It will not attack any ship unless it is attacked first.
if (diceroll === "19") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_nemesis_courier", 1, "wpu", [0, 0, 0.20])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// 5% Chance of a group of three Triad Wasps appearing at the witchpoint.
if (diceroll === "20") {
system.legacy_addShipsAt("assassins_rebooted_unlocked_wasp_squad", 1, "wpu", [0, 0, 0.0])
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// Closing bracket for the jump counter reaching 10 or more.
}
// Closing Bracket for Unlocked Ships
}
// Closing Backet for code only run in Galaxy 7.
}
// Closing Bracket for this system will populate
}

//Function to Populate all Assassins Systems with planets, moons, ships and stations
this.assassins_populator = function assassins_populator() {
// If Strangers World is installed we don't want to add anything until after the first launch from a save game.
// So if we haven't yet launched and Strangers world is installed, bail out of the assassins populator and run it on the first launch instead.
if (missionVariables.assassins_rebooted_stranger_installed === "Yes" && !missionVariables.assassins_rebooted_stranger_has_populated) return;
// The main station at each of the systems modified by Assassins is protected by a minesweeper.
// This version is invisible and will suppress q-mines being used near the main station.
system.addShips("assassins_rebooted_minesweeper_hidden",1,system.mainStation.position.add([6500,0,0]), 1000)[0];
// Populate Orramaor 
if (system.ID === 73) {
// The resort planet Appollodrus is always added regardless of whether any missions are running or not.
var apollodorus = system.addPlanet("assassins_rebooted_Apollodorus"); 
apollodorus.displayName = "Apollodorus (Planet)";
// Because we have given it a display name, Planetary Compass OXZ (if installed) will not assign a name to the moon or give it a beacon.
// If the Galactic Almanac is installed then it will automatically add the name and beacon. But we don't want to do this twice as then it will end up with two beacons on it.
// The Assassins script will only add beacon labels to any planets and moons it adds therefore if the Galactic Almanac is not installed.
// The same code is used to name and add beacons to all the moons, planets and gas giants added by the OXZ.
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_planet", apollodorus.position); 
this.beacon.beaconCode = apollodorus.displayName;
this.beacon.beaconLabel = apollodorus.displayName;
}
// Likewise, The Sunset Retirement Home is always present.
system.legacy_addShipsAt("assassins_rebooted_sunset_retirement_home_station", 1, "pwm", [-100000, -500000, 305000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-100000, -489900, 305000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-100000, -510100, 305000]);
// ***************************************************************************** Story Note *****************************************************************************************
// The 1st Mission to kill Be Soin in his Vintage Adder takes place near the Sunset Retirement Home Station. The station's own script populates space around
// it with a Tourist Shuttle, Tourist Lander and a Tourist Transporter. The Lander and the Shuttle will fly to and land on Apollodorus. The Transporter will fly to the main station
// and dock with it. The script also adds three Tourist Ophidian Yachts, one with an AI to go to the witchpoint and dock with the nearest station to the witchpoint, another with an AI 
// to go to the main station and dock with it and a third with an AI to dock with the Retirement Home. These six ships will always be encountered near the station as their AIs,
// fly around near the station until the player arrives before setting off towards their destinations.

// The stations script also spawns 4 more Ophidian Yachts in a line between the station and the main station at 50, 100, 150 and 300kms from the Retirement Home. These
// ships start flying towards their destinations as soon as they are spawned. One will go to the Retirement Home, the second to the Main Station, the third to a random OXZ
// station within 500kms of its starting point and the fourth with an AI to go to the witchpoint and dock with the nearest station to the witchpoint. The main script adds 10 more yachts
// in the spacelanes with AIs to go to the Retirement Home, Main Station or OXZ stations.

// The transporters, shuttles and landers are all unarmed and will try to flee if attacked. The yachts are armed with a pulse laser and will only attack ships which attack them first.
// None of these ships present any threat to the player and are there for flavour. All these ships are lawful however so attacking them will make the player a fugitive. The Retirement
// Home will launch Micro Mambas armed with Beam Lasers to attack criminal ships nearby to it, but it has no ships on patrol as the first hit is meant to be very easy.

// The station's own script adds Be Soin's Adder, armed with a Pulse Laser about 20kms from the Retirement Home. His ship will stay between 15 to 20 kms from the
// retirement home until the player arrives. When it detects the player it will send a friendly greeting to give away its position and fly to within 10kms of the player before
// heading towards Apollodorus. As his ship is very weak he can be destroyed easily, although the player will become an offender. The station will launch Mambas once 
// Be Soin has been killed, but these do not present a major threat and the player can just leave once Be Soin is dead.

// Assassins also uses a condition script (only run at Orramaor) to override the native populater adding shuttles and hunters. All shittles in the system are replaced with
// Tourist shuttles, transporters and landers with AIs to land on the nearest planet to the station which launched them.  Hunters are replaced with Soin Clan Micro Mambas, 
// Geckos, Kraits, Sidewinders and Morays.

// ***************************************************************************** Story Note *****************************************************************************************
// Add a Tourist Ophidian Yacht fairly near the main station with an AI to go to the main station and dock with it. 
system.addShips("assassins_rebooted_sunset_planet_yacht",1,system.mainStation.position.add([27500,0,0]), 1000)[0];
// Add a Tourist Ophidian Yacht near the player's position with an AI to go to the Retirement Home.
system.addShips("assassins_rebooted_sunset_homebound_yacht",1,player.ship.position.add([17500,0,0]), 2000)[0];
// Add a Tourist Ophidian Yacht in the spacelane with an AI to go to the witchpoint and dock with the nearest station to the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_sunset_outbound_yacht", 1, "wpu", [0, 0, 0.25])
// Add 5 Tourist Ophidian Yachts in the spacelane with an AI to go to the Retirement Home, Main Station or an OXZ station and dock with it.
system.legacy_addShipsAt("assassins_rebooted_sunset_homebound_yacht", 1, "wpu", [0, 0, 0.35])
system.legacy_addShipsAt("assassins_rebooted_sunset_spacelane_yacht", 1, "wpu", [0, 0, 0.45])
system.legacy_addShipsAt("assassins_rebooted_sunset_spacelane_yacht", 1, "wpu", [0, 0, 0.55])
system.legacy_addShipsAt("assassins_rebooted_sunset_outbound_yacht", 1, "wpu", [0, 0, 0.65])
system.legacy_addShipsAt("assassins_rebooted_sunset_homebound_yacht", 1, "wpu", [0, 0, 0.75])
 // Add a Tourist Ophidian Yacht in the spacelane with an AI to go to the main station and dock with it.
system.legacy_addShipsAt("assassins_rebooted_sunset_planet_yacht", 1, "wpu", [0, 0, 0.85])
// Add a Tourist Ophidian Yacht in the spacelane with an AI to go to go to the witchpoint and dock with the nearest station to the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_sunset_outbound_yacht", 1, "wpu", [0, 0, 0.95])
// The first hit takes place in this system - Be Soin in his Vintage Adder is added by the Retirement Home's script when the mission to kill him is running.
// Closing Bracket for Orramaor.
}
// Populate Esrire
if (system.ID === 107) {
// The first mission is handed in at the Station Orbiting the Gas Giant.
// The Gas Giant and station are always added regardless of the mission stage.
// Add the Gas Giant Cerberus.
var cerberus = system.addPlanet("assassins_rebooted_Cerberus"); 
cerberus.displayName = "Cerberus (Gas Giant)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_planet", cerberus.position); 
this.beacon.beaconCode = cerberus.displayName;
this.beacon.beaconLabel = cerberus.displayName;
}
// Add the Torus Station: Corpse Bride in orbit around Cerberus.
// Having completed the first mission to kill Be Soin, the player is invited to go to the Corpse Bride station in Esrire if they wish to join the Guild.
// ***************************************************************************** Story Note *****************************************************************************************
// The first time the player docks having killed Be Soin they will receive a message from the guild paying them for the hit and inviting them to meet the Guild Master aboard the 
// Corpse Bride Station in the Esire system if they wish to join the Guild. Meeting the Guild Master and joining the guild is mandatory to progress the OXZs missions as further 
// missions are only offered once the player has joined the guild.

// The first time the player docks whilst the stage variable is at 3, they will get a mission screen explaining how the are inducted into the guild and are awarded a Mark Transponder
// Scanner, which will mark assassination targets on the scanner. The guild states it will be in contact with more work soon and the stage variable advances to 4. Further messages 
// offering hits and News broadcasts will now start being sent. Each event has a scripted delay, so a certain number of hyperspaces jumps have to be made before the next event 
// will occur.

// The Gas Giant and the Corpse Bride Station are permanent features of the system. The station is Neutral in alignment. It will allow any ship to dock with it regardless of the ship's
// legal status. It does not police space around it and so will not mark ships for committing offenses and it won't defend ships against attacks by other ships. All goods are legal 
// at the station, and it will have larger than normal quantities of slaves, narcotics and firearms for sale. It will launch well equipped Cobra Mark IIIs to attack any ship which 
// attacks the station itself. 

// If the player docks with the station (at any time except when the meet the guild master mission is running) then a custom arrival screen is shown, and a docking fee is charged. 
// If the player has attacked the station however, an arrival screen refusing landing permission is shown and the player is forcibly launched back into space.  The hostility variable
// is set when the station is attacked by the player and cleared on making a hyperspace jump, so the station will cease being hostile to the player from an attack if the player
//  jumps out and returns later.
// ***************************************************************************** Story Note *****************************************************************************************
system.legacy_addShipsAt("assassins_rebooted_corpse_bride_station", 1, "pwm", [7000000, 8000000, 23278750]); 
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [7000000, 7989900, 23278750]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [7000000, 8010100, 23278750]);
// Closing Bracket for Esrire.
}
// Populate Tiared
if (system.ID === 194) {
// ***************************************************************************** Story Note *****************************************************************************************
// The planet and the orbiting stadium are permanent features of the system. The stadium is lawful in alignment. It will only grant docking permission to clean ships, and it will launch
// fighters to attack any offenders or fugitives within its scanner range. The station has Ramons Nemesis from the original Assassins OXP as its defence ships and a squad of 3 
// Nemesis ships are added near the stadium with an AI to patrol around the stadium and attack any offender or fugitive ships they encounter. This is done by the Stadium's own
// script. As the station and its ships are lawful, attacking them make the player a fugitive. The Nemesis fighters all have custom pilots and comms messages. The model and texture
// for the Nemesis are Ramons originals, but the ships are given new Ais, scripts and shipdata entities.

// As with all the lawful stations in assassins, if a clean player docks with the station, they will receive a custom arrival report and be charged a docking fee. Non-clean players who
// dock without permission receive a message explaining how they were refused landing permission and are forcibly launched back into space. Clean players can trade with the 
// station and use the shipyard. The stadium will pay slightly higher prices than normal for food, liquors & wines and gem stones. Otherwise, prices are similar to the main station 
// but with less in stock.

// The 2nd Assassination, to kill the Zarausxian Hockey Team takes place in Tiared. The team are in the Armoured Passenger Liner by Ramon from the original Assassins OXP.
// As with all the ships from the original Assassins, the ship has a new Ai, script and shipdata entry. As per the mission briefing, at the time of the mission, the ship is added 150kms
// from the stadium in a straight line with the main station by the Stadum's own script.  It slowly flies toward the main station accompanied by 4 Nemesis fighters. If it reaches the
// main station, it will turn round and fly back to the Stadium and then back to the main station again. As it starts about 900kms from the main station, it takes it about an hour of real 
// time to get there. It can easily be found by flying to the Stadium and then setting the ASC for the main station and flying the route. Or, if the player starts at the main station, setting
// the ASC for the Stadium and flying the route to the Stadium will also encounter the team. Killing the team will raise the players bounty to 65, so the player will need to deal with
// this until time or measures from OXZs are used to reduce it.
// ***************************************************************************** Story Note *****************************************************************************************
// The desert planet Diomedes is always added regardless of whether any missions are running or not.
var diomedes = system.addPlanet("assassins_rebooted_Diomedes"); 
diomedes.displayName = "Diomedes (Planet)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_planet", diomedes.position); 
this.beacon.beaconCode = diomedes.displayName;
this.beacon.beaconLabel = diomedes.displayName;
}
// Likewise, the Madison Square Orbital Stadium is always added in orbit around Diomedes.
system.legacy_addShipsAt("assassins_rebooted_orbital_stadium", 1, "pwm", [-200000, 600000, 924120]); 
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-200000, 589900, 924120]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-200000, 610100, 924120]);
// The second hit takes place in this system, the mission ship is added by the Stadium's own script at the time of the mission.
//Closing Bracket for Tiared
}
// Populate Beatle
if (system.ID === 203) {
// ***************************************************************************** Story Note *****************************************************************************************
// Assassins makes fairly extensive modifications to Beatle and the third assassination to destroy the Fair Wind is scripted near the Repair Facility. The Fair Wind with two 
// Phantom Escorts is added by the Facilities own script when the mission is running. The station, moon and the other ships added are permanent features of Beatle.

// The Facility is a lawful station, but it will only grant docking permission to its own ships. Neither the player nor other NPCs can dock with the station. If the player attempts
// to manually dock, they will crash into the back wall of the dock and die as the station will only open its docking port to its own pre-booked customers. Whilst it will not permit
// ships to dock with it, it will not be hostile to clean ships in its vicinity. It will launch Phantoms armed with three forward mounted Beam Lasers to attack any offenders or fugitives 
// within scanner range.

// The script also adds a squadron of three Phantoms to patrol around the Facility. These ships will also attack any offenders or fugitives they detect and will also attack any ships
// which attack the facility's ships. 3 Damaged Ships, each with two phantom escorts are added with Ais to orbit the facility. The Damaged Ships are clones of the standard oolite
// ships, but they are unarmed and have no equipment. The escorts will attack any ship which attacks their mother but will not intervene to defend other ships in the yard.
// Attacking one of the Damaged Ships will therefore cause the player to be attacked by 5 Phantoms as the escorts and the three Phantoms on patrol will all attack the attacker. 
// The facility will also start launching more Phantoms to engage the attacker.

// The Damaged Ships are picked from three pools. Pool 1 (Python, Boa Mark I, Transporter, Cobra Mark I & Cobra Mark III). Pool 2 (Asp, Fer-de-lance, Moray Star Boat & Viper). 
// Pool 3 (Gecko, Krait, Mamba & Sidewinder). One ship from each pool is spawned on each visit to the system, so there will always be three different Damaged Ships with escorts 
// orbiting the facility.

// The Phantoms and the Damaged Ships all have unique pilots and comms messages, but as the Damaged Ships have no escape capsules, their crews never eject. The main script 
// also adds two Damages Ships each with 2 Phantom escorts to the spacelanes. These ships will fly to the witchpoint, main station or directly to the Facility. If they went to the
// witchpoint or main station first, then they will fly to the Facility once they arrive at the witchpoint or main station. They are not armed (but their escorts are). Their escorts will only
// attack ships which attack their mother and wont attack other ships (regardless of their legal status) unless they attack their mother.

// On system population, the main script will add a squadron of 3 Phantoms within 13kms of the players position. This will be near the witchpoint if jumping into the system or near 
// the station the player is docked with if loading from a saved game. These Phantoms have an AI to fly directly to the Facility and dock with it if they reach it. If they cannot dock 
// with the Facility for any reason, they will switch Ais to patrol between the sun, main planet or witchpoint. These ships will actively attack any offenders or fugitives they come 
// across and will answer distress calls from clean ships.

// A condition script is also used to over-ride the native populator to replace all hunters added by the native populator at Beatle with Augeas Security Phantoms. These ships have
// an AI to patrol between the Facility, Planet, Witchpoint or Sun hunting for ships with bounties.

// At the time of the 3rd Assassination the Repair Facilities own script adds The Fair Wind with two Phantom escorts to the ships around the facility. As with the other Damaged
// Ships, it is unarmed and has no equipment. As it is an Anaconda it is very slow and cannot outrun missiles of any type, although its escorts will ECM standard missiles and the 
// minesweepers will disarm any q-mines or other cascade weapons. The Fair Wind will be the only Anaconda around the Facility and as the player by this stage has the Mark
// Transponder Scanner, its golf club on the scanner with be flashing.

// The trick to completing the mission is to make sure you are Clean and arrive at the Facility with full tanks. If you are anything other than Clean the three security Phantoms on
// patrol will instantly attack you and the Facility will start launching more Phantoms to attack you. However, provided you are clean none of the ships will bother you until you start
// shooting at the Fair Wind. As soon as you do its two Phantom escorts will attack you and the three Phantoms on patrol will turn hostile and start flying towards you. 
// The range of the Phantoms three Beam Lasers is limited, so initially youll only have to deal with the two escorts.

// The Fair Wind has a higher than normal energy level, but it is a sitting duck as it too slow and damaged to avoid attack. You can simply creep up behind it and fire off a couple of 
// hard head missiles as this will take care of it, provided they both hit and give it a full blast of your forward laser to make sure. You need to destroy it quickly however and then
// hit the injectors and flee out of the repair yard as the Phantoms will overwhelm you once they reach you. Destroying the Fair Wind will raise the players bounty to 70 Credits,
// so having enough fuel for the 4.4 light year jump to the nearest system is useful as Security Phantoms may be encountered near the Sun if topping up the tanks by fuel skimming.

// ***************************************************************************** Story Note *****************************************************************************************
// The moon Augeas is always added regardless of whether any missions are running or not.
var augeas = system.addMoon("assassins_rebooted_Augeas"); 
augeas.displayName = "Augeas (Moon)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_moon", augeas.position); 
this.beacon.beaconCode = augeas.displayName;
this.beacon.beaconLabel = augeas.displayName;
}
// The third hit takes place at the Augeaian Orbital Repair Facility, but the station is always present regardless of whether any missions are running or not. 
// Add the Station
system.legacy_addShipsAt("assassins_rebooted_orbital_repair_facility", 1, "pwm", [300000, 700000, 724270]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [300000, 700000, 714170]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [300000, 700000, 734370]);
// Add three Phantom Secuity Ships (leader with two escorts) to patrol the area around the facility where the damaged ships are parked.
system.legacy_addShipsAt("assassins_rebooted_augeas_security_patrol_leader", 1, "pwm", [300000, 700000, 713170]);  
// Add 3 damaged ships escorted by 2 Phantoms each .
// Each ship is chosen from a pool of small, medium and large ships (so different types of ships appear on each visit.
// The ships slowly fly around near the facility. Attacking them will cause their escorts to attack and make the attacking ship a fugertive.
// The Phantoms on patrol will also then join the attack and the facility will launch more Phantoms to attack the aggressor.
system.legacy_addShipsAt("assassins_rebooted_augeas_damaged_ship_type1", 1, "pwm", [300000, 700000, 743070]);  
system.legacy_addShipsAt("assassins_rebooted_augeas_damaged_ship_type2", 1, "pwm", [300000, 681200, 724270]); 
system.legacy_addShipsAt("assassins_rebooted_augeas_damaged_ship_type3", 1, "pwm", [281200, 700000, 724270]); 
// The third hit takes place here. If the mission is running the target ship The Fair Wind will also be present - Added by the Facility's own script.
// Add another group of Phantoms near the player's position on system population. This means they will be near the witchpoint when entering the system from hyperspace
// or near the station the player is docked with if loading from a saved game.
// Either way, these Phantoms will fly from their starting point to the Repair Facility. When they reach it they will dock with it. If unable to dock they will switch AIs to patrol
// between the main planet, sun, the main station and the witchpoint. They will attack pirates and offenders and answer distress calls. 
system.addShips("assassins_rebooted_augeas_security_long_patrol_leader",1,player.ship.position.add([10000,0,0]),3560)[0];
// Add a damaged ship with two escorts somewhere in the main spacelane about a third on the way between the witchpoint and the main planet.
// This version of the damaged ships will cruise the spacelane and then fly to the repair facility. Should it get there it will switch AIs to the same AI as the ships already at the Facility
// and orbit the station. If you have Anarchies OXZ installed, the spawn point for these ships is near the Salvage Gang, so they will start from the Salvage Gang and make their
// way to the Repair Facility. If you don't have it installed the ships will still be at the same position.
system.legacy_addShipsAt("assassins_rebooted_augeas_damaged_ship_spacelane", 1, "wpu", [0, 0, 0.35])
// Add a second damaged ship (again with two escorts). This one is closer to the main planet, about 25% of the way between the planet and the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_augeas_damaged_ship_spacelane", 1, "wpu", [0, 0, 0.75])
// Closing Bracket for Beatle
}
// Populate Geteve
if (system.ID === 18) {
// The moon Hercules is always added regardless of whether any missions are running.
var hercules = system.addPlanet("assassins_rebooted_Hercules");  // Added as a planet so it has an Atmosphere as its a habitable moon.
hercules.displayName = "Hercules (Moon)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_moon", hercules.position); 
this.beacon.beaconCode = hercules.displayName;
this.beacon.beaconLabel = hercules.displayName;
}
// Add the Special Branch Outpost (also always present regardless of the mission stage).
system.legacy_addShipsAt("assassins_rebooted_special_branch_hq", 1, "pwm", [80000, 300000, -220000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [80000, 300000, -209900]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [80000, 300000, -230100]);
// ***************************************************************************** Story Note *****************************************************************************************
// The Geteve system features in the 4th Assassination and the system is also subject to a Thargoid Invasion. This is measured with a variable and additional ships are added as
// the invasion variable is advanced. At the start of the OXZ the variable is at zero as the Invasion hasnt started yet. The following changes are permanent and are always added 
// regardless of whether the invasion is in progress or not:

// The moon Hercules and the orbiting Special Branch Outpost are always present. The outpost's own script adds two groups of three Special Branch Asps with Ais to patrol around
// the outpost and attack any offender or fugitive ships. The Special Branch Asps have custom pilots and comms messages. The station is lawful and so as with other lawful 
// Assassins stations, it will deny docking permission to and attack non-clean ships. If the player docks without permission, they will be thrown out of the station and forcibly 
// launched. Clean players will see a custom arrival report and be charged a docking fee. The outpost does not have much in stock but will pay higher than normal prices for 
// liquors & wines, luxuries and alien items.

// On system population, the mains script adds a group of three special branch Asps with an AI to go to the outpost and dock with it within 12.5kms of the players position 
// (either near the station the player is docked with or near the witchpoint). Another group of three Asps with an AI to patrol around the main station are added near the main station.
// Two more groups of Special Branch Asps are added in the spacelane with an AI to pick one of 5 patrol destinations: The planet, the main station, the sun, the special branch 
// outpost or the witchpoint. The ships will fly the route picked responding to distress calls and attacking offenders & fugitives. Ships which end up at the main station or the outpost
// will dock. If they can't dock, they'll resume patrol going to the witchpoint or sun.

// Assassins also uses a condition script to override the native populator at Geteve and replace all the police ships in the system with Special Branch Asps. Ships called by the 
// native populator as police specifically (either as individual ships or group leaders) use the same AI as the Asps added by script in the spacelane and so will patrol all over the 
// system. Ships called as wingmen and interceptors will also be Special Branch Asps but have auto AI turned on and so will use the standard Oolite police Ais.

// As the player plays through the missions the Guild will have cause to silence an inquisitive journalist, whose suspicious death is being investigated by Inspector Thorstan of
// GalCop Special Branch. Shortly after the Thargoids begin an invasion of Geteve and the invasion variable is set to 1. Whilst the invasion is underway the OXZ adds Thargoid
// raiders to Geteve. All are like-ships of the normal Oolite Thargoid Warship but have custom Ais, roles and scripts.

// At invasion stage 1, a group of Thargoids with an AI to go to the main station and attack it are added 50kms from the main station. A second group of Thargoids are added 75kms
// from the Special Branch Outpost to with an AI to go and attack it. A third group are added in the spacelane with an AI to go and attack the nearest OXZ station or either the
// witchpoint or main station if there are none. A fourth group with Ais to go to the witchpoint and attack any ships they find there are added 30kms from the witchpoint. All ships
// with the role pirate are also converted into Thargoids with Ais to patrol the system and attack any ships they encounter. Groups of Thargoids are also added to the system generally.

// The fourth Assassination takes place during the Thargoid Invasion as the player will be offered the contract to kill Inspector Thorstan whilst he is fighting the Thargoids attacking
// the Outpost. At the time of the mission the outpost's own script adds Inspector Thorstan's Special Branch Asp near the Outpost. He will be marked on the players scanner as
// his golf club will be flashing. His Asp is a standard Special Branch Asp, although he has shield boosters fitted. The challenge of the mission is having to fight or evade the waves
// of Thargoids in the system.

// Later in the OXZs plot when Griff Research Ltd perfect and release their Navy BattleBots and Control Drones the variable is advanced to 2. The invasion continues and the same
// ships added at stage 1 still appear, but BattleBots and Control drones are also added to the system with Ais to attack Thargoids in the system.

// Towards the end of the OXZ's plot it will be announced on the news that Geteve has been victorious and the Thargoids have been repelled. At this point the variable will be set
// to over. Without a numeric value no Thargoids or BattleBots are added, so the only ships appearing are the default ones which are always present and Geteve returns to being
// a normal system policed by Special Branch Asps. The description of Geteve is changed as the Thargoid Invasion plot line plays out and its productivity and population
// decline during the invasion. 
// ***************************************************************************** Story Note *****************************************************************************************
// The Ships below always appear regardless of the mission variables.
// Add a wing (Leader and two escorts) near the Main Station with AIs to patrol the area 25 kms around the main station.
system.addShips("assassins_rebooted_special_branch_asp_planet_patrol",1,system.mainStation.position.add([10000,0,0]),20750)[0];
// Add another wing with AIs to go from their spawn point (near the station if loading from a saved game or near the witchpoint if entering from hyperspace) to the Outpost.
// If they reach the Outpost they will dock with it. If they can't dock then they will switch AIs to patrol the main spacelane.
system.addShips("assassins_rebooted_special_branch_asp_long_patrol",1,player.ship.position.add([10000,0,0]),12500)[0];
// Add two groups of 3 ships is the spacelane with an AI to go to the Witchpoint, Main Planet, the Sun or the nearest station. (Random dice roll for destination).
system.legacy_addShipsAt("assassins_rebooted_special_branch_asp_lawful_patrol", 1, "wpu", [0, 0, 0.45])
system.legacy_addShipsAt("assassins_rebooted_special_branch_asp_lawful_patrol", 1, "wpu", [0, 0, 0.65])
// Thargoid Invasion - Main Script Part
if (missionVariables.assassins_rebooted_thargoid_invasion > 0 && missionVariables.assassins_rebooted_thargoid_invasion !=="Over") {
// Thargoid Raiders always present during the Invasion.
// Add a group of Thargoids at the Witchpoint. These Thargoids will go to the witchpoint and remain within 5 to 15kms of the witchpoint, attacking any ships there.
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type1", 10, "wpu", [0, 0, 0.0])
// One ship at the witchpoint will specifically target the player.
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type2", 1, "wpu", [0, 0, 0.0])
// Add a smaller groups out of scanner range of the wichpoint with an AI to go to the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type1", 4, "wpu", [0, 0, 0.15])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type1", 4, "wpu", [0, 0, 0.25])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type1", 4, "wpu", [0, 0, 0.35])
// Add a group at the same positions at the Special Branch Asps with AI to go to the Witchpoint, Main Planet, the Sun or the nearest station. (Random dice roll for destination).
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type3", 4, "wpu", [0, 0, 0.45])
// Two ships out of the group will specifically target the player if they are not already being attacked by another ship.
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type2", 2, "wpu", [0, 0, 0.55])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type3", 4, "wpu", [0, 0, 0.65])
// Add groups with AIs to go to the nearest station to their spawn point and remain there attacking the station and any nearby ships.
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type4", 4, "wpu", [0, 0, 0.75])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type4", 4, "wpu", [0, 0, 0.85])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type4", 4, "wpu", [0, 0, 0.95])
// Add a large group near the main station. Most will go to the main station, but if there are any OXZ stations near the main station some will also go there.
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type4", 10, "wpu", [0, 0, 1.0])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type6", 10, "wpu", [0, 0, 1.0])
// Two ships added near the main station will specifically target the player
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type2", 2, "wpu", [0, 0, 1.0])
// Add a Thargoid with an AI specifically to attack the player near the player's position.
system.addShips("assassins_rebooted_thargoid_raider_type2",1,player.ship.position.add([4000,0,0]),6500)[0];
// The Special Branch Outpost's script populates the space around it with Thargoids. The main script also adds Thargoids in the spacelanes with AIs to go to the Outpost.
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type5", 2, "wpu", [0, 0, 0.10])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type5", 1, "wpu", [0, 0, 0.30])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type5", 1, "wpu", [0, 0, 0.50])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type5", 2, "wpu", [0, 0, 0.60])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type5", 1, "wpu", [0, 0, 0.70])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type5", 1, "wpu", [0, 0, 0.80])
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type5", 1, "wpu", [0, 0, 0.90])
// Navy BattleBots and Control Drones added when the variable is at 2.
if (missionVariables.assassins_rebooted_thargoid_invasion === 2) {
// Add one Navy Control Drone with 4 BattleBot escorts at the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_navy_control_drone_geteve_type1", 1, "wpu", [0, 0, 0.0])
// Add another Navy Control Drone with 4 BattleBot escorts near the main station with an AI to patrol around the main station.
system.addShips("assassins_rebooted_navy_control_drone_geteve_type2",1,system.mainStation.position.add([1000,0,0]),10750)[0];
// Add some additional Thargoid Ships.
system.addShips("assassins_rebooted_thargoid_raider_type4",4,system.mainStation.position.add([1000,0,0]),15750)[0];
system.legacy_addShipsAt("assassins_rebooted_thargoid_raider_type1", 3, "wpu", [0, 0, 0.0])
// Closing Bracket for adding Navy BattleBots and Control Drones.
}
// Closing Bracket for the Thargoid Invasion being in progress
}
// The fourth Assassination takes place here. If the mission is running the target ship of Inspector Thorstans Special Branch Asp is added by the Outpost's own script.
// Closing Bracket for Geteve.
}
// Populate Ateslete
if (system.ID === 39) {
// The ice-world Stymphal is always added regardless of whether any missions are running or not.
var stymphal = system.addPlanet("assassins_rebooted_Stymphal"); 
stymphal.displayName = "Stymphal (Planet)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_planet", stymphal.position); 
this.beacon.beaconCode = stymphal.displayName;
this.beacon.beaconLabel = stymphal.displayName;
}
// Add the Griff Research Orbital Base in orbit around Stymphal.
system.legacy_addShipsAt("assassins_rebooted_griff_research_orbital_base", 1, "pwm", [-2500000, -150000, 947900]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-2500000, -150000, 937800]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-2500000, -150000, 958000]);
// ***************************************************************************** Story Note *****************************************************************************************
// The 5th Assassination takes place at Ateslete and the ice planet Stymphal together with the Griff Research Orbital Base are permanent features of the System. As the Base is
// a lawful station, it will refuse docking permission and launch Wolf Mark I defence ships to attack any ships with bounties within its scanner range. Non-Clean players who dock
// without permission will see a custom arrival report explaining how they were thrown out of the base. Clean players will see a custom arrival report and will be charged a docking
// fee. The base pays slightly higher than normal prices for alloys, computers and gold. It will pay a high price for alien items.

// Assassins also uses a condition script to override the native populator at Ateslete and replaces all hunters in the system with Griff Research Wolves. Their AI will pick one of 
// 5 patrol destinations: The planet, the main station, the sun, the base or the witchpoint. The ships will fly the route picked responding to distress calls and attacking offenders 
// & fugitives. Ships which end up at the main station or the base will dock. If they can't dock, they'll resume patrol going to the witchpoint or sun. The main script also adds two
// groups of 3 wolves (a leader with two escorts) to the spacelane, with the same AI as the replacement hunters. The security wolves also have custom pilots and comms messages.

// Griff Research Ltd are working on a contract for the military to develop a remote battle robot to counter the Thargoids. At the start of the OXZ the development level variable is set
// to zero. As the BattleBots are developed this variable is advanced and different ships appear.

// Whilst the variable is at zero, a Positronic Brian (Griff's Bouy from Busy Ports OXP) is added in front of the Base by the base's own script. It's AI waits for the player to arrive
// and then sends out 3 messages, once per minute. The first warns that a drone test is in progress, the second states it is testing the prototypes resistance to EMP. It will also fire
// its ECM. It will then say that the test was unsuccessful before repeating from the first message. 

// Also added by the base's script are a group of 20 Experimental Drones (Griffs Auto Loader). These have military scan class and shooting at the drones, or the Brian will make
// the player a fugitive and the base to launch Security Wolves to attack the player. The drones are unarmed, and their AI is to swarm around the station, the brain and the station's
// minesweepers. When an ECM is fired by the brain (or any other ship) the drones will shut down for 5 seconds and the brain will announce that the test was disappointing. 
// If the player happens to visit the Base before the mission to destroy the rouge Control Drone is offered, they get a clue that the BattleBots are vulnerable to being shut down by 
// using ECM.

// Some time after completing the 4th Assassination, the player will see a News Broadcast reporting on a trader who had to eject from his ship having been attacked by a swarm of
// small ships at Ateslete. This News Broadcast also hints at the Botts vulnerability to ECM. Griff Research's first version of the BattleBot has gone rouge and is attacking civilian
// ships in the spacelanes. Once the broadcasts is seen, the variable is advanced to 1. 

// At development level 1, the bases script will now add a group of unarmed BattleBots near the base. These Bots will behave in the same way as the experimental drones. 
// All pirates in the system are also replaced with Malfunctioning BattleBots with Ais to patrol the spacelane and attack any ship that isn't a BattleBot. They are small with low energy
// and only have a pulse laser, but they are very fast and so will get in range very quickly. If destroyed, they will spawn splinter missiles, to encourage putting them to sleep with 
// ECM bursts instead.

// Shortly after the News Broadcast mentioning the attack on the trader is seen, the Guild will offer the contract to destroy the Malfunctioning Control Drone at Ateslete. 
// The main script will add the Drone with BattleBot escorts to the spacelane together with groups of battle bots with Ais to attack the player if encountered. The Control Drone will
// also attack the player as soon as it encounters them. It will fly between the witchpoint and the planet in a loop until the player encounters it. It is quite tough, but only has 
// short range plasma turrets to defend itself with. Using ECM will shut down its escorts and the Drone can then be destroyed by keeping out of range of its turrets as it is fairly slow.

// When paid for the BattleBot mission the briefing will mention that Griff Research managed to shut down most of the Bots but some escaped though using other ships wormholes. 
// The variable advances to 2 and a timer is started. Malfunctioning Bots will no longer appear at Ateslete, and the brain will still be testing unarmed BattleBots at the base. 
// All the systems within 7 light years however will become infested with Malfunctioning Batts by pirates in the system being replaced with them. A new system will become infested
// every 10 jumps the player makes since completing the BattleBot mission until they are all infested. Each time a system is infested, its description will change to reference this. 

// Shortly after being paid for completing the BattleBot mission, the player will see a news broadcast announcing the Griff Researchs BattleBot has been delivered to the Navy and
// deployed to fight the Thargoid Invasion at Geteve and the variable is advanced to Complete. Once the variable reaches Complete Control Drones and Mark I and Mark II
// BattleBots appear at Geteve with Ais to attack the invading Thargoids. The brain will no longer be present at the Base and instead a group of Mark II BattleBots with police scan
// class will patrol around the base and attack any offenders and fugitives within scanner range. All police, interceptor and wingmen ships added by the native populater are 
// replaced with Mark I and Mark II BattleBots and Control Drones with police scan class and BattleBot escorts are added to the spacelane with an AI to patrol and attack ships
// with bounties and answer distress calls. 
// ***************************************************************************** Story Note *****************************************************************************************
// Add two groups of 3 Griff Security Wolves in the Spacelane with an AI to pick one of 5 patrol destinations: The planet, the main station, the sun, the base or the witchpoint.
// The ships will fly the route picked responding to distress calls and attacking offenders & fugitives. Ships which end up at the main station or the base will dock. 
// If they can't dock, they'll resume patrol going to the witchpoint or sun.
// These ships do not appear when the mission to destroy the Malfunctioning BattleBot Control Drone is running or once the police force is fully robotic.
if (missionVariables.assassins_rebooted_stage !== 24 && missionVariables.assassins_rebooted_battlebot_development_level !== 3 && 
missionVariables.assassins_rebooted_battlebot_development_level !=="Complete") {
system.legacy_addShipsAt("assassins_rebooted_griff_spacelane_wolf", 1, "wpu", [0, 0, 0.45])
system.legacy_addShipsAt("assassins_rebooted_griff_spacelane_wolf", 1, "wpu", [0, 0, 0.75])
}
// Once the Working Versions of the Control Drones and BattleBots replace the police force at Ateslete, different ships are added in the spacelane.
if (missionVariables.assassins_rebooted_battlebot_development_level === 3 || missionVariables.assassins_rebooted_battlebot_development_level ==="Complete") {
// Add a Police BattleBot Interceptor with 2 Police BattleBot escorts near the player's position (either the witchpoint or the station the player has just launched from).
// These ships will go to the Groff Reaserach Base and dock with it if they get there.
system.addShips("assassins_rebooted_police-battlebot_interceptor_leader",1,player.ship.position.add([15000,0,0]), 3000)[0];
// Add a Police Control Drone. This version has a police patrol AI to fly to the planet, patrol around the main station, then go to the witchpoint, then go to the main planet again.
// Escorted by 4 BattleBots with police scan class.
system.legacy_addShipsAt("assassins_rebooted_police_control_drone", 1, "wpu", [0, 0, 0.15])
// Add a group of 3 Police BattleBots with an AI to patrol towards the planet..
system.legacy_addShipsAt("assassins_rebooted_police-battlebot_planet_patrol_leader", 1, "wpu", [0, 0, 0.40])
// Add a group of 3 Police BattleBots with an AI to go to the Reserach Base.
system.legacy_addShipsAt("assassins_rebooted_police-battlebot_homebound_patrol_leader", 1, "wpu", [0, 0, 0.55])
// Add a group of 3 Police BattleBots with an AI to patrol out to the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_police-battlebot_witchpoint_patrol_leader", 1, "wpu", [0, 0, 0.85])
}
// The 5th Mission takes place in this system.
// Once the player has seen the 5th News Broadcast, Malfunctioning BattleBots are added to the spacelane until the Contract to destroy the Malfunctioning Control Drone
// has been offered and completed. The Malfunctioning BattleBots will attack anything that isn't a BattleBot.  
if (missionVariables.assassins_rebooted_stage === 23 || missionVariables.assassins_rebooted_stage === 24) {
// Add a group in the same positions as the Wolf Security Patrols with AIs respectively to go to the Witchpoint and the Main Station. Usually these BattleBotts will
// get involved in a fight with the Wolves. When the Malfunctioning BattleBot Control Drone mission is running these ships still appear (but the wolves do not) and will attack
// all ships which are not BattleBots or the Control Drone, including the player.
system.legacy_addShipsAt("assassins_rebooted_malfunctioning_battlebot_type1", 5, "wpu", [0, 0, 0.45])
system.legacy_addShipsAt("assassins_rebooted_malfunctioning_battlebot_type2", 5, "wpu", [0, 0, 0.75])
// Ships added only when the 5th Assassination mission is running.
if (missionVariables.assassins_rebooted_stage === 24) {
// Add the Malfunctioning BattleBot Control Drone with 4 BattleBot escorts when the mission is running. The ship is added in the middle of the spacelane with an AI to fly between the
// planet and the witchpoint. It will attack the player as soon as it detects them, but will not attack any other ships.
system.legacy_addShipsAt("assassins_rebooted_victim5", 1, "wpu", [0, 0, 0.50])
// Two BattleBots with an AI to target a random non-battlebot are added at the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_malfunctioning_battlebot_type1", 2, "wpu", [0, 0, 0.0])
// Another BattleBot is added just outside the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_malfunctioning_battlebot_type1", 1, "wpu", [0, 0, 0.05])
// Groups of 3 BattleBots with an AI to fly towards the Main Station or Planet and attack the player if they encounter them are added to the spacelane.
system.legacy_addShipsAt("assassins_rebooted_victim5_support_type1", 1, "wpu", [0, 0, 0.15])
system.legacy_addShipsAt("assassins_rebooted_victim5_support_type1", 1, "wpu", [0, 0, 0.25])
system.legacy_addShipsAt("assassins_rebooted_victim5_support_type1", 1, "wpu", [0, 0, 0.35])
system.legacy_addShipsAt("assassins_rebooted_malfunctioning_battlebot_type1", 1, "wpu", [0, 0, 0.40])
system.legacy_addShipsAt("assassins_rebooted_victim5_support_type1", 1, "wpu", [0, 0, 0.55])
system.legacy_addShipsAt("assassins_rebooted_victim5_support_type2", 1, "wpu", [0, 0, 0.79])
system.legacy_addShipsAt("assassins_rebooted_victim5_support_type2", 1, "wpu", [0, 0, 0.89])
// Three BattleBots with an AI to target a random non-battlebot are added around the main station.
system.legacy_addShipsAt("assassins_rebooted_malfunctioning_battlebot_type1", 3, "wpu", [0, 0, 1.0])
// Closing bracket for ships added only at Stage 24 - When the Mission is running.
}
// Closeing bracket for ships added at stages 23 to 24.
}
// Closing Bracket for Ateslete.
}
// Populate Ataneris
if (system.ID === 81) {
// ***************************************************************************** Story Note *****************************************************************************************
// Sometime after completing the 5th Assassination the player will receive a message from the Guid warning that the Zarausxian Hockey Team Fan Club have put out a contract on
// the player in retaliation for the player rubbing out the Team in the 2nd Assassination. During this interlude phase, the player will occasionally be attacked by Fans flying Ramon's
// Nemesis fighters. Once the player has made a total of 15 jumps since receiving the warning message, the Guild will contact the player again and explain that rather unfortunately
// the contract on the player has been accepted by a fellow Guild Member. The 6th Assassination, to duel O-Ren Ishi takes place in the Ataneris System. The planet, Mining Depot
// and the Bug Mining and defence ships are permanent features of the System.

// The Depot is a lawful station. It will refuse docking permission and launch Bugs armed with Beam Lasers to attack any ships with bounties within its scanner range. Non-Clean
// players who dock without permission will see a custom arrival report explaining how they were thrown out of the base. Clean players will see a custom arrival report and will be
// charged a docking fee. The Depot is a typical mining installation with cheaper prices for minerals, gold, platinum and gemstones and higher prices sometimes paid for machinery
// and textiles.

// The Depot's own script adds a field of 40 of Griffs glowing asteroids within 18kms of the Depot. 3 Bugs equipped with Mining Lasers are also added to the asteroid field, with Ais
// to mine the asteroids. If attacked they will flee towards the Depot. A Squad of 3 Bugs armed with Beam Lasers are also added in the asteroid field by the Depot's script. They will
// patrol around the asteroid field and attack any ships with bounties (including the player) and any ships which attack the Mining Bugs. A condition script is also used to replace
// miner ships added by the native populater with Miner Bugs. All the Bugs have custom pilots and comms messages.

// The Depot does not directly feature in the mission, but as per the system description the duel takes place near the asteroid fields. At the time of the mission, the Main script 
// adds a Duelling Beacon (Sothis Ring Beacon Model) 100kms from the Depot together with an asteroid field, O-Ren Ishi and her mining drones. Their Ais will fly around near the 
// Beacon until the player arrives and attack the player as soon as they arrive. The Beacons AI will disarm any cascade weapons within its scanner range. The mission takes place
// at the agreed duelling spot and the Duelling Beacon has an ASC Beacon. All the player need do to find the target is follow the compass beacon.

// As O-Ren Ishi has dishonourably brought back-up, the fight is harder than the Guild intended. She has rather sneakily hacked the targeting parameters of the local asteroid
// mining drones and programmed them to attack the player. The drones only have pulse lasers and have very little energy, but they are very fast.

// ***************************************************************************** Story Note *****************************************************************************************
// Add the forest world Hippolyte.
var hippolyte = system.addPlanet("assassins_rebooted_Hippolyte"); 
hippolyte.displayName = "Hippolyte (Planet)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_planet", hippolyte.position); 
this.beacon.beaconCode = hippolyte.displayName;
this.beacon.beaconLabel = hippolyte.displayName;
}
// Add the Mining Depot
system.legacy_addShipsAt("assassins_rebooted_miner_depot", 1, "pwm", [250000, 400000, 840000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [250000, 400000, 830000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [250000, 400000, 850000]);
// At the time of the 6th Assassination add the Dueling Beacon and O-Ren Ishi flying a Cobra IX together with escorts.
if (missionVariables.assassins_rebooted_stage === 30) {
// The Beacon's own script spawns an asteroid field, hostile mining drones and the Mission ship with escorts, so just the beacon is added by the main script.
system.legacy_addShipsAt("assassins_rebooted_victim6_duelling_beacon", 1, "pwm", [250000, 300000, 840000]);
}
// Closing Bracket for Ataneris.
}
// Populate Quandixe
if (system.ID === 53) {
// Add the tropical moon Hesperides.
var hesperides = system.addPlanet("assassins_rebooted_Hesperides"); // Added as a planet so it has an atmosphere as it is a habitable moon. 
hesperides.displayName = "Hesperides (Moon)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_moon", hesperides.position); 
this.beacon.beaconCode = hesperides.displayName;
this.beacon.beaconLabel = hesperides.displayName;
}
// Add the Darkside Mafia Waystation
system.legacy_addShipsAt("assassins_rebooted_mafia_waystation", 1, "pwm", [250000, 175000, 66500]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [250000, 175000, 56500]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [250000, 175000, 76500]);
// ***************************************************************************** Story Note *****************************************************************************************
// The Quandixeian Mafia feature in three of the ten Assassinations, the second to kill the hockey team, the third to destroy the Fair Wind at Beatle and the seventh Assassination 
// to kill the Triad leader who has taken to attacking the Mafia's drug ships at Quandixe. The triad leader and his escorts are added when the mission is running. The moon, orbiting
// station and the fleets of Mafia Anacondas ferrying narcotics around the system are permanent features of the system. 

// As the system is a Corporate State and the corporation in question is a Mafia drugs cartel, the Mafia run the system. Using a conditions script, police ships in Quandixe are
// replaced with Mafia sidewinders, Traders with Mafia Anacondas carrying narcotics and Shuttles with Mafia Cargo Shuttles. Although the mafia allow their own ships to carry
// narcotics, they don't want other criminals muscling in on their operation and so the police Sidewinders will behave as regular police ships (although they will not attack Mafia
// ships and will actively defend them if they are attacked). 

// The Mafia Anacondas are escorted by two Sidewinders and have custom Ais to travel to one of 5 destinations and dock with the closest station there: the Main Station,
// the Planet, the Mafia Waystation, the Witchpoint or a randomly picked OXZ station within 500kms of their starting point. The Shuttles have auto-ai so will behave as standard
// shuttles. All of the ships have custom pilots and comms messages. As the main station, the outpost and any other OXZ stations in the system which have NPC traffic set to yes,
// will periodically launch Mafia Anacondas, there are a steady stream of Mafia Anacondas present flying drugs between all the stations in the system and docking with their
// destination station.

// The Darkside Waystation is the distribution centre for the megaweed being cultivated on Hesperides. All goods are legal, and it will buy narcotics at a below average price and pay
// a higher than average price for firearms and slaves. Otherwise, its market is similar to the main station, but with generally higher quantities in stock.  It is neutral in alignment.
// It will not mark ships for committing crimes or respond to distress calls. It will not attack Offenders but will not grant them docking permission either. It will send a comms
// message warning Non-Clean players not to dock and welcoming clean players. It will not tolerate fugitives (they might be pirates after the weed) and will launch Mafia Sidewinders
// to attack fugitives or any ship which attacks the Waystation or Mafia ships. Non-Clean players who dock without permission will see a custom arrival report explaining how
// they were thrown out of the base. Clean players will see a custom arrival report and will be charged a docking fee.

// The Waystation's own script adds two Mafia Anacondas with sidewinder escorts near the Waystation with Ais to fly around near the station until the player arrives. Once they
// detect the player one ship will dock with the station and the other will leave, either jumping out or travelling to one of the other stations in the system. The Waystations script
// also adds three Mafia Anacondas with Sidewinder escorts in a line with the main station at 30kms, 50kms and 235kms from its position. The ships have Ais respectively
// to go to the Waystation, Witchpoint and Main Station. The main script also adds 5 Mafia Anacondas to the spacelane at various points, 2 with Ais to go to a random OXZ station,
// 1 with an AI to go to the Main Station, 1 with an AI to go to the Witchpoint and 1 with an AI to go to the Waystation.

// When the mission to kill the Triad Boss is running, his ship with escorts and the Triad Ships are added by the Waystation's script between the Waystation and the Main Station 
//together with Mafia Anacondas for them to attack. The ships scripts repopulate by spawning a replacement ship 30kms from their position when they died and an AI to return to the
// co-ordinates of the attack, so there will always be a battle in progress at the Triad Bosss location when the player arrives. As per the mission briefing, he is attacking the Mafia
// Anacondas ferrying drugs between the Waystation and the Main Station, so will be encountered if you fly directly from the Main Station towards the Waystation or flying from the
// Waystation to the Main Station.

// The Boss's Griff Boa is pretty tough as it has both plasma turrets and Military Lasers and his escorts have Beam Lasers. However, whilst the Boss will target the player when it
// detects them, the other Triad ships present are occupied with the Mafia ships and so won't attack the player unless the player attacks them first. The Boss is faster than his
// escorts and their weapons have shorter range, so he can be lured away from his escorts and then fought on his own. The mission ship has slightly higher energy than a standard
// Griff Boa, but one on one he is much less of a threat.
// ***************************************************************************** Story Note *****************************************************************************************
// Add a Mafia Anaconda with Sidewinder Escorts in the Spacelane near the Main planet with an AI to go to the Main Station and dock with it.
system.legacy_addShipsAt("assassins_rebooted_mafia_planet_drugship", 1, "wpu", [0, 0, 0.20])
// Add 2 Mafia Anacondas with Sidewinder Escorts to the Spacelane. Their AI will send them towards a Random OXZ station and dock with it.
// If none are within 500kms of their starting position then they will go to the Main Station and dock there.
system.legacy_addShipsAt("assassins_rebooted_mafia_spacelane_drugship", 1, "wpu", [0, 0, 0.35])
system.legacy_addShipsAt("assassins_rebooted_mafia_spacelane_drugship", 1, "wpu", [0, 0, 0.65])
// Add another Anaconda with 2 escorts in the spacelane with an AI to fly to the Waystation and dock with it.
system.legacy_addShipsAt("assassins_rebooted_mafia_homebound_drugship", 1, "wpu", [0, 0, 0.50])
// Add another Anaconda with 2 escorts in the spacelane with an AI to fly to the Witchpoint and dock with the nearest OXZ station to the witchpoint.
// If it can't find a station it will either go to the Main Station, Jump Out or go to the Waystation.
system.legacy_addShipsAt("assassins_rebooted_mafia_outbound_drugship", 1, "wpu", [0, 0, 0.85])
// Closing Bracket for Quandixe.
}
// Populate Estiri.
if (system.ID === 82) {
// ***************************************************************************** Story Note *****************************************************************************************
// Upon being paid for the 7th Assassination, the Guild will warn the player that the Triads are unhappy with the killing of their leader and have sworn vengeance on the player. During
// this interlude phase there is a chance on each jump that the player will encounter and be attacked by a group of Triads flying Ramon's Wasp fighters. After making 10 jumps a 
// news broadcast will appear, reporting on the fact that the Triad Leader has been arrested and a former member of the Triads has turned super grass and is due to give evidence
// against the new Triad Leader at his forthcoming trial at the Estiri Supreme Court. 

// The Triad Wasps will no longer attack the player and after making 2 more jumps the player will receive a message from the guild explaining that the Trial Leader wishes to make
// peace and offering the Contract to assassinate the witness, who is being housed aboard an Aeron Class Frigate near the Naval Outpost orbiting Nemean. At this stage the outpost 
// will be in lockdown. A minefield of automated torpedo launchers has been deployed and the Navy ships will fire on any non-navy ship (including the player) approaching the Outpost.
// The lockdown variable is set to true, and the outposts own script will add the Navy Ships and the Target near the Outpost.

// The Moon and the Outpost are permanent features of the System. The main script also adds 3 Navy Carries with Navy Sidewinder escorts to the system.  The Carrier Geryones is
// added near the main station with an AI to patrol around the Main Station. The Mylinos is added in the spacelane with an AI to patrol between the sun, main planet or witchpoint.
// The Orion is added near the witchpoint with an AI to travel to the Outpost. 

// When not in lockdown, the Outpost's script also adds three carriers near the Outpost. The Antiphates has an AI to patrol around the Outpost. The Damasen has an AI to travel
// to the witchpoint. The Elatreus has an AI to go to the main planet. The Outposts script also adds a total of 12 Navy Sidewinders in 4 groups of 3 ships, near the Outpost with Ais
// to patrol around the Outpost. A conditions script is also used to replace all police ships in Estiri with Navy Sidewinders.

// All of the carriers can be docked with. They are lawful ships and so will only grant docking permission to clean ships. They will attack and launch defence ships to attack any
// ships with bounties and will respond to distress calls. As with other lawful stations, the clean players who dock will see a custom arrival message and will be charged a docking
// fee. Non-Clean players who dock without permission will see a custom arrival report explaining how they were thrown out of the carrier. The carriers will pay higher than normal
// prices for food, liquors & wines and luxuries. The carriers and sidewinders have unique comms messages and pilots.

// The Outpost can also be docked with (when not in lockdown). As with other lawful stations it will only grant docking permission to Clean ships. The patrolling sidewinders and the
// Antiphates will attack any ship with a bounty and the Outpost will launch more sidewinders to assist. Clean players will see a custom arrival message (using a different pool of
// messages to the carriers) and will be charged a docking fee. Non-Clean players who dock without permission will see a custom arrival report explaining how they were thrown out.

// The normal version of the Outpost is added when the base is not in lockdown. At the time of the mission, the lockdown variable is set to true, and a different version of the Outpost
// is added. The lockdown version is a like-ship of the normal version, but with its allegiance set to private and a different AI and script. When in lockdown, a field of 20 cluster-bombs
// are added near the outpost. These have a short scanner range, but should they detect the player each will launch a relatively slow moving (0.4lm) missile at the player. 12 Navy
// BattleBots are also on patrol and will also attack the player once they detect them. The Outpost will start launching Naval Sidewinders to attack the player. The three carriers
// normally added by the Outpost's script are still added, but with Ais to patrol 50kms out and attack the player if encountered.

// The target in an Aeron Class Frigate escorted by BattleBots is also added by the Outpost's script. Its AI will fly around near the Outpost until the player arrives. Due to the
// BattleBots, missile launchers and the Navy Sidewinders, remaining near the Outpost is suicide and the player will need to lure the target away from the Outpost a bit to outrun
// the BattleBots and missiles. The frigate is tough but has a low recharge rate so can be worn down. Once out of range of the missile launchers it can be taken down in a straight
// fight.
// ***************************************************************************** Story Note *****************************************************************************************
// Add the ocean moon Nemean. 
var nemean = system.addPlanet("assassins_rebooted_Nemean"); // Added as a Planet to give it an atmosphere. 
nemean.displayName = "Nemean (Moon)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_moon", nemean.position); 
this.beacon.beaconCode = nemean.displayName;
this.beacon.beaconLabel = nemean.displayName;
}
// Add the Navy Base in orbit.
// Normally, the Base is open to civilians and will not be hostile to the player as long as they are clean.
// At the time of the 8th Hit the base is in lock-down, so during lockdown a different version of the station and ships are used which have AIs hostile to non-military ships.
if (!missionVariables.assassins_rebooted_navy_base_lockdown || missionVariables.assassins_rebooted_navy_base_lockdown === "No") {
system.legacy_addShipsAt("assassins_rebooted_navy_station", 1, "pwm", [50000, 875000, 625000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [50000, 875000, 615000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [50000, 875000, 635000]);
}
//  During the 8th Assassination a different version of the Base is added. This version is hostile to the player and will add three Navy Carriers and a squad of BattleBots
// with AIs hostile to the player, together with a minefield of clusterbombs.
if (missionVariables.assassins_rebooted_navy_base_lockdown === "Yes") {
system.legacy_addShipsAt("assassins_rebooted_navy_station_lockdown", 1, "pwm", [50000, 875000, 625000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [50000, 875000, 615000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [50000, 875000, 635000]);
}
// Add the Navy Carrier Geryones with an AI to patrol around the main station. (These ships appear with the same AI regardless of whether the base is in lockdown as during 
// lockdown they are not hostile to a clean player in the spacelanes or the sun skimming route, only the ships in the 50km zone around the base change AIs).
system.addShips("assassins_rebooted_geryones",1,system.mainStation.position.add([24000,0,0]), 1000)[0];
// Add the Navy Carrier Mylinos with an AI to patrol between the sun, planet or witchpoint or go to the Naval Base (Dice Roll in the AI).
system.legacy_addShipsAt("assassins_rebooted_mylinos", 1, "wpu", [0, 0, 0.47])
// Add the Navy Carrier Orion with an AI to travel to the Naval Base.
system.legacy_addShipsAt("assassins_rebooted_orion", 1, "wpu", [0, 0, 0.10])
// The 8th Assassination take place in this system - Added by the Locked Down version of the Outpost's script.
// Closing Bracket for Estiri.
}
// Populate Eszausve.
if (system.ID === 13) {
// Add the rocky moon Columba.
var columba = system.addMoon("assassins_rebooted_Columba"); 
columba.displayName = "Columba (Moon)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_moon", columba.position); 
this.beacon.beaconCode = columba.displayName;
this.beacon.beaconLabel = columba.displayName;
}
// Add the gas giant Hades.
var hades = system.addPlanet("assassins_rebooted_Hades"); 
hades.displayName = "Hades (Gas Giant)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_planet", hades.position); 
this.beacon.beaconCode = hades.displayName;
this.beacon.beaconLabel = hades.displayName;
}
// Add the gas giant Lernean.
var lernean = system.addPlanet("assassins_rebooted_Lernean"); 
lernean.displayName = "Lernean (Gas Giant)";
if (!missionVariables.assassins_rebooted_almanac_installed) {
this.beacon = system.addVisualEffect("assassinsCompass_planet", lernean.position); 
this.beacon.beaconCode = lernean.displayName;
this.beacon.beaconLabel = lernean.displayName;
}
// ***************************************************************************** Story Note *****************************************************************************************

// Assassins makes extensive modifications to Eszausve as the system and its civil war form the backdrop to the last three missions of
// the OXZ. The Moon and the two Gas Giants are always present in the system. The ships appearing and how the stations behave depends
// on the value of the Civil War variable. When the OXZ is first installed, the value is 0. The system is policed by imperial ships, 
// prison ships take dissidents to the prison and passenger liners take tourists to the two HoOpy Hotels. 

// Sometime after completing the 5th Assassination, the player will see a news broadcast where the Dictatorship is condemned by the
// neighbouring Democratic system of Angeriri for deploying Scorpion Frigates against civilian targets. After this broadcast, the
// variable advances to 1 and Scorpion Frigates attacking rebel ships are added to the system in addition to the ships normally 
// present. Shortly after the 8th Assassination, another News broadcast appears mentioning that all out civil war has broken
// out. Deamon Class Cruisers have been deployed against rebel positions and Angeriri is arming the rebels with Sonoran fighters. 

// The Daemons variable is set to Lawful. During this phase of the OXZ, the Dictatorship is still the official government, so their
// ships have police scan-class and the rebels are fugitives. 4 Deamon Class Cruisers with Scorpion escorts are added at the
// witchpoint, main station and in the spacelanes along with groups of attacking rebel ships. The prison will also be under attack
// by rebels.

// After making 5 more jumps, another news broadcasts appears, reporting that the rebels have made substantial gains in surface 
// battles and the Sky Marshal announces that he is assembling a fleet to destroy the rebel held cities from orbit. After making 
// two more jumps, the Guild will contact the player offering the contract to kill the Sky Marshal aboard the Imperial Flagship (with
// 4 Deamon Class Cruiser Escorts) is added by the main script near the main Imperial Station.

// After making 2 more jumps since being paid for destroying the flagship, the 14th News Broadcast appears. Once this 
// broadcast has been seen, an addition 6 rebel ships are added at the main station and the prison.  

// After making 5 more jumps, the 15th News Broadcast appears. The imperial dreadnaught has been challenged by a GalCop Behemoth due
// to having illegal anti-matter cannons. The dreadnaught easily destroys the Behemoth and resumes its hyperspace course to Eszausve
// (its at Ribeties and still 10 jumps away). The Rebels take over the Main Station and the Imperial Prison. Due to the destruction
// of the GalCop Carrier, GalCop finally takes action and declares the imperial navy fugitives and recognises the rebels opposing the
// imperials as lawful ships. The Civil war variable is advanced to 2 and the description, population and productivity of the system
// are also changed.

// Once the civil war variable is at 2, the rebels have police scan class and the imperials are now the fugitives. The Main Station
// and the Prison are renamed and are now defended by rebel Sonorans. The rebel Sonorans replace all the police in the system and
// fugitive scorpion frigates replace any pirates present. Hunters and Traders are replaced with offender Mongoose fighters (they
// attack all non-imperial ships even though called by the populator as the have their own custom Ais). Fugitive Demon Class Cruisers
// are added at the witchpoint, main station and in the spacelanes. Groups if battling rebel and imperial ships are added in the 
// spacelanes, the main station, the former prison, the space around the prison and the main station.     

// After making 4 more jumps, the 16th News Broadcast appears. The Thargoid Invasion of Geteve has finally been repelled, but in less
// welcome news the Imperial Dreadnaught has been sighted at Qudior and is now 6 jumps from Eszausve. No changes are made to the ships
// appearing as the Dreadnaught has not arrived yet and the battles at Eszausve continue as before. 

// After making 2 more jumps the Guild will contact the player again and offer the mission to collect a special type of missile which
// can destroy the Dreadnaught from a secret rebel base in the Angeriri system and take them to the Main Station. 
// The base is deserted and main power is out. Docking at the base will trigger a sub-mission, where the player is placed 
// in a retro Chose Your Own Adventure style text adventure using the mission screen. Once the player has completed the text
// adventure, main power is restored and the players missile pylons will be filled with Graviton Missiles. The base will then explode
// due to fluctuations in its power grid. Once the player completes the mission by docking at the Main Station, the Guild will contact
// the player again. The Dreadnaught has arrived in the Eszausve system and is wreaking havoc upon the rebel fleet. The player is
// offered the contract to destroy the Dreadnaught (which can only be done with a Gravitation Missile). The Reble held prison has been
// destroyed by the Dreadnaught and a massive battle is taking place. It is replaced by the Dreadnaught together with battling navy 
// and imperial ships at the time of the mission.

// Destroying the Dreadnaught is the last mission of the OXZ. If the player is successful, the variable is advanced to 3. At this
// stage only rebel ships will be present in the system. 3 jumps after being paid for destroying the Dreadnaught, a News broadcast
// will appear announcing that Eszausve has been readmitted to the Union of Worlds as a Democracy. As the civil war plays out, the
// description, productivity and population of Eszausve will change at each stage. Following the News Broadcast, it will become a 
// democracy and the variable will change to Over. Eszausve main station will be become a normal GalCop Station. Eszausve will be
// a normal democracy, but with the former rebels as the police. The Hotels, additional planets and passenger lines continue to 
// appear and a War Memorial is placed at the former prison location.

// Ships and Stations present when the Variable is at Zero    

// Assassins uses the ships from Dictators OXZ at the start of the OXZ. These will appear regardless of whether Dictators is installed
// or not. If Dictators is installed, then at Eszausve only, Assassins will override the ships normally added by Dictators OXZ using
// a conditions script, so that all the Government and police ships will follow the custom Ais added by the Assassins OXZ. 

// At stage 0 the native populator is overridden so that all police ships and police wingmen and interceptors are replaced with 
// Quaestors, Censors, Enforcers, Guardians and Lictors. These ships have custom Ais, to patrol between the prison, hotels, sun, 
// planet and witchpoint. They have police scan class and will behave as regular police ships, only attacking ships with bounties
// and responding to distress calls. Hunters are replaced with Imperial Mongoose fighters who will patrol the system attacking 
// non-clean ships. Shuttles are replaced with Imperial Shuttles who will also either exit the system by jumping out or go on a 
// patrol of the system looking for non-clean ships to attack. Traders are replaced by one third Prison Ships, one third Liners 
// and one third Mongoose Hunters. The Prison Ships and Liners are escorted by Quaestors, Censors, Enforcers, Guardians and Lictors.
// These transport prisoners to the prison, main station or a randomly picked OXZ station. The Liners will travel between the hotels
// and the main station. These ships will not actively hunt rebels or criminals but will defend themselves if attacked. 

// Pirates are replaced by rebels flying Geckos, Adders, Mambas, Sidewinders, Kraits, Cobra Mark Is & Morays. Although called as 
// pirates, the rebels are not pirates and will only attack imperial ships, although they will defend themselves if attacked. 
// Although the Imperials are the bad guys morally, at this stage they are still the lawful government of Eszausve. The rebel ships
// are offenders and the imperials are lawful ships (albeit lawful evil!). Attacking the rebel ships incurs no legal penalty and
// killing them awards a small bounty. Attacking imperial ships at this stage will earn the player a fugitive rating.

// The main station is replaced by a Torus station, named as Imperial Station: Eyrie of Order. It is defended by Enforcers rather
// than Vipers, but at Stage 0 it is otherwise a normal Main Station.

// The Imperial Prison Red Wing orbits the moon and the Hoopy Hotels Eagle in Flight and Game Theory respectively orbit the 
// gas giants. At stage 0, all three stations are lawful stations.  They will only grant docking permission to clean ships. They will
// attack and launch defence ships to attack any ships with bounties and will respond to distress calls. As with other lawful
// stations, clean players who dock will see a custom arrival message and will be charged a docking fee. Non-Clean players who 
// dock without permission will see a custom arrival report explaining how they were thrown out. The prison will offer cheaper prices
// on minerals, gold, platinum and gemstones and will sometimes pay more for food, machinery and textiles. The Hotels will offer
// higher prices for food, textiles, luxuries, gold, platinum and gemstones.

// The scripts for each of the three stations also populate space near them with ships. The prison adds an asteroid field and groups
// of 3 Censors and 3 Enforcers with Ais to patrol around the prison and attack any ships with bounties. It also adds a Prison Ship
// with 2 Quaestor escorts. This ship has an AI to fly around near the prison until the player arrives and then dock with the prison.
// A second Prison Ship with 2 Enforcer escorts is also added near the prison. This ship will travel from the prison to the Main 
// Station and when it arrives, it will dock with the main station.

// The Game Theorys script adds a group of 3 Lictors who patrol around the Hotel and will attack ships with bounties. A passenger
// liner with 2 Guardian escorts is also added near the hotel with an AI to fly around near the hotel until the player arrives and 
// then dock with the hotel. Three more liners are added at respectively, 2,500kms, 7,500kms and 15,000kms from the hotel. The first
// has an AI to travel to the Main Station and dock with it and the second and third have Ais to travel to the hotel and dock with it.

// The Eagle in Flights script is similar and adds a group of 3 Guardians to patrol around the Hotel and attack ships with bounties. 
// A passenger liner with 2 escorts is also added near the hotel with an AI to fly around near the hotel until the player arrives and
// then dock with the hotel. Three more liners are added at respectively, 10,000kms, 20,000kms and 30,000kms from the hotel. The first
// has an AI to travel to the Main Station and dock with it and the second and third have Ais to travel to the hotel and dock with it.

// The Main Script also adds: A group of 3 Censor Police Patrol ships near the Main Station with Ais to patrol around the Main Station.
// Three groups of Lictors, Quaestors and Enforcers are also added in the spacelane with Ais to patrol between the prison, hotels, 
// sun, planet and witchpoint. Additionally, 2 Prison Ships with escorts are added by the Main Script, both with Ais to travel to 
// the prison and dock with it. The first is added 25kms from the players position (either near the witchpoint or near whichever
// station the player is docked with) and the second is added in the spacelane. A third Prison Ship with escorts and an AI to pick
// a random OXZ station within 500kms of its spawn point and dock with it, is also added.

// Ships and Stations present when the Variable is at One

// In addition to the ships present at level 0, Imperial Scorpion Class Frigates with Mongoose escorts are added at the Witchpoint, 
// spacelane and near the main station. The Scorpions own script spawns groups of rebel ships nearby. At this stage the dictatorship
// is still the lawful government, so its ships have police scan class and the rebel ships are offenders.

// Ships appearing when the Deamons Variable is at Lawful

// During this phase of the OXZ, the Dictatorship is still the official government, so their ships have police scan-class and the
// rebels are fugitives. 4 Deamon Class Cruisers with Scorpion escorts are added at the witchpoint, main station and in the spacelanes
// along with groups of attacking rebel ships. The prison will also be under attack by rebels.

// Ships appearing when the Reinforcements Variable is at Outlaw

// Following the successful assassination of the Sky Marshal by the player, the reinforcements variable is set to Outlaw. During this
// phase, 6 additional offender rebel ships are added near the main station with Ais to go to the main station and attack imperial 
// ships. After the 14th News Broadcast has been read, 6 further offender rebel ships are added at both the main station and the 
// prison. The rebels will now have the advantage over the imperial ships.

// Ships and Stations present when the Variable is at Two

// Whilst the variable is at 2: 1) The Main Station is renamed New Hope and is described as a Rebel Station. It is now defended by
// Rebel Sonoran fighters with police scan class. 2) All police, interceptor and wingman ships in the system are replaced with Rebel
// Sonoran fighters. 3) All pirates in the system are replaced with fugitive Imperial Scorpions with Ais to attack any non-imperial
// ships they encounter. 4) All hunters and traders in the system are replaced with Imperial Mongoose fighters. Although called by
// the populator as hunters or traders they are all offenders and will attack any non-imperial ships they encounter. 5) If Dictators
// OXZ is installed then any freighters and prison ships it would otherwise have added are replaced with offender imperial shuttles
// with Ais to attack any non-imperial ships they encounter. 6) A total of 2 Deamon Class Cruisers, 7 Scorpions and 10 Mongoose 
// fighters are added near the main station with Ais to attack all non-imperial ships. 7) A Deamon Class Cruiser, 5 Scorpions, 
// 5 Mongoose fighters and 3 Rebel Sonoran fighters are added at the witchpoint. If the Imperials destroy all the ships at the 
// witchpoint, they will then head for the main station. 8) A fourth Deamon and groups of Mongoose fighters, imperial shuttles and
// Rebel Sonoran fighters are added to the spacelanes with Ais to intercept each other. If the Demon destroys all targets near its
// spawn point it will head for the rebel held prison. 9) The former prison is renamed Rebel Base: Echo of Hoth and is now defended
// by Sonoran fighters and attacked by imperial ships. During this phase of the OXZ the rebel base will not be offering normal station
// services due to the war and if the player docks with the base they will receive a message explaining that no services are available,
// and they will be re-launched. 10) The two Hoopy Hotels conduct business as usual, but they are now defended by Rebel Sonoran 
// fighters. Functionally, they remain the same. However, no passenger liners appear until the civil war is over.

// Additional Ships appearing during the mission to destroy the Dreadnaught

// The Civil War variable remains at 2 and therefore the battling rebel and imperial ships appear in the system as previously. Whilst
//  the variable is at 55, the Prison is no longer added and in its place the Dreadnaught is spawned at its former location. The 
// Dreadnaughts script spawns an asteroid field within 25kms of its starting position and it will remain within the asteroid field.
// Its script also adds three special Aeron Class Frigates. The Dreadnaught and the Frigates all have station level energy and 
// recharge so cannot be destroyed by normal means. The Frigates attack the dreadnaught and the dreadnaught will use its turrets on
// any frigates in range.
 
// The script also adds a group of 5 Imperial Shuttles, 3 Scorpion Frigates and 3 Mongoose fighters with Ais to attack the frigates. 
// These ships have normal energy levels, but the Frigates wont respond to attacks by them and will keep attacking the dreadnaught.
 
// When the frigates detect the player come within scanner range, one will become vulnerable and whilst it will continue to fight, it
// will explode the next time an enemy ship hits it. The other two will fly away and then jump out. The effect is that the Dreadnaught
// and 14 other ships will be exchanging fire in the centre of the asteroid field. The Dreadnaught is large enough to be visible from
// about 500kms and the large asteroid field and all the laser blasts will be seen if you fly towards the moon, enabling you to find
// the Dreadnaught. Once you arrive however, the frigates will be removed by being destroyed or jumping out and the Dreadnaught and
// the other imperials will attack the player. The Dreadnaught's script also adds a total of 9 Mongoose Fighters, 9 Imperial Shuttles
// and 3 Scorpion Frigates within 25km of its spawn position. These ships have AIs to patrol the asteroid field looking for the player
// and attack them as soon as they enter the field. Additionally, 12 Mongoose fighters, 6 Imperial Shuttles and 2 Scorpions are added
// in spheres between 35 and 105kms of the Dreadnaughts spawn position. These ships will fly towards either the witchpoint or main
// station looking for the player. 

// Ships are also added between the Dreadnaughts position and the main station with Ais to fly towards the main planet / main station
// and attack the player if they intercept them. 3 Mongoose Fighters at 125kms. 3 Shuttles at 175kms. A Scorpion at 225kms. 
// 3 Mongoose Fighters at 300kms. A Demon Class Cruiser with 4 Mongoose escorts at 400kms. 3 Shuttles at 500kms. 3 Mongoose Fighters
// at 600kms. A Scorpion at 700kms. The environmental story is the Rebels attacking the Dreadnaught have been destroyed and the
// advance Imperial Fleet is heading for the station with the Balrog being held off by the last three frigates. If the player is
// starting from the Main Station (eg they jumped in and then docked and saved their game to attempt the Balrog mission), then these
// ships will provide the opposition on the way to the Dreadnaught. The ships are always present, but wont be encountered by the
// player if travelling from the Witchpoint. They will all ultimately arrive at the Main Station though and get into fights with the
// Frigates and Police Ships there. 9 more Mongoose Fighters and 3 Scorpions are added within 45kms of the Dreadnaughts position with
// Ais to fly towards the witchpoint and attack the player. At the witchpoint a Deamon Class Cruiser with 4 Mongoose escorts, a 
// Scorpion with 2 Mongoose Escorts, a group of 5 Mongoose Fighters and 3 Imperial Shuttles are added. Another Scorpion with two 
// Mongoose escorts and 3 Imperial Shuttles are added near the witchpoint. 

// Ships and Stations present when the Variable is at Three

// 3 jumps after being congratulated on destroying the Dreadnaught, the final news broadcast of the OXZ will be shown. At this point
// Eszausve becomes an officially recognised democracy and the variable changes to Over. In this interim phase however, although
// the rebels have won, the system is still a dictatorship in code and so will be populated by the system populator as a dictatorship
// rather than a democracy. 

// No imperial ships are added (as the empire has now fallen), but Oolite will add pirate ships in the normal way. To make the system
// better policed than a standard dictatorship, 9 additional police ships are added between the witchpoint and the main station. These
// will all be Rebel Sonoran fighters as the override of police ships at Eszausve remains in place. 3 Areon Class Frigates are added
// at the witchpoint with an AI to patrol the system and another 3 are added near the Main Station with Ais to patrol around the Main
// Station. An asteroid field and 2 rebel police patrol ships are added at the location of the destroyed prison.

// Ships and Stations present when the Variable is at Over

// Now that the civil war is over, a War Memorial is added at the location of the destroyed prison. The Memorial's script spawns an
// asteroid field around it and a squad of three police Sonoran ships with Ais to patrol the asteroid field. They will attack criminals
// and any ships firing on the Memorial.  A Liner with two Fer-de-lance escorts is also added in the asteroid field. Its AI will
// remain in the asteroid field unless or until the player arrives. When the player arrives, it will fly towards the Monument and
// broadcast a prayer when it gets there. It will then go to the Main Station and dock with it. If it cannot dock it will fly back
// towards the monument and repeat the loop. 

// A liner escorted by two Asps and a liner escorted by two Cobra Mark IIIs are added near each of the hotels. Each has an AI to fly
// around near the hotel until or unless the player arrives. They will then dock with the hotel. If they cannot dock they will pick
// a random destination (Main Station, Witchpoint, OXP station or a Hotel) and fly there to dock with the station there instead. 

// On each visit to the system a liner escorted by either Sidewinders or Geckos is added near the main station with an AI to go to
// either the Hades or Lernean Hoopy Hotel and dock with the Hotel. A liner escorted by Mambas is added in the spacelane about 55kms
// from the Main Station with an AI to go to the Main Station and dock with it. A liner escorted by two Kraits is added about 4,800kms
// from the Main Station in a line with the Hades Hoopy Hotel, with an AI to go to the main station and dock with it. A liner escorted
// by two Cobra Mk Is with an AI to go to the Lernean Hoopy Hotel is added 7,500kms from the hotel. A liner escorted by either 
// Sidewinders or Geckos is added at the Witchpoint with an AI to go to a random OXZ station. If there are none, it will go to the 
// main station, the witchpoint or one of the Hoopy Hotels.

// Liners escorted by two Wolves are added in the spacelane and near each of the hotels. These ships have Ais to go to the Witchpoint
// and dock with any stations near the witchpoint. If none are present, then they will go to one of the hotels or the main station and
// dock there. Two more liners escorted by Asps and Cobra Mark IIIs are added in the spacelane with AIs to go to a random OXZ station.
// If there are none, they will go to the main station, the witchpoint or one of the Hoopy Hotels. A total of 15 liners are added to
// the system, although usually only a couple will actually be seen by the player on each visit. 

// Finally, a group of 3 Sonoran police ships are added to patrol around the main station and additional Sonoran police ships are
// added at the witchpoint and in the spacelane.

// ***************************************************************************** Story Note *****************************************************************************************
// Starting State - Imperial Control (Civil War Variable at Zero or 1)
if (missionVariables.assassins_rebooted_civil_war < 2) {
// Add the Imperial Prison - The Red Wing. (At the Start of the OXZ it is part of the lawful govenment of Eszausve).
system.legacy_addShipsAt("assassins_rebooted_red_wing", 1, "pwm", [-200000, -700000, 260000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-200000, -700000, 250000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-200000, -700000, 270000]);
// Add the Hades Hoopy Hotel - Game Theory
system.legacy_addShipsAt("assassins_rebooted_hades_hotel_imperial", 1, "pwm", [5000000, 3000000, 25278750]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [5000000, 3000000, 25267250]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [5000000, 3000000, 25288750]);
// Add the Lernean Hoopy Hotel - Eagle in Flight
system.legacy_addShipsAt("assassins_rebooted_lernean_hotel_imperial", 1, "pwm", [-2900000, -7500000, -27358750]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-2900000, -7500000, -27347250]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-2900000, -7500000, -27370250]);
// Add a group of 3 Censor Police Patrol ships near the Main Station with a Planet Patrol AI.
system.addShips("assassins_rebooted_censor_planetpatrol_leader",1,system.mainStation.position.add([27000,0,0]), 1000)[0];
// Add a Prison Ship with 2 Censor escorts. 
// If entering the system from hyperspace it will be near the wichpoint. If launching from a saved game, it will be near the station the player saved at.
system.addShips("assassins_rebooted_homebound_prison_ship",1,player.ship.position.add([24500,0,0]), 1000)[0];
// Add a group of 3 Lictor Police Patrol ships in the spacelane with an AI to patrol between the spacelane and the sun.
system.legacy_addShipsAt("assassins_rebooted_lictor_sunpatrol_leader", 1, "wpu", [0, 0, 0.25])
// Add another Prison Ship with 2 Quaestors escorts and an AI to find the nearest OXZ station within 500kms of its starting point and dock with it. 
// If there are none it will go to the main station.
system.legacy_addShipsAt("assassins_rebooted_spacelane_prison_ship", 1, "wpu", [0, 0, 0.34])
// Add another Prison Ship with 2 Censor escorts about half-way between the witchpoint and the planet also with an AI to go to the Prison and dock with it.
system.legacy_addShipsAt("assassins_rebooted_homebound_prison_ship", 1, "wpu", [0, 0, 0.52])
// Add a group of 3 Quaestor Police Patrol ships in the spacelane with an AI to go to the prison, the hotels, the main station or the witchpoint (Dice Roll in the AI).
system.legacy_addShipsAt("assassins_rebooted_quaestor_randompatrol_leader", 1, "wpu", [0, 0, 0.65])
// Add a group of 3 Enforcer Police Patrol ships in the spacelane with an AI to patrol between the main station and the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_enforcer_spacelanepatrol_leader", 1, "wpu", [0, 0, 0.75])
// Once the variable is at 1, Imperial Scorpion Class Frigates with Mongoose escorts are added to the system. The Scorpion's script adds a group of 3 rebels
// nearby, so there will usually be a battle going at the spawn point.
if (missionVariables.assassins_rebooted_civil_war === 1) {
// Add a Scorpion and group of Rebels at the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_scorpion_imperial_control", 1, "wpu", [0, 0, 0.00])
// Add a Scorpion and group of Rebels in the main spacelane.
system.legacy_addShipsAt("assassins_rebooted_scorpion_imperial_control", 1, "wpu", [0, 0, 0.45])
// Add a Scorpion and group of Rebels near the main station.
system.legacy_addShipsAt("assassins_rebooted_scorpion_imperial_control", 1, "wpu", [0, 0, 0.85])
// Closing Bracket for additional ships added when the variable is at 1.
}
// Closing bracket for Stations and Ships added when Civil War Variable is 0 or 1.
}
// Once the civil war breaks out Deamon Class Crusiers and Scorpions are deployed by the Dictatorship to fight the rebles.
// At this stage the Dictatorship is still the lawful govenment of the system, so their ships have police scan class and the rebles are offenders and fugitives.
if (missionVariables.assassins_rebooted_deamons === "Lawful") {
// Add a Deamon Class Cruiser with 2 Scorpion escorts and a group of three rebels flying Sonoran fighters at the witchpoint..
system.legacy_addShipsAt("assassins_rebooted_deamon1_imperial_control", 1, "wpu", [0, 0, 0.00])
// Add a Deamon with Scorpion escorts and group of attacking rebels with an AI to patrol around the main station.
if (missionVariables.assassins_rebooted_stage !== 47) {system.addShips("assassins_rebooted_deamon2_imperial_control",1,system.mainStation.position.add([10000,0,0]), 1000)[0];}
// Add a group of Rebles flying Sonoran fighters near the main station.
system.addShips("assassins_rebooted_rebel_outlaw_sonoran_type3",1,system.mainStation.position.add([15000,0,0]), 1000)[0];
system.addShips("assassins_rebooted_weak_outlaw_rebel",3,system.mainStation.position.add([10000,0,0]), 1000)[0];
// Add a Deamon in the spacelane with Scorpion escorts and group of attacking rebels with an AI to patrol the spacelane and go to the main station.
system.legacy_addShipsAt("assassins_rebooted_deamon3_imperial_control", 1, "wpu", [0, 0, 0.25]) 
// Add a groups of weak rebel ships in the spacelane.
system.legacy_addShipsAt("assassins_rebooted_weak_outlaw_rebel", 3, "wpu", [0, 0, 0.35]) 
system.legacy_addShipsAt("assassins_rebooted_weak_outlaw_rebel", 2, "wpu", [0, 0, 0.52]) 
// Add a Deamon in the spacelane with Scorpion escorts and group of attacking rebels with an AI to patrol the spacelane and go to the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_deamon4_imperial_control", 1, "wpu", [0, 0, 0.65]) 
// Add a group of 3 rebles flying Sonoran fighters with an AI to go to the main station and attack imperial ships there.
system.legacy_addShipsAt("assassins_rebooted_rebel_outlaw_sonoran_type3", 1, "wpu", [0, 0, 0.75]) 
// Add another group of weak rebels in the spacelane.
system.legacy_addShipsAt("assassins_rebooted_weak_outlaw_rebel", 3, "wpu", [0, 0, 0.85])
}
// At the time of the 9th Assassination, add Sky Marshal Claudius Maximus in a Deamon Class Cruiser with 2 Deamon Class Cruiser escorts.
if (missionVariables.assassins_rebooted_stage === 47) {
missionVariables.assassins_rebooted_escort_counter = 0;
system.addShips("assassins_rebooted_victim9",1,system.mainStation.position.add([20000,0,0]), 1000)[0];
delete missionVariables.assassins_rebooted_escort_counter;
}
// Once the 9th Assassination is completed, the death actions of Victim 9 will set the reinforcements variable to Outlaw.
// Whilst the variable is set to Outlaw, 6 additional rebles with offender status are added near the main station with an AI to go to the main station and attack imperial
// ships near the station. Another 6 ships are added near the prison after the 14th News Broadcast has been seen.
if (missionVariables.assassins_rebooted_reinforcements === "Outlaw") {
system.addShips("assassins_rebooted_rebel_outlaw_sonoran_type3",1,system.mainStation.position.add([12000,0,0]), 1000)[0];
system.addShips("assassins_rebooted_rebel_outlaw_sonoran_type3",1,system.mainStation.position.add([30000,0,0]), 1000)[0];
if (missionVariables.assassins_rebooted_stage > 49) {
system.addShips("assassins_rebooted_rebel_outlaw_sonoran_type3",1,system.mainStation.position.add([18000,0,0]), 1000)[0];
system.addShips("assassins_rebooted_rebel_outlaw_sonoran_type3",1,system.mainStation.position.add([19000,0,0]), 1000)[0];
}
}
// Once the Rebels take control of the main station and the prison, the civil war variable is advanced to 2 and different ships and stations appear.
if (missionVariables.assassins_rebooted_civil_war === 2) {
// Add 2 Fugitive Deamon Class Cruiser each with 2 Scorpion Escorts near the main station with an AI to attack non-imperial ships.
system.addShips("assassins_rebooted_deamon1_rebel_control",1,system.mainStation.position.add([10000,0,0]), 1000)[0];
system.addShips("assassins_rebooted_deamon2_rebel_control",1,system.mainStation.position.add([13000,0,0]), 1000)[0];
// Add a wing of 3 Fugitive Scorpions near the main station with an AI to attack non-imperial ships.
system.addShips("assassins_rebooted_imperial_scorpion_outlaw_station_attacker",1,system.mainStation.position.add([15000,0,0]), 1000)[0];
// Add a wing of 5 Offender Mongoose Fighters near the main station with an AI to attack non-imperial ships.
system.addShips("assassins_rebooted_imperial_mongoose_outlaw_station_attacker",1,system.mainStation.position.add([17000,0,0]), 1000)[0];
// Add a second wing of 5 Offender Mongoose Fighters near the main station with an AI to attack non-imperial ships.
system.addShips("assassins_rebooted_imperial_mongoose_outlaw_station_attacker",1,system.mainStation.position.add([25000,0,0]), 1000)[0];
// Add a third Deamon Class Cruiser with two Scorpion escort at the witchpoint. If it destroys all ships at the witchpoint, it will then head for the main station.
system.legacy_addShipsAt("assassins_rebooted_deamon3_rebel_control", 1, "wpu", [0, 0, 0.00])
// Add another wing of 3 Scorpions at the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_imperial_scorpion_outlaw_station_attacker", 1, "wpu", [0, 0, 0.00])
// Add a wing of 5 Mongoose Fighters at the witchpoint.
system.legacy_addShipsAt("assassins_rebooted_imperial_mongoose_outlaw_station_attacker", 1, "wpu", [0, 0, 0.00])
// Add two police ships (Rebels flying Sonoran fighters) at the witchpoint. (An additional Rebel is spawned near the Daemon by the Daemon's own script).
// All police ships at Eszausve are replaced by Rebel Sonorans at this stage of the OXZ, so these ships will be in addition to any ships added by the native populator.
system.legacy_addShipsAt("police", 2, "wpu", [0, 0, 0.00])
// Add groups of Mongoose Fighters, Imperial Shuttles, Rebel Sonorans and a fourth Deamon to the spacelanes.  
system.legacy_addShipsAt("assassins_rebooted_imperial_mongoose_outlaw_station_attacker", 1, "wpu", [0, 0, 0.15])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.15])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.20])
system.legacy_addShipsAt("assassins_rebooted_imperial_mongoose_outlaw_station_attacker", 1, "wpu", [0, 0, 0.25])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.25])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.30])
system.legacy_addShipsAt("assassins_rebooted_imperial_mongoose_outlaw_station_attacker", 1, "wpu", [0, 0, 0.35])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.40])
system.legacy_addShipsAt("assassins_rebooted_imperial_mongoose_outlaw_station_attacker", 1, "wpu", [0, 0, 0.45])
system.legacy_addShipsAt("assassins_rebooted_imperial_shuttle_outlaw_witchpoint_attacker", 1, "wpu", [0, 0, 0.50])
// The Deamon's own script adds a Rebel Sonoran near the Deamon's spawn point. If it destroys all targets at its spawn point it will go to the Rebel held prison.
system.legacy_addShipsAt("assassins_rebooted_deamon4_rebel_control", 1, "wpu", [0, 0, 0.55])
system.legacy_addShipsAt("assassins_rebooted_imperial_shuttle_outlaw_witchpoint_attacker", 1, "wpu", [0, 0, 0.60])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.65])
system.legacy_addShipsAt("assassins_rebooted_imperial_mongoose_outlaw_witchpoint_attacker", 1, "wpu", [0, 0, 0.75])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.80])
system.legacy_addShipsAt("assassins_rebooted_imperial_mongoose_outlaw_witchpoint_attacker", 1, "wpu", [0, 0, 0.85])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.90])
system.legacy_addShipsAt("assassins_rebooted_imperial_mongoose_outlaw_station_attacker", 1, "wpu", [0, 0, 0.95])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.95])
system.legacy_addShipsAt("police", 2, "wpu", [0, 0, 1.00])
// Add the Rebel held Prison together with Minesweepers .
// As the Prison is now held by the Rebels it is renamed "Rebel Base: Echo of Hoth" and is defended by Rebel Sonorans.
// This is done by using a like-shiped version of the imperial held prison.
if (missionVariables.assassins_rebooted_stage < 55) {
system.legacy_addShipsAt("assassins_rebooted_echo_of_hoth", 1, "pwm", [-200000, -700000, 260000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-200000, -700000, 250000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-200000, -700000, 270000]);
}
// At the time of the Final Mission, the Base has been destroyed, so the Dreadnaught is spawned at the former base's position and its script spawns the asteroid field and
// the mission ships.
if (missionVariables.assassins_rebooted_stage === 55) {
// At the time of the Final Mission add The Imperial Dreadnaught where the rebel held prison used to be.
// Its own script spawns an asteroid field around it (as appears before the station was destroyed) and also adds Aeoron Class Frigates and imperial ships.
// The First Frigate will attack the Dreadnaught. It will use its turrents on the Frigate, but will hold position within 1 to 2 kms of its spawn point.
// A group of 5 Imperial Shuttles will attack the Frigate (but it will ignore them and keep attacking the Dreadnaught).
// The Frigate has virtually indestructable energy and recharge so the battle will continue until the player arrives. When the Frigate detects the player, it will then
// become vunerable to attack and will be destroyed by the Balrog or the shutles (as taking one more hit about the player arrives causes to to execute becomeExplosion).
// Once the First Target dummy explodes, the Balrog and the shuttles will attack the player.
// A second Target dummy is also added by the Balrog's script. This also attacks the Dreadnaught, but when the player arrives it will jump out. This ship is in turn
// attacked by a group of 3 Mongoose Fighters. These will also attack the player when the second frigate jumps out. 
// A third target dummy, also attacks the dreadnaught and is in turn attacked by 3 Scorpion Frigates. When it detects the player it will head 30kms away and then jump.
// If it is hit whilst travelling then it explodes. The scorpions will attack the player once the target dummy ship is destroyed or jumps.
// Three groups of 3 Mongoose Fighters are added in the asteroid field with AIs to patrol around the asteroid field and attack the player if they find them.
// Groups of Scorpions and Shuutles are also added in the asteroid field with the same AI.
// Waves of Mongoose Fighters, Shuttles, Scorpions and a Demon Class Cruiser are all also added between the Dreadnaught's position and  the main station with AIs to
// fly towards the Main Station / Main Planet and attack the player if they encounter them.
system.legacy_addShipsAt("assassins_rebooted_victim10", 1, "pwm", [-200000, -700000, 260000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper_type2", 1, "pwm", [-200000, -700000, 250000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper_type2", 1, "pwm", [-200000, -700000, 270000]);
// A group of 3 Aeron Class Frigates are added near the main station with an AI to patrol around the main station and attack imperial ships.
system.addShips("assassins_rebooted_aeron_cavalry_type2",1,system.mainStation.position.add([5000,0,0]), 1000)[0];
// Add groups of Mongoose Fighters with an AI to patrol the system looking for the player to the spacelanes.
system.legacy_addShipsAt("assassins_rebooted_mongoose_imperial_outlaw_mission_space_lane", 1, "wpu", [0, 0, 0.20])
system.legacy_addShipsAt("assassins_rebooted_mongoose_imperial_outlaw_mission_space_lane", 1, "wpu", [0, 0, 0.40])
system.legacy_addShipsAt("assassins_rebooted_mongoose_imperial_outlaw_mission_space_lane", 1, "wpu", [0, 0, 0.60])
system.legacy_addShipsAt("assassins_rebooted_mongoose_imperial_outlaw_mission_space_lane", 1, "wpu", [0, 0, 0.80])
// Ships to intercept the player at the witchpoint. If the player escapes, they will head towards the Dreadnaught's position.
// Add a Deamon Class Cruiser with 4 Mongoose Escorts at the Witchpoint.
system.legacy_addShipsAt("assassins_rebooted_victim10_demon_player_killer_squad_dreadnaught", 1, "wpu", [0, 0, 0.00])
// Add a Scorpion with 2 Mongoose Escorts at the Witchpoint.
system.legacy_addShipsAt("assassins_rebooted_victim10_scorpion_player_killer_squad_dreadnaught", 1, "wpu", [0, 0, 0.00])
// Add a group of 5 Mongoose Fighters at the Witchpoint.
system.legacy_addShipsAt("assassins_rebooted_victim10_mongoose_player_killer_squad_dreadnaught", 1, "wpu", [0, 0, 0.00])
// Add a group of 3 Imperial Shuttles at the Witchpoint.
system.legacy_addShipsAt("assassins_rebooted_victim10_shuttle_player_killer_squad_dreadnaught", 1, "wpu", [0, 0, 0.00])
// Add another group of Imperial Shuttles near the Witchpoint.
system.legacy_addShipsAt("assassins_rebooted_victim10_shuttle_player_killer_squad_dreadnaught", 1, "wpu", [0, 0, 0.05])
// Add another Scorpion with 2 Mongoose Escorts near the Witchpoint.
system.legacy_addShipsAt("assassins_rebooted_victim10_scorpion_player_killer_squad_dreadnaught", 1, "wpu", [0, 0, 0.10])
// Closing Bracket for ships added during the mission to destroy the Dreadnaught.
}
// Closing Bracket for Civil War variable at 2.
}
// Once the Rebles take control, the Hoopy Hotels are defended by Sonorans but they are functionaly the same as when controled by the empire.
// No passenger liners appear however until the civil war is over (added by the hotels own scripts).
// After the destuction of the Prison (when the variable is at 3 or "Over") it is replaced with an ateroid field.
if (missionVariables.assassins_rebooted_civil_war > 1 || missionVariables.assassins_rebooted_civil_war === "Over") {
// Add the Hades Hoopy Hotel - Game Theory
system.legacy_addShipsAt("assassins_rebooted_hades_hotel_democratic", 1, "pwm", [5000000, 3000000, 25278750]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [5000000, 3000000, 25267250]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [5000000, 3000000, 25288750]);
// Add the Lernean Hoopy Hotel - Eagle in Flight
system.legacy_addShipsAt("assassins_rebooted_lernean_hotel_democratic", 1, "pwm", [-2900000, -7500000, -27358750]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-2900000, -7500000, -27347250]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-2900000, -7500000, -27370250]);
// During the three jump delay between the Rebels winning the civil war and being recognised as a democracy, the system will in code
// still be a dictatorship and so not well policed. An asteroid field is added to the former prison's location and extra police ships
// and Aeron Class Frigates are added to boost the policing level to higher than a normal dictatorship.
if (missionVariables.assassins_rebooted_civil_war === 3) {
// Add an asteroid at the co-ordinates of the former prison with a script to spawn 45 of Griff's glowing rocks within 25kms of its
// position to create the asteroid field. 2 Reble police ships are also spawned between 15 and 45kms with system patrol AIs.
system.legacy_addShipsAt("assassins_rebooted_asteroid_field_spawner_rock_field", 1, "pwm", [-200000, -700000, 260000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-200000, -700000, 250000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-200000, -700000, 270000]);
// Add extra police ships at the witchpoint and in the spacelanes.
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.00])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.00])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.10])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.20])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.45])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.65])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.80])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.90])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 1.00])
// Add a group of 3 Aeron Class Frigates with an AI to patrol around the Main Station, near the Main Station 
system.addShips("assassins_rebooted_aeron_cavalry_type2",1,system.mainStation.position.add([9000,0,0]), 1000)[0];
// Add another group of 3 Aeron Class Frigates at the witchpoint with AIs to patrol the witchpoint and then patrol the system.
system.legacy_addShipsAt("assassins_rebooted_aeron_cavalry_type3", 1, "wpu", [0, 0, 0.0])
}
if (missionVariables.assassins_rebooted_civil_war === "Over") {
// A War Memorial is added at the sight of the destroyed prison.
// The Memorial's own script spawns an asteroid field around it and 3 Sonoran police patrol ships with AIs to patrol around
// the asteroid field. They will attack offenders and fugitives and any ship fireing at the War Memorial. A liner with two
// fer-de-lance escorts is also added in the Asteroid field. It will stay in the asteroid field until the player arrives, it will
// then fly to the Monument, broadcast a prayer and then go to the Main Station and dock there.
system.legacy_addShipsAt("assassins_rebooted_war_memorial", 1, "pwm", [-200000, -700000, 260000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-200000, -700000, 250000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [-200000, -700000, 270000]);
// The Hotels' own scripts add Liners escorted by Cobra Mark IIIs and Asps near each hotel. These will wait for the player to
// arrive and then dock with the hotel. A group of 3 Sonoran police patrol ships with AIs to patrol around the hotel are
// also added. The main script also adds liners to the system. Additionally, the hotel's scripts add a Liner 4,800kms from the
// main station with an AI to go to the main station and a Liner 7,500kms from the Lernean hoopy hotel with an AI to go to the
// hotel and dock with it. These liners may be encountered if flying to the hotels from the Main Station. A Liner escorted by
// Wolf Mark Is with an AI to go to the witchpoint and dock with the nearest station to the witchpoint is added by each hotel's
// script near each of the hotels.
// Add a Liner escorted by two sidewinders with an AI to go to the Lernean Hoopy Hotel and dock with it or a Liner escorted
// by two geckos with an AI to go to the Hades Hoopy Hotel and dock with it (50/50 chance) by the Main Station.
// A Liner escorted either by sidewinders or geckos is added at the Witchpoint with an AI to go to a random station within
// 500kms of its starting position and dock with it. If there are none it will either go to the main station, the witchpoint
// or one of the hotels.
var diceroll = expandDescription("[assassins-coin-flip]");
if (diceroll === "Heads") {
system.addShips("assassins_rebooted_democratic_lernean_homebound_liner",1,system.mainStation.position.add([10000,0,0]), 3000)[0];
system.legacy_addShipsAt("assassins_rebooted_democratic_oxpstation_liner_type2", 1, "wpu", [0, 0, 0.0])
}
if (diceroll === "Tails") {
system.addShips("assassins_rebooted_democratic_hades_homebound_liner",1,system.mainStation.position.add([10000,0,0]), 3000)[0];
system.legacy_addShipsAt("assassins_rebooted_democratic_oxpstation_liner_type1", 1, "wpu", [0, 0, 0.0])
}
// Add a Liner escorted by two Mambas with an AI to go to the main station and dock with it in the spacelane about 55kms from
// the main station.
system.legacy_addShipsAt("assassins_rebooted_democratic_mainstationbound_liner_type1", 1, "wpu", [0, 0, 0.85])
// Add a Liner escorted by two Wolf Mark Is with an AI to go to the witchpoint and dock with the closest station to the witchpoint.
// If there are no stations near the witchpoint, it will go to the main station or one of the hotels.
system.legacy_addShipsAt("assassins_rebooted_democratic_witchpoint_liner", 1, "wpu", [0, 0, 0.75])
// Add two liners, one escorted by Asps and the other escorted by Cobra Mark IIIs in the spacelanes with an AI to go to a random 
// station within 500kms of its starting position and dock with it. If there are none it will either go to the main station, the
// witchpoint or one of the hotels.
system.legacy_addShipsAt("assassins_rebooted_democratic_oxpstation_liner_type3", 1, "wpu", [0, 0, 0.55])
system.legacy_addShipsAt("assassins_rebooted_democratic_oxpstation_liner_type4", 1, "wpu", [0, 0, 0.35])
// Finally add a Squad of 3 Sonoran police ships are added to patrol around the main station and additional Sonoran police ships are
// added at the witchpoint and in the spacelane.
system.addShips("assassins_rebooted_rebel_police_additional_planet_patrol_leader",1,system.mainStation.position.add([20000,0,0]), 2000)[0];
system.addShips("police",1,system.mainStation.position.add([15000,0,0]), 2000)[0];
system.addShips("police",1,system.mainStation.position.add([18000,0,0]), 2000)[0];
system.legacy_addShipsAt("police", 2, "wpu", [0, 0, 0.0])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.65])
system.legacy_addShipsAt("police", 1, "wpu", [0, 0, 0.45])
}
// Closing Bracket for Civil War variable at 2, 3 and "Over".
}
// Closing Bracket for Eszausve.
}
// Populate Angeriri.
if (system.ID === 71) {
// No new planets, ships or stations are ordinarily added to Angeriri, but in order to complete the 10th Assassination, the player will need to collect a special
// Missile from the Rebel Outpost in Angeriri. The Outpost, together with hostile imperial ships are added at the time of this mission. The outpost is destroyed
// when the player completes the Text Adventure mission set on it and leaves with Graviton Missiles on their pylons. 
if (missionVariables.assassins_rebooted_stage === 53) {
// Add the Black Mesa Reserach Facility out of the space lane (the player will need to use their ASC to follow its secret beacon code) to find it.
// The Stations own script spawns an asteroid field around it and a distress beacon buoy which sends out an automated distress call every 30 seconds.
// The text adventure begins when the player docks at the Facility. The facility is added about 500kms from the witchpoint and 925kms from the Main Station.
system.legacy_addShipsAt("assassins_rebooted_black_mesa", 1, "pwm", [250000, 400000, 840000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [250000, 400000, 830000]);
system.legacy_addShipsAt("assassins_rebooted_minesweeper", 1, "pwm", [250000, 400000, 850000]);
// Add a group of three Scorpion Frigates wilh an AI to attack the player near the player's stating position (either the witchpoint if jumping in or the station the player is
// docked at if loading from a saved game). If they don't encounter the player or the player runs away and gets out of scanner range, they will fly to the Black Mesa base
// looking for the player. If they reach the base they switch to a general player hunter AI and will pick a random new destination of the witchpoint, sun, main planet or the
// main station and patrol this route looking for the player.
system.addShips("assassins_rebooted_scorpion_imperial_outlaw_mission_base_bound",1,player.ship.position.add([1000,0,0]),15000)[0];
// Add a group of 3 Mongoose Fighters wil the same AI to go to the base and look for the player, out of scanner range, so may be encountered on the way to the base.
system.addShips("assassins_rebooted_mongoose_imperial_outlaw_mission_base_bound",1,player.ship.position.add([1000,0,0]),45000)[0];
// Add 4 groups of 3 Mongoose fighters in the spacelane with general kill player AI in the spacelanes.
system.legacy_addShipsAt("assassins_rebooted_mongoose_imperial_outlaw_mission_space_lane", 1, "wpu", [0, 0, 0.20])
system.legacy_addShipsAt("assassins_rebooted_mongoose_imperial_outlaw_mission_space_lane", 1, "wpu", [0, 0, 0.40])
system.legacy_addShipsAt("assassins_rebooted_mongoose_imperial_outlaw_mission_space_lane", 1, "wpu", [0, 0, 0.60])
system.legacy_addShipsAt("assassins_rebooted_mongoose_imperial_outlaw_mission_space_lane", 1, "wpu", [0, 0, 0.80])
// The Rebel Facility's script adds 2 groups of 3 Mongoose fighters near its own position with AIs to go to the witchpoint and attack the player if they find them.
// The Facility's script also adds Three Groups of 5 Mongoose fighters are added in a line between the Facility and the Main Station at 250, 500 and 750kms from the Facility. 
// These ships will fly to the main station and attack the player if they encounter them. If the player is flying to the Facility from the main station, it is likley that they will encounter
// some of these ships.
// When the player launches, having completed the text adventure, the main script also adds a Deamon and a Group of Imperial Fighters to attack the Reble Base (which
// explodes 10 seconds after the player launches) and then the player. A total of 12 Mongoose Fighters and 3 Scorpions are spawned between the player and the main station
// and another group of 3 Mongoose Fighters are added within 100kms. 3 more Scorpions are added at the main station. All these ships have an AI to fly from their starting points.
// to the former location of the Reble Facility and attack the player if they find them.
}
// Closing Bracket for Angeriri.
}
return;	
//Closing Bracket for the whole populator function.
}

// One off use of this.shipSpawned to rename any ships spawned by Dictators.OXZ to switch sides (captured ships flown by rebels)
// as otherwise they will be labled as Imperial Ships although (as ships with policeAI) they will in fact be fighting on the side
// of the Rebles once the Imperials lose control of the system at civil war variables 2 and 3.
this.shipSpawned = function(ship)
{
// Bracket off to only check when at Eszausve and the civil war variable is also 2 or 3.
if (system.ID === 13 && galaxyNumber === 6 && missionVariables.assassins_rebooted_civil_war > 1) {
// Bracket off again to just check targeted ships.
if (ship.displayName.indexOf("Imperial AstroFactory") >= 0 || ship.displayName.indexOf("Enforcer") >= 0 || 
ship.displayName.indexOf("Censor") >= 0 || ship.displayName.indexOf("Revolutionary Logistics") >= 0 ||
ship.displayName.indexOf("Quaestor") >= 0 || ship.displayName.indexOf("Revolutionary Guard") >= 0 ||
ship.displayName.indexOf("Lictor") >= 0 || ship.displayName.indexOf("Imperial Tanker") >= 0 || 
ship.displayName.indexOf("Imperial Freighter") >= 0) 
{
// Rename the AstroFactory.
if (ship.displayName.indexOf("Imperial AstroFactory") >= 0) {
ship.name = "AstroFactory";
ship.displayName = "AstroFactory";
if (missionVariables.random_station_names_oxps === "On") {
ship.name = "AstroFactory: Dubious Company";
ship.displayName = "AstroFactory: Dubious Company";
}
}
// Set up a name for the ship, generated on the fly from descriptions.
var rebelname = expandDescription("[assassins-rebel-dictators-added-ship-name]");
// Rename any Censors added by Dictators OXZ.
if (ship.displayName.indexOf("Censor") >= 0) {
ship.name = "Rebel Censor: "+rebelname;
ship.displayName = "Rebel Censor: "+rebelname;
} 
// Rename any Enforcers added by Dictators OXZ.
if (ship.displayName.indexOf("Enforcer") >= 0) {
ship.name = "Rebel Enforcer: "+rebelname;
ship.displayName = "Rebel Enforcer: "+rebelname;
} 
// Rename any Quaestors added by Dictators OXZ.
if (ship.displayName.indexOf("Quaestor") >= 0) {
ship.name = "Rebel Quaestor: "+rebelname;
ship.displayName = "Rebel Quaestor: "+rebelname;
} 
// Rename any Lictors added by Dictators OXZ.
if (ship.displayName.indexOf("Lictor") >= 0) {
ship.name = "Rebel Lictor: "+rebelname;
ship.displayName = "Rebel Lictor: "+rebelname;
} 
// Rename any Revolutionary Guards added by Dictators OXZ.
if (ship.displayName.indexOf("Revolutionary Guard") >= 0) {
ship.name = "Rebel Guardian: "+rebelname;
ship.displayName = "Rebel Guardian: "+rebelname;
} 
// Different name styles for the Transport Ships.
var rebelname2 = expandDescription("[assassins-rebel-dictators-added-ship-name-transports]");
// Rename any Revolutionary Logistics ships added by Dictators OXZ.
if (ship.displayName.indexOf("Revolutionary Logistics") >= 0) {
ship.name = "Rebel Transporter: "+rebelname2;
ship.displayName = "Rebel Transporter: "+rebelname2;
} 
// Rename any Imperial Tankers added by Dictators OXZ.
if (ship.displayName.indexOf("Imperial Tanker") >= 0) {
ship.name = "Rebel Tanker: "+rebelname2;
ship.displayName = "Rebel Tanker: "+rebelname2;
} 
// Rename any Imperial Freighters added by Dictators OXZ.
if (ship.displayName.indexOf("Imperial Freighter") >= 0) {
ship.name = "Rebel Freighter: "+rebelname2;
ship.displayName = "Rebel Freighter: "+rebelname2;
} 
// Closeing Bracket for name check.
}
// Closing Bracket for being at Eszausve.
}
// Closing Bracket for this ship spawned.
}

// Docking Fees and Custom Arrival Reports for Assassins Stations.
// Lawful Stations will refuse docking permission and docking with the docking computers to any ship (including the player) that does not hold Clean legal status.
// They will also launch defence ships to attack the offender. If however the player manually docks anyway, they will be thrown out of the station with a scripted forced launch.
// In this case an Arival Report is generated explaining they were chucked out of the Station. On pressing the space bar, the player is launched back out of the station.
// No entry for The Augeaian Orbital Repair Facility as you can't dock with it (NPC Customers only). 
this.shipDockedWithStation = function (station) {
// Only check if in Galaxy 7 and if docked to set up docking messages and fees.
if (galaxyNumber === 6) {
// Do the award of the Scanner if the player is meeting the Guildmaster, so that the player has the scanner before
// the set up of the F4 screen is done on docking at the Corpse Bride Station.
if (missionVariables.assassins_rebooted_stage === 3 && player.ship.dockedStation.name === "Torus Station: Corpse Bride" ) {
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_SCANNER");
}
// ---------------------------------------------------------------------------------------------- Docking Messages --------------------------------------------------------------------------------------------
// The Sunset Retirement Home
if (player.ship.dockedStation.name === "The Sunset Retirement Home" && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if not Clean.
if (player.bounty >0) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_sunset_retirement_home_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean.
if (player.bounty <= 0) {
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_sunset_retirement_home]");
var message2 = expandDescription("[assassins_rebooted_dockfee_sunset_retirement_home_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
}
// Closing Bracket for docked with The Sunset Retirement Home
}
// The Corpse Bride Torus Station.
// If the mission to meet the guildmaster is running then no arrival report is given and the mission briefing is given instead on docking.
if (player.ship.dockedStation.name === "Torus Station: Corpse Bride" && !missionVariables.assassins_rebooted_docking_fee
&& missionVariables.assassins_rebooted_stage !== 3) {
// Not Welcome Message and not allowed to dock if the player has attacked the station.
if (missionVariables.assassins_rebooted_corpse_bride_hostile) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_corpse_bride_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally regarless of legal status, provided the player has not attacked the station.
if (!missionVariables.assassins_rebooted_corpse_bride_hostile) {
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_corpse_bride]");
var message2 = expandDescription("[assassins_rebooted_dockfee_corpse_bride_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
}
// Closing Bracket for docked with The Corpse Bride Station.
}
// Madison Square Orbital Stadium.
if (player.ship.dockedStation.name === "Orbital Stadium: Madison Square" && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if not Clean.
if (player.bounty >0) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_orbital_stadium_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean.
if (player.bounty <= 0) {
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_orbital_stadium]");
var message2 = expandDescription("[assassins_rebooted_dockfee_orbital_stadium_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
}
// Closing Bracket for docked with Madison Square Orbital Stadium.
}
// Special Branch Outpost
if (player.ship.dockedStation.name === "Special Branch Outpost: Watching the Detectives" && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if not Clean.
if (player.bounty >0) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_special_branch_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean.
if (player.bounty <= 0) {
// Normal docking fee and station services if the player is clean and the thargoid invasion is not happening.
if (missionVariables.assassins_rebooted_thargoid_invasion === 0 || missionVariables.assassins_rebooted_thargoid_invasion === "Over") {
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_special_branch]");
var message2 = expandDescription("[assassins_rebooted_dockfee_special_branch_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
}
// During the invasion, there are no station services available and clean players recieve an arrival report explaining this, before the player is re-launched.
if (missionVariables.assassins_rebooted_thargoid_invasion === 1 || missionVariables.assassins_rebooted_thargoid_invasion === 2) {
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_special_branch_closed]");
}
// Closing Bracket for being Clean.
}
// Closing Bracket for docked with Special Branch Outpost
}
// Griff Research Orbital Base
if (player.ship.dockedStation.name === "Griff Research Orbital Base" && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if not Clean.
if (player.bounty >0) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_griff_research_orbital_base_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean.
if (player.bounty <= 0) {
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_griff_research_orbital_base]");
var message2 = expandDescription("[assassins_rebooted_dockfee_griff_research_orbital_base_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
}
// Closing Bracket for docked with Griff Research Orbital Base.
}
// Mafia Darkside Waystation
if (player.ship.dockedStation.name === "Darkside Waystation: High Times" && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if a Fugitive
if (player.bounty >50) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_mafia_waystation_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean or an Offender.
if (player.bounty <= 50) {
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_mafia_waystation]");
var message2 = expandDescription("[assassins_rebooted_dockfee_mafia_waystation_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
}
// Closing Bracket for docked with the Darkside Waystation.
}
// House of Blue Leaves Mining Depot.
if (player.ship.dockedStation.name === "Mining Depot: House of Blue Leaves" && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if not Clean.
if (player.bounty >0) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_house_of_blue_leaves_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean.
if (player.bounty <= 0) {
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_house_of_blue_leaves]");
var message2 = expandDescription("[assassins_rebooted_dockfee_house_of_blue_leaves_orbital_base_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
}
// Closing Bracket for docked with the House of Blue Leaves Mining Depot.
}
// The Naval Outpost: Pillar of Summer
if (player.ship.dockedStation.name === "Naval Outpost: Pillar of Summer" && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if not Clean.
if (player.bounty >0) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_pillar_of_summer_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean.
if (player.bounty <= 0) {
if (missionVariables.assassins_rebooted_navy_base_lockdown === "No" || !missionVariables.assassins_rebooted_navy_base_lockdown) {
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_pillar_of_summer]");
var message2 = expandDescription("[assassins_rebooted_dockfee_pillar_of_summer_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
}
// However, if the Base is in lockdown where no civillian craft are permitted near the base, then the player will still be thown out even if Clean.
if (missionVariables.assassins_rebooted_navy_base_lockdown === "Yes") {
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_pillar_of_summer_not_welcome]");
}
// Closing Bracket for being Clean.
}
// Closing Bracket for docked with The Naval Outpost: Pillar of Summer.
}
// The Navy Carriers on patrol around the Estiri system.
// All five carriers use the same pool of messages, but the carriers use a different pool to the Outpost.
// The custom docking screens and fees only run on the Carriers added by Assassins to Estiri. Other carriers added by other OXZs are excluded so Assassins doesn't
// interfer with any scripts they may be running.
if (player.ship.dockedStation.name.indexOf("Navy Carrier: ") >= 0  && system.ID === 82 && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if not Clean.
if (player.bounty >0) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_navy_carrier_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean.
if (player.bounty <= 0) {
var throwout = 0;
if (missionVariables.assassins_rebooted_navy_base_lockdown === "Yes")  {
// These three Carriers will be hostile to the player during lockdown so will not allow docking
if (player.ship.dockedStation.name.indexOf("Antiphates") >= 0 || player.ship.dockedStation.name.indexOf("Damasen") >= 0 || 
player.ship.dockedStation.name.indexOf("Elatreus") >= 0) {
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_pillar_of_summer_not_welcome]");
var throwout = 1;
}
}
if (throwout === 0) {
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_navy_carrier]");
var message2 = expandDescription("[assassins_rebooted_dockfee_navy_carrier_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
}
}
// Closing Bracket for docked with a Navy Carrier.
}
// The Imperial Prison - Red Wing
if (player.ship.dockedStation.name === "Imperial Prison: Red Wing" && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if not Clean.
if (player.bounty >0) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_red_wing_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean.
if (player.bounty <= 0) {
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_red_wing]");
var message2 = expandDescription("[assassins_rebooted_dockfee_red_wing_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
}
// Closing Bracket for docked with The Imperial Prison - Red Wing.
}
// When the Rebels take control of the prison it is renamed, but no station services are available due to the war.
if (player.ship.dockedStation.name === "Rebel Base: Echo of Hoth" && !missionVariables.assassins_rebooted_docking_fee) {
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_rebel_base_closed]");
// Closing Bracket for docked with the Rebel Base: Echo of Hoth
}
// Hades Hoopy Hotel: Game Theory
if (player.ship.dockedStation.name === "Hades Hoopy Hotel: Game Theory" && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if not Clean.
if (player.bounty >0) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_hades_hotel_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean.
if (player.bounty <= 0) {
// Normal docking fee and station services if the player is clean and the thargoid invasion is not happening.
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_hades_hotel]");
var message2 = expandDescription("[assassins_rebooted_dockfee_hades_hotel_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
// Closing Bracket for being Clean.
}
// Closing Bracket for docked with Hades Hoopy Hotel: Game Theory.
}
// Lernean Hoopy Hotel: Eagle in Flight
if (player.ship.dockedStation.name === "Lernean Hoopy Hotel: Eagle in Flight" && !missionVariables.assassins_rebooted_docking_fee) {
// Not Welcome Message and not allowed to dock if not Clean.
if (player.bounty >0) {
// No Docking Fee charged though.
missionVariables.assassins_rebooted_docking_fee = 0;
missionVariables.assassins_rebooted_thrown_out = expandDescription("[assassins_rebooted_dockfee_lernean_hotel_not_welcome]");
// As the variable thrown_out is now defined, the mission screen to thrown the player out and launch the player will now run under mission screen opotunity below.
}
// Normal Message and player is docked normally if Clean.
if (player.bounty <= 0) {
// Normal docking fee and station services if the player is clean and the thargoid invasion is not happening.
this.assassins_docking_fee();
var message1 = expandDescription("[assassins_rebooted_dockfee_lernean_hotel]");
var message2 = expandDescription("[assassins_rebooted_dockfee_lernean_hotel_fee_paid]");
if (missionVariables.assassins_rebooted_docking_fee === 0) var message2 = expandDescription("[assassins_rebooted_dockfee_fee_zero]");
var message = message1+"\n\n"+message2;
player.addMessageToArrivalReport(message);
// Closing Bracket for being Clean.
}
// Closing Bracket for docked with Lernean Hoopy Hotel: Eagle in Flight
}
// Show the Assassins Guild Status Screen on the F4 screen if the player has joined the guild and thus has the Mark Transponder
// Scanner. This is only available whilst in Galaxy 7.
if (player.ship.equipmentStatus("EQ_ASSASSINS_REBOOTED_SCANNER") === "EQUIPMENT_OK") {this.deathnote(); return;}
// Closing Bracket for Code only Checked in Galaxy 7.
}
// Closing Bracket for shipDockedWithStation.
}

// Function to calculate Docking Fees payable (random between 5 and 20 Credits).
this.assassins_docking_fee = function assassins_docking_fee() {
missionVariables.assassins_rebooted_docking_fee = expandDescription("[assassins_rebooted_dockfee_ammount_due]");
var fee = missionVariables.assassins_rebooted_docking_fee;
// No Charge if the player has less than 50 Credits.
if (player.credits <50) {
missionVariables.assassins_rebooted_docking_fee = 0;
}
// Otherwise, deduct the fee.
if (player.credits >=50) {
player.credits -= fee;
if (player.credits <0) player.credits = 0;
}
return;
// End of Fee Calculator function
}

// Mission Screen Function.
// All of the mission briefings, messages, news broadcasts and the text adventure are run through the mission screen when docked.
this.missionScreenOpportunity = function() {
// Only check if in Galaxy 7.
if (galaxyNumber === 6) {
// If the player has docked at a lawful station and is not clean then an arrival report throwing the player out is shown.
// The message generated is different for each station (set above).
if (missionVariables.assassins_rebooted_thrown_out) {
// Set the header
// Set the message to be displayed (recalled in a temporay mission variable set above).
var message = missionVariables.assassins_rebooted_thrown_out;
// Set the background screen, added depending on which station the player is at.
// In order to match the image used by the Docking Fees OXZ (if installed) the same image from Docking Fees is used as the background.
var bgImage = "assassins_rebooted_docking_fee_screen.png";
// Run the mission screen.
mission.runScreen({
titleKey: "assassins_rebooted_arrival_report_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_station_exit"
},
function (choice) {
// Once the player hits enter having read the message, they are forceably lauched from the station.
delete missionVariables.assassins_rebooted_thrown_out; 
player.ship.launch();
}, this); 
// Closing bracket for Thrown Out of Lawful Station.
}
// ----------------------------------------------------------------------------- Mission Briefings & News Broadcasts --------------------------------------------------------------------------------------------
// Mission Briefing Screens & News Broadcasts - All of this code is bracketed off to only be checked when the OXZs missions are running.
// If a mission briefing screen would be due, but the player has just been thrown out of one of the Assassins stations, then it is delayed until the player next docks normally.
if (!missionVariables.assassins_rebooted_thrown_out && missionVariables.assassins_rebooted_stage !== "Complete") {

// Offer the 1st Assassination - Kill Be Soin. Must have 200+ kills and be docked anywhere in Galaxy 7 except Orramaor.
if (missionVariables.assassins_rebooted_stage === 0 && system.ID !== 73 && player.score > 199) {
var message = "Message From: Brother Lucien Lachance.\nSecure Mail Box: lachance@removals.co.gal\n\nYour reputation as a killer proceeds you Commander. We are given to understand that on occasions, you have displayed a tendency to bend some of GalCop's Regulations in pursuit of profit. Please allow me to introduce myself. I represent the Assassins Guild.\n\nSome admirers of the Starship designer, Be Soin, would like him to have a fitting career end in the Orramaor System. Intelligence indicates that the mark is currently flying a Vintage Adder named 'Pride and Joy'. He is enjoying a touring holiday in the vicinity of the Sunset Retirement Home orbiting Orramaor's companion planet Apollodorus.\n\nBe Soin is something of a nostalgia freak, preferring retro designs to well equipped modern ships. As his craft has been custom painted to resemble an antique Bell & Braben Shipyards model, you should have no difficulty visually identifying the mark.\n\nA fee of 200 Credits will be paid upon the execution of this contract.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_victim1",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 1;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_01");
mission.markSystem({system: 73, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Paid for killing Be Soin and offered the opportunity to join the Assassins Guild. - Must have killed Be Soin and be docked anywhere (except the Corpse Bride Station)..
if (missionVariables.assassins_rebooted_stage === 2 && player.ship.dockedStation.name !== "Torus Station: Corpse Bride") {
var message = "Message From: Brother Lucien Lachance.\nSecure Mail Box: lachance@removals.co.gal\n\nThe Guild is pleased to see that you have retired Be Soin.\n\nThis innocent rodent was of no importance to any of our clients. We merely selected his ship IR signature at random from the GalCop Database. Be Soin did a lot of good work for charity and leaves a grieving widow, five starving children and a broken hearted extended litter. You showed a commendable lack of mercy, striking whilst he was least expecting trouble, flying a pathetically equipped ship.\n\nThe Guild has use for unprincipled killers of your caliber. If you seek membership of The Brotherhood, you must report to Guildmaster Nua'ectou. You will find him in the disused sewage tunnels of the Corpse Bride station orbiting the gas giant Cerberus in the Esrire system. There you will undergo the initiation ritual.\n\nA fee of 200 Credits (minus the Guild's Commission of 10%) has been credited.\n\n---MESSAGE ENDS.";
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 3;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_03");
mission.markSystem({system: 107, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
var fee = 180;
player.credits += fee;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Meet the Guidmaster at the Corpse Bride Station.
// Slightly different versions depending on whether the player had attacked the Corpse Bride before docking.
// Version 1 - Corpse Bride not hostile to the player.
if (missionVariables.assassins_rebooted_stage === 3 && player.ship.dockedStation.name === "Torus Station: Corpse Bride" 
&& !missionVariables.assassins_rebooted_corpse_bride_hostile) {
var message = "You leave your ship apprehensively and follow the signs to the main elevator. After a short delay, a Sirius Cybernetics happy vertical people transporter arrives and swiftly conveys you downwards to the sewer level.\n\nA sinister looking yellow frog, wearing a black leather trench coat, is waiting for you at the sewer entrance. Flanking him are a group of murderous looking killer edible arts graduates. The frog hops forward and introduces himself: 'I am Guildmaster Nua'etou. Come with us.'\n\nIn a shadowy, abandoned tunnel you undergo the trial of admission. Having sworn an oath of loyalty to the Guild, you are presented with a carved wooden knife and a leather-bound book of rules. 'Congratulations', croaks the Guildmaster, 'We will contact you in due course. May your aim always be true.'\n\nAs you board your ship, you notice that someone has painted a small red hand just above the forward laser mounting. You are also surprised to find that a Mark Transponder Scanner has been fitted to your ship's sensors.\n\nFlipping through the technical manual, lying on your co-pilots seat, you read that the device will highlight a contract target on the scanner in flashing red and blue, but you will not be able to cloak or use energy bombs whilst you are within one AU of the target.\n\nYou also note that you will be able to open a secure link to the Assassins Guild on the F4 Screen whilst docked, enabling you to view your current rank, reputation and the details of any outstanding contracts.";
var bgImage = "assassins_rebooted_corpse_bride.png";
mission.runScreen({
titleKey: "assassins_rebooted_corpse_bride_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_corpse_bride_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 4;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_04");
mission.unmarkSystem(107);
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Version 2 - Corpse Bride hostile to the player as they attacked it.
// Different introductory paragraph in the text and the player is forcably launched after meeting the Guildmaster.
if (missionVariables.assassins_rebooted_stage === 3 && player.ship.dockedStation.name === "Torus Station: Corpse Bride" 
&& missionVariables.assassins_rebooted_corpse_bride_hostile === "Yes") {
var message = "Given that you have important business abroad the Corpse Bride, it was perhaps unwise to fire upon it. You manage to find an out of the way landing pad and touch down undetected. In order to evade station security you laboriously crawl through the air vents and finally reach the sewer level, tired and covered in dust.\n\nA sinister looking yellow frog, wearing a black leather trench coat, is waiting for you at the sewer entrance. Flanking him are a group of murderous looking killer edible arts graduates. The frog hops forward and introduces himself: 'I am Guildmaster Nua'etou. Come with us.'\n\nIn a shadowy, abandoned tunnel you undergo the trial of admission. Having sworn an oath of loyalty to the Guild, you are presented with a carved wooden knife and a leather-bound book of rules. 'Congratulations', croaks the Guildmaster, 'We will contact you in due course. May your aim always be true.'\n\nAs you board your ship, you notice that someone has painted a small red hand just above the forward laser mounting. You are also surprised to find that a Mark Transponder Scanner has been fitted to your ship's sensors.\n\nFlipping through the technical manual, lying on your co-pilots seat, you read that the device will highlight a contract target on the scanner in flashing red and blue, but you will not be able to cloak or use energy bombs whilst you are within one AU of the target.\n\nYou also note that you will be able to open a secure link to the Assassins Guild on the F4 Screen whilst docked, enabling you to view your current rank, reputation and the details of any outstanding contracts.";
var bgImage = "assassins_rebooted_corpse_bride.png";
mission.runScreen({
titleKey: "assassins_rebooted_corpse_bride_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_station_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 4;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_04");
mission.unmarkSystem(107);
player.ship.launch();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 1st News Broadcast Appears - The Soin Clan are upset over the death of their uncle, but don't know who did it yet...
// Must have made at least 5 jumps since meeting the Guildmaster and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 4 && missionVariables.assassins_rebooted_jumpcounter > 4) {
var message = "Bringing you the news around the Galaxy, around the Clock!\n\nA memorial service for the well known ship designer, Be Soin, was held today on the southern continent of Orramaor. Be Soin disappeared in mysterious circumstances in his home system just over a month ago, whilst holidaying near Apollodorus, flying a lovingly restored Vintage Adder.\n\nThe service was well attended by members of the Soin Clan. Before scurrying to his iron ass configured Micro Fer-de-Lance fighter, the newly elected Chief Rodent of Soin Classic Shipyards, Inno Soin made the following statement:-\n\n'We do not believe our uncle's death was an accident. My sisters and I will hunt down his murderer, if we have to scour the entire Galaxy. We'll follow him through the Antaris Maelstrom and round perditions flames before we give him up.'\n\nThe Galactic Stock Market reacted positively to the Soin Clan's announcement with shares in Faulcon de Lacy, Tyley Feynman and Ingram Lasers Inc rising sharply in anticipation of increased order volumes over the coming quarter.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 5;
missionVariables.assassins_rebooted_jumpcounter = 0;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Offer the 2nd Assassination - Kill the Zarausxian Zero-G Hockey Team. 
// Must have made at least 5 jumps since viewing the 1st News Broadcast and be docked anywhere in Galaxy 7 except Tiared.
if (missionVariables.assassins_rebooted_stage === 5 && system.ID !== 194 && missionVariables.assassins_rebooted_jumpcounter > 4) {
var message = "Message From: Brother Lucien Lachance.\nSecure Mail Box: lachance@removals.co.gal\n\nThe Quandixeian Mafia is most displeased that the Zarausxian Zero-G Hockey Team failed to lose the Galactic Cup last Sunday, despite their acceptance of an offer they couldn't refuse. We are informed that Don Unias Ilmear personally lost over one million credits in bets placed against the team with the HoOpy Casino chain.\n\nThe team are now enjoying a victory tour of the Tiared System, travelling between the Madison Square Orbital Stadium and the main station in an Armoured Passenger Liner. Although the Liner is well shielded, it is relatively lightly armed. You are cautioned however that Ramon Security Services Ltd are under contract to provide the Team with Nemesis Class Fighters as escorts.\n\nThe members of Don Ilmear's gambling syndicate would be extremely grateful if someone could arrange that the team meets with an accident. A fee of 4,800 Credits will be paid upon completion of this contract.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_victim2",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 6;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_05");
mission.markSystem({system: 194, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Paid for killing The Zarausxian Zero-G Hockey Team.
// Must have killed the Team and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 7) {
var message = "Message From: Brother Lucien Lachance.\nSecure Mail Box: lachance@removals.co.gal\n\nExcellent work in terminating the Zarausxian Zero-G Hockey Team. Don Ilmear conveys his personal thanks and requests that you remain available for further lucrative contracts with the Quandixeian Mafia.\n\nYour actions also seem to have pleased the losing finalists. Director Nayler of Arzageat was particularly gleeful regarding the death of the cup-winners. In an interview with the Galaxy 7 Sports Roundup Show, the Director stated:-\n\n'After those cheating Zarausxians won a penalty in the last minute of extra time, I must confess I lost my faith in Ion. Now they've got their just deserts, I'll be back to attending church every Sunday. May Ion bless their executioner.'\n\nA fee of 4,800C (minus the Guild's Commission of 10%) has been credited to your account. The Guild will contact you again shortly. May your missiles always find their targets.\n\n---MESSAGE ENDS.";
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 8;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_07");
var fee = 4320;
player.credits += fee;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Warned by the Guild that their computer system has been hacked and the Soin Clan know it was the player who killed their uncle.
// Must have made at least 7 jumps since being paid for killing the Hockey Team.
if (missionVariables.assassins_rebooted_stage === 8 && missionVariables.assassins_rebooted_jumpcounter > 6) {
var message = "Message From: Guildmaster Astred Nua'ectou.\nSecure Mail Box: astred@removals.co.gal\n\nThe Guild's Computer network security was compromised this morning. Soin Clan hackers downloaded the files relating to the sanction of the rodent Soin. We regret therefore that the Soin Clan has learned of your identity and ship IR signature.\n\nFortunately Brother Xedis, aboard the GSS Behemoth Atlas, managed to arrange a 'misfire' of the ship's main plasma turrets, destroying the Soin Clan Burrow and several small villages in a 10km radius. Although most of the Clan was terminated, Inno Soin and some of his sisters remain at large. The Soin Clan are known for their motto: 'Revenge is a dish best served cold.' It is very cold in space.\n\nRest assured Brother, that our I.T. department has been disciplined. Once we have buried the bodies, we will be advertising for replacement staff in all fashionable magazines and colour supplements. In the meantime, I can only advise you to watch your Aft View for Soin Clan Micro Mambas.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_soin_sister_leader_type1",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 9;
missionVariables.assassins_rebooted_jumpcounter = 0;
System.infoForSystem(6,73).description = "Orramaor is noted for the resort world of Apollodorus, where many of the residents of the nearby Sunset Retirement Home spend their days.  Formerly the corporate headquarters of Soin Classic Shipyards Ltd, the Planet Orramaor is now famous for a large crater on the southern continent.";
System.infoForSystem(6,73).productivity = 38535;
missionVariables.assassins_rebooted_interlude = "Yes";
mission.setInstructionsKey("assassins_rebooted_mission_description_08");
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Update from the Guild - They have taken care of the remaining Soin Clan members, but Inno Soin still remains at large.
// Must have made at least 10 jumps since being warned by the Guild. Once the 10th jump is made, the script sets the stage variable to 10.
if (missionVariables.assassins_rebooted_stage === 10) {
var message = "Message From: Guildmaster Astred Nua'ectou.\nSecure Mail Box: astred@removals.co.gal\n\nIt appears that the Guild rather underestimated the importance of the late Be Soin. Our spies inform us that, in addition to producing Micro Class ships, Soin Classic Shipyards were working on several military projects.  These included a new weapon of mass-destruction, codenamed: The Nova Device. When deployed, this device will generate overlapping cascade fields neutralising all matter in the immediate vicinity.\n\nFortunately, our operatives managed to contaminate the Soin cheese stockpile with warfarin and we believe that the lactose intolerant Inno Soin is now the last surviving member of the Clan. Unfortunately, we have also learnt that a prototype Nova Device has been fitted to Inno Soin's Micro Fer-de-Lance, the 'Stainless Steel Rat'.\n\nWe consider it likely that he will attempt a suicide attack upon you and would suggest you maintain high fuel reserves until he is dealt with. Please accept our apologies for this blunder and the sum of 500 Credits in compensation for the inconvenience caused.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_inno_soin",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 11;
missionVariables.assassins_rebooted_jumpcounter = 0;
var fee = 500;
player.credits += fee;
mission.setInstructionsKey("assassins_rebooted_mission_description_09");
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Update from the Guild - Debriefed following the death of Inno Soin.
// Must have encounted Inno Soin and survived him detonating the Nova Device - This advances the stage to 12.
// Once the stage is at 12, the next message is dispalyed as soon as the player docks anywhere.
if (missionVariables.assassins_rebooted_stage === 12) {
var bgImage = "assassins_rebooted.email-message.png";
var message = "Message From: Guildmaster Astred Nua'ectou.\nSecure Mail Box: astred@removals.co.gal\n\nThe Guild is most pleased to see that you have prevailed against Inno Soin and his fiendish cascade device. Operatives of your calibre are difficult to replace.\n\nOur new Chief Director of Information Technology has been working night and day upon the problem of Guild Data Security. He assures us, upon his hatchling's life, that his new firewall software will prevent any unauthorised downloads from the Operatives Database in the future. Be assured that with the fiery death of the last surviving member of the Soin Clan, your cloak of anonymity has been fully restored.\n\nWe anticipate that a lucrative assignment will be available to you shortly.\n\nIn the meantime, the sum of 1,000 Credits has been deposited in your account, in compensation for the inconvenience caused to you by Inno Soin.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 13;
missionVariables.assassins_rebooted_jumpcounter = 0;
var fee = 1000;
player.credits += fee;
mission.setInstructionsKey("assassins_rebooted_mission_description_11");
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Offer the 3rd Assassination - Destroy the Fair Wind.
// Must have made at least 3 jumps since being congratulated for surviving Inno Soin's attack.
if (missionVariables.assassins_rebooted_stage === 13 && system.ID !== 203 && missionVariables.assassins_rebooted_jumpcounter > 2) {
var message = "Message From: Brother Desmond Miles.\nSecure Mail Box: miles@removals.co.gal\n\nDon Ilmear sends his warmest regards and requests your assistance in a practical demonstration of the value of proper insurance cover.\n\nThe McJamefire Trading Corporation is three months behind in its protection payments to the Quandixeian Mafia. It is Don Ilmear's view that the Company needs a reminder that accidents can happen to corporate assets.\n\nThe Corporation's flagship Anaconda Trader, the GSS Fair Wind, is currently undergoing its annual 5,000 light year service. The ship is in a parking orbit around the Augeaian Orbital Repair Facility in the Beatle system.\n\nThe Quandixeian Mafia would be most obliged if you could arrange the destruction of this ship. A fee of 10,000 Credits will be paid upon completion of this contract.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_victim3",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 14;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_12");
mission.markSystem({system: 203, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Paid for destroying The Fair Wind.
// Must have killed the Fair Wind and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 15) {
var message = "Message From: Brother Desmond Miles.\nSecure Mail Box: miles@removals.co.gal\n\nExcellent job Commander! We trust the Augeaian Security Phantoms did not cause you too much inconvenience.\n\nWe understand that, with their usual generosity, the Quandixeian Mafia has already commenced a collection for the widows and kittens of the work crew stationed aboard the Fair Wind at the time of its demise.\n\nMost unfortunate that 53 Felines were vaporised, but one cannot make an omelette without breaking legs. Don Ilmear extends his heartfelt thanks for your assistance in persuading this defaulting client to see the error of his ways.\n\nA fee of 10,000 Credits (minus the Guild's Commission of 10%) has been credited to your account. Your reputation grows. We will be in contact again soon.\n\n---MESSAGE ENDS.";
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 16;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_14");
var fee = 9000;
player.credits += fee;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 2nd News Broadcast Appears - A journalist is looking into the Guild's activities.
// Must have made at least 4 jumps since being paid for destroying the Fair Wind and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 16 && missionVariables.assassins_rebooted_jumpcounter > 3) {
var message = "Bringing you the news around the Galaxies, around the Clock!\n\nThe Galaxy 7 News team can exclusively reveal that the recent alarming rise in the Galaxy 7 murder rate has little to do with psycho-historical trends, as Asimov theorists would have our viewers believe.\n\nAn in depth investigation by our leading investigative journalist, Ge Iterbe, points strongly to the conclusion that a nefarious 'murder to order' criminal organisation is operating somewhere in the south-western quadrant of the Galaxy.\n\nEarlier this morning a full dossier, containing Mr Iterbe's findings, was transmitted to Inspector Thorstan of the GalCop Special Branch. Whilst promising to forward our findings to the Galactic Prosecution Service, Inspector Thorstan dismissed Mr Iterbe's findings as 'an alarmist bunch of dingo's kidneys.' \n\nMore news on this breaking story as it's made.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 17;
missionVariables.assassins_rebooted_jumpcounter = 0;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 3rd News Broadcast Appears - The journalist has died in a freak accicident.
// Must have made at least 2 jumps since seing the 2nd News Broakcast and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 17 && missionVariables.assassins_rebooted_jumpcounter > 1) {
var message = "Bringing you the news around the Galaxies, around the Clock!\n\nThe Galaxy 7 news team is sad to announce the death of investigative journalist Ge Iterbe. Mr Iterbe was apparently gored to death by a deadly Orreedonian goat, whilst refuelling at Erarrior.\n\nOn behalf of the Erarriorian Government, a Spokesbeing stated:- 'As everyone will be aware, such creatures are not native to Erarrior. We can only assume that a private collector failed to control his animals, resulting in this tragic accident. The Government is reviewing the licenses issued to private individuals under Section 451 of the Control of Dangerous Animals (Goats) Act 2926.'\n\nSpeaking from his offices at Geteve, Inspector Thorstan admitted that he might have been hasty in dismissing our dossier. He stated that:- 'Although my superiors have accepted the verdict of death by misadventure, I remain sceptical. I am convinced Mr Iterbe was murdered by the organisation he was investigating. I will continue investigating his death even if I have to do so in my own time.'\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 18;
missionVariables.assassins_rebooted_jumpcounter = 0;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 4th News Broadcast Appears - Thargoids have commenced an invasion of the Geteve System.
// Must have made at least 3 jumps since seing the 3rd News Broakcast and be docked anywhere except the Geteve System.
if (missionVariables.assassins_rebooted_stage === 18 && system.ID !== 18 && missionVariables.assassins_rebooted_jumpcounter > 2) {
var message = "Bringing you the news around the Galaxies, around the Clock!\n\nA large Thargoid Invasion fleet has commenced a sustained attack upon the Geteve System. Reports are coming in of vast swarms of Bugs attacking both the main GalCop Station and the Special Branch Outpost. Reports from escaping traders indicate that the space lanes remain relatively clear at the moment.\n\nInspector Thorstan of GalCop Special Branch has been placed in charge of the System's defences. In a rushed press conference this morning, the Inspector made the following statement:-\n\n'Special Branch has a large force of Asp ships available and we are holding their own against the Thargoid onslaught. We have so far prevented any successful Thargoid landings. However, the Bugs have us hard-pressed. I appeal to all Commanders with Bug-squashing experience to join us in the fight.'\n\nAre there any Commanders out there brave enough to answer this call to arms?\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 19;
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_thargoid_invasion = 1;
System.infoForSystem(6,18).description = "Geteve is reasonably well known for its large moon, Hercules. GalCop Special Branch operates from a small outpost in orbit around Hercules. The main offices of the Galactic Prosecution Service are based on the moon's surface. A Thargoid invasion of the system is underway. Bugs commonly attack the Stations, but Special Branch Asps engaged in defence of the system have so far prevented any landings.";
System.infoForSystem(6,18).productivity = 49479;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Offer the 4th Assassination - Kill Inspector Thorstan
// Must have made at least 2 jumps since seeing the 4th News Broadcast and be docked anywhere except the Geteve System.
if (missionVariables.assassins_rebooted_stage === 19 && system.ID !== 18 && missionVariables.assassins_rebooted_jumpcounter > 1) {
var message = "Message From: Sister Vernita Green.\nSecure Mail Box: copperhead@removals.co.gal\n\nThe inquisitive journalist Ge Iterbe was silenced some time ago by Guild Sister O-Ren Ishii and her trained deadly goat. A reminder to the Head of the Galactic Prosecution Service that we still possess the holo-images featuring himself and the harmless slimy frogs, has ensured that no official investigation will be forthcoming.\n\nInspector Thorstan remains troublesome, determined to pursue his investigations without the support of his superiors. At the moment he has his hands full dealing with the Thargoid invasion of Geteve. We had hoped that he would have fallen under Thargoid lasers, but regrettably he seems more than capable of outflying the Bugs.\n\nInspector Thorstan is currently engaged in the defence of the Special Branch Outpost near Geteve's moon, flying an Asp with the callsign 'High Noon'. Ensure that he falls in battle.\n\nA fee of 15,000 Credits will be paid upon completion of this contract.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_victim4",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 20;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_15");
mission.markSystem({system: 18, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Paid for killing Inspector Thorstan
// Must have killed the Kill Inspector Thorstan and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 21) {
var message = "Message From: Sister Vernita Green.\nSecure Mail Box: copperhead@removals.co.gal\n\nCongratulations upon your efficient extermination of Inspector Thorstan. The tying up of this final lose end should put an end to any further official investigations into our business. Your efforts have helped preserve a bright future for the Guild.\n\nWe doubt the authorities will trouble themselves to investigate the case too closely, the loss of police patrol ships to Thargoid raiding parties being an almost hourly event in the Geteve System at the moment.\n\nWe have transmitted a Sobeerian spotted cod wrapped in newspaper to the features editor of the Galaxy 7 news desk. We are confident that there will be no further journalistic enquiries into the Guild's activities.\n\nWe will be in contact with more work for your soon. A fee of 15,000 Credits has been credited to your account.\n\n---MESSAGE ENDS.";
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 22;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_17");
var fee = 15000;
player.credits += fee;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 5th News Broadcast Appears - Pirates are attacking a lot of ships in the Ateslete System. But is it really pirates?
// Must have made at least 5 jumps since being paid for killing Inspector Thorstan and be docked anywhere except the Ateslete System..
if (missionVariables.assassins_rebooted_stage === 22 && system.ID !== 39 && missionVariables.assassins_rebooted_jumpcounter > 4) {
var message = "Bringing you the news around the Galaxies, around the Clock!\n\nAt a news conference this morning, Director Lyttlebern-Carres of Ateslete announced that the unfortunate increase in piracy in the system's space lanes had been conclusively traced to a large pirate fleet operating from the neighbouring system of Cemaer. He reassured worried traders that the ringleaders would be traced and eliminated.\n\nMoments after stepping from his escape pod, Trader Buffett gave an exclusive interview to your Galaxy 7 News correspondents on the spot. The hapless Commander described how he had encountered an unusual cigar shaped craft and seconds later he was attacked by dozens of tiny ships.\n\n'They had my Mosquito's shields ripped apart in seconds', he explained. 'I was so panicked I hit the ECM rather than the escape pod release and only just made it to the pod before she blew. When I glanced back towards the wreck of my ship, the attackers were just hanging there dead in space, making no attempt to scoop the 10 tones of Erdiaresian Evil Juice I had aboard. Strange bunch of pirates!'\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 23;
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_battlebot_development_level = 1;
System.infoForSystem(6,39).description = "The Ateslete System is reasonably noted for the ice-world, Stymphal. The well known robotics company, Griff Research Ltd, operates factories over most of the planet and maintains an orbital research station near Stymphal. Although normally one of the safer systems in the Galaxy, pirates currently plague the main space lanes.";
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Offer the 5th Assassination - Destroy the Malfunctioning BattleBot Control Drone in the Ateslete System
// Must have made at least 5 jumps since seeing the 5th News Broadcast and be docked anywhere except the Ateslete System.
if (missionVariables.assassins_rebooted_stage === 23 && system.ID !== 39 && missionVariables.assassins_rebooted_jumpcounter > 4) {
var message = "Message From: Brother Jacob Frye.\nSecure Mail Box: shroud@removals.co.gal\n\nDirector Lyttlebern-Carres of Griff Research Ltd urgently requests your assistance in resolving the Ateslete System crisis. The company has been retained by the Galactic Navy to develop remote drone fighters for deployment against the Thargoid menace. Several BattleBot prototypes have been perfected. The robot ships function purely under computer control and are fitted with nano-bots in order to allow them to self replicate. However, it was intended that they would only be deployed deep into Thargoid space.\n\nLast month one of the Control Drones, callsign 'Logan 5', escaped from its testing base and has been lurking in the spacelane manufacturing BattleBot fighters. We are unsure as to the reason, but these BattleBots are attacking every ship they encounter. Fortunately, the BattleBot fighters are programmed to self destruct if their Mothership is destroyed. It is imperative that the BattleBots are eliminated before they can spread beyond Ateslete.\n\nA fee of 25,000 Credits will be paid upon the destruction of the Control Drone.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_victim5",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 24;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_18");
mission.markSystem({system: 39, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Paid for destroying the Malfunctioning BattleBot Control Drone
// Must have destroyed the Malfunctioning BattleBot Control Drone and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 25) {
var message = "Message From: Brother Jacob Frye.\nSecure Mail Box: shroud@removals.co.gal\n\nDirector Lyttlebern-Carres conveys his deepest gratitude for your elimination of the malfunctioning Control Drone. Inexplicably the destruction of the Control Drone failed to cause the BattleBots to self-destruct, although they shut down once your ship passed beyond their scanner range.\n\nTechnicians were deployed to scoop up the sleeping BattleBots. However, when the BattleBots detected the approaching ships, they reactivated and immediately entered Witchspace. Fortunately, the BattleBots have no fuel scoop and cannot self-replicate without a Control Drone. The Company feels it now has no choice but to offer rewards for their destruction, in the hope that the final clean up will be accomplished by bounty hunters.\n\nA fee of 25,000 Credits (minus the Guild's Commission of 10%) has been credited to your account. As always, the Guild will be in contact again soon.\n\n---MESSAGE ENDS.";
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 26;
missionVariables.assassins_rebooted_jumpcounter = 0;
// A working version of the Navy BattleBot Control Drone with two Navy BattleBots will be on patrol around the Griff Reaserach Base and the Brain will be testing
// a group of unarmed PlasmaBots..
// The escape timer will start running and over time the 6 systems within 7 light years of will become home to groups of Malfunctioning BattleBots.
missionVariables.assassins_rebooted_battlebot_development_level = 2;
missionVariables.assassins_rebooted_battlebot_escape_level = 1;
missionVariables.assassins_rebooted_battlebot_escape_timer = 0;
// The description is changed to reference the victory over the local pirates.
System.infoForSystem(6,39).description = "The Ateslete System is reasonably noted for the ice-world, Stymphal. The well known robotics company, Griff Research Ltd, operates factories over most of the planet and maintains an orbital research station near Stymphal. The System was recently been beset by pirate activity. Rumors circulate of a mysterious Commander, flying a ship marked with the Red Hand, who destroyed all the pirate vessels and then vanished.";
mission.setInstructionsKey("assassins_rebooted_mission_description_20");
var fee = 22500;
player.credits += fee;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 6th News Broadcast Appears - The Eszausve Dictatorship is being ceasored for using military ships against civillian targets.
// Must have made at least 6 jumps since being paid for destroying the Control Drone and be docked anywhere except the Eszausve System..
if (missionVariables.assassins_rebooted_stage === 26 && system.ID !== 13 && missionVariables.assassins_rebooted_jumpcounter > 5) {
var message = "Bringing you the news around the Galaxies, around the Clock!\n\nThe Imperial Dictatorship of Eszausve was condemned today by Amnesty Interplanetary for its use of military class vessels against civilian targets. Harrowing footage was played, showing Scorpion Class Frigates strafing several small villages and bombing the local orphanage. A platoon of the Guardians of Order emerged from the landed Scorpion and proceeded to gun down the fleeing chicks.\n\nOur reporters attempted to contact the Director of Ramon Security Ltd, but he was taking an intergalactic cruise in his office. Sky Marshal Claudius Maximus of the Eszausveian Navy confirmed that it had engaged in action against known terrorists with notable success. He condemned the insurgents for their use of HoloTech modules to disguise their bases.\n\nThe democratic government of the neighbouring system, Angeriri has also condemned the actions of the Eszausveian Navy and has filled a formal motion to expel Eszausve from the Union of Worlds. The motion is expected to be considered at the next meeting of the GalCop Parliamentary Council in nine months time.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 27;
missionVariables.assassins_rebooted_jumpcounter = 0;
// The Civil War variable is advanced to 1. In addition to the Imperial and Rebel ships normally present at Eszausve, Scorpion Class Imperial Frigates will now appear
// at Eszausve together with additional rebel ships fighting them.
missionVariables.assassins_rebooted_civil_war = 1;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 7th News Broadcast Appears - The Zarausxian Zero-G Hockey Team Fan Club has put out a contract on you!
// Must have made at least 5 jumps since seeing the 6th News Broadcast and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 27 && missionVariables.assassins_rebooted_jumpcounter > 4) {
var message = "Bringing you the news around the Galaxies, around the Clock!\n\nA moving service was held today in the Tiared system to commemorate the anniversary of the tragic death of the members of the Zarausxian Zero-G Hockey Team. As our viewers will recall, the team was murdered within days of winning last year's Galactic Cup. A ship marked with The Red Hand was observed leaving the area at speed.\n\nFollowing the ceremony, Esaral Wyvern, Chairbeing of the Zarausxian Zero-G Hockey Team Fan Club, made the following statement:-\n\n'I am pleased to announce that after nearly a year of coffee mornings, whist drives and jumble sales, we have reached our target of 150,000 Credits. Fans flying Nemesis interceptors, hired from Ramon Security Ltd, are hunting the killer. Adverts have been placed at all moderately disreputable space-ports offering the bounty to any Commander bringing in the criminal either dead or very dead.'\n\nThe staff at Galaxy 7 News wish them all the best of luck in the hunt.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 28;
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_interlude = "Yes";
mission.setInstructionsKey("assassins_rebooted_mission_description_21");
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Offer the 6th Assassination - Duel Guild Sister  O-Ren Ishi.
// Must have made at least 5 jumps since seeing the 7th News Broadcast and be docked anywhere except the Ataneris System.
// The stage variable is advanced to 29 on the 5th jump during the Hocky Fan attack interlude.
if (missionVariables.assassins_rebooted_stage === 29 && system.ID !== 81) {
var message = "Message From: Guildmaster Astred Nua'ectou.\nSecure Mail Box: astred@removals.co.gal\n\nAs you will probably be aware, a rather lucrative assignment to terminate your good self is currently being offered by the Zarausxian Zero-G Hockey Team Fan Club. Regrettably, this contract has been accepted by Guild Sister O-Ren Ishii. Nothing personal my friend, just a matter of business.\n\nNaturally, the acceptance of a contract is a sacred undertaking that a Guild Member must, as a matter of honour, complete. On the other hand, strife between Members will not be tolerated. Accordingly, the issue between yourself and Sister O-Ren Ishii will be settled by single combat.\n\nThe duel will take place near the House of Blue Leaves Mining Depot in the Ataneris system. A duelling beacon has been deployed to mark the location on your advanced space compass. No seconds are permitted. Your opponent is flying a Cobra Mark IX named the 'Lady of the Dead' and awaits your convenience. May the better assassin prevail.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_victim6",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 30;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_22");
mission.markSystem({system: 81, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Congratulated for killing O-Ren Ishi.
// Must have killed O-Ren Ishi. and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 31) {
var message = "Message From: Guildmaster Astred Nua'ectou.\nSecure Mail Box: astred@removals.co.gal\n\nWe are pleased to see that you have prevailed. The Guild Dueling Rules are clear on the point that the duellists must fight alone without seconds, combatants limited to the use of missiles and lasers.\n\nSister O-Ren Ishi's underhand tactic of hacking the targeting parameters of the local mining robots to turn them against you was most dishonourable. Had she prevailed, she might have found herself added to the Guild's list of Marked Commanders. We trust however that the GalCop bounties paid provided some compensation for her treachery.\n\nOur intelligence sources indicate that the Quandixeian Mafia are having a little local difficulty with their neighbours, the Esreatesian Triads. We anticipate that Don Ilmear will need somebody to carry out some precision wetwork in the near future. We will be in contact shortly with a lucrative assignment.\n\n---MESSAGE ENDS.";
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 32;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_24");
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 8th News Broadcast Appears - The Ateslete System is replacing its police force with robot ships purchased from Griff Research Ltd.
// Must have made at least 3 jumps since being congratualted on winning the duel and be docked anywhere except Ateslete 
if (missionVariables.assassins_rebooted_stage === 32 && system.ID !== 39 && missionVariables.assassins_rebooted_jumpcounter > 2) {
var message = "Bringing you the news around the Galaxies, around the Clock!\n\nAt a Griff Research Ltd press briefing earlier this morning Director Lyttlebern-Carres of the Ateslete system unveiled the company's latest contribution to the war on crime, the Mark I BattleBot Unit and Control Drone. These robotic law enforcement officers will be taking over all policing duties at Ateslete with effect from midnight tonight.\n\nChief Constable Gregson of the GalCop Police Federation, was scathing on behalf of his soon to be redundant colleagues, speaking at length about the dangers of artificial intelligence and that the remote drones could easily have their targeting parameters altered by hackers in the criminal fraternity.\n\nThe Director responded by pointing to the fact that the AI controlled units had consistently outperformed GalCop officers in testing both in accurately targeting criminal vessels and in avoiding friendly fire incidents. Commanders who do not subscribe to Butlerian Orthodoxy and wish to judge these robotic police officers for themselves need only pay a visit to the Ateslete system.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 33;
missionVariables.assassins_rebooted_jumpcounter = 0;
// The BattleBot development level reaches 3. All police ships at Ateslete will be replaced with working BattleBots and a Control Drone with BattleBot escorts is
// added to the Spacelane. A squadron of BattleBot Interceptors will also patrol near the Research Base together with a Control Drone and BattleBot escorts.
missionVariables.assassins_rebooted_battlebot_development_level = 3;
// The description is changed to reference the presence of the robotic police force.
System.infoForSystem(6,39).description = "The Ateslete System is reasonably noted for the ice-world, Stymphal. The well known robotics company, Griff Research Ltd, operates factories over most of the planet and maintains an orbital research station near Stymphal. Crime in the system has fallen since the introduction of an entirely robotic police force, but members of the Butlerian Order now refuse to visit the system.";
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 9th News Broadcast Appears - The Director of Sales at Ramon Security has been boasting that they are about to supply the Eszausveian Navy with a fleet of powerful cruisers. 
// The Angeririan Foreign Office is threatening military intervention if the build up of capital ships on its boarder continues. 
// Must have made at least 2 jumps since seeing the 8th News Broadcast and be docked anywhere. 
if (missionVariables.assassins_rebooted_stage === 33 && missionVariables.assassins_rebooted_jumpcounter > 1) {
var message = "Bringing you the news around the Galaxies, around the Clock!\n\nFollowing an in depth enquiry by our investigative journalists, Galaxy 7 News can exclusively reveal the shocking level of corruption within certain starship design companies developing military vessels under contract from the Galactic Navy.\n\nPosing as members of the criminal underworld, our intrepid journalists made approaches to high level employees at ten such franchised companies. In most cases our approaches were rebuffed, usually with dire threats to blast us out of space. However, when employees of Ramon Security Ltd were approached our journalists were treated to a sumptuous lunch. Over desert a list of ships available for sale, ranging from fighters to cruisers, was passed over. The Director of Sales boasted that he was in talks to provide the Eszausveian Navy with a fleet of cruisers, which make the Scorpion Frigate look like a toy.\n\nThe Angeririan Foreign Office reacted with alarm to this development, stating that it would take any further escalation as an unfriendly act and that it reserved the right to provide direct military aid to the Eszausveian rebels if the build up of capital ships continued.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 34;
missionVariables.assassins_rebooted_jumpcounter = 0;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Offer the 7th Assassination - Wack Boss Yankisona
// Must have made at least 3 jumps since seeing the 9th News Broadcast and be docked anywhere except the Quandixe System.
if (missionVariables.assassins_rebooted_stage === 34 && system.ID !== 53 && missionVariables.assassins_rebooted_jumpcounter > 2) {
var message = "Message From: Brother Corvo Attano.\nSecure Mail Box: outsider@removals.co.gal\n\nDon Ilmear requests a few moments of your time. Relations between the Quandixeian Mafia and the Esreatesian Triads have become strained in recent months. Due to an issue over some marked cards, Triad boss Enio Yanksona has taken to leading attacks upon the Mafia's Anaconda transport ships, flying an armoured Boa named 'Atom Smasher'.\n\nThe Mafia's fleet of Anacondas perform the vital social service of ferrying megaweed from the plantations upon Quandixe's moon Hesperides to the main station. Whilst Don Ilmear has no wish to start an intersystem gang war, profits are down and the Narcotics Fleet must be protected at all costs.\n\nThe Syndicate would be very grateful therefore, if a third party could arrange the demise of Boss Yanksona and assist in restoring normal commercial trade. Don Ilmear respectfully requests that you avoid collateral damage to his transport ships. A fee of 30,000 Credits will be paid upon completion of this contract.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_victim7",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 35;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_25");
mission.markSystem({system: 53, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Paid for killing Boss Yankisona.
// Must have killed Boss Yankisona and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 36) {
var message = "Message From: Brother Corvo Attano.\nSecure Mail Box: outsider@removals.co.gal\n\nDon Ilmear expresses his deep gratitude for your help in the execution of Boss Yankisona. The intervention of a third party in this dispute has enabled the Quandixeian Mafia to avoid an all out gang war with the Esreatesian Triads. Don Ilmear assures the Guild that he is working upon a subtle plan that will ensure the destruction of the Triad gang.\n\nHowever, the new Triad gang leader, Ni Katona has sworn rivers of blood. The Mafia are aware that the Triads have managed to salvage the flight recorder from one of the Triad ships destroyed in the battle. It is likely that they will have already identified your ship, from the distinctive Red Hand above the forward laser mounting.\n\nDon Ilmear apologies in advance and hopes you will accept the sum of an additional 5,000 credits to provide for your funeral expenses, should the need arise. A fee of 35,000 Credits (minus the Guild's Commission of 10%) has been credited to your account.\n\n---MESSAGE ENDS.";
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 37;
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_interlude = "Yes";
// The Description and productivity of Esreates changes as the Triad's fortunes fall.
System.infoForSystem(6,100).description = "Formally a GalCop penal colony, a successful rebellion by the prisoners placed the system in the hands of felons. At present the system is run by the Yankisona Triad gang. Opinion in the criminal fraternity is divided on the future of the Triads, following the assassination of Boss Yankisona. Some feel that the Triads are finished. Others think that the promotion of henchman, Ni Katona, to gang leader, will ensure their reign of terror continues.";
System.infoForSystem(6,100).productivity = 27093;
mission.setInstructionsKey("assassins_rebooted_mission_description_27");
var fee = 31500;
player.credits += fee;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 10th News Broadcast Appears - The Triad Leaders have been arrested and are awaiting trial.  
// Must have made 4 jumps since being attacked by a Triad Hit-Shit outside the station. Been attacked advances the variable to 38 and after 4 jumps the
// variable is advanced to 39. 
if (missionVariables.assassins_rebooted_stage === 39) {
var message = "In a dramatic raid late last night, GalCop Special Branch Officers arrested alleged Triad gang leader Ni Katona at the Orraesian HoOpy Casino. Further arrests of Mr Katona's alleged henchmen are expected later today.\n\nSpeaking at a packed press conference this morning, Detective Constable Nick Valentine of GalCop Special Branch credited the breakthrough to intelligence received from the criminal underworld, although he declined to confirm or deny the involvement of local legitimate businessmen in the operation.\n\nThe authorities appear to be confident that Mr Katona will be convicted at his trial, listed to take place at the Estiri Galactic Supreme Court next month. Our sources at the Galactic Prosecution Service tell us that they intend to rely upon irrefutable evidence from Bi Xea'nu, a former Triad gang member turned Supergrass.\n\nIs the case really that strong or has the witness been bribed as many observers believe? The truth is, we don't know. We'll bring you more news on this story as its made.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 40;
missionVariables.assassins_rebooted_jumpcounter = 0;
System.infoForSystem(6,100).description = "Formally a GalCop penal colony, a successful rebellion by the prisoners placed the system in the hands of felons. At present the system is run by the Yankisona Triad gang, although their power currently hangs by a thread. Most of the criminal community have written off the Esreatesian Triads, following the arrest of the higher echelons by GalCop Special Branch. There are some who believe, that the Triads will yet manage to stage a miraculous return to power.";
System.infoForSystem(6,100).productivity = 23431;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Offer the 8th Assassination - Eliminate Bi Xea'nu aboard an Aeron Class Frigate.
// Must have made at least 2 jumps since seeing the 10th News Broadcast and be docked anywhere except the Estiri System.
if (missionVariables.assassins_rebooted_stage === 40 && system.ID !== 82 && missionVariables.assassins_rebooted_jumpcounter > 1) {
var message = "Message From: Brother Vicente Valtieri.\nSecure Mail Box: dumer@removals.co.gal\n\nBoss Ni Katona respectfully requests that you will permit bygones to be bygones, as he is in desperate need of your services. As a gesture of goodwill, the Esreatesian Triads have immediately rescinded the contract upon your life.\n\nThe Supergrass Bi Xea'nu is shortly due to give evidence in the case of R v Katona. Boss Katona would prefer that this traitorous cove failed to enter the witness box and that his remains are soon residing in a rather differently shaped box.\n\nThe Galactic Navy has closed the Naval Outpost near Estiri's moon, Nemean to civilian traffic and imposed a 25 km exclusion zone. Intelligence indicates that a minefield is in place and Navy Carriers, BattleBots and Sidewinders are on patrol within the exclusion zone. The mark is believed to be aboard the Aeron Class Frigate, Indefatigable, currently stationed near the Naval Outpost. A fee of 40,000 Credits will be paid upon the exclusion of the Supergrass's evidence.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_victim8",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 41;
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_navy_base_lockdown = "Yes";
System.infoForSystem(6,82).description = "Estiri is noted for its large ocean covered moon, Nemean, and famous as the location of the Galactic Supreme Court. The Galactic Navy operates from a well defended base orbiting the moon. The Navy has imposed a 25 km exclusion zone around the base. Non-Military ships entering the zone will be fired upon without warning.";
mission.setInstructionsKey("assassins_rebooted_mission_description_28");
mission.markSystem({system: 82, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Paid for killing Bi Xea'nu 
// Must have killed Bi Xea'nu and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 42) {
var message = "Message From: Brother Vicente Valtieri.\nSecure Mail Box: dumer@removals.co.gal\n\nExcellent work in permanently excluding the testimony of Bi Xea'nu. Without his evidence, the Prosecution will be unable to prove their case. We understand that Chief Prosecutor Selezen is currently reviewing the case, with a view to offering no evidence. It is anticipated that Ni Katona will be released later this week.\n\nThe Esreatesian Triads send their profound thanks for the assistance you have rendered in this unhappy affair. They look forward to resuming their careers of extortion, blackmail, piracy and murder with renewed vigour.\n\nWe feel confident that the Triads will provide a profitable source of work for the Guild in the future, although their feud with the Quandixeian Mafia appears to have cooled down for the moment. In the meantime, we expect that an intriguing assignment of a political nature will be available to you soon. A fee of 40,000 Credits (minus the Guild's Commission of 10%) has been credited to your account.\n\n---MESSAGE ENDS.";
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 43;
missionVariables.assassins_rebooted_jumpcounter = 0;
// The Description and productivity of Esreates changes as the Triad's fortunes are restored.
System.infoForSystem(6,100).description = "Formally a GalCop penal colony, a successful rebellion by the prisoners placed the system in the hands of felons. At present the system is run by the Yankisona Triad gang. Despite recent unfortunate setbacks, most professional gangsters regard their future as bright. The surprise decision of the Galactic Prosecution Service to offer no evidence in the case of R v Ni Katona & Others, has led many in the criminal community to treat the Triads with a healthy respect.";
System.infoForSystem(6,100).productivity = 28418;
// The base does not go back into lockdown again and remains permently in its open state, so the variable is no longer needed as open is the default state.
delete missionVariables.assassins_rebooted_navy_base_lockdown;
mission.setInstructionsKey("assassins_rebooted_mission_description_30");
var fee = 36000;
player.credits += fee;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 11th News Broadcast Appears - Must have made at least 4 jumps since having been paid for killing Bi Xea'nu and be docked anywhere except Geteve.  
//  Once this broadcast has been seen, the battlebot development variable is set to "Complete" and the thargoid invasion variable is advanced to 2.
// There will now be Navy BattleBots and Control Drones assisting in fighting the Thargoids at Geteve. 
if (missionVariables.assassins_rebooted_stage === 43 && system.ID !== 18 && missionVariables.assassins_rebooted_jumpcounter > 3) {
var message = "Shares in Griff Research Ltd rose sharply at the opening bell upon the announcement that Her Imperial Majesty's Navy had taken delivery of thirty squadrons of BattleBot remote drone fighters and deployment frigates.\n\nAs our viewers will recall, the BattleBot Mark I Law Enforcement Drone was successfully tested in the Ateslete System and has performed with a flawless operational record despite criticism from the Butlerian Order and the redundant former human police force.\n\nAdmiral Ni-Tourall has informed us that the BattleBots have already engaged the Thargoids currently assaulting the Geteve System and are causing heavy casualties. GalCop Special Branch gave a cautious welcome to their new robotic assistants, apparently reassured against the possibility of friendly fire incidents by the drones Asimov Compliant Certification.\n\nThe Admiralty Office stressed however that, whilst the BattleBots were a welcome addition to the defences, the situation remains extremely serious. The Admiral issued a formal appeal to all Commanders rated Competent or higher to make their way to Geteve and assist in driving the invading bugs from the system once and for all.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 44;
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_battlebot_development_level = "Complete";
// Navy BattleBots and Control Drones now appear at Geteve 
missionVariables.assassins_rebooted_thargoid_invasion = 2;
// System description changed again to reflect reflect the battle starting to turn in GalCop's favour and the economy improves a little bit.
System.infoForSystem(6,18).description = "Geteve is reasonably well known for its large moon, Hercules. GalCop Special Branch operates from a small outpost in orbit around Hercules. The main offices of the Galactic Prosecution Service are based on the moon's surface. A Thargoid invasion of the system is underway. Although Special Branch forces remain hard-pressed by Thargoid attacks, the deployment of Navy BattleBots has started to turn the tide against the Bugs.";
System.infoForSystem(6,18).productivity = 49841;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 12th News Broadcast Appears - Must have made at least 3 jumps since seing the 11th News broadcast and be docked anywhere except Eszausve.
// Civil war has broken out at Eszausve!
if (missionVariables.assassins_rebooted_stage === 44 && system.ID !== 13 && missionVariables.assassins_rebooted_jumpcounter > 2) {
var message = "Rioting occurred in many cities on the Eszausveian capital planet earlier this week as the general strike organised by the People's Popular Front entered its third day. Rebel guerrilla forces appear to have taken control of several major settlements on the southern continent and battles for control of the spaceports rage all over the surface.\n\nIn response, Sky Marshal Claudius Maximus of the Eszausveian Navy has deployed Demon Class Cruisers to bombard rebel positions on the planetary surface from orbit and engage rebel ships around the main imperial station.\n\nThe neighbouring Democratic Republic of Angeriri has condemned the escalation by the Eszausveian Navy and has committed itself to providing military aid to the rebels. Our on the spot reporters can confirm that rebel birds flying Sonoran fighters have been sighted assaulting the imperial prison and engaging the navy in open space.\n\nThe main imperial station remains open for business as usual, but Commanders are cautioned that the system is in a state of civil war and ships exchanging fire in the spacelanes is a persistent hazard. More news on this developing situation as its made.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 45;
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_deamons = "Lawful";
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. The People's Popular Front has made substantial gains in surface battles but remains out gunned by the imperial fleet in the spacelanes.";
System.infoForSystem(6,13).productivity = 93098;
System.infoForSystem(6,13).inhabitants = "Resisting Harmless Fat Birds";
System.infoForSystem(6,13).population = 70;
System.infoForSystem(6,71).description = "The red lizards of Angeriri are fiercely democratic. Hatchlings are fitted with brain implants upon emerging from the egg permitting citizens to telepathically vote on all government decisions in real time. In response to the use of capital ships against civilian targets, the system is providing military aid to the Eszausveian People's Popular Front.";
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 13th News Broadcast Appears - Must have made at least 5 jumps since seing the 12th News broadcast and be docked anywhere except Eszausve.
// The Civil War continues to rage and Sky Marshal Maximus vows to smash the rebles once and for all.
if (missionVariables.assassins_rebooted_stage === 45 && system.ID !== 13 && missionVariables.assassins_rebooted_jumpcounter > 4) {
var message = "The Eszausveian civil war entered a new phase this week, with amphibious rebel bird commando units assaulting port cities under imperial control across the eastern seaboard of the northern continent. Reports from the battlefront remain confused, but the rebel offensive appears to have been largely successful with imperial stormtroopers in full retreat and reportedly firing inaccurately at the advancing rebel infantry.\n\nSky Marshal Claudius Maximus of the Eszausveian Navy addressed a news conference this morning with his feathers looking somewhat ruffled. He dismissed the recent rebel gains as a minor setback and pledged to personally lead a fleet to obliterate the captured cities rather than permit them to remain in rebel hands.\n\nReble forces remain outgunned and outnumbered in the spacelanes, despite their victories in surface battles. If the imperial navy launches a major spaceborne offensive, it seems unlikely that the rebels will be able to repel it.\n\nOur avian civil war correspondent, Piper Wright, will be remaining aboard the main Imperial Station, the 'Eyrie of Order' to keep us abreast of the situation.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 46;
missionVariables.assassins_rebooted_jumpcounter = 0;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Offer the 9th Assassination - Terminate Sky Marshal Claudius Maximus in a Deamon Class Cruiser 
// Must have made at least 2 jumps since seeing the 13th News Broadcast and be docked anywhere except the Eszausve System.
if (missionVariables.assassins_rebooted_stage === 46 && system.ID !== 13 && missionVariables.assassins_rebooted_jumpcounter > 1) {
var message = "Message From: Guildmaster Astred Nua'ectou.\nSecure Mail Box: astred@removals.co.gal\n\nAs you will be aware the Eszausveian civil war has heated up recently with the rebels making significant advances in surface battles whilst the imperial government maintains the advantage in spaceborne combat. The Guild has been approached by the People's Popular Front for aid in their rebellion. We have no interest in politics but one being's credits, or their blood, are as good as anothers.\n\nThe rebels have received intelligence that Sky Marshal Maximus is preparing to make good upon his threat to obliterate rebel held cities from orbit by assembling a flotilla of Deamon Class Cruisers near the Imperial Station. The Sky Marshal himself is personally supervising the operation abroad the Imperial Flagship 'Vengeance'.\n\nWe are aware that the rebels are very low on funds but the prestige of this contract is high and should the rebels succeed in their goal, a planetary government in the Guild's pocket will pay dividends. The people of Eszausve would be extremely obliged if you could terminate Sky Marshal Maximus near the main Imperial Station. A fee of 10,000 Credits will be paid upon completion of this contract.\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_victim9",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 47;
missionVariables.assassins_rebooted_jumpcounter = 0;
// The description of Eszausve is changed to reflect the updated situation and its population and productivety continue to fall as the civil war continues.
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. The People's Popular Front has made substantial gains in surface battles but remains out gunned by the imperial fleet in the spacelanes. The gathering of an armada of Demon Class Cruisers near the Imperial Station may however spell the end for the rebellion.";
System.infoForSystem(6,13).productivity = 89153;
System.infoForSystem(6,13).population = 68; 
mission.setInstructionsKey("assassins_rebooted_mission_description_31");
mission.markSystem({system: 13, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Paid for killing Sky Marshal Claudius Maximus.
// Must have killed Sky Marshal Claudius Maximus and be docked anywhere.
if (missionVariables.assassins_rebooted_stage === 48) {
var message = "Message From: Guildmaster Astred Nua'ectou.\nSecure Mail Box: astred@removals.co.gal\n\nWe are pleased to see that you have prevailed against the might of the imperial navy, demonstrating to the galaxy that none are beyond the reach of the Brotherhood. Your actions also seem to have rallied our client's forces and struck fear into the hearts of the imperial troops, although they will no doubt strike back in due course.\n\nGovernor Tarkin has remained suspiciously quiet thus far, leaving the conduct of the war to his subordinates. The elimination of the head of his armed forces may however finally draw his attention away from the delights of the HoOpy Hotels and towards the oppression of his people again. The Top Bird is known as a particularly foul fowl and we do not doubt that the People's Popular Front will require more than a little help if they are to have any hope of success in their rebellion. Chaos and war are often the meat and drink of our profession.\n\nWe expect that the Eszausveian civil war will prove to be a source of interesting further opportunities. In the meantime, the fee of 10,000 Credits (minus the Guild's commission of 10%) has been credited to your account.\n\n---MESSAGE ENDS.";
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 49;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_33");
var fee = 9000;
player.credits += fee;
delete missionVariables.assassins_rebooted_escort_counter;
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 14th News Broadcast Appears - Must have made at least 3 jumps since being paid for killing the Sky Marshal and be docked anywhere except Eszausve.
// The rebels are assaulting the main station and the prison and the empire is preparing to strike back with a mighty Dreadnaught.
if (missionVariables.assassins_rebooted_stage === 49 && system.ID !== 13 && missionVariables.assassins_rebooted_jumpcounter > 2) {
var message = "The Eszausveian rebels have redoubled their assault upon the imperial held main station and the notorious Red Wing prison, with several boarding attempts being conducted earlier today. From her vantage point aboard the Eyrie of Order our war correspondent, Piper Wright, reported that fighting remains fierce outside the station, but thus far imperial stormtroopers have successfully rebuffed all attempts to deploy rebel marines aboard the main station. Transmissions from the Imperial Prison appear to be jammed.\n\nIn an excusive interview with Galaxy 7 News, Governor Tarkin remained in definite mood despite the recent loss of the Imperial Flagship. Speaking from an undisclosed location, the beleaguered avian was scathing of the rebels stating:\n\n'The fact that the insurgents had to employ one of the Red Handed scum to fight their battles rather speaks for itself. These terrorists have no will to fight. I have personally supervised the construction of a weapons platform dwarfing the Deamon in every particular. I am the ruler or Eszausve by right of birth. Upon my return, the mutinous rabble will witness the power of my fully armed and operational Dreadnaught.'\n\nMore news on this developing story as it's made.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 50;
missionVariables.assassins_rebooted_jumpcounter = 0;
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. The People's Popular Front has taken control of much of the planetary surface with assaults upon the system main station and the imperial prison in progress. The whereabouts of the Governor and his fearsome Dreadnaught remain a mystery.";
System.infoForSystem(6,13).productivity = 73920;
System.infoForSystem(6,13).population = 67; 
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 15th News Broadcast Appears - Must have made at least 5 jumps since seeing the 14th News Broadcast and be docked anywhere except Eszausve.
// The rebels have taken the main station and the prison. The Dreadnaught has destroyed a GalCop Carrier leading to the rebels being recognised as the govenment
// and the imperial navy declared fugitives. Civil war contains as before, but now the rebels are flying ships with police scan class and the imperials are the fugutives.
if (missionVariables.assassins_rebooted_stage === 50 && system.ID !== 13 && missionVariables.assassins_rebooted_jumpcounter > 4) {
var message = "Reports are coming in that the People's Popular Front has taken control of the Eszausveian main station and the former imperial prison. Rebel marines stormed the Eyrie of Order at dawn this morning with prisoners disguised as imperial stormtroopers simultaneously taking control of the prison.\n\nRumours that the Eszausveian Dictatorship has constructed a vast Dreadnaught were confirmed in the Ribeties system earlier today when the ship was sighted by the Behemoth Loki. Upon detecting that the Dreadnaught was armed with Anti-Matter Cannons, outlawed by the Lave Strategic Arms Limitation Treaty of 3055, the GalCop Carrier ordered the Dreadnaught to stand down. The last confused combat report from the Loki showed the Dreadnaught opening fire and the Loki's shields collapsing in a matter of seconds.\n\nIn light of this unprecedented aggression by a member state, the Union of Worlds has met in emergency session and voted to recognise the People's Popular Front as the official government and declare the entire imperial navy fugitives. Whilst GalCop has officially recognised the rebels, bloody civil war continues both in space and upon the planetary surface. The present whereabouts of Governor Tarkin and the fearsome Dreadnaught remain unknown, although they are believed to be on route to Eszausve.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 51;
missionVariables.assassins_rebooted_jumpcounter = 0;
missionVariables.assassins_rebooted_civil_war = 2;
delete missionVariables.assassins_rebooted_deamons;
delete missionVariables.assassins_rebooted_reinforcements;
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. The People's Popular Front has taken control of the main station and the former imperial prison. Whilst GalCop has recognised the rebels as the lawful government, imperial forces remain in control of much of the system and a bitter civil war is in progress.";
System.infoForSystem(6,13).inhabitants = "Waring Harmless Fat Birds";
System.infoForSystem(6,13).productivity = 65246;
System.infoForSystem(6,13).population = 65; 
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// 16th News Broadcast Appears - Must have made at least 4 jumps since seeing the 15th News Broadcast and be docked anywhere except Geteve
// The Navy and Special Branch have finally succeeded in driving the Thargoids from Geteve. But in less good news, the imperial dreadnaught has been spotted
// sun-skimming at Qudior (it is now 6 jumps from Eszausve).
if (missionVariables.assassins_rebooted_stage === 51 && system.ID !== 18 && missionVariables.assassins_rebooted_jumpcounter > 3) {
var message = "We are delighted to report that the Thargoid invasion of the Geteve system appears to be finally at an end. Our brave Special Branch officers, assisted by their loyal BattleBots have won a crushing victory against the alien hoards and the Thargoids seem to have abandoned their attempts to take the system. In a moving address, Chief Constable Claudia Auditore paid tribute to all the gallant officers and machines who have fallen in the defence of the system. She singled out Inspector Thorstan, whom she personally witnessed meet his end under the concentrated fire from five warships, for special praise.\n\nWhilst one threat to galactic peace has been vanquished, another has arisen to pose perhaps a greater threat than even the fearsome Thargoids. The imperial dreadnaught, previously sighted at Ribeties is believed to have recently sun skimmed at Qudior before resuming its course through witchspace to the Eszausve system.\n\nAlthough no ship has yet managed to confirm contact, the Qudior Corporate Observatory detected an occlusion of the local star consistent with the passage of a small moon. The object was not however of natural origin, its radar echo matching the silhouette of the Imperial Dreadnaught.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 52;
missionVariables.assassins_rebooted_jumpcounter = 0;
// As the Invasion is now over, Thargoids and Navy BattleBots no longer appear at Geteve and it returns to being a normal democracy, but patroled by Special Branch Asps
// rather than regular police ships. The Moon and the Special Branch Outpost appear as normal, but are no longer attacked by Thargoids.
missionVariables.assassins_rebooted_thargoid_invasion = "Over";
System.infoForSystem(6,18).description = "Geteve is reasonably well known for its large moon, Hercules. GalCop Special Branch operates from a small outpost in orbit around Hercules. The main offices of the Galactic Prosecution Service are based on the moon's surface. Although heavy causalities were suffered during the recent Thargoid Invasion, the combined efforts of Special Branch officers, Navy BattleBots and freelance civilian Commanders finally defeated the Bugs.";
// Once the player has made 2 jumps since seeing the News Broadcast, a squadon of Imperial Moongose fighters will attack the player at the witchpoint, trying to take revenge
// for the assassination of the Sky Marshal. The Interlude variable is set to Yes. The next event won't happen until the player has made a total of 5 jumps since seeing the
// news broadcast (the Dreadnaught being at this point one jump away from Eszausve).
missionVariables.assassins_rebooted_interlude = "Yes";
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// The Guild Contracts the player and asks them to collect a special type of missile from a secret rebel base in the Angeriri System.
// Must have made at least 5 jumps since seeing the 16th News Broadcast and be docked anywhere except the Angeriri System.
if (missionVariables.assassins_rebooted_stage === 52 && system.ID !== 71 && missionVariables.assassins_rebooted_jumpcounter > 4) {
var message = "Message From: Guildmaster Astred Nua'ectou.\nSecure Mail Box: astred@removals.co.gal\n\nAs you will be aware from the news, the Imperial Dreadnaught is approaching its home system of Eszausve. However, what has been withheld from the galactic public is that the Dreadnaught is equipped with regenerative armour plating, rendering it invulnerable to all known weapons and that its cannons are capable of destroying an entire planet.\n\nFortunately, the Eszausveian People's Popular Front have developed a gravitonic missile capable of penetrating the Dreadnaught's hull plating. Unfortunately, they have lost contact with their research facility in the Angeriri system. Your mission is to dock with the facility and use the auto-loaders to remove any mounted missiles and replace them with graviton missiles. You must therefore ensure that your ship has at least one pylon.\n\nAssuming that you are successful you must then go to the Angeriri system main GalCop station to meet your contact Agent Bluebird. She will arrange your renumeration and brief you further. The frequency of the Rebel Facility 'Black Mesa' beacon code has been impulse coded in this transmission, enabling you to locate it with your Advanced Space Compass.\n\n---MESSAGE ENDS.";
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 53;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_34");
mission.markSystem({system: 71, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// If the player is docked at the Reble Facillity, but their ship has no missile pylons then they will not be able to complete the mission as they need to fit at least one graviton
// missile. If the player has no missile pylons, then they recieve a message explaining that they can't complete the mission and will need to return to the facility later when
// when they have a ship with missile pylons.
if (player.ship.dockedStation.name === "Rebel Facility: Black Mesa" && missionVariables.assassins_rebooted_stage === 53 && player.ship.missileCapacity === 0) {
var message = "You guide your ship into its docking berth and extend the universal docking tube to connect to the main airlock. Whilst the auto-docking systems appear to be functional, main power is off-line and a catastrophic depletion of the internal atmosphere has taken place, leaving the entire station in a vacuum state. No life-forms can be detected aboard, although an unusually high level of graviton radiation is making an accurate scan difficult.\n\nYou are about to leave your command chair to suit up and enter the station, when you remember that your ship does not possess any missile pylons. Without any missile pylons you will be unable to transport any graviton missiles from the facility to the main station.\n\nCursing your own foolishness you realise that you have no option but to leave the facility for the moment and return later once you own a properly equipped ship.";
var bgImage = "assassins_rebooted_bgs_adventure_ship.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_exit"
},
function (choice) {
player.ship.launch();
}, this); 
}

// Provided however the player has at least one missile pylon (it does not matter whether there is a missile on it or not) then the text adventure will run.
// At the end of the text adventure the player succeds in restoring main power and allows the player to load up on graviton missiles (this is done by the script).
// The main reactor then overloads and the player will be force launched and the player will be attacked by a squad of Mongoose Fighters.
// With the graviton missiles the player must now go to the Angeriri system main station to be given their next mission.
if (player.ship.dockedStation.name === "Rebel Facility: Black Mesa" && missionVariables.assassins_rebooted_stage === 53 && player.ship.missileCapacity > 0) {
// The text adventure is divided into rooms which each have a 'page number'. When a choice is made the OXZ turns to the page in the gamebook by changing the page
// variable. Each page only displays when the variable is equal to its number, so the game will stay in the text adventure loop until the player reaches the last page of the
// gamebook and is launched, advancing the stage variable and taking the game out of the text adventure loop.
// Start on Page 0 (basically the Now Turn Over page!) by setting the page number to 0 if it is not already defined.
if (!missionVariables.assassins_rebooted_adventure_page) {
missionVariables.assassins_rebooted_adventure_page = 0;
}
// Page 0.
if (missionVariables.assassins_rebooted_adventure_page === 0) {
var message = "You guide your ship into its docking berth and attempt to connect to the station's auto-trader system. Much to your surprise the familiar interface fails to appear on your main viewer. Your ship's computer reports that it is unable to access the mainframe, due to the station's main power being off-line.\n\nSensors also report a catastrophic depletion of the internal atmosphere, leaving the entire station in a vacuum state. No life-forms can be detected aboard, although an unusually high level of graviton radiation is making an accurate scan difficult.\n\nIf you are ever going to be able to open the main launch bay door again, you must explore the station on foot and attempt to restore main power. You climb into your EVA suit, slinging an Ingram Pulse Rifle over your shoulder. Using your ship's internal power you open the berth door and step out into the main docking hangar.\n\nAs you do so, the overloaded power-coupling fails causing the berth door to slam shut behind you. You stand in the Main Hangar and survey your surroundings...";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_entrance"
},
function (choice) {
missionVariables.assassins_rebooted_adventure_page = 1;
// There are two objects to collect, each of which will get you through an obstruction and the location descriptions change when you take them.
// At the start you don't have either, so you have nothing in your inventory.
missionVariables.assassins_rebooted_adventure_keycard = 0;
missionVariables.assassins_rebooted_adventure_trumble = 0;
// An imperial ship with an AI to destroy the distress beacon and then head for the planet looking for the player is added at this point, so that it has destroyed the beacon
// and left before the player completes the text adventure.
system.addShips("assassins_rebooted_shuttle_text_adventure",1,player.ship.position.add([1000,0,0]),10560)[0];
}, this); 
}

// Page 1 - The Main Hangar.
if (missionVariables.assassins_rebooted_adventure_page === 1) {
var message = "You stand in the Main Hangar beside your berthed ship.\n\nA Sonoran is berthed to the right and a Scorpion Class Frigate to the left. Otherwise the hangar is empty of ships. The nearby Sonoran is equipped in Iron Ass configuration and sports an insignia above the forward laser mount. The insignia bears the words 'Fly free or die' above the image of a dove.\n\nThe dead bodies of many harmless fat birds are strewn across the hangar. All appear to have died in combat. Some are dressed in white uniforms bearing a similar insignia to that upon the Sonoran. Other corpses are dressed in black uniforms bearing a hawk insignia and the words 'Tarkin Rules All'.\n\nThree exits lead from the hangar. The left exit leads to the Crew Quarters, the centre exit to the Happy Rebel Bar and the right to the Station Managers Office.\n\nWhich exit will you take Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page1",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page1_choices"
},
function (choice) {
if (choice === "1_PAGE1_1") {
missionVariables.assassins_rebooted_adventure_page = 2;
}
if (choice === "2_PAGE1_2") {
missionVariables.assassins_rebooted_adventure_page = 3;
}
if (choice === "3_PAGE1_3") {
missionVariables.assassins_rebooted_adventure_page = 7;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 2 - The Crew Quarters.
if (missionVariables.assassins_rebooted_adventure_page === 2) {
var message = "You enter the Crew Quarters to witness a hellish scene.\n\nThe walls of the Crew Quarters are lined with metal roosting perches, spaced a couple of meters apart to accommodate the sleeping avian forms. A credit operated seed dispenser stands in the centre of the room.\n\nIt appears that in a desperate attempt to form a makeshift barricade, the crew resorted to ripping perches from the walls. In one corner of the room interlaced perches are piled, their surfaces scarred by blaster and laser fire. A pair of steel tables are upended near the seed dispenser. All around are corpses similar to those in the hangar, most are either undressed or not wearing full uniforms.\n\nIt seems likely that the crew were caught roosting and managed to put up only a short-lived defence. A polished marble corridor leads right to the Happy Rebel Bar. A plain metal corridor behind you leads back to the Main Hager.\n\nWhich corridor will you follow Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page2",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page2_choices"
},
function (choice) {
if (choice === "1_PAGE2_1") {
missionVariables.assassins_rebooted_adventure_page = 1;
}
if (choice === "2_PAGE2_2") {
missionVariables.assassins_rebooted_adventure_page = 3;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 3 - The Happy Rebel Bar.
if (missionVariables.assassins_rebooted_adventure_page === 3) {
var message = "You enter the Happy Rebel Bar, noting the poor lighting and generally sleazy decor.\n\nA stuffed Thargoid is mounted on a stand in one corner of the room and a computerized HoOpy Casino gaming machine takes up another. Bottles of Evil Juice and Lethal Brandy are neatly stacked behind the Bar.\n\nHolo-screens, showing famous avian adult holo-stars shaking their tail feathers, are dotted across the room. Several overturned bowls of diced edible poets, fried Laveian tree grubs and other bar snacks litter the floor.\n\nThere are signs of battle here, broken and overturned furniture, spilled drinks but only a few bodies. A small alcove behind the bottle racks appears to have been comprehensively sprayed with laser fire. Behind you a plain metal corridor leads to the Main Hangar and a marble corridor leads to the Crew Quarters.\n\nWhat will you do Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page3",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page3_choices"
},
function (choice) {
if (choice === "1_PAGE3_1") {
missionVariables.assassins_rebooted_adventure_page = 4;
}
if (choice === "2_PAGE3_2") {
missionVariables.assassins_rebooted_adventure_page = 2;
}
if (choice === "3_PAGE3_3") {
missionVariables.assassins_rebooted_adventure_page = 1;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 4 - The Curious Alcove (Starting Version - before the player picks up the keycard).
if (missionVariables.assassins_rebooted_adventure_page === 4 && missionVariables.assassins_rebooted_adventure_keycard === 0) {
var message = "You jump over the Bar and examine the small alcove.\n\nCrouched inside you see the dead body of a fat bird dressed in a white uniform. A fancy gold trim decorates the cuffs and two platinum doves are affixed to the lapels. A fully charged hand laser still sits in his holster.\n\nRolling his rotund corpse over with your Ingram you see that he clutches a Security Passcard in his feathery fist. The body bears no sighs of laser damage, although his eyeballs appear to have exploded.\n\nA scan with your EVA suit mini-sensor confirms the cause of the cause of death as asphyxiation and exposure to a vacuum. It appears the Officer survived the fire-fight by cowering in the alcove, but his spineless nature proved no defence against unforgiving space. Looking at his remains and seeing the agonized expression on his eyeless face makes you glad you are safe in your EVA suit.\n\nWhat action will you take Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page4",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page4_choices"
},
function (choice) {
if (choice === "1_PAGE4_1") {
missionVariables.assassins_rebooted_adventure_page = 5;
}
if (choice === "2_PAGE4_2") {
missionVariables.assassins_rebooted_adventure_page = 2;
}
if (choice === "3_PAGE4_3") {
missionVariables.assassins_rebooted_adventure_page = 1;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 5 - The Curious Alcove (Special Page only accessed once when the player takes the keycard and the dead bird's wing).
if (missionVariables.assassins_rebooted_adventure_page === 5) {
var message = "You bend down to take the card from the bird's dead wing.\n\nFrozen by the cold of space, his feathery fingers are brittle. Fortunately, in life, the bird's grip upon the card was light. Determined to extract the card, you begin breaking off the deceased bird's digits. Your grim task only requires you to snap off three of his digits before the card is safely in your possession.\n\nThe card bears a holo-image of the frozen owner and the name Major Yan De Sorton. The centre of the card is inscribed with the words:\n\n'Security Access Card. Subject Access : Level 2. User access must be confirmed by contemporaneous DNA wing-print scan.'\n\nRealising that the card is unlikely to be helpful alone and reasoning that the dearly departed is unlikely to need them again, you relieve the corpse of its remaining digits and slip them in your EVA suit pocket together with the Passcard.\n\nWhat will you do now Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
missionVariables.assassins_rebooted_adventure_keycard = 1;
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page5",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page5_choices"
},
function (choice) {
if (choice === "1_PAGE5_1") {
missionVariables.assassins_rebooted_adventure_page = 2;
}
if (choice === "2_PAGE5_2") {
missionVariables.assassins_rebooted_adventure_page = 1;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Notional Page 6 - Only displayed if you return to the alcove having already taken the keycard.
// The description is different and the option to take the keycard is not offered as you alreday have it.
if (missionVariables.assassins_rebooted_adventure_page === 4 && missionVariables.assassins_rebooted_adventure_keycard === 1) {
var message = "You have entered the alcove where you discovered the Passcard.\n\nThe Major's desecrated body still lies where you left it. The macabre atmosphere of this de-oxygenated station is beginning to test even your iron nerves and for a superstitious moment, you fancy that the corpse is reaching out to you, demanding the return of its missing members.\n\nAlthough you did not become a Grandmaster Assassin without committing a fair number of cruel acts, you cannot help but feel a small twinge of pity at the pathetic sight of the frozen bird's mutilated single winged body.\n\nSuddenly the Station shudders under you and for a heat-stopping moment you feel a slight lurch of weightlessness as the artificial gravity temporally fails. You stop feeling sorry for the dead bird and start feeling sorry for yourself, wondering if you will ever see your bridge again and escape this tomb of a station.\n\nWhere will you go now Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page6",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page6_choices"
},
function (choice) {
if (choice === "1_PAGE6_1") {
missionVariables.assassins_rebooted_adventure_page = 2;
}
if (choice === "2_PAGE6_2") {
missionVariables.assassins_rebooted_adventure_page = 1;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 7 - The Station Manager's Office (No KeyCard Version)
// You need to get the keycard to progress through the blast door. If you do not have the keycard when you enter the Station Manager's office then you will be offered the options
// to blast the door with your hand laser or go back to the hangar. Blasting the door doesn't work and you'll have to go back to the hangar.
if (missionVariables.assassins_rebooted_adventure_page === 7 && missionVariables.assassins_rebooted_adventure_keycard === 0) {
var message = "You enter the Station Manager's Office.\n\nBehind a large steel desk sits the Station Manager, or rather what remains of him. His head is not present, apparently removed by an extremely high yield laser blast. In one wing he still grips a laser pistol, although two of his digits appear to have been removed with a sharp object. You also note, as you look around, a single blast mark on the wall by the door.\n\nThe wall behind the Manager's mutilated form is badly charred and on the desk an ID Passcard sits, its data chip smashed beyond use. Ahead of you is a large blast door, tightly sealed. A sign above the door reads:\n\n'Access to Research Laboratories restricted to Level 2 and above personnel. Insert your passcard and stand by for DNA verification.'\n\nA small slot is positioned by the door. Next to the slot is a scanner panel. The scanner panel is wing shaped and currently illuminated with a red light. Behind you a plain metal corridor leads to the Main Hangar.\n\nWhat action will you take Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page7",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page7_choices"
},
function (choice) {
if (choice === "1_PAGE7_1") {
missionVariables.assassins_rebooted_adventure_page = 8;
}
if (choice === "2_PAGE7_2") {
missionVariables.assassins_rebooted_adventure_page = 1;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 8 - The Station Manager's Office - Page only shown if you do not have the passcard and try to blast the door with your laser.
// It doesn't work and you have to go back to the main hangar.
if (missionVariables.assassins_rebooted_adventure_page === 8) {
var message = "There are few problems you have encountered in the space lanes, that couldn't be solved with your trusty laser and you reason that a door will prove no different.\n\nYou sling your Ingram from your shoulder, power up the charge and take careful aim. As the blast door is nearly five meters wide, even a Harmless newbie straight out of Lave could hardly fail to hit the target.\n\nSqueezing the trigger you send a series of 0.1 Mega Watt laser bolts into the obstinate door. The Ingram begins to grow warm in your hands as its laser temperature rises and then cuts out as the auto-safety activates.\n\nAs the laser cools you examine the door. Although your Ingram is one of the more powerful weapons available on the open market, it has had little effect on the blast door other than causing a little superficial damage to the smooth surface. You realize that the blast door has clearly been designed to resist assaults by hand weapons.\n\nYou would seem to have no choice but to return to the Main Hangar.";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page8",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_black_mesa_page8_choices"
},
function (choice) {
missionVariables.assassins_rebooted_adventure_page = 1;
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Notional Page 9 - The Station Manager's Office (Has the KeyCard Version)
// You need to get the keycard to progress through the blast door. The description of the room is the same as before, but you will now be offered the option to use the
// Card and severed fingers to open the door lock.
// As the location is the same, the page triggers when the Page number is 7, but the player also has the keycard.
if (missionVariables.assassins_rebooted_adventure_page === 7 && missionVariables.assassins_rebooted_adventure_keycard === 1) {
var message = "You enter the Station Manager's Office.\n\nBehind a large steel desk sits the Station Manager, or rather what remains of him. His head is not present, apparently removed by an extremely high yield laser blast. In one wing he still grips a laser pistol, although two of his digits appear to have been removed with a sharp object. You also note, as you look around, a single blast mark on the wall by the door.\n\nThe wall behind the Manager's mutilated form is badly charred and on the desk an ID Passcard sits, its data chip smashed beyond use. Ahead of you is a large blast door, tightly sealed. A sign above the door reads:\n\n'Access to Research Laboratories restricted to Level 2 and above personnel. Insert your passcard and stand by for DNA verification.'\n\nA small slot is positioned by the door. Next to the slot is a scanner panel. The scanner panel is wing shaped and currently illuminated with a red light. Behind you a plain metal corridor leads to the Main Hangar.\n\nWhat action will you take Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page9",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page9_choices"
},
function (choice) {
if (choice === "1_PAGE9_1") {
missionVariables.assassins_rebooted_adventure_page = 10;
}
if (choice === "2_PAGE9_2") {
missionVariables.assassins_rebooted_adventure_page = 1;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 10 - The Short Red Corridor - Page only shown when you use the passcard and digits to open the door.
// You pass down the corridor and find yourself in The Cafeteria...
if (missionVariables.assassins_rebooted_adventure_page === 10) {
var message = "You extract the Passcard from your suit pocket and insert it into the slot.\n\nA computer monitor nearby flickers into life. You presume the machine is attempting to give you instructions, but in the vacuum of the airless station you cannot hear the typically dulcet tones of the AI. The scanner panel changes colour from red to green, so you assume that the machine requires a wing-print scan.\n\nTaking Major Yan De Sorton's digits, you press them firmly against the scanner panel. For a few agonising seconds the display flickers from green to red, before setting down to a pulsing blue. You feel the hum of power vibrating through the floor beneath your feet and the blast door slowly opens.\n\nLooking through the open doorway, you see a short red corridor leading away into darkness. Glancing at your oxygen meter, you are concerned to see that you have less than twenty minutes of air left. Wasting no time, you step through the blast door and begin following the corridor. The blast door closes behind you.\n\nAfter a few minutes you arrive in a large open room. Slinging your Ingram into your hands you take stock of your surroundings...";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page10",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_black_mesa_page10_choices"
},
function (choice) {
missionVariables.assassins_rebooted_adventure_page = 11;
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 11 - The Cafeteria.
if (missionVariables.assassins_rebooted_adventure_page === 11) {
var message = "You have entered a cafeteria, presumably for the use of the station's scientific staff.\n\nTables and chairs are set out around the room, most laid out with half eaten meals. There are no signs of battle here, but the bodies of many harmless fat birds are slumped over the tables, several still clutching data-pads. All are dressed in long white coats, most with identification badges pinned to the lapels.\n\n Examining the corpses of the hapless scientists you see no signs that these birds met a violent death, all appearing to have died when the station was decompressed. Searching the cafeteria, you quickly locate a computer terminal in the corner of the room and instruct it to display a schematic of your immediate surroundings.\n\nIt appears that you are now within the inner section of the station. According to the computer, the Research Laboratories are to your left, a corridor to the Main Power Room lies to your right. Ahead of you is the Missile Storage Center.\n\nWhich exit will you take Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page11",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page11_choices"
},
function (choice) {
if (choice === "1_PAGE11_1") {
missionVariables.assassins_rebooted_adventure_page = 12;
}
if (choice === "2_PAGE11_2") {
missionVariables.assassins_rebooted_adventure_page = 16;
}
if (choice === "3_PAGE11_3") {
missionVariables.assassins_rebooted_adventure_page = 22;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 12 - The Research Laboratories (No Trumble in inventory).
// A trumble can be found here and capturing it is required to use it to open the door to the power room.
// Once found, it won't be found again and so two different pages are used for the location depending on weather the player has already got the trumble.
if (missionVariables.assassins_rebooted_adventure_page === 12 && missionVariables.assassins_rebooted_adventure_trumble === 0) {
var message = "The door to this room describes it as the 'Bioagent Research Laboratory' in large red letters above various yellow 'Biohazard' and 'Danger of Hideous Mutation and Death' signs. As you approach, the door slides open and you enter the Laboratory.\n\nThe lighting is fitful, flickering on and off and in some places not coming on at all, making the interior of the lab difficult to identify. At the far end you can see a large metal blast-door. As you peer into the gloom you can make out rows of tall glass tubes, each about a meter across and filled with a green liquid. Inside each is a different creature. Investigation reveals the poor aliens are dead, each slain by some form of avian manufactured toxin.\n\nAt the end of the lab, you see a tube which is broken. Glass shards and frozen liquid cover the floor as the monitor beneath the tube flashes 'Warning: Booth Malfunction! Tube Breached! Bioagent Contamination Risk!'. Through the thin atmosphere of the lab, your EVA suit's audio sensors can make out a noise, part whimper part growl. Something is still alive and it knows you're here!\n\nWhat will you do Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page12",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page12_choices"
},
function (choice) {
if (choice === "1_PAGE12_1") {
missionVariables.assassins_rebooted_adventure_page = 14;
}
if (choice === "2_PAGE12_2") {
missionVariables.assassins_rebooted_adventure_page = 11;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Notional Page 13 - The Research Laboratories (Trumble in inventory).
// This Page is displayed if the player returns to the room where they found the trumble having already collected the trumble.
// The page is displayed when the page value is at 12 but a different version is displayed without the option to investigate the noise or pick up the trumble.
if (missionVariables.assassins_rebooted_adventure_page === 12 && missionVariables.assassins_rebooted_adventure_trumble === 1) {
var message = "The door to this room describes it as the 'Bioagent Research Laboratory' in large red letters above various yellow 'Biohazard' and 'Danger of Hideous Mutation and Death' signs. As you approach, the door slides open and you enter the Laboratory.\n\nThe lighting is fitful, flickering on and off and in some places not coming on at all, making the interior of the lab difficult to identify. At the far end you can see a large metal blast-door. As you peer into the gloom you can make out rows of tall glass tubes, each about a meter across and filled with a green liquid. Inside each is a different creature. Investigation reveals the poor aliens are dead, each slain by some form of avian manufactured toxin.\n\nAt the end of the lab, you see a tube which is broken. Glass shards and frozen liquid cover the floor as the monitor beneath the tube flashes 'Warning: Booth Malfunction! Tube Breached! Bioagent Contamination Risk!'.\n\n The albino trumble in your pocket trills in an unhappy way. Perhaps the room is bringing back memories of the experiments performed here? There is nothing else of use in the laboratory and you seem to have no option but to return to the Cafeteria.";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page13",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_black_mesa_page13_choices"
},
function (choice) {
missionVariables.assassins_rebooted_adventure_page = 11;
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 14 - The Research Laboratories (Chosen to Investigate the strange noise).
// The noise is being made by a trumble, whch can be picked up and added to the inventory.
// The option to pick it up is given once the player has investigated the noise.
if (missionVariables.assassins_rebooted_adventure_page === 14) {
var message = "Swallowing down your mounting panic, you unsling your Ingram and hold it ready.\n\nIt seems to take an eternity for it to cycle up to full power, but finally the indicator on the side of the weapon switches from red to green, indicating full power is available. Placing your gloved finger over your weapon's trigger, you begin to feel a little braver. Time to find out what exactly could survive temperatures of minus eighty with less than one tenth an atmosphere of air pressure.\n\nSetting the power rating of the Ingram's beam to full, you cautiously round the shattered tube and proceed towards the source of the ominous sound. Behind the tube is a wreaked computer bank, trailing a mess of wires across the floor.\n\nIn amongst them you see something that is extraordinary in the extreme, a rare Albino Trumble! As it becomes aware of you, the Trumble ceases chewing a circuit board and rolls towards you. As it sits at your feet, it starts to trill cheerfully and the sound through your helmet speakers makes you feel much better.\n\nWhat will you do Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page14",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page14_choices"
},
function (choice) {
if (choice === "1_PAGE14_1") {
missionVariables.assassins_rebooted_adventure_page = 15;
}
if (choice === "2_PAGE14_2") {
missionVariables.assassins_rebooted_adventure_page = 11;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 15 - The Research Laboratories (Picking up the trumble).
//  Picking up the trumble adds it to your inventory. You then return to the Cafeteria.
if (missionVariables.assassins_rebooted_adventure_page === 15) {
var message = "You pick up the Albino Trumble.\n\nThe little creature seems pleased to have found a friend, trilling contentedly as you slip it into your suit pocket. You sweep aside the mess of wires and wreaked circuit boards to discover a set of scientific notes. It appears the scientists at the research station were working on a new guidance system for a Graviton Warhead Missile.\n\nRather than using a computer guidance system, vulnerable to an EMP defence, it seems the rebel bird scientists planned to use trained trumbles to guide the missile to its target. As you glance around the lab, you notice that images of a Balrog Class Dreadnaught are displayed on many monitors, along with images of scantily clan female trumbles. Several dead trumbles are connected to electric shock devices. You shudder at the methods used to train the poor beasts.\n\nThe Albino Trumble seems to have taken a shine to you, chirruping happily in your EVA suit pocket and snuggling against your leg through the material of the suit. You just hope the affectionate little critter won't decide to start chewing!\n\nWith your new pet in tow, you return to the Cafeteria.";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
missionVariables.assassins_rebooted_adventure_trumble = 1;
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page15",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_black_mesa_page15_choices"
},
function (choice) {
missionVariables.assassins_rebooted_adventure_page = 11;
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 16 - The Long Winding Corridor (No Trumble in Inventory).
// The trumble is needed to bypass the malfunctioning door. If the player has not yet found the trouble, then the option to attempt to manually rewire the door circuits manually
// will be given. This won't work however and the player will have to return to the Cafeteria.
if (missionVariables.assassins_rebooted_adventure_page === 16 && missionVariables.assassins_rebooted_adventure_trumble === 0) {
var message = "You have entered a long winding corridor.\n\nThe lighting system has failed and the corridor is bathed in the eerier blood red light cast by the emergency illumination systems. Your respiration resonates loudly in the confines of your helmet. This corpse ridden station is starting to give you the creeps. Your heartbeat is racing and you feel the sweat from your palms pooling uncomfortably in your gloves.\n\nYou proceed cautiously, Ingram in hand. After a few minutes creeping forward along the corridor, you encounter an obstacle. A large blast-door prevents further progress forward. It would seem that the door automatically sealed when the station suffered its catastrophic decompression, presumably as a safety mechanism.\n\nUnfortunately the control panel has taken a solid blast from a laser and now hangs from the recess by a few charred wires. You have a good poke around inside the recess, but the confused mess of blackened wires mean little to you.\n\nWhat will you do Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page16",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page16_choices"
},
function (choice) {
if (choice === "1_PAGE16_1") {
missionVariables.assassins_rebooted_adventure_page = 17;
}
if (choice === "2_PAGE16_2") {
missionVariables.assassins_rebooted_adventure_page = 11;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 17 - The Long Winding Corridor (Attempting to rewire the door manually doesn't work.).
// Having failed to fix the door, you return to the Cafeteria.
if (missionVariables.assassins_rebooted_adventure_page === 17) {
var message = "Taking a hyper-spanner from your suit's utility belt, you attempt to rewire the fused opening circuits. How hard can a bit of electronics work be after all?\n\nYou poke around with your hyper-spanner attempting to rewire the fused circuits. However, although you may be an excellent pilot and lethal assassin, the basic ship maintenance course that you took at the Lave Academy didn't extend to repairing fused door circuits and you have little idea of the correct procedure.\n\nUndeterred by your negligible grasp of the basic principles, you none the less inexpertly fiddle with the doors systems for a few minutes. Suddenly there is a snap and crackle of electricity. Your EVA suit whoops a warning into your helmet as the suit valiantly resists thousands of volts of power.\n\nAs a diagnostic scrolls across your helmet HUD, you are forced to concede that your skills do not extend to repairing bird-manufactured electronics!\n\nLacking the technical skills to repair the door yourself, you seem to have little option but to return to the Cafeteria.";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page17",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_black_mesa_page17_choices"
},
function (choice) {
missionVariables.assassins_rebooted_adventure_page = 11;
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Notional Page 18 - The Long Winding Corridor (Trumble in Inventory).
// The trumble is needed to bypass the malfunctioning door. Once the player has the trumble, the option to drop it into the recess to eat through the locking mechanism
// is offered. Selecting this will work, letting the player into the coridoor to the Power Room.
if (missionVariables.assassins_rebooted_adventure_page === 16 && missionVariables.assassins_rebooted_adventure_trumble === 1) {
var message = "You have entered a long winding corridor.\n\nThe lighting system has failed and the corridor is bathed in the eerier blood red light cast by the emergency illumination systems. Your respiration resonates loudly in the confines of your helmet. This corpse ridden station is starting to give you the creeps. Your heartbeat is racing and you feel the sweat from your palms pooling uncomfortably in your gloves.\n\nYou proceed cautiously, Ingram in hand. After a few minutes creeping forward along the corridor, you encounter an obstacle. A large blast-door prevents further progress forward. It would seem that the door automatically sealed when the station suffered its catastrophic decompression, presumably as a safety mechanism.\n\nUnfortunately the control panel has taken a solid blast from a laser and now hangs from the recess by a few charred wires. You have a good poke around inside the recess, but the confused mess of blackened wires mean little to you.\n\nWhat will you do Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page18",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page18_choices"
},
function (choice) {
if (choice === "1_PAGE18_1") {
missionVariables.assassins_rebooted_adventure_page = 19;
}
if (choice === "2_PAGE18_2") {
missionVariables.assassins_rebooted_adventure_page = 11;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 19 - The Long Winding Corridor (Trumble placed in the control panel recess).
// The trumble will eat through the circuits opening the door and allowing the player into the corridor to the power room.
// However an evil looking armed bird is blocking the way and going for their gun.
// The option is to fight or flee to the Power Room, although whichever choice is made the player will end up in the power room either having gunned down the imperial bird
// or having run past it and sealing the door.
if (missionVariables.assassins_rebooted_adventure_page === 19) {
var message = "You drop the calmly cooing Trumble into the control panel recess and listen as it hungrily starts munching on the mess of wiring within.\n\nMoments later there is the flash and crackle of raw electricity arcing and a thin squeal of pain swiftly cut off. Thin white smoke drifts out of the recess before the large blast door's securing bolts slide back and it ponderously opens. You feel a momentary pang of guilt for the poor Trumble which is swiftly replaced by the certain knowledge of the fate the life support circuits aboard your ship would have met had the little critter survived!\n\nYou step through the door and follow the corridor along for several minutes.\n\nAs you round a bend in the corridor, it widens out into a large room. Ahead you see an open blast door, leading to the Main Power room. Suddenly a figure in a dark EVA suit steps from the shadows. Despite the dim lighting you note with concern that his gloved wing is reaching for a heavy blaster at his side.\n\nWhat action will you take Commander?";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page19",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_page19_choices"
},
function (choice) {
if (choice === "1_PAGE19_1") {
missionVariables.assassins_rebooted_adventure_page = 20;
}
if (choice === "2_PAGE19_2") {
missionVariables.assassins_rebooted_adventure_page = 21;
}
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 20 - The Main Power Room (Chose to shoot the enemy).
// Having gunned down your opponent, you walk like a badass into the Main Power room.
// Having restored the power, you log onto the Auto Loader Computer to load up your ship with Graviton Missiles.
if (missionVariables.assassins_rebooted_adventure_page === 20) {
// Store as a variable wheather or not the player shoots the stormtrooper.
missionVariables.assassins_rebooted_shot_stormtrooper = "Yes";
var message = "You did not become a Grandmaster Assassin without developing quick reflexes!\n\nBefore the bird's feathery fist is half way to his blaster, your trusty Ingram is in your hands and ready for action. Whilst your opponent is still fiddling with the safety catch of his weapon, you have drawn a bead on him and dispatched him with a series of well aimed laser bolts to his head.\n\nAs his headless corpse falls to the ground, you hurry forward into the Main Power room. Within moments you have the main reactor back on line. Anxiously checking the system diagnostic screen, you see that power to the space doors, airlocks and the Auto Ordinance Loader Systems are back on-line.\n\nYou access the station mainframe and note that the auto loading systems can remove any ordinance you have fitted and load graviton missiles directly from the silos onto your ship's weapons pylons.\n\nYou scroll through the configuration options, select your ship and enter the command codes to commence the loading procedure.";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page20",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_black_mesa_page20_choices"
},
function (choice) {
missionVariables.assassins_rebooted_adventure_page = 23;
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 21 - The Main Power Room (Chose to flee to the Main Power Room and shut the door).
// Having run away you slam the door shut locking your enemy out of the Power Room.
// Having restored the power, you log onto the Auto Loader Computer to load up your ship with Graviton Missiles.
if (missionVariables.assassins_rebooted_adventure_page === 21) {
missionVariables.assassins_rebooted_shot_stormtrooper = "No";
var message = "You did not become a Grandmaster Assassin without knowing when to run!\n\nA quick glance at the rounded form of your opponent, tells your experienced combat senses that he will have trouble hitting a moving target. You are safely within the Main Power room before he can get off a shot. Inside you shoot the locking mechanism and the blast door slams shut. Within moments you have the main reactor back on line. Anxiously checking the system diagnostic screen, you see that power to the space doors, airlocks and the Auto Ordinance Loader Systems are back on-line.\n\nYou access the station mainframe and note that the auto loading systems can remove any ordinance you have fitted and load graviton missiles directly from the silos onto your ship's weapons pylons.\n\nYou scroll through the configuration options, select your ship and enter the command codes to commence the loading procedure.";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page21",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_black_mesa_page21_choices"
},
function (choice) {
missionVariables.assassins_rebooted_adventure_page = 23;
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 22 - The Missile Storage Center.
// This is an optional room, as you do not need to go here to complete the adventure. If you visit it then you get a description of the missile sillos.
// The room is a dead-end and you can only go back out into the Cafeteria. 
if (missionVariables.assassins_rebooted_adventure_page === 22) {
var message = "You have entered the Missile Storage Centre.\n\nStacked neatly in racks are missiles of a design you have not encountered before. Each is six meters in length and approximately half a meter in width. Considerably larger than even a Nuclear Torpedo, each is fitted with a powerful rocket engine. The warhead of each missile is marked 'Graviton Warhead. Trumble Inside Guidance'.\n\nTurning your EVA suit audio sensors up to maximum volume and placing your helmet against the side of one of the missiles, you can just make out faint chirruping sounds coming from within the polished metal nosecone of the rocket.\n\nGlancing upwards you see a remote crane is positioned above the missiles. You realize that the missiles are far too heavy to move by hand. However, if you could restore Main Power, you would be able to order the crane to load Graviton Missiles to your ship's missile pylons.\n\nYou seem to have no option but to return to the Cafeteria.";
var bgImage = "assassins_rebooted_bgs_adventure_screen.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page22",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_black_mesa_page22_choices"
},
function (choice) {
missionVariables.assassins_rebooted_adventure_page = 11;
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 23 - The Missile Loading Screen
// Provides some technical information on the Graviton Missiles as the player operates a computer terminal to load the missiles onto the ship's pylons. 
if (missionVariables.assassins_rebooted_adventure_page === 23) {
var display1 = "Selected Ordinance: Graviton Missile Mark I (10 Units in Storage).\n\nThis weapon is fully autonomous and regardless of the target selected by the user, the trumble pilot will guide the missile towards the Imperial Dreadnaught. The graviton burst from the warhead will interact only with regenerative armour. It will not detonate if it strikes a target other than the Dreadnaught. Effective range is limited to five kilometres by the visual acuity of the average trumble.\n\n";
var maxmissiles = player.ship.missileCapacity;
// Special case if the player only has one pylon.
if (maxmissiles === 1) {
var display2 = "The selected ship possesses a single pylon. ";
var displayaddition = "Any armament currently mounted will be removed and replaced with a Graviton Missile, denoted by a square icon.\n\n";
}
// If the player has more than one pylon, convert numbers to words before displying the text.
if (maxmissiles > 1) {
var sizenumbers = ["zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty", "twenty one", "twenty two", "twenty three", 
"twenty four", "twenty five", "twenty six", "twenty seven", "twenty eight", "twenty nine", "thirty", "thirty one", "thirty two", "thirty three", "thirty four", "thirty five", "thirty six", "thirty seven", "thirty eight", "thirty nine", "forty", "forty one", "forty two", "forty three", 
"forty four", "forty five", "forty six", "forty seven", "forty eight", "forty nine", "fifty", "fifty one", "fifty two", "fifty three", "fifty four", "fifty five", "fifty six", "fifty seven", "fifty eight", "fifty nine", "sixty", "sixty one", "sixty two", "sixty three", "sixty four", "sixty five", 
" sixty six", "sixty seven", "sixty eight", "sixty nine", "seventy", "seventy one",  "seventy two", "seventy three", "seventy four", "seventy five", "seventy six", "seventy seven", "seventy eight", "seventy nine", "eighty", "eighty one", "eighty two", "eighty three", 
"eighty four", "eighty five", "eighty six", "eighty seven", "eighty eight", "eighty nine", "ninety", "ninety one", "ninety two", "ninety three", "ninety four", "ninety five",  "ninety six", "ninety seven", "ninety eight", "ninety nine", "one hundred",
// Not Used as with more than 100 pylons the OXP display will switch to numbers instead of words.
"One hundred and one"];
var displaymaxmissiles = sizenumbers[maxmissiles];
if (maxmissiles > 100)  displaymaxmissiles = maxmissiles;
var display2 = "The selected ship possesses "+displaymaxmissiles+" pylons. ";
var displayaddition = "Any and all armaments currently mounted will be removed and replaced with "+displaymaxmissiles+" Graviton Missiles, denoted by a square icon.\n\n"; 
if (maxmissiles > 10) var displayaddition = "Ten armaments currently mounted will be removed and replaced with Graviton Missiles, denoted by a square icon.\n\n";
}
var display3 = "Exposure to graviton radiation may cause side effects in some users. Prolonged exposure may cause memory loss, vomiting, nausea, loss of appetite and fear of the colour green. SoloSoft accepts no liability for any loss or injury caused by the use of this weapon system.\n\n Awaiting user confirmation to proceed.\n\:>_";
var message = display1+display2+displayaddition+display3;
var bgImage = "assassins_rebooted_bgs_adventure_terminal.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page23",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_black_mesa_page23_choices"
},
function (choice) {
// Run a sub-function to remove all missiles (up to a max of 10) and replace them with Graviton Missiles (also up to a maximum of 10).
// All your missiles will be replaced with Graviton Missiles, unless you have 11 or more missile pylons, in which case only 10 will be replaced (maxium on the station).
this.assassins_missileloadup();
missionVariables.assassins_rebooted_adventure_page = 24;
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 24 - The Observation Gantry.
if (missionVariables.assassins_rebooted_adventure_page === 24) {
// Slightly different opening paragraph depending on weather the player has one missile pylon or more than one for plural and singular.
var maxmissiles = player.ship.missileCapacity;
var messagestart = "Having activated the ordinance loading system, you retract the blast shutters and step through onto the Observation Gantry overlooking the Main Hangar. You watch nervously as the robotic cranes gently lift Graviton Missiles from the silos in the Missile Storage Center and install them onto the hardpoints of your ship.";
if (maxmissiles === 1) var messagestart = "Having activated the ordinance loading system, you retract the blast shutters and step through onto the Observation Gantry overlooking the Main Hangar. You watch nervously as the robotic cranes gently lift a Graviton Missile from the silo in the Missile Storage Center and install it onto the hardpoint of your ship.";
var messageend = "\n\nThe process takes considerably longer than you were expecting and also places a significant drain on the power reserves. Numerous red warning lights start blinking on the power console as the cooling systems struggle to maintain the overburdened reactor. Finally, the auto-loaders complete their task as the main reactor reaches critical temperature.\n\nFortunately, an emergency exit slide opens behind you as the evacuation alarms begin to sound. Wasting no time and noting that you also now only have three minutes of air remaining, you dive headfirst down the escape slide and combat roll into the Main Hanger.\n\nYou have never been more relived to see your berthed ship.";
var message = messagestart+messageend;
var bgImage = "assassins_rebooted_bgs_adventure_gantry.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page24",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_black_mesa_page24_choices"
},
function (choice) {
missionVariables.assassins_rebooted_adventure_page = 25;
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Page 25 - Back in the Command Chair.
// This is the final page of the Gamebook, with the station's reactor about to blow, the situation gets worse as laser fire starts hitting the station.
// The player is force launched from the station and must now deliver the Graviton Missiles on their pylons to the system main station.
// A group of Imperial Ships are spawned as soon as the player launches. These will attack the station.
// The station's AI looks for the imperial ships by role and once it finds them it will pause for 10 seconds before it's AI executes becomeExplosion.
// The station will therefore blow up 10 seconds after the player launches, but it will look like it was the Imperial Ships attacking it which destroyed it.
// Once the station explodes, the imperial ships will attack the player or if the player has injectored out of their scanner range, they will head towards the main station
// themselves and attack the player if they find them.
if (missionVariables.assassins_rebooted_adventure_page === 25) {
var message = "Back aboard your ship, you pull off your EVA suit and return your Ingram to the Weapons Locker. Very pleased to have escaped the doomed station to the relative safety of your ship, you settle back in your Command Chair with a sigh of relief. Quickly, you retract the gangplank, seal the airlocks and power up the main drive.\n\nAs you retract the landing gear and taxi towards the launch tunnel, you notice that fires have broken out in the Main Power room and the lighting in the landing bay has dimmed to a faint red glow. Suddenly, you hear the distinctive sound of laser fire striking the outer hull of the Facility as a large support beam collapses, narrowly missing the nose of your ship.\n\nIt would appear that in addition to your other difficulties, imperial forces are attempting to prevent you from completing your mission to deliver the Graviton Missiles to Agent Bluebird at the Angeriri main station.\n\nGrimley, you charge your own weapons systems and prepare for combat.";
var bgImage = "assassins_rebooted_bgs_adventure_ship.png";
mission.runScreen({
titleKey: "assassins_rebooted_black_mesa_page25",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_black_mesa_exit"
},
function (choice) {
// The mission stage is advanced taking the game out of the Text Adventure Loop.
missionVariables.assassins_rebooted_stage = 54;
// Change the Short Description - The player's mission is now to take the Graviton Missiles to the Main Station.
mission.setInstructionsKey("assassins_rebooted_mission_description_35");
// Delete the variables only used during the text adventure.
delete missionVariables.assassins_rebooted_adventure_page;
delete missionVariables.assassins_rebooted_adventure_keycard;
delete missionVariables.assassins_rebooted_adventure_trumble;
// Add a Deamon Class Cruiser near the Rebel Facility with an AI to attack the Facility. Once the Facility expodes, it will attack the player.
system.addShips("assassins_rebooted_demon_text_adventure",1,player.ship.position.add([1000,0,0]),10560)[0];
// Add a squad of three Imperial Shuttles with the same AI as the Deamon.
system.addShips("assassins_rebooted_shuttle_text_adventure_station_attacker",1,player.ship.position.add([1000,0,0]),15500)[0];
// Add a squad of three Mongoose Fighters with the same AI as the Deamon.
system.addShips("assassins_rebooted_mongoose_text_adventure_station_attacker",1,player.ship.position.add([1000,0,0]),18500)[0];
player.ship.launch();
// As the docking port faces the main station, ships added below will be in a straight line with the Facility and the player's destination of the main station.
// All have an AI to fly towards where the Reble facility was and attack the player if they encounter them.
// Add a group of three Scorpion Frigates 250kms from the player's position with AIs to go to the player's current position.
system.legacy_addShipsAtPrecisely("assassins_rebooted_scorpion_imperial_outlaw_mission_base_bound", 1, "abs", player.ship.position.add(player.ship.heading.multiply(250000)))
// Add a group of 3 Mongoose Fighters with an AI to go to the player's current position 100kms from the player's current position.
system.addShips("assassins_rebooted_mongoose_imperial_outlaw_mission_base_bound",1,player.ship.position.add([1000,0,0]),100000)[0];
// Add 3 more groups of Mongoose fighters with an AI to go to the player's current position at 350, 650 and 850kms.
system.legacy_addShipsAtPrecisely("assassins_rebooted_mongoose_imperial_outlaw_mission_base_bound", 1, "abs", player.ship.position.add(player.ship.heading.multiply(350000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_mongoose_imperial_outlaw_mission_base_bound", 1, "abs", player.ship.position.add(player.ship.heading.multiply(650000)))
system.legacy_addShipsAtPrecisely("assassins_rebooted_mongoose_imperial_outlaw_mission_base_bound", 1, "abs", player.ship.position.add(player.ship.heading.multiply(850000)))
// Another wing of three Scorpions are added near the main station.
system.addShips("assassins_rebooted_scorpion_imperial_outlaw_mission_base_bound",1,system.mainStation.position.add([26500,0,0]), 1000)[0];
}, this); 
}
// Closeing Bracket for the whole of the text adventure.
}

// Fail Safe in case the player manually docks after completing the text adventure but before the station explodes.
// Unlikley to be posible, but if the player was quick enough to flip over and dock, they will be forcabley relaunched.
if (player.ship.dockedStation.name === "Rebel Facility: Black Mesa" && missionVariables.assassins_rebooted_stage > 53) {
player.ship.launch();
}

// Offer the 10th (and final) Assassination - Eliminate Governor Tarkin aboard the Imperial Dreadnaught. 
// Must be docked at the Angeriri Main Station having completed the Text Adventure.
// There has been a change of plan. The Dreadnaught has jumped into Eszausve and has destroyed the rebel held prison. The rebels are throwing everything they have at it
// and even GalCop's Navy has deployed some Frigates to assist. But its regenerative armour is proof against all weapons systems except a Graviton Missile.
// As the only ship equiped with Graviton Missiles, it's up to you to take it down.
if (missionVariables.assassins_rebooted_stage === 54 && system.ID === 71 && player.ship.dockedStation.isMainStation) {
var messagestart = "It appears that there has been a change of plan. The Imperial Dreadnaught has entered the Eszausve System and engaged the rebels near the rocky moon, Columba. Agent Bluebird has left to join the battle, but the situation is grim. The rebel held prison was destroyed with the first broadside and the Dreadnaught's regenerative armour is proving invulnerable to conventional weapons.\n\nIn light of the clear and present danger presented by the Dreadnaught, GalCop has deployed a squadron of Aeron Class Frigates to Intercept it but even they cannot hope to do more than delay its progress towards the densely populated inner planet. Governor Tarkin himself is believed to have taken personal command of the Dreadnaught and thus it's destruction could end the civil war at a stroke.\n\n";
var describemissiles = "As your ship is equipped with the last Graviton Missiles in existence, ";
var maxmissiles = player.ship.missileCapacity;
// Slightly different wording if the player only has one missile.
if (maxmissiles === 1) {
var describemissiles = "As your ship is equipped with the last Graviton Missile in existence, ";
}
var messageend = "it would seem that the fates have conspired to cast you in the role of hero. Your contract, should you chose to accept it, is to assassinate Governor Tarkin and end the Eszausveian civil war. A GalCop bounty of 50,000 Credits will be paid upon the execution of this contract.";
var message = "Message From: Guildmaster Astred Nua'ectou.\nSecure Mail Box: astred@removals.co.gal\n\n"+messagestart+describemissiles+messageend+"\n\n---MESSAGE ENDS.";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
message: message, 
model: "assassins_rebooted_victim10",
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 55;
missionVariables.assassins_rebooted_jumpcounter = 0;
// The description of Eszausve is changed to reflect the updated situation and its population and productivety continue to fall as the civil war continues.
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean but cursed by one of the most oppressive governments in the Galaxy. Although the rebels have fought bravely, the spark of freedom appears about to be snuffed out by the arrival in the system of the Imperial Dreadnaught. The rebels are making a desperate last stand against the Dreadnaught near the rocky moon, Columba.";
System.infoForSystem(6,13).productivity = 62131;
System.infoForSystem(6,13).population = 64; 
mission.setInstructionsKey("assassins_rebooted_mission_description_36");
mission.unmarkSystem(71);
mission.markSystem({system: 13, markerColor: "redColor", markerScale: 1.5, markerShape: "MARKER_DIAMOND"});
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

//  Congratulate the player on destroying the Dreadnaught.
// Must be docked anywhere having destroyed the Dreadnaught.
if (missionVariables.assassins_rebooted_stage === 56) {
// Count how many (if any) Graviton Missiles the player has left.
var i = 0;
var loop = player.ship.missiles;
var missilesremoved = 0;
if (loop.length !== 0) {
for (i = 0; i < loop.length; i++) {
var eq = player.ship.missiles[0].equipmentKey;
if (eq.indexOf("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE") > -1)  {
// Remove any Graviton Missiles remaining on the pylons, but leave any other pylon mounted weapon / equipment untouched.
player.ship.removeEquipment(eq);
// Count up how many gravition missiles we've removed.
missilesremoved++;
}
}
}
var messagestart = "Message From: Guildmaster Astred Nua'ectou.\nSecure Mail Box: astred@removals.co.gal\n\nI am pleased to see that you have prevailed. Getting close enough to the Dreadnaught for the optically challenged trumble to acquire the target must have tested even your iron nerve. The graviton detonation was more powerful than we had expected. Perhaps with modifications graviton weapons could prove to be a welcome addition to the Guild's arsenal.";
// Default of comment if the player has no gravition missiles left (ie if there are no gravitions on the pylons to remove so removed variable is still at zero)
var describemissiles = " It is unfortunate that you were forced to deploy the last warhead in existence.";
// Plural if the player had more than one gravition missile to begin with.
if (player.ship.missileCapacity > 1) {
var describemissiles = " It is unfortunate that you were forced to deploy the last warheads in existence.";
}
// Different comment if graviton missiles have been removed.
if (missilesremoved === 1) {
var describemissiles = " We have dispatched a loading drone to remove your remaining graviton missile.";
}
if (missilesremoved > 1) {
var describemissiles = " We have dispatched a loading drone to remove your remaining graviton missiles.";
}
var messageend = "\n\nAlthough somewhat late to the party, reinforcement fleets of Naval Aeron Class Frigates are jumping into the Eszausve system to assist in mopping up the remnants of the Imperial Fleet. The death of Governor Tarkin at your hands, appears to have demoralised his minions. Many have fled into witchspace and others have surrendered to the former rebels. Free and fair elections are being organised, although in light of their debt to the Guild, we will have something to say as to whom the correct candidates will be.\n\nI have promoted you to the rank of The Hand. Few contracts will call for the skills of the Hand of the Guild but in the meantime, keep an eye on to the Galaxy 7 News Service for the results of the imminent Eszausveian election.\n\n---MESSAGE ENDS.";
var message = messagestart+describemissiles+messageend;
var bgImage = "assassins_rebooted.email-message.png";
mission.runScreen({
titleKey: "assassins_rebooted_general_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_message_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
missionVariables.assassins_rebooted_stage = 57;
missionVariables.assassins_rebooted_jumpcounter = 0;
mission.setInstructionsKey("assassins_rebooted_mission_description_38");
}, this); 
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// The 17th and final News Broadcast of the OXZ appears. - Must be docked anywhere except Eszausve having made at least 3 jumps since 
// being congratulated for destroying the Dreadnaught.
// Eszausve has been recognised by GalCop and someone of the player's aquantance has been elected as First Citizen.
// The system is set to its final state. As with the original assassins OXP reference is made to Agent Wombat to
// indicate to the player that the OXZ is Complete and the short description is deleted.
// The player can still view their status and achievments with the Guild on the F4 screen.
// If Victim 11 OXP is installed, this will be triggered once the player has made at least one jump since seeing
// the final News Broadcast. 
if (missionVariables.assassins_rebooted_stage === 57 && system.ID !== 13 && missionVariables.assassins_rebooted_jumpcounter > 2) {
var message = "The results of the Eszausve General Election were announced earlier this morning by the returning officer, Desmond Miles. After a tightly fought campaign, Lucien Lachance of the Popular Democratic Party defeated Vernita Green of the Freedom Party, winning an overall majority of 19 perches in the Planetary Parliament. GalCop Chief Observer, Jacob Frye, certified the elections as free and fair and confirmed that the entry in the Galactic Registry would be updated to recognise Eszausve as a democratic system.\n\nIn his maiden speech, First Citizen Lachance announced the decommissioning of the Imperial Astro Factory and the construction of a war memorial at the location of the destroyed imperial prison. A project to harness gravition radiation as a form of clean energy is also planned with reactors being constructed deep beneath the surface of Columba.\n\nIn other news, Inspector Tobias Gregson of GalCop Special Branch announced that he has reopened the investigation into the death of his colleague Inspector Thorstan during the recent Thargoid Invasion of the Geteve system. Whilst originally attributed to alien raiders, closer examination of the combat telemetry has shown that a GalCop registered ship marked with a red hand decal fired the fatal shots. A covert operative known only as Agent Wombat is understood to be working under deep cover within the nefarious organisation behind the assassination.\n\n---TRANSMISSION ENDS.";
var bgImage = "assassins_rebooted_news_alert.png";
mission.runScreen({
titleKey: "assassins_rebooted_news_header",
screenID: "AssassinsRebooted",
overlay: bgImage,
message: message, 
choicesKey: "assassins_rebooted_news_exit"
},
function (choice) {
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();
// This is the last event of Assassins OXZ, but the Stage variable will be set to complete once the player has made at least 1 jump and docked again in order to accomadate
// the Victim 11 OXP (if installed). Once a single jump has been made then the stage variables for both the old version of assassins and the rebooted version will be set
// to Complete. As Victim 11 tests for the orginal assassins stage variable being at Complete, this causes the Victim 11 OXZ to run after the rebooted version of assassins
// has been completed with a short delay of making 1 jump. 
missionVariables.assassins_rebooted_stage = 58;
missionVariables.assassins_rebooted_jumpcounter = 0;
// Now that Eszausve has been re-designated a Democracy, no imperial or military ships are present, the main station is renamed to be a GalCop station, passenger liners will start
// flying to the Hotels again.
missionVariables.assassins_rebooted_civil_war = "Over";
// Delete unneeded variables.
delete missionVariables.assassins_rebooted_escort_counter;
delete missionVariables.assassins_rebooted_interlude;
delete missionVariables.assassins_rebooted_navy_base_lockdown;
// Delete the short description for assassins rebooted (Your status as The Hand can still be viewed on the F4 Screen, if you wish!).
mission.setInstructions(null);
// Set Eszausve to its final state.
System.infoForSystem(6,13).government = 6;
System.infoForSystem(6,13).description = "Eszausve is famous for its rocky moon and the twin gas giants Hades and Lernean. Following a long period of civil war, the former dictatorship was overthrown and replaced with a democratic republic under the guidance of elected First Citizen Lucien Lachance. Commercial research is underway within the system into using graviton powered reactors as a source of clean and sustainable energy.";
System.infoForSystem(6,13).productivity = 77203;
System.infoForSystem(6,13).population = 65;
System.infoForSystem(6,13).inhabitants = "Harmless Fat Birds";
}, this); //
var mySound = new SoundSource;
mySound.sound = "assassins_rebooted_beep.ogg";
mySound.loop = false;
mySound.play();}

// Set the OXZ to Complete and also set the state for the orginal Assassins OXP to complete once the player docks having
// made at least one jump since seeing the last news broadcast.
if (missionVariables.assassins_rebooted_stage === 58 && missionVariables.assassins_rebooted_jumpcounter > 0) {
missionVariables.assassins = "assassins_COMPLETE";
missionVariables.assassins_rebooted_stage = "Complete";
missionVariables.assassins_rebooted_jumpcounter = 0;
}
// Closing Bracket for all Mission Briefing Screens and News Broadcasts
}
// Closing Bracket for Code only Checked in Galaxy 7.
}
// Closing Bracket for the whole of this.missionScreenOpportunity.
} 

// Function used to remove any missiles on the player's pylons and then fill the pylons to maximum with Gravition Missiles.
// Used at the end of the Text Adventure Mission to equip the player with the means to destroy the imperial dreadnaught.
this.assassins_missileloadup = function assassins_missileloadup() {
// Remove all the missiles (if any) on the player's pylons.
var loop = player.ship.missiles;
// As there are only 10 missiles in stock, then if the player has more than 10 pylons only 10 missiles will be removed and replaced with Graviton Missiles.
if (loop > 10) var loop = 10;
var i = 0;
if (loop.length !== 0) {
for (i = 0; i < loop.length; i++) {
var eq = player.ship.missiles[0].equipmentKey;
player.ship.removeEquipment(eq);
}
}
// Refill the Missile Pylons with Graviton Missiles up to the Maximim in Stock of 10.
// If the Player has a very unusual ship with more than 10 missiles then they will still only recieve the maximum of 10.
// If the player has more than 10 missile pylons, any weapon on pylon 11 onwards will not be replaced with a graviton missile and remains in place as before.
//The player will not end up however with more missiles than they have pylons.
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE");
player.ship.awardEquipment("EQ_ASSASSINS_REBOOTED_GRAVITON_MISSILE");
return;
// Closeing Bracket for Missile Load Up Function.
}

// Functions to add an interface to the F4 Screen to view achievements, ranks and details of any current missions with the Guild.
// This is only available once the player has joined the Guild and whilst they are in Galaxy 7. 
this.deathnote = function() {	
player.ship.dockedStation.setInterface("assassins_rebooted_death_note",{
title: "Open a Secure Link to The Assassins Guild",
category: "Assassinations",
summary: "Whilst within Galaxy 7 you may open an encrypted datalink to view your current standing with the Assassins Guild and the details of any outstanding contracts.",
callback: this.displaydeathnote.bind(this)});	
};

this.displaydeathnote = function() {	
// Starting Rank, Career History, Reputation, and Mission Description having first joined the Guild.
// These are advanced depending on the mission stage the player is currently at.
var rank = "You hold the rank of a Novice.";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 200 Credits and have taken a single life.\n\nYou are credited with retiring an elderly rodent scientist.";
var reputation = "\n\nNone of the local factions have any interest in you.";
var currentjob = "\n\nYou have no outstanding contracts.";
// Default Model of a Gravestone shown when no contract is active. When a contract is running, the model of the victim's ship is shown instead.
var currentbackground = "assassins_rebooted_gravemarker";
// Set the ship model to the current target if a mission to assassinate a target is running or the player is under attack by
// a hostile faction. Updates to the mission description and sometimes reputation when a mission is offered or completed. 
// Offered the Contract on Victim 2.
if (missionVariables.assassins_rebooted_stage === 6) {
var currentbackground = "assassins_rebooted_victim2";
var reputation = "\n\nYou are accepted by the Mafia.";
var currentjob = "\n\nYou are currently contracted to eliminate the Zarausxian Zero-G Hockey Team travelling aboard an Armoured Passenger Liner. The team are enjoying a victory tour of the Tiared System, travelling between the Madison Square Orbital Stadium and the main station. The liner is reported to be lightly armed, but the Nemesis security escorts could prove to be more formidable. A fee of 4,800 Credits is payable for this assignment.";
}
// Completed the Contract on Victim 2.
if (missionVariables.assassins_rebooted_stage > 6) {
var rank = "You hold the rank of a Cut-throat.";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 5,000 Credits and have taken 36 lives.\n\nYou are credited with retiring an elderly rodent scientist and eliminating a professional sports team together with their wives and girlfriends.";
var reputation = "\n\nYou are respected by the Mafia.";
var currentjob = "\n\nYou have no outstanding contracts.";
}
// Hunted by Soin Clan Sisters
if (missionVariables.assassins_rebooted_stage === 9) {
var currentbackground = "assassins_rebooted_soin_sister_leader_type1";
var reputation = "\n\nYou are respected by the Mafia but hated by the Soin Clan.";
var currentjob = "\n\nAs a result of an unfortunate data security breach, the remnants of the Soin Clan have sworn vengeance upon you for the retirement of Be Soin. Their Micro Mambas are small and manurable, but only lightly shielded. Should they locate you, they should not pose a significant threat. Evade their attempts at revenge until the Guildmaster can devise a more permanent solution to the issue.";
}
// Hunted by Inno Soin
if (missionVariables.assassins_rebooted_stage > 9 && missionVariables.assassins_rebooted_stage < 13) {
var currentbackground = "assassins_rebooted_inno_soin";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 5,500 Credits and have taken 36 lives.\n\nYou are credited with retiring an elderly rodent scientist and eliminating a professional sports team together with their wives and girlfriends.";
var reputation = "\n\nYou are respected by the Mafia but hated by the last surviving member of the Soin Clan.";
var currentjob = "\n\nThe Soin Clan have been poisoned by warfarin laced cheese, save for the lactose intolerant Inno Soin. His Micro Fer-de-Lance has been fitted with a powerful cascade weapon and he is closing in on your location. It may be possible to lure him into making a suicide run provided you have sufficient injector fuel to escape.";
}
// Congratulated on killing Inno Soin and promoted to Murderous Thug.
if (missionVariables.assassins_rebooted_stage > 12) {
var rank = "You hold the rank of a Murderous Thug.";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 6,500 Credits and have taken 37 lives.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends and driving a clan leader to suicide.";
var reputation = "\n\nYou are respected by the Mafia.";
var currentjob = "\n\nYou have no outstanding contracts.";
}
// Offered the Contract on Victim 3.
if (missionVariables.assassins_rebooted_stage === 14) {
var currentbackground = "assassins_rebooted_victim3";
var currentjob = "\n\nYou have been assigned to destroy the Anaconda Trader, the GSS Fair Wind, currently in a parking orbit around the Augeaian Orbital Repair Facility in the Beatle system. The ship itself is unarmed and stripped for servicing, but Phantom patrol ships will be providing protection. A surgical strike and a quick retreat may be the best approach. A fee of 10,000 Credits will be paid upon completion of this contract.";
}
// Congratulated on killing Victim 3 and promoted to Seasoned Killer.
if (missionVariables.assassins_rebooted_stage > 14) {
var rank = "You hold the rank of a Seasoned Killer.";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 16,500 Credits and have taken 90 lives.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide and reducing a feline repair crew to ashes.";
var reputation = "\n\nYou are highly regarded by the Mafia.";
var currentjob = "\n\nYou have no outstanding contracts.";
}
// Offered the Contract on Victim 4.
if (missionVariables.assassins_rebooted_stage === 20) {
var currentbackground = "assassins_rebooted_victim4";
var currentjob = "\n\nYour current assignment is to terminate Inspector Thorstan, flying a Special Branch Asp with the call sign High Noon. He is engaged in the defence of the Outpost orbiting the moon Hercules in the Geteve system. The inspector is likely to prove a tough opponent, but the hoards of Thargoids occupying the system may be even more dangerous. A fee of 15,000 Credits will be paid upon completion of this contract.";
}
// Congratulated on killing Victim 4 and promoted to Master Murderer.
if (missionVariables.assassins_rebooted_stage > 20) {
var rank = "You hold the rank of a Master Murderer.";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 31,500 Credits and have taken 91 lives.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes and ambushing a police inspector.";
var reputation = "\n\nYou are highly regarded by the Mafia.";
var currentjob = "\n\nYou have no outstanding contracts.";
}
// Offered the Contract on Victim 5.
if (missionVariables.assassins_rebooted_stage === 24) {
var currentbackground = "assassins_rebooted_victim5";
var reputation = "\n\nYou are highly regarded by the Mafia and trusted by Griff Research Ltd.";
var currentjob = "\n\nYou have been engaged by Griff Research Ltd to seek and destroy the malfunctioning Control Drone, Logan 5. The artificial intelligence has run amok and is hunting the main spacelane of the Ateslete system, gunning down any ships it encounters. The renegade robot is armed only with short range plasma cannons and thus an attack from a distance may prove to be more prudent. A fee of 25,000 Credits will be paid upon the deletion of the troublesome automation.";
}
// Congratulated on killing Victim 5 and promoted to Skilled Assassin.
if (missionVariables.assassins_rebooted_stage > 24) {
var rank = "You hold the rank of a Skilled Assassin.";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 56,500 Credits and have taken 91 lives.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector and deleting a malevolent machine intelligence.";
var reputation = "\n\nYou are highly regarded by the Mafia and venerated by Griff Research Ltd.";
var currentjob = "\n\nYou have no outstanding contracts.";
}
// Hunted by Hockey Fans.
if (missionVariables.assassins_rebooted_stage === 28 || missionVariables.assassins_rebooted_stage === 29) {
var currentbackground = "assassins_rebooted_hocky_fan_type1";
var reputation = "\n\nYou are highly regarded by the Mafia, venerated by Griff Research Ltd but vilified by the Zarausxian Zero-G Hockey Team Fan Club.";
var currentjob = "\n\nIt would appear that the Zarausxian Zero-G Hockey Team Fan Club has finally managed to crowdfund the costs of hiring of a flotilla of Nemesis Fighters with a view to avenging the deaths for their favourite team. There is little cause for concern however, as they are mediocre pilots and the eye-wateringly high fees charged by Ramon Security are likely to render sustaining the hunt for long cost prohibitive.";
}
// Ordered to dual O-Ren Ishii (Victim 6)
if (missionVariables.assassins_rebooted_stage === 30) {
var currentbackground = "assassins_rebooted_victim6";
var reputation = "\n\nYou are highly regarded by the Mafia, venerated by Griff Research Ltd but vilified by the Zarausxian Zero-G Hockey Team Fan Club.";
var currentjob = "\n\nRegrettably, the contract upon your life offered by the Zarausxian Zero-G Hockey Team Fan Club has been accepted by Guild Sister O-Ren Ishii. The Guildmaster has decreed that the issue will be settled by a duel in the asteroid field near the House of Blue Leaves Mining Depot in the Ataneris system. A duelling beacon has been deployed to mark the location on your advanced space compass. Your opponent is flying a Cobra Mark IX, Lady of the Dead and awaits your convenience.";
}
// Congratulated on killing Victim 6 and promoted to an Efficient Cleaner.
if (missionVariables.assassins_rebooted_stage > 30) {
var rank = "You hold the rank of an Efficient Cleaner.";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 57,000 Credits and have taken 92 lives.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence and defeating a dishonourable opponent in single combat.";
var reputation = "\n\nYou are highly regarded by the Mafia and venerated by Griff Research Ltd.";
var currentjob = "\n\nYou have no outstanding contracts.";
}
// Offered the Contract on Victim 7.
if (missionVariables.assassins_rebooted_stage === 35) {
var currentbackground = "assassins_rebooted_victim7";
var currentjob = "\n\nYou have been contracted by the Mafia to whack Triad Boss Enio Yanksona, flying an armoured Boa named Atom Smasher. He is leading groups of Triad ships attacking the Mafia operated fleet of Anacondas ferrying megaweed from the plantations on the tropical moon Hesperides to the main station in the Quandixe system. His attention is likely to be focused on his prey, making him vulnerable to a surprise attack. A fee of 30,000 Credits will be paid upon completion of this contract.";
}
// Hunted by Triad Hit ships after killing Victim 7.
if (missionVariables.assassins_rebooted_stage === 36 || missionVariables.assassins_rebooted_stage === 37
|| missionVariables.assassins_rebooted_stage === 38 || missionVariables.assassins_rebooted_stage === 39
|| missionVariables.assassins_rebooted_stage === 40) {
var currentbackground = "assassins_rebooted_triad_wasp_type1";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 92,000 Credits and have taken 98 lives.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat and whacking a Triad robber barron.";
var reputation = "\n\nYou are revered by the Mafia, venerated by Griff Research Ltd but loathed by the Triads.";
var currentjob = "\n\nYour elimination of Boss Enio Yanksona has greatly displeased the Triads who have sworn your destruction. Their ships are fast, well armed and crewed by experienced combat pilots, many with notionally Clean legal status. Although the Guildmaster is working on a subtle plan to neutralise the threat, discretion may be the better part of valour should you encounter their attack ships in the meantime.";
}
// Offered the Contract on Victim 8.
if (missionVariables.assassins_rebooted_stage === 41) {
var rank = "You hold the rank of an Efficient Cleaner.";
var currentbackground = "assassins_rebooted_victim8";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 92,000 Credits and have taken 98 lives.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat and whacking a Triad robber barron.";
var reputation = "\n\nYou are revered by the Mafia, venerated by Griff Research Ltd and at peace with the Triads.";
var currentjob = "\n\nIn return for rescinding the contract on your life, the Triads have engaged your services to exclude the evidence of Bi Xea'nu. The witness is housed aboard the Aeron Class Frigate Indefatigable, currently stationed near the Naval Outpost in the Estiri system. The outpost is closed to civilian traffic and you will be fired upon by the Navy when you enter the exclusion zone. A fee of 40,000 Credits will be paid upon completion of this contract.";
}
// Congratulated on killing Victim 8 and promoted to a Master of Death.
if (missionVariables.assassins_rebooted_stage > 41) {
var rank = "You hold the rank of a Master of Death.";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 132,000 Credits and have taken 102 lives.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron and silencing a crucial witness.";
var reputation = "\n\nYou are revered by the Mafia, venerated by Griff Research Ltd and at peace with the Triads.";
var currentjob = "\n\nYou have no outstanding contracts.";
}
// Offered the Contract on Victim 9.
if (missionVariables.assassins_rebooted_stage === 47) {
var currentbackground = "assassins_rebooted_victim9";
var currentjob = "\n\nYou have been asked to intervene in the Eszausveian civil war by the People's Popular Front. Sky Marshal Maximus is preparing to obliterate rebel held cities from orbit by assembling a flotilla of Deamon Class Cruisers near the main Imperial Station, the Eyrie of Order in the Eszausve system. The Sky Marshal is supervising the operation aboard the Imperial Flagship, Vengeance. His death will prevent millions of civilian casualties and advance the rebel cause. A fee of 10,000 Credits will be paid upon completion of this contract.";
}
// Congratulated on killing Victim 9 and promoted to a Grandmaster.
if (missionVariables.assassins_rebooted_stage > 47) {
var rank = "You hold the rank of a Grandmaster.";
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 142,000 Credits and have taken 147 lives. Your intervention in the Eszausveian civil war has prevented 13.429 million civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness and terminating a command with extreme prejudice.";
var reputation = "\n\nYou are adored by the people of Eszausve, revered by the Mafia, venerated by Griff Research Ltd, at peace with the Triads but detested by the Imperial War Council.";
var currentjob = "\n\nYou have no outstanding contracts.";
}
// Offered the Contract to collect the gravition missiles from the Rebel base.
if (missionVariables.assassins_rebooted_stage === 53) {
var currentbackground = "assassins_rebooted_graviton_missile_screen_display";
var currentjob = "\n\nYou have been tasked with collecting as many Gravition Missiles as possible from the Black Mesa Facility, located in the Angeriri system. The Facility is transmitting a phased impulse encrypted beacon code which can be detected with an Advanced Space Compass. Once you have docked at the Facility, you will need to use the auto-loaders to remove any mounted missiles and replace them with Graviton Missiles. You must then deliver the missiles to your contact Agent Bluebird aboard the Angeriri system main station.";
}
// Updated description once the missiles are collected.
if (missionVariables.assassins_rebooted_stage === 54) {
var currentbackground = "assassins_rebooted_graviton_missile_screen_display";
// Default history - Did not shoot the sinister bird during the text adventure.
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 142,000 Credits and have taken 147 lives. Your intervention in the Eszausveian civil war has prevented 13.429 million civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness and terminating a command with extreme prejudice.";
// Alternative history - Did shoot the sinister bird (same but adds the stormtrooper to the kill list).
if (missionVariables.assassins_rebooted_shot_stormtrooper === "Yes") {
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 142,000 Credits and have taken 148 lives. Your intervention in the Eszausveian civil war has prevented 13.429 million civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness, terminating a command with extreme prejudice and gunning down an imperial stormtrooper.";
}
// Check for 1 missile or more than 1.
var maxmissiles = player.ship.missileCapacity;
var describemissiles = "You have collected a Graviton Missile from the Black Mesa Research Facility.";
var describemissiles2 = "missile";
if (maxmissiles > 1) {
var describemissiles = "You have collected the Graviton Missiles from the Black Mesa Research Facility.";
var describemissiles2 = "missiles";
}
var currentjob = "\n\n"+describemissiles+" You must now deliver the "+describemissiles2+" to your contact Agent Bluebird aboard the Angeriri system main station. She will arrange your renumeration and brief you further.";
}
// Offered the contract on Victim 10.
if (missionVariables.assassins_rebooted_stage === 55) {
var currentbackground = "assassins_rebooted_victim10";
// Default history - Did not shoot the sinister bird during the text adventure.
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 142,000 Credits and have taken 147 lives. Your intervention in the Eszausveian civil war has prevented 13.429 million civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness and terminating a command with extreme prejudice.";
// Alternative history - Did shoot the sinister bird (same but adds the stormtrooper to the kill list).
if (missionVariables.assassins_rebooted_shot_stormtrooper === "Yes") {
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 142,000 Credits and have taken 148 lives. Your intervention in the Eszausveian civil war has prevented 13.429 million civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness, terminating a command with extreme prejudice and gunning down an imperial stormtrooper.";
}
// Check for 1 missile or more than 1.
var maxmissiles = player.ship.missileCapacity;
var describemissiles = "a Gravition Missile";
if (maxmissiles > 1) {
var describemissiles = "Graviton Missiles";
}
var currentjob = "\n\nAs the only operative armed with "+describemissiles+", the rebels have requested that you assassinate Governor Tarkin aboard the Imperial Dreadnaught near the moon Columba in the Eszausve System. Your approach will not be easy as you will be required to deploy a missile within five kilometres of your target. A precise hit should cause a chain reaction in the regenerative armour and destroy the Dreadnaught.";
}
// Final rank, history, reputation and contract description at the end of the OXP when all missions are completed.
if (missionVariables.assassins_rebooted_stage > 55 || missionVariables.assassins_rebooted_stage === "Complete") {
var rank = "You hold the rank of The Hand.";
// Default history - Did not shoot the sinister bird during the text adventure.
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 192,000 Credits and have taken 215 lives. Your heroic actions during the Eszausveian civil war prevented 4.862 billion civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness, terminating a command with extreme prejudice and vaporising an evil emperor.";
// Alternative history - Did shoot the sinister bird (same but adds the stormtrooper to the kill list).
if (missionVariables.assassins_rebooted_shot_stormtrooper === "Yes") {
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 192,000 Credits and have taken 216 lives. Your heroic actions during the Eszausveian civil war prevented 4.862 billion civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness, terminating a command with extreme prejudice, gunning down an imperial stormtrooper and vaporising an evil emperor.";
}
var reputation = "\n\nYou are loved by the people of Eszausve, revered by the Mafia, venerated by Griff Research Ltd and at peace with the Triads.";
var currentjob = "\n\nThere are currently no contracts calling for the skills of The Hand of the Guild.";
}
// Additional Mission added by Victim 11 OXZ.
// The script below checks the Stage Variable set by Victim 11 (if installed). The mission description will be updated depending
// on the stage the player is at in Victim 11's script.
// Stage 1 - Ordered to report to Esrire.
if (missionVariables.Victim11 === "STAGE_20") {
var currentjob = "\n\nThere have been troubling reports in the news feeds concerning Agent Wombat and the threat this operative may pose to the Guild. You have been ordered to report to the Esrire system main station for a briefing from the Guildmaster.";
}
// Stage 2 - Offered the mission to capture Agent Wombat.
if (missionVariables.Victim11 === "STAGE_30") {
var currentbackground = "blackmaria";
var currentjob = "\n\nAgent Wombat is aboard a prison transport ship with a military escort on route to the naval outpost orbiting the ocean covered moon Nemean in the Estiri system. You have been ordered to take Agent Wombat alive and bring him to the Guildmaster at the Esire system main station. There will be numerous prisoners aboard the transport and thus you must scoop all escape pods to ensure you have captured the traitor.";
}
// Note: If you destroy the Prison Ship and scoop none of the pods, Victim 11's script does not treat this as a failure and the
// mission state will not change, allowing you to jump back into the system and the Prison Ship will respawn. You will only be
// treated as failing if you scoop 1 to 3 pods. Agent Wombat is always placed in the 4th Pod scooped, so only Scooping all 4 pods
// is treated as succcess by Victim 11's script.
// The description of the current job is advanced with Victim 11's script. If you have scooped 1 to 3 pods the description will
// update to say that whilst you destroyed the ship, you failed to capture Agent Wombat and you should report your failure to
// the Guildmaster. If you scoop all 4, then it will update to saying you have sucessfully captured him and should deliver him
// to the Guildmaster. This is a bit odd (as really scooping zero pods should be a failure and the ship should not still be re-spawned
// as you destroyed it), but it is the way Victim 11 works. The deathnote function just reads the different stages set by Victim 11
// and describes where you are at each stage.
// Check using the Pod Count variable to give a failed mission description if the pod count is > 0 but less than 4.
if (missionVariables.Victim11_pod_count) {
// Failed if scooped less than 4 pods.
if (missionVariables.Victim11_pod_count < 4) {
var currentbackground = "assassins_rebooted_gravemarker";
var currentjob = "\n\nWhilst you succeeded in destroying the prison transport ship, you failed to capture Agent Wombat and he was killed when the transport exploded. You should dock with the nearest main station and report your failure to the Guildmaster.";
}
// Success if scooped all 4 pods.
if (missionVariables.Victim11_pod_count > 3) {
var currentbackground = "assassins_rebooted_display_escape_pod";
var currentjob = "\n\nYou have destroyed the prison transport ship and captured Agent Wombat. You should transport him to the Guildmaster at the Esrire system main station.";
}
// Closing bracket for the pod count variable being defined.
}
// Stage 3 - Double check using the stage variable. If the variable is at 40 then Agent Wombat has been scooped.
if (missionVariables.Victim11 === "STAGE_40") {
var currentbackground = "assassins_rebooted_display_escape_pod";
var currentjob = "\n\nYou have destroyed the prison transport ship and captured Agent Wombat. You should transport him to the Guildmaster at the Esrire system main station.";
}
// Mission Endings to Victim 11.
// There are three posibile endings 1) Failed to Capture, 2) Captured but handed over to GalCop and 3) the 'good ending' of capturing
// and handing him in to the Guild. If you hand him over to GalCop, you are not paid and the guild is annoyed, but they do not take
// any action against you. If you scooped 1 to 3 pods, then the Guild will tell you they have a new job for you in at Oresrati in
// Galaxy 8. You would have to make a jump from the right place in G7 to appear at Oresrati. Should you do so and dock at the main
// station, upon docking you will be told that you have been expelled from the Guild and are marked for death. As soon as you launch
// Victim11's script causes your ship to explode. If you fail the mission to capture Agent Wombat, completing the Oresrati mission
// will break your save file and you will no longer be able to play the commander as you will die as soon as you launch (meaning you
// can never launch again with that commander!) The link to the Guild is only available in G7, so you cannot access it at Oresrati.
// Just in case you survive the Oresrati mission set by Victim 11 (by editing your save file) then the F4 screen will show you were 
// expelled from the guild and that it would be sensible to leave Galaxy 7 as the Guild are gunning for you.  
// Victim 11 - Ending 1 - Failed to Capture Ending (Stage 90).
if (missionVariables.Victim11 === "STAGE_90") {
var currentbackground = "assassins_rebooted_gravemarker";
var reputation = "\n\nYou are loved by the people of Eszausve, revered by the Mafia, venerated by Griff Research Ltd, at peace with the Triads but the Assassins Guild is displeased with you.";
var currentjob = "\n\nThe Guild is displeased with your failure to capture Agent Wombat but has offered you the opportunity to redeem yourself. You have been instructed to make a galactic jump to Oresrati in Galaxy 8. Should you manage to reach the Oresrati system, you will be given further instructions at the main station.";
}
// Victim 11 - Endings 2 and 3.
// There is not a way to test whether the player spared or killed Agent Wombat as whatever the player's choice, Victim11's script sets
// it's stage variable to Complete. The difference is just in whether it awards 1 Credit or 45,000! For the F4 Screen, I've had to
// assume that you killed him (as I had to pick one!). Can be handwaved as you still earnt the Credits for the hit even if you
// nobley gave them away by sparing him (so the figure for earnings is correct) and handing him over to GalCop did not necessarily 
// save him as he may have been executed for his crime by GalCop or died in some hellhole prison so you were still responsible for his
// death whichever choice you made!
if (missionVariables.Victim11 === "COMPLETE") {
var currentbackground = "assassins_rebooted_gravemarker";
// Default history - Did not shoot the sinister bird during the text adventure.
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 242,000 Credits and have taken 216 lives. Your heroic actions during the Eszausveian civil war prevented 4.862 billion civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness, terminating a command with extreme prejudice, vaporising an evil emperor and capturing a petty thief.";
// Alternative history - Did shoot the sinister bird (same but adds the stormtrooper to the kill list).
if (missionVariables.assassins_rebooted_shot_stormtrooper === "Yes") {
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 242,000 Credits and have taken 217 lives. Your heroic actions during the Eszausveian civil war prevented 4.862 billion civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness, terminating a command with extreme prejudice, gunning down an imperial stormtrooper, vaporising an evil emperor and capturing a petty thief.";
}
}
// Completed the Victim11 Oresrati mission and lived (Not possible to do without a save file edit).
if (missionVariables.Victim11 === "STAGE_100") {
var currentbackground = "assassins_rebooted_gravemarker";
var rank = "You have been excommunicated by the Assassins Guild.";
// Default history - Did not shoot the sinister bird during the text adventure.
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 192,000 Credits and have taken 215 lives. Your heroic actions during the Eszausveian civil war prevented 4.862 billion civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness, terminating a command with extreme prejudice and vaporising an evil emperor.";
// Alternative history - Did shoot the sinister bird (same but adds the stormtrooper to the kill list).
if (missionVariables.assassins_rebooted_shot_stormtrooper === "Yes") {
var history = "\n\nIn the course of your murderous profession, you have earnt a total of 192,000 Credits and have taken 216 lives. Your heroic actions during the Eszausveian civil war prevented 4.862 billion civilian casualties.\n\nYou are credited with retiring an elderly rodent scientist, eliminating a professional sports team together with their wives and girlfriends, driving a clan leader to suicide, reducing a feline repair crew to ashes, ambushing a police inspector, deleting a malevolent machine intelligence, defeating a dishonourable opponent in single combat, whacking a Triad robber barron, silencing a crucial witness, terminating a command with extreme prejudice, gunning down an imperial stormtrooper and vaporising an evil emperor.";
}
var reputation = "\n\nYou are loved by the people of Eszausve, revered by the Mafia, venerated by Griff Research Ltd, at peace with the Triads but detested by the Assassins Guild.";
var currentjob = "\n\nThe mission to Oresrati turned out to be a trap set by the Assassins Guild to punish you for your failure to capture Agent Wombat. Although you survived, it would be prudent to leave Galaxy 7 as soon as possible as the members of the Guild will have orders to kill you on sight, preferably in an embarrassing or painful way.";
}
// Note: However you finish Victim 11, there are no actual consequences as this is the end of the story and no further missions
// or events will occour (except the occasional appearance of the unlocked ships whilst you remain in Galaxy 7).
// The ending states after completing Victim 11 are just for flavour.
var message = rank+history+reputation+currentjob;
mission.runScreen({
title: "Assassinations and Reputation",
screenID:"AssassinsRebooted",
message: message,
model: currentbackground,
exitScreen: "GUI_SCREEN_INTERFACES",
choicesKey: "assassins_rebooted_f4_exit"},
function (choice) {}, this); 
};

// Version 2.0 - Started on 07/06/24 and Completed on 13/04/25.

// Thats all folks!