"use strict";
this.name           = "assassins_rebooted_victim1.js";
this.author         = "LittleBear";
this.copyright      = "CC-by-nc-sa-3.0";
this.version        = "1.0";
this.description    = "Script for the first Mission Ship - Be Soin in a Vintage Adder";

this.shipSpawned = function()
{
this.ship.bounty = 0;
}
// Only react to attacks from the player.
this.shipBeingAttacked = function (whom)
{
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
player.bounty |= 5;
return;	
}
// As Victim 1 is a clean ship and none of the Assassins Victims ever attack NPC ships, lawful ships such as the police, bounty hunters and Assassins ships with a lawful
// Alignment will only have hit a Victim by accident. The Victim won't respond to an NPC hit except to move out of the way and breaking the target lock of the NPC which hit
// the Victim stops it shooting for a few seconds whilst it finds a new traget. If the Victim accidently hit a police ship, it's bounty is set back to 0, so it won't be attacked again
// by police or other ships which attack ships with bounties. If the lawful ship which hit the Victim got a bounty added to it for hitting a clean ship, its bounty is also set back to
// 0, so a hunter doesn't get attacked by other hunters or police ships for the fiendly fire incident.
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1 || whom.roles.indexOf("hunter") > -1 
|| whom.roles.indexOf("assassins_rebooted_lawful_character") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// In the native game the only ship which could deliberatly find and target an assassins Victim ship would be a Thargoid. If the ship whitch hit the Victim ship is anything other
// than a police, hunter or lawful ship then it's AI is set to a customAI to flee 26kms from the Victim Ship, then return to its normal AI. If it is attacked by another ship whilst
// it is fleeing from the Victim Ship then it will fight that ship instead and exit the fleeingAI if it destroys its attacker.
else
{
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// End of this.shipBeingAttacked		
}

this.shipBeingAttackedUnsuccessfully = function(whom)
{
// Same Tests as for being attacked above.
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_ATTACK"); 
player.bounty |= 5;
return;	
}
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1 || whom.roles.indexOf("hunter") > -1 
|| whom.roles.indexOf("assassins_rebooted_lawful_character") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
else
{
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("FRIENDLY_FIRE"); 
return;		
}
// End of shipBeingAttackedUnsuccessfully	
}

this.shipAttackedWithMissile = function(missile, whom)
{
// Same Tests as for being attacked above, but whilst the Victim will ignore a laser attack (as it won't be hit again), if an NPC has fired a missile at it, it will send
// a script message to the AI to flee the incoming missile and use ECM, but not to attack the other ship.
if (!whom) return;
this.ship.bounty = 0;    
if (whom.isPlayer) 
{
this.ship.reactToAIMessage("PLAYER_MISSILE"); 
player.bounty |= 5;
return;	
}
if (whom.roles.indexOf("police") > -1 || whom.roles.indexOf("wingman") > -1  || whom.roles.indexOf("interceptor") > -1 || whom.roles.indexOf("hunter") > -1 
|| whom.roles.indexOf("assassins_rebooted_lawful_character") > -1)  
{
whom.target = null;
whom.bounty = 0;
whom.reactToAIMessage("TARGET_LOST");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("NPC_MISSILE"); 
return;		
}
else
{
whom.reactToAIMessage("TARGET_LOST");
whom.setAI("assassins_rebooted_break_offAI.plist");
this.ship.target = null;
this.ship.bounty = 0;
this.ship.reactToAIMessage("NPC_MISSILE"); 
return;		
}
// End of this.shipAttackedWithMissile
}

this.shipDied = function (whom)
{
if (whom && whom.isPlayer)
{
player.bounty |= 10;
missionVariables.assassins_rebooted_stage = 2;
mission.setInstructionsKey("assassins_rebooted_mission_description_02", "AssassinsRebooted");
mission.unmarkSystem(73);
this.ship.commsMessage(expandDescription("[assassins-death-victim1]"), player.ship);
}




// End of this.shipDied
}
